<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

$arts_class_spinner = '';

$arts_enable_spinner_desktop = get_theme_mod( 'enable_spinner_desktop', false );
$arts_enable_spinner_mobile  = get_theme_mod( 'enable_spinner_mobile', true );

if ( $arts_enable_spinner_desktop ) {
	$arts_class_spinner .= ' d-lg-block';
} else {
	$arts_class_spinner .= ' d-lg-none';
}

if ( $arts_enable_spinner_mobile ) {
	$arts_class_spinner .= ' d-block';
} else {
	$arts_class_spinner .= ' d-none';
}
?>

<svg class="spinner js-spinner <?php echo esc_attr( $arts_class_spinner ); ?>" width="65px" height="65px" viewBox="0 0 66 66" xmlns="http://www.w3.org/2000/svg">
	<circle class="spinner__path" fill="none" stroke-width="6" stroke-linecap="round" cx="33" cy="33" r="30"></circle>
</svg>
