<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.7
 */

namespace radiustheme\Classima;

use RtclPro\Controllers\Hooks\TemplateHooks;
use Rtcl\Controllers\Hooks\TemplateHooks as freeTemplateHooks;
use Rtcl\Helpers\Link;
use Rtcl\Helpers\Functions;

?>
<div class="listing-grid-each listing-grid-each-8 listing-grid-each-9<?php echo esc_attr( $class ); ?>"<?php Functions::listing_data_attr_options() ?>>
    <div class="rtin-item">
        <div class="rtin-thumb">
            <a class="rtin-thumb-inner rtcl-media"
               href="<?php the_permalink(); ?>"><?php $listing->the_thumbnail(); ?></a>
			<?php if ( $listing->is_featured() ) { ?>
                <div class="rtin-featured-ad">
					<?php freeTemplateHooks::listing_featured_badge( $listing ); ?>
                </div>
			<?php } ?>

			<?php if ( isset( $type['label'] ) && ( $display['type'] == 1 || $display['type'] == 'true' ) ): ?>
                <div class="rtin-type">
                    <span><?php echo sprintf( apply_filters( 'classima_ad_type_prefix', __( "For %s", 'classima' ), $type['label'] ),
		                    $type['label'] ); ?></span>
                </div>
			<?php endif; ?>
			<?php TemplateHooks::sold_out_banner(); ?>
			<?php freeTemplateHooks::loop_item_meta_buttons(); ?>
        </div>
        <div class="rtin-content">
			<?php do_action( 'classima_grid_view_before_content' ); ?>
			<?php
			if ( $display['label'] == 1 || $display['label'] == 'true' ) {
				$listing->the_badges();
			}
			?>

            <h3 class="rtin-title listing-title" title="<?php the_title(); ?>"><a
                        href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>

			<?php if ( $display['cat'] == 1 || $display['cat'] == 'true' ): ?>
                <div class="rtin-cat-action">
                    <div class="rtin-cat-wrap">
                        <div class="rtin-cat">
		                    <?php
		                    foreach ( $category as $cat ) {
			                    echo $glue ?? '';
			                    ?>
                                <a href="<?php echo esc_url( Link::get_category_page_link( $cat ) ); ?>"><?php echo esc_html( $cat->name ); ?></a>
			                    <?php
			                    $glue = '<span class="rtcl-delimiter">,</span>';
		                    }
		                    ?>
                        </div>
                    </div>
                </div>
			<?php endif; ?>

			<?php
			if ( $display['fields'] == 1 || $display['fields'] == 'true' ) {
				TemplateHooks::loop_item_listable_fields();
			}
			?>

            <ul class="rtin-meta">
				<?php if ( $display['date'] == 1 || $display['date'] == 'true' ): ?>
                    <li><svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <g clip-path="url(#clip0_1032_1643)">
                                <path d="M8.00003 3.73336V8.00003L10.8445 9.42225M15.1111 8.00003C15.1111 11.9274 11.9274 15.1111 8.00003 15.1111C4.07267 15.1111 0.888916 11.9274 0.888916 8.00003C0.888916 4.07267 4.07267 0.888916 8.00003 0.888916C11.9274 0.888916 15.1111 4.07267 15.1111 8.00003Z" stroke="#ACACAC" stroke-width="0.977778" stroke-linecap="round" stroke-linejoin="round"/>
                            </g>
                            <defs>
                                <clipPath id="clip0_1032_1643">
                                    <rect width="16" height="16" fill="white"/>
                                </clipPath>
                            </defs>
                        </svg>
	                    <?php $listing->the_time(); ?>
                    </li>
				<?php endif; ?>
				<?php if ( ( $display['location'] == 1 || $display['location'] == 'true' ) && $listing->has_location() ): ?>
                    <li><svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M15 7.54545C15 12.6364 8.5 17 8.5 17C8.5 17 2 12.6364 2 7.54545C2 5.80949 2.68482 4.14463 3.90381 2.91712C5.12279 1.68961 6.77609 1 8.5 1C10.2239 1 11.8772 1.68961 13.0962 2.91712C14.3152 4.14463 15 5.80949 15 7.54545Z" stroke="#ACACAC" stroke-width="1.3" stroke-linecap="round" stroke-linejoin="round"/>
                            <path d="M8.5 9.72727C9.69662 9.72727 10.6667 8.75044 10.6667 7.54545C10.6667 6.34047 9.69662 5.36364 8.5 5.36364C7.30338 5.36364 6.33333 6.34047 6.33333 7.54545C6.33333 8.75044 7.30338 9.72727 8.5 9.72727Z" stroke="#ACACAC" stroke-width="1.3" stroke-linecap="round" stroke-linejoin="round"/>
                        </svg>
	                    <?php $listing->the_locations( true, true ); ?>
                    </li>
				<?php endif; ?>
				<?php if ( $display['views'] == 1 || $display['views'] == 'true' ): ?>
                    <li><i class="fa fa-fw fa-eye"
                           aria-hidden="true"></i><?php echo sprintf( esc_html__( '%1$s Views', 'classima' ),
							number_format_i18n( $listing->get_view_counts() ) ); ?>
                    </li>
				<?php endif; ?>
            </ul>

			<?php if ( $display['price'] == 1 || $display['price'] == 'true' ): ?>
                <div class="rtin-price">
					<?php
					if ( method_exists( $listing, 'get_price_html' ) ) {
						Functions::print_html( $listing->get_price_html() );
					}
					?>
                </div>
			<?php endif; ?>
			<?php do_action( 'classima_grid_view_after_content' ); ?>
        </div>
    </div>

</div>