<?php
/**
 *
 * @package Cocoon
 *
 * @since 1.0
 *
 * ========================
 * CUSTOMIZER OPTIONS
 * ========================
 **/

/** Exit if accessed directly **/
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class cocoon_Customize {

	/** Customize settings */
	protected $config = [];

	/** The class constructor */
	public function __construct( $config ) {
		$this->config = $config;

		if ( ! class_exists( 'Kirki' ) ) {
			return;
		}

		$this->register();
	}

	/** Register settings **/
	public function register() {

		/** Add the theme configuration */
		if ( ! empty( $this->config['theme'] ) ) {
			Kirki::add_config(
				$this->config['theme'],
				[
					'capability'  => 'edit_theme_options',
					'option_type' => 'theme_mod',
				]
			);
		}

		/** Add panels */
		if ( ! empty( $this->config['panels'] ) ) {
			foreach ( $this->config['panels'] as $panel => $settings ) {
				Kirki::add_panel( $panel, $settings );
			}
		}

		/**  Add sections */
		if ( ! empty( $this->config['sections'] ) ) {
			foreach ( $this->config['sections'] as $section => $settings ) {
				Kirki::add_section( $section, $settings );
			}
		}

		/** Add fields */
		if ( ! empty( $this->config['theme'] ) && ! empty( $this->config['fields'] ) ) {
			foreach ( $this->config['fields'] as $name => $settings ) {
				if ( ! isset( $settings['settings'] ) ) {
					$settings['settings'] = $name;
				}

				Kirki::add_field( $this->config['theme'], $settings );
			}
		}
	}

	/** Get config ID **/
	public function get_theme() {
		return $this->config['theme'];
	}

	/** Get customize setting value **/
	public function get_option( $name ) {
		if ( ! isset( $this->config['fields'][ $name ] ) ) {
			return false;
		}

		$default = isset( $this->config['fields'][ $name ]['default'] ) ? $this->config['fields'][ $name ]['default'] : false;

		return get_theme_mod( $name, $default );
	}
}

/*** Move some default sections to 'general' panel ***/
function cocoon_customize_modify( $wp_customize ) {
	$wp_customize->get_section( 'title_tagline' )->panel     = 'general';
	$wp_customize->get_section( 'static_front_page' )->panel = 'general';
}

add_action( 'customize_register', 'cocoon_customize_modify' );

/** This is a short hand function for getting setting value from customizer **/
function cocoon_get_option( $name ) {
	global $cocoon_customize;

	$value = false;

	if ( class_exists( 'Kirki' ) ) {
		$value = Kirki::get_option( 'cocoon', $name );
	} elseif ( ! empty( $cocoon_customize ) ) {
		$value = $cocoon_customize->get_option( $name );
	}

	return apply_filters( 'cocoon_get_option', $value, $name );
}

/** Get customize settings **/
function cocoon_customize_settings() {

	/** Customizer configuration */
	return [
		'theme'    => 'cocoon',

		'panels'   => [

			// GENERAL OPTIONS.
			'general'               => [
				'priority'    => 10,
				'title'       => esc_html__( 'General Options', 'cocoon' ),
				'description' => esc_html__( 'General options', 'cocoon' ),
			],

			// TYPOGRAPHY GENERAL OPTIONS.
			'typo_general'          => [
				'priority'    => 10,
				'title'       => esc_html__( 'Typography Options', 'cocoon' ),
				'description' => esc_html__( 'Typography related options', 'cocoon' ),
			],

			// HEADER GENERAL OPTIONS.
			'header_general'        => [
				'priority'    => 10,
				'title'       => esc_html__( 'Header Options', 'cocoon' ),
				'description' => esc_html__( 'Header related options', 'cocoon' ),
			],

			// WOOCOMMERCE GENERAL OPTIONS.
			'woocommerce'           => [
				'priority'    => 11,
				'title'       => esc_html__( 'WooCommerce', 'cocoon' ),
				'description' => esc_html__( 'WooCommerce related options', 'cocoon' ),
			],

			// BLOG OPTIONS.
			'blog_general'          => [
				'priority'    => 11,
				'title'       => esc_html__( 'Blog Options', 'cocoon' ),
				'description' => esc_html__( 'Blog related options', 'cocoon' ),
			],

			// PAGES OPTIONS.
			'pages_general'         => [
				'priority'    => 11,
				'title'       => esc_html__( 'Pages Options', 'cocoon' ),
				'description' => esc_html__( 'Pages related options', 'cocoon' ),
			],

			// EXTRA OPTIONS.
			'extra_general_options' => [
				'priority'    => 13,
				'title'       => esc_html__( 'Extra Options', 'cocoon' ),
				'description' => esc_html__( 'Extra options', 'cocoon' ),
			],
		], // end of panels array.

		'sections' => [

			// COLORS OPTIONS.
			'colors'             => [
				'title'          => esc_html__( 'Color Options', 'cocoon' ),
				'description'    => '',
				'panel'          => 'general', // Not typically needed.
				'priority'       => 160,
				'capability'     => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
			],

			// PAGE HEADER OPTIONS.
			'page_header'        => [
				'title'          => esc_html__( 'Page Header Options', 'cocoon' ),
				'description'    => '',
				'panel'          => 'general', // Not typically needed.
				'priority'       => 160,
				'capability'     => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
			],

			// EXTRA OPTIONS.
			'extra_options'      => [
				'title'          => esc_html__( 'Extra Options', 'cocoon' ),
				'description'    => '',
				'panel'          => 'general', // Not typically needed.
				'priority'       => 160,
				'capability'     => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
			],

			// BODY - TYPOGRAPHY OPTIONS.
			'body_typo'          => [
				'title'          => esc_html__( 'Body', 'cocoon' ),
				'description'    => '',
				'panel'          => 'typo_general', // Not typically needed.
				'priority'       => 160,
				'capability'     => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
			],

			// HEADINGS - TYPOGRAPHY OPTIONS.
			'headings_typo'      => [
				'title'          => esc_html__( 'Heading', 'cocoon' ),
				'description'    => '',
				'panel'          => 'typo_general', // Not typically needed.
				'priority'       => 160,
				'capability'     => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
			],

			// MENU - TYPOGRAPHY OPTIONS.
			'menu_typo'          => [
				'title'          => esc_html__( 'Menu', 'cocoon' ),
				'description'    => '',
				'panel'          => 'typo_general', // Not typically needed.
				'priority'       => 160,
				'capability'     => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
			],

			// LOGO OPTIONS.
			'logo'               => [
				'title'          => esc_html__( 'Logo', 'cocoon' ),
				'description'    => '',
				'panel'          => 'header_general', // Not typically needed.
				'priority'       => 160,
				'capability'     => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
			],

			// MAIN HEADER OPTIONS.
			'header'             => [
				'title'          => esc_html__( 'Header Options', 'cocoon' ),
				'description'    => esc_html__( 'Header related options', 'cocoon' ),
				'panel'          => 'header_general', // Not typically needed.
				'priority'       => 160,
				'capability'     => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
			],

			// FOOTER OPTIONS.
			'footer'             => [
				'title'          => esc_html__( 'Footer Options', 'cocoon' ),
				'description'    => esc_html__( 'Footer related options', 'cocoon' ),
				'panel'          => '', // Not typically needed.
				'priority'       => 10,
				'capability'     => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
			],

			// GENERAL BLOG OPTIONS.
			'blog'               => [
				'title'          => esc_html__( 'General Blog Options', 'cocoon' ),
				'description'    => esc_html__( 'Blog related options', 'cocoon' ),
				'panel'          => 'blog_general', // Not typically needed.
				'priority'       => 160,
				'capability'     => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
			],

			// SINGLE BLOG POST OPTIONS.
			'single_blog_post'   => [
				'title'          => esc_html__( 'Single Blog Post Options', 'cocoon' ),
				'description'    => esc_html__( 'Single blog post related options', 'cocoon' ),
				'panel'          => 'blog_general', // Not typically needed.
				'priority'       => 160,
				'capability'     => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
			],

			// SEARCH PAGE OPTIONS.
			'search_page'        => [
				'title'          => esc_html__( 'Search Page Options', 'cocoon' ),
				'description'    => esc_html__( 'Search page related options', 'cocoon' ),
				'panel'          => 'pages_general', // Not typically needed.
				'priority'       => 160,
				'capability'     => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
			],

			// 404 PAGE OPTIONS.
			'page_not_found'     => [
				'title'          => esc_html__( '404 Page Options', 'cocoon' ),
				'description'    => esc_html__( '404 page related options', 'cocoon' ),
				'panel'          => 'pages_general', // Not typically needed.
				'priority'       => 160,
				'capability'     => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
			],

			// MAP OPTIONS.
			'map_options'        => [
				'title'          => esc_html__( 'Map Options', 'cocoon' ),
				'description'    => esc_html__( 'Map related options', 'cocoon' ),
				'panel'          => 'extra_general_options', // Not typically needed.
				'priority'       => 12,
				'capability'     => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
			],

			// GENERAL SHOP LAYOUT.
			'shop_general'       => [
				'title'       => esc_html__( 'Shop General', 'cocoon' ),
				'description' => '',
				'priority'    => 5,
				'panel'       => 'woocommerce',
				'capability'  => 'edit_theme_options',
			],

			// SHOP BADGES.
			'shop_badges'        => [
				'title'       => esc_html__( 'Badges', 'cocoon' ),
				'description' => '',
				'priority'    => 50,
				'panel'       => 'woocommerce',
				'capability'  => 'edit_theme_options',
			],

			// PRODUCT GRID.
			'product_grid'       => [
				'title'       => esc_html__( 'Product Grid', 'cocoon' ),
				'description' => '',
				'priority'    => 50,
				'panel'       => 'woocommerce',
				'capability'  => 'edit_theme_options',
			],

			// PRODUCT GRID.
			'single_product'     => [
				'title'       => esc_html__( 'Single Product', 'cocoon' ),
				'description' => '',
				'priority'    => 50,
				'panel'       => 'woocommerce',
				'capability'  => 'edit_theme_options',
			],

			// SUBSCRIPTION OPTIONS.
			'subscription_popup' => [
				'title'          => esc_html__( 'Subscription Popup Options', 'cocoon' ),
				'description'    => '',
				'panel'          => 'extra_general_options', // Not typically needed.
				'priority'       => 160,
				'capability'     => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
			],

			// COOKIE BAR OPTIONS.
			'cookie_bar'         => [
				'title'          => esc_html__( 'Cookie Notice Options', 'cocoon' ),
				'description'    => '',
				'panel'          => 'extra_general_options', // Not typically needed.
				'priority'       => 160,
				'capability'     => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
			],

		], // end of sections array.

		'fields'   => [

			// GENERAL - COLORS OPTIONS.
			'cocoon_body_color'                  => [
				'type'        => 'color',
				'label'       => esc_html__( 'Select body color', 'cocoon' ),
				'description' => '',
				'section'     => 'colors',
				'default'     => '#fff',
				'priority'    => 10,
			],

			'cocoon_wrapper_color'               => [
				'type'        => 'color',
				'label'       => esc_html__( 'Select body wrapper color', 'cocoon' ),
				'description' => '',
				'section'     => 'colors',
				'default'     => '#fff',
				'priority'    => 10,
			],

			'cocoon_main_color'                  => [
				'type'        => 'color',
				'label'       => esc_html__( 'Select main theme color', 'cocoon' ),
				'description' => '',
				'section'     => 'colors',
				'default'     => '#22a3a4',
				'priority'    => 10,
			],

			// PAGE HEADER OPTIONS.
			'cocoon_pageheader'                  => [
				'type'        => 'switch',
				'label'       => esc_html__( 'Page Header', 'cocoon' ),
				'description' => esc_html__( 'Turn the switch "OFF" if you want to disable the page header on all pages.', 'cocoon' ),
				'section'     => 'page_header',
				'priority'    => 10,
				'default'     => 1,
			],

			'cocoon_page_header_background'      => [
				'type'        => 'color',
				'label'       => esc_html__( 'Select the default background color for your page header', 'cocoon' ),
				'description' => '',
				'section'     => 'page_header',
				'default'     => '#252525',
				'priority'    => 10,
			],

			'cocoon_page_header_color_overlay'   => [
				'type'        => 'color',
				'label'       => esc_html__( 'Select color overlay for your page header', 'cocoon' ),
				'description' => '',
				'section'     => 'page_header',
				'default'     => '#252525',
				'priority'    => 10,
			],

			'cocoon_page_header_overlay_opacity' => [
				'type'        => 'slider',
				'label'       => esc_html__( 'Select the opacity for the color overlay', 'cocoon' ),
				'description' => '',
				'section'     => 'page_header',
				'default'     => '0.85',
				'priority'    => 10,
				'choices'     => [
					'min'  => '0',
					'max'  => '1',
					'step' => '0.01',
				],
			],

			'cocoon_general_breadcrumbs'         => [
				'type'        => 'switch',
				'label'       => esc_html__( 'Breadcrumbs', 'cocoon' ),
				'description' => esc_html__( 'Turn the switch "OFF" to disable the breadcrumbs.', 'cocoon' ),
				'section'     => 'page_header',
				'default'     => true,
				'priority'    => 10,
			],

			// EXTRA OPTIONS.
			'cocoon_body_style'                  => [
				'type'        => 'select',
				'label'       => esc_html__( 'Layout style', 'cocoon' ),
				'description' => '',
				'section'     => 'extra_options',
				'default'     => 'fullwidth',
				'priority'    => 10,
				'choices'     => [
					'fullwidth' => esc_html__( 'Full-Width', 'cocoon' ),
					'boxed'     => esc_html__( 'Boxed', 'cocoon' ),
				],
			],

			'cocoon_preloader'                   => [
				'type'        => 'switch',
				'label'       => esc_html__( 'Page Preloader', 'cocoon' ),
				'description' => esc_html__( 'Turn the switch "OFF" to disable the preload animation.', 'cocoon' ),
				'section'     => 'extra_options',
				'default'     => true,
				'priority'    => 10,
			],

			'cocoon_back_top'                    => [
				'type'        => 'switch',
				'label'       => esc_html__( 'Back To Top', 'cocoon' ),
				'description' => esc_html__( 'Turn the switch "OFF" to disable the back to top button.', 'cocoon' ),
				'section'     => 'extra_options',
				'default'     => true,
				'priority'    => 10,
			],

			'cocoon_lazyload'                    => [
				'type'        => 'switch',
				'label'       => esc_html__( 'Lazy Load', 'cocoon' ),
				'description' => esc_html__( 'Check this to load the images live and improve the performance of your website.', 'cocoon' ),
				'section'     => 'extra_options',
				'default'     => 1,
				'priority'    => 10,
			],

			// BODY - TYPOGRAPHY OPTIONS.
			'cocoon_body_typo'                   => [
				'type'        => 'typography',
				'label'       => esc_html__( 'Body Typography', 'cocoon' ),
				'description' => '',
				'section'     => 'body_typo',
				'priority'    => 10,
				'default'     => [
					'font-family'    => 'Poppins',
					'variant'        => 'regular',
					'font-size'      => '16px',
					'line-height'    => '1.65',
					'letter-spacing' => '0',
					'subsets'        => '',
					'color'          => '#948a99',
					'text-transform' => 'none',
				],
				'output'      => [
					[
						'element' => 'body',
					],
				],
			],

			// HEADINGS - TYPOGRAPHY OPTIONS.
			'cocoon_heading1_typo'               => [
				'type'     => 'typography',
				'label'    => esc_html__( 'Heading 1', 'cocoon' ),
				'section'  => 'headings_typo',
				'priority' => 10,
				'default'  => [
					'font-family'    => 'Poppins',
					'variant'        => '500',
					'font-size'      => '46px',
					'line-height'    => '1.3',
					'letter-spacing' => '0',
					'subsets'        => '',
					'color'          => '#1f1f1f',
					'text-transform' => 'none',
				],
				'output'   => [
					[
						'element' => 'h1',
					],
				],
			],

			'cocoon_heading2_typo'               => [
				'type'     => 'typography',
				'label'    => esc_html__( 'Heading 2', 'cocoon' ),
				'section'  => 'headings_typo',
				'priority' => 10,
				'default'  => [
					'font-family'    => 'Poppins',
					'variant'        => '500',
					'font-size'      => '38px',
					'line-height'    => '1.3',
					'letter-spacing' => '0',
					'subsets'        => '',
					'color'          => '#1f1f1f',
					'text-transform' => 'none',
				],
				'output'   => [
					[
						'element' => 'h2',
					],
				],
			],

			'cocoon_heading3_typo'               => [
				'type'     => 'typography',
				'label'    => esc_html__( 'Heading 3', 'cocoon' ),
				'section'  => 'headings_typo',
				'priority' => 10,
				'default'  => [
					'font-family'    => 'Poppins',
					'variant'        => '500',
					'font-size'      => '30px',
					'line-height'    => '1.3',
					'letter-spacing' => '0',
					'subsets'        => '',
					'color'          => '#1f1f1f',
					'text-transform' => 'none',
				],
				'output'   => [
					[
						'element' => 'h3',
					],
				],
			],

			'cocoon_heading4_typo'               => [
				'type'     => 'typography',
				'label'    => esc_html__( 'Heading 4', 'cocoon' ),
				'section'  => 'headings_typo',
				'priority' => 10,
				'default'  => [
					'font-family'    => 'Poppins',
					'variant'        => '500',
					'font-size'      => '24px',
					'line-height'    => '1.3',
					'letter-spacing' => '0',
					'subsets'        => '',
					'color'          => '#1f1f1f',
					'text-transform' => 'none',
				],
				'output'   => [
					[
						'element' => 'h4',
					],
				],
			],

			'cocoon_heading5_typo'               => [
				'type'     => 'typography',
				'label'    => esc_html__( 'Heading 5', 'cocoon' ),
				'section'  => 'headings_typo',
				'priority' => 10,
				'default'  => [
					'font-family'    => 'Poppins',
					'variant'        => '500',
					'font-size'      => '20px',
					'line-height'    => '1.3',
					'letter-spacing' => '0',
					'subsets'        => '',
					'color'          => '#1f1f1f',
					'text-transform' => 'none',
				],
				'output'   => [
					[
						'element' => 'h5',
					],
				],
			],

			'cocoon_heading6_typo'               => [
				'type'     => 'typography',
				'label'    => esc_html__( 'Heading 6', 'cocoon' ),
				'section'  => 'headings_typo',
				'priority' => 10,
				'default'  => [
					'font-family'    => 'Poppins',
					'variant'        => '500',
					'font-size'      => '18px',
					'line-height'    => '1.3',
					'letter-spacing' => '0',
					'subsets'        => '',
					'color'          => '#1f1f1f',
					'text-transform' => 'none',
				],
				'output'   => [
					[
						'element' => 'h6',
					],
				],
			],

			// MENU - TYPOGRAPHY OPTIONS.
			'cocoon_menu_typo'                   => [
				'type'     => 'typography',
				'label'    => esc_html__( 'Menu', 'cocoon' ),
				'section'  => 'menu_typo',
				'priority' => 10,
				'default'  => [
					'font-family'    => 'Poppins',
					'variant'        => '400',
					'font-size'      => '14px',
					'line-height'    => '37px',
					'letter-spacing' => '0',
					'subsets'        => '',
					'color'          => '#fff',
					'text-transform' => 'capitalize',
				],
				'output'   => [
					[
						'element' => 'header.header1 .navbar-nav .nav-link, header.header1 .extra-nav li a, header.header2 .navbar-nav .nav-link, header.header2 .extra-nav li a',
					],
				],
			],

			'cocoon_submenu_typo'                => [
				'type'     => 'typography',
				'label'    => esc_html__( 'Submenu Item', 'cocoon' ),
				'section'  => 'menu_typo',
				'priority' => 10,
				'default'  => [
					'font-family'    => 'Poppins',
					'variant'        => '400',
					'font-size'      => '14px',
					'line-height'    => '1.4',
					'letter-spacing' => '0',
					'subsets'        => '',
					'color'          => '#1f1f1f',
					'text-transform' => 'capitalize',
				],
				'output'   => [
					[
						'element' => 'header.header1 #main-nav .navbar-nav .dropdown-menu > li > a, #main-nav .navbar-nav .mega-menu .dropdown-menu .mega-menu-inner .menu-item-mega a,
                        .header-btn-wrapper .extra-menu-item.ca-join-now ul.ca-user-menu li a',
					],
				],
			],

			// LOGO OPTIONS.
			'logo'                               => [
				'type'        => 'image',
				'label'       => esc_html__( 'Logo', 'cocoon' ),
				'description' => esc_html__( 'This logo is used for all site.', 'cocoon' ),
				'section'     => 'logo',
				'default'     => '',
				'priority'    => 20,
			],

			'logo-white'                         => [
				'type'        => 'image',
				'label'       => esc_html__( 'Logo White', 'cocoon' ),
				'description' => esc_html__( 'This white version of the logo can be used for transparent header.', 'cocoon' ),
				'section'     => 'logo',
				'default'     => '',
				'priority'    => 20,
			],

			'logo_text'                          => [
				'type'     => 'text',
				'label'    => esc_html__( 'Text Logo', 'cocoon' ),
				'section'  => 'logo',
				'priority' => 20,
				[
					'setting'  => 'logo',
					'operator' => '!=',
					'value'    => '',
				],
			],

			'logo_width'                         => [
				'type'     => 'text',
				'label'    => esc_html__( 'Logo Width(px)', 'cocoon' ),
				'section'  => 'logo',
				'priority' => 20,
				'default'  => '150',
				[
					'setting'  => 'logo',
					'operator' => '!=',
					'value'    => '',
				],
			],

			'logo_height'                        => [
				'type'     => 'text',
				'label'    => esc_html__( 'Logo Height(px)', 'cocoon' ),
				'section'  => 'logo',
				'priority' => 20,
				'default'  => '',
				[
					'setting'  => 'logo',
					'operator' => '!=',
					'value'    => '',
				],
			],

			'logo_margins'                       => [
				'type'        => 'spacing',
				'label'       => esc_html__( 'Logo Margin', 'cocoon' ),
				'description' => '',
				'section'     => 'logo',
				'priority'    => 20,
				'default'     => [
					'top'    => '0px',
					'bottom' => '0px',
					'left'   => '0px',
					'right'  => '0px',
				],
				[
					'setting'  => 'logo',
					'operator' => '!=',
					'value'    => '',
				],
			],

			// MAIN HEADER OPTIONS.
			'cocoon_header_style'                => [
				'type'        => 'select',
				'label'       => esc_html__( 'Layout Style', 'cocoon' ),
				'description' => esc_html__( 'Choose your header version.', 'cocoon' ),
				'section'     => 'header',
				'default'     => 'header1',
				'priority'    => 10,
				'choices'     => [
					'header1' => esc_html__( 'Header 1 - Default', 'cocoon' ),
					'header2' => esc_html__( 'Header 2', 'cocoon' ),
				],
			],

			'cocoon_sticky_header'               => [
				'type'            => 'switch',
				'label'           => esc_html__( 'Sticky Header', 'cocoon' ),
				'description'     => esc_html__( 'Turn the switch "OFF" to disable Sticky Header.', 'cocoon' ),
				'section'         => 'header',
				'default'         => true,
				'priority'        => 10,
				'active_callback' => [
					[
						'setting'  => 'cocoon_header_style',
						'value'    => 'header1',
						'operator' => '==',
					],
				],
			],

			'cocoon_fullwidth_header'            => [
				'type'            => 'switch',
				'label'           => esc_html__( 'Full Width Header', 'cocoon' ),
				'description'     => esc_html__( 'Turn the switch "OFF" to disable Full Width Header.', 'cocoon' ),
				'section'         => 'header',
				'default'         => true,
				'priority'        => 10,
				'active_callback' => [
					[
						'setting'  => 'cocoon_header_style',
						'value'    => 'header1',
						'operator' => '==',
					],
				],
			],

			'cocoon_static_header'               => [
				'type'            => 'switch',
				'label'           => esc_html__( 'Static Header', 'cocoon' ),
				'description'     => esc_html__( 'Turn the switch "ON" if you want your header to be on top and not overlay the page header.', 'cocoon' ),
				'section'         => 'header',
				'default'         => false,
				'priority'        => 10,
				'active_callback' => [
					[
						'setting'  => 'cocoon_header_style',
						'value'    => 'header1',
						'operator' => '==',
					],
				],
			],

			'cocoon_menu_buttons'                => [
				'type'        => 'switch',
				'label'       => esc_html__( 'Menu Buttons', 'cocoon' ),
				'description' => esc_html__( 'Turn the switch "OFF" to disable all the buttons from the header.', 'cocoon' ),
				'section'     => 'header',
				'default'     => true,
				'priority'    => 10,
			],

			'menu_extras'                        => [
				'type'            => 'multicheck',
				'label'           => esc_html__( 'Menu Extras', 'cocoon' ),
				'description'     => '',
				'section'         => 'header',
				'default'         => [ 'account', 'cart', 'search', 'wishlist' ],
				'priority'        => 10,
				'choices'         => [
					'lang'     => esc_html__( 'Language Switcher', 'cocoon' ),
					'currency' => esc_html__( 'Currency Switcher', 'cocoon' ),
					'account'  => esc_html__( 'Account', 'cocoon' ),
					'cart'     => esc_html__( 'Cart', 'cocoon' ),
					'search'   => esc_html__( 'Search', 'cocoon' ),
					'wishlist' => esc_html__( 'Wishlist', 'cocoon' ),
				],
				'active_callback' => [
					[
						'setting'  => 'cocoon_menu_buttons',
						'value'    => 1,
						'operator' => '==',
					],
				],
			],

			'cocoon_ajax_search'                 => [
				'type'            => 'switch',
				'label'           => esc_html__( 'AJAX Search', 'cocoon' ),
				'description'     => esc_html__( 'Turn the switch "OFF" to disable ajax search.', 'cocoon' ),
				'section'         => 'header',
				'default'         => true,
				'priority'        => 10,
				'active_callback' => [
					[
						'setting'  => 'cocoon_menu_buttons',
						'value'    => 1,
						'operator' => '==',
					],
					[
						'setting'  => 'menu_extras',
						'operator' => 'contains',
						'value'    => 'search',
					],
				],
			],

			// FOOTER OPTIONS.
			'cocoon_footer_skin'                 => [
				'type'        => 'select',
				'label'       => esc_html__( 'Footer Skin', 'cocoon' ),
				'description' => esc_html__( 'Choose your footer style-skin.', 'cocoon' ),
				'section'     => 'footer',
				'default'     => 'dark-skin',
				'priority'    => 10,
				'choices'     => [
					'light-skin' => esc_html__( 'Light Skin', 'cocoon' ),
					'dark-skin'  => esc_html__( 'Dark Skin', 'cocoon' ),
				],
			],
			'cocoon_footer_info'                 => [
				'type'        => 'switch',
				'label'       => esc_html__( 'Footer Info Section', 'cocoon' ),
				'description' => esc_html__( 'Turn the switch "OFF" to remove the footer info section. ', 'cocoon' ),
				'section'     => 'footer',
				'default'     => true,
				'priority'    => 10,
			],

			'cocoon_footer_sidebar_1'            => [
				'type'            => 'select',
				'label'           => esc_html__( 'Footer Sidebar Column 1', 'cocoon' ),
				'description'     => '',
				'section'         => 'footer',
				'default'         => 'col-lg-6 col-md-6 col-sm-6 col-12',
				'priority'        => 10,
				'choices'         => [
					'col-12'                            => esc_html__( 'Full Width', 'cocoon' ),
					'col-lg-9 col-md-9 col-sm-9 col-12' => esc_html__( '3/4', 'cocoon' ),
					'col-lg-8 col-md-8 col-sm-8 col-12' => esc_html__( '2/3', 'cocoon' ),
					'col-lg-6 col-md-6 col-sm-6 col-12' => esc_html__( '1/2', 'cocoon' ),
					'col-lg-4 col-md-4 col-sm-4 col-12' => esc_html__( '1/3', 'cocoon' ),
					'col-lg-3 col-md-6 col-sm-12'       => esc_html__( '1/4', 'cocoon' ),
					'disabled'                          => esc_html__( 'disabled', 'cocoon' ),
				],
				'active_callback' => [
					[
						'setting'  => 'cocoon_footer_info',
						'value'    => true,
						'operator' => '==',
					],
				],
			],

			'cocoon_footer_sidebar_2'            => [
				'type'            => 'select',
				'label'           => esc_html__( 'Footer Sidebar Column 2', 'cocoon' ),
				'description'     => '',
				'section'         => 'footer',
				'default'         => 'col-lg-3 col-md-6 col-sm-12',
				'priority'        => 10,
				'choices'         => [
					'col-12'                            => esc_html__( 'Full Width', 'cocoon' ),
					'col-lg-9 col-md-9 col-sm-9 col-12' => esc_html__( '3/4', 'cocoon' ),
					'col-lg-8 col-md-8 col-sm-8 col-12' => esc_html__( '2/3', 'cocoon' ),
					'col-lg-6 col-md-6 col-sm-6 col-12' => esc_html__( '1/2', 'cocoon' ),
					'col-lg-4 col-md-4 col-sm-4 col-12' => esc_html__( '1/3', 'cocoon' ),
					'col-lg-3 col-md-6 col-sm-12'       => esc_html__( '1/4', 'cocoon' ),
					'disabled'                          => esc_html__( 'disabled', 'cocoon' ),
				],
				'active_callback' => [
					[
						'setting'  => 'cocoon_footer_info',
						'value'    => true,
						'operator' => '==',
					],
				],
			],

			'cocoon_footer_sidebar_3'            => [
				'type'            => 'select',
				'label'           => esc_html__( 'Footer Sidebar Column 3', 'cocoon' ),
				'description'     => '',
				'section'         => 'footer',
				'default'         => 'col-lg-3 col-md-6 col-sm-12',
				'priority'        => 10,
				'choices'         => [
					'col-12'                            => esc_html__( 'Full Width', 'cocoon' ),
					'col-lg-9 col-md-9 col-sm-9 col-12' => esc_html__( '3/4', 'cocoon' ),
					'col-lg-8 col-md-8 col-sm-8 col-12' => esc_html__( '2/3', 'cocoon' ),
					'col-lg-6 col-md-6 col-sm-6 col-12' => esc_html__( '1/2', 'cocoon' ),
					'col-lg-4 col-md-4 col-sm-4 col-12' => esc_html__( '1/3', 'cocoon' ),
					'col-lg-3 col-md-6 col-sm-12'       => esc_html__( '1/4', 'cocoon' ),
					'disabled'                          => esc_html__( 'disabled', 'cocoon' ),
				],
				'active_callback' => [
					[
						'setting'  => 'cocoon_footer_info',
						'value'    => true,
						'operator' => '==',
					],
				],
			],

			'cocoon_footer_sidebar_4'            => [
				'type'            => 'select',
				'label'           => esc_html__( 'Footer Sidebar Column 4', 'cocoon' ),
				'description'     => '',
				'section'         => 'footer',
				'default'         => 'disabled',
				'priority'        => 10,
				'choices'         => [
					'col-12'                            => esc_html__( 'Full Width', 'cocoon' ),
					'col-lg-9 col-md-9 col-sm-9 col-12' => esc_html__( '3/4', 'cocoon' ),
					'col-lg-8 col-md-8 col-sm-8 col-12' => esc_html__( '2/3', 'cocoon' ),
					'col-lg-6 col-md-6 col-sm-6 col-12' => esc_html__( '1/2', 'cocoon' ),
					'col-lg-4 col-md-4 col-sm-4 col-12' => esc_html__( '1/3', 'cocoon' ),
					'col-lg-3 col-md-6 col-sm-12'       => esc_html__( '1/4', 'cocoon' ),
					'disabled'                          => esc_html__( 'disabled', 'cocoon' ),
				],
				'active_callback' => [
					[
						'setting'  => 'cocoon_footer_info',
						'value'    => true,
						'operator' => '==',
					],
				],
			],

			'cocoon_copyrights'                  => [
				'type'        => 'textarea',
				'label'       => esc_html__( 'Copyrights text', 'cocoon' ),
				'description' => esc_html__( 'Enter your Copyright Text (HTML allowed).', 'cocoon' ),
				'default'     => '&copy; Cocoon. Developed by <a href="http://themeforest.net/user/gnodesign/portfolio?ref=gnodesign" target="_blank">Gnodesign</a>',
				'section'     => 'footer',
				'priority'    => 10,
			],

			'cocoon_footer_socials'              => [
				'type'        => 'repeater',
				'label'       => esc_html__( 'Social Media', 'cocoon' ),
				'description' => esc_html__( 'Choose the social media that you want to be displayed in the footer.', 'cocoon' ),
				'section'     => 'footer',
				'priority'    => 10,
				'default'     => '',
				'fields'      => [
					'social_type' => [
						'type'        => 'select',
						'label'       => esc_html__( 'Social Media Type', 'cocoon' ),
						'description' => esc_html__( 'Choose your social media type.', 'cocoon' ),
						'default'     => '',
						'priority'    => 10,
						'choices'     => [
							''            => '-',
							'facebook'    => 'Facebook',
							'twitter'     => 'Twitter',
							'google-plus' => 'Google Plus',
							'instagram'   => 'Instagram',
							'linkedin'    => 'LinkedIN',
							'pinterest'   => 'Pinterest',
							'tumblr'      => 'Tumblr',
							'github'      => 'GitHub',
							'dribbble'    => 'Dribbble',
							'rss'         => 'RSS',
							'wordpress'   => 'WordPress',
							'amazon'      => 'Amazon',
							'dropbox'     => 'Dropbox',
							'paypal'      => 'PayPal',
							'yahoo'       => 'Yahoo',
							'flickr'      => 'Flickr',
							'reddit'      => 'Reddit',
							'vimeo'       => 'Vimeo',
							'spotify'     => 'Spotify',
							'youtube'     => 'YouTube',
						],
					],
					'link_url'    => [
						'type'        => 'text',
						'label'       => esc_html__( 'Social URL', 'cocoon' ),
						'description' => esc_html__( 'Enter the URL for this social', 'cocoon' ),
						'default'     => '',
					],
				],
			],

			// GENERAL BLOG OPTIONS
			'cocoon_blog_page_header_bg'         => [
				'type'        => 'upload',
				'label'       => esc_html__( 'Page Header Background Image', 'cocoon' ),
				'description' => esc_html__( 'Upload your a background image for the "page header"', 'cocoon' ),
				'section'     => 'blog',
				'priority'    => 10,
			],

			'cocoon_blog_title'                  => [
				'type'     => 'text',
				'label'    => esc_html__( 'Blog Title', 'cocoon' ),
				'default'  => esc_html__( 'Latest News', 'cocoon' ),
				'section'  => 'blog',
				'priority' => 10,
			],

			'cocoon_blog_meta'                   => [
				'type'        => 'multicheck',
				'label'       => esc_html__( 'Meta Informations on Blog Posts', 'cocoon' ),
				'description' => esc_html__( 'Set which elements of posts meta data you want to display on blog and archive pages.', 'cocoon' ),
				'section'     => 'blog',
				'default'     => [ 'author', 'date', 'cat', 'com' ],
				'priority'    => 10,
				'choices'     => [
					'author' => esc_html__( 'Author', 'cocoon' ),
					'date'   => esc_html__( 'Date', 'cocoon' ),
					'cat'    => esc_html__( 'Categories', 'cocoon' ),
					'tags'   => esc_html__( 'Tags', 'cocoon' ),
					'com'    => esc_html__( 'Comments', 'cocoon' ),
				],
			],

			'cocoon_blog_sidebar_custom'         => [
				'type'     => 'custom',
				'section'  => 'blog',
				'default'  => '<hr>',
				'priority' => 10,
			],

			'cocoon_blog_sidebar'                => [
				'type'        => 'switch',
				'label'       => esc_html__( 'Blog Sidebar', 'cocoon' ),
				'description' => esc_html__( 'Turn the switch "OFF" if you want to disable the sidebar on the blog pages.', 'cocoon' ),
				'section'     => 'blog',
				'priority'    => 10,
				'default'     => 1,
			],

			'cocoon_blog_sidebar_side'           => [
				'type'            => 'select',
				'label'           => esc_html__( 'Blog Sidebar Side', 'cocoon' ),
				'description'     => esc_html__( 'Choose on which side you want the sidebar to be.', 'cocoon' ),
				'section'         => 'blog',
				'default'         => 'sidebar-right',
				'priority'        => 10,
				'choices'         => [
					'sidebar-right' => esc_html__( 'Sidebar Right', 'cocoon' ),
					'sidebar-left'  => esc_html__( 'Sidebar Left', 'cocoon' ),
				],
				'active_callback' => [
					[
						'setting'  => 'cocoon_blog_sidebar',
						'operator' => '==',
						'value'    => 1,
					],
				],
			],

			// SINGLE POST OPTIONS.
			'cocoon_single_blog_meta'            => [
				'type'        => 'multicheck',
				'label'       => esc_html__( 'Meta Informations on Single Blog Posts', 'cocoon' ),
				'description' => esc_html__( 'Set which elements of posts meta data you want to display on single post.', 'cocoon' ),
				'section'     => 'single_blog_post',
				'default'     => [ 'author', 'date', 'cat', 'com' ],
				'priority'    => 10,
				'choices'     => [
					'author' => esc_html__( 'Author', 'cocoon' ),
					'date'   => esc_html__( 'Date', 'cocoon' ),
					'cat'    => esc_html__( 'Categories', 'cocoon' ),
					'tags'   => esc_html__( 'Tags', 'cocoon' ),
					'com'    => esc_html__( 'Comments', 'cocoon' ),
				],
			],

			'cocoon_post_share'                  => [
				'type'        => 'switch',
				'label'       => esc_html__( 'Show Sharing Icons', 'cocoon' ),
				'description' => esc_html__( 'Display social sharing icons on single post', 'cocoon' ),
				'section'     => 'single_blog_post',
				'default'     => true,
				'priority'    => 10,
			],

			// SEARCH PAGE OPTIONS.
			'cocoon_search_page_header_bg'       => [
				'type'        => 'upload',
				'label'       => esc_html__( 'Page Header Background Image', 'cocoon' ),
				'description' => esc_html__( 'Upload your a background image for the "page header"', 'cocoon' ),
				'section'     => 'search_page',
				'priority'    => 10,
			],

			// 404 PAGE OPTIONS.
			'cocoon_404_page_header_bg'          => [
				'type'        => 'upload',
				'label'       => esc_html__( 'Page Header Background Image', 'cocoon' ),
				'description' => esc_html__( 'Upload your a background image for the "page header"', 'cocoon' ),
				'section'     => 'page_not_found',
				'priority'    => 10,
			],

			// MAP OPTIONS.
			'cocoon_gmap_api_key'                => [
				'type'        => 'text',
				'label'       => esc_html__( 'API Key', 'cocoon' ),
				'description' => esc_html__( 'Add your Google Map API Key here', 'cocoon' ),
				'section'     => 'map_options',
				'priority'    => 10,
				'default'     => '',
			],

			// WOOCOMMERCE.
			'cocoon_catalog_mode'                => [
				'type'        => 'switch',
				'label'       => esc_html__( 'Catalog Mode', 'cocoon' ),
				'description' => esc_html__( 'Turn the switch "ON" to hide all "Add To Cart" buttons on your site.', 'cocoon' ),
				'section'     => 'shop_general',
				'priority'    => 10,
				'default'     => 0,
			],

			'cocoon_catalog_custom'              => [
				'type'     => 'custom',
				'section'  => 'shop_general',
				'default'  => '<hr>',
				'priority' => 10,
			],

			'cocoon_ajax_shop'                   => [
				'type'        => 'switch',
				'label'       => esc_html__( 'Shop AJAX', 'cocoon' ),
				'description' => esc_html__( 'Turn the switch "OFF" if you want to disable AJAX functionality for the shop.', 'cocoon' ),
				'section'     => 'shop_general',
				'priority'    => 10,
				'default'     => 1,
			],

			'cocoon_shop_page_header_bg'         => [
				'type'        => 'upload',
				'label'       => esc_html__( 'Page Header Background Image', 'cocoon' ),
				'description' => esc_html__( 'Upload your a background image for the "shop page"', 'cocoon' ),
				'section'     => 'shop_general',
				'priority'    => 10,
			],

			'cocoon_shop_sidebar'                => [
				'type'        => 'switch',
				'label'       => esc_html__( 'Shop Sidebar', 'cocoon' ),
				'description' => esc_html__( 'Turn the switch "OFF" if you want to disable the sidebar on the shop page.', 'cocoon' ),
				'section'     => 'shop_general',
				'priority'    => 10,
				'default'     => 1,
			],

			'cocoon_shop_sidebar_side'           => [
				'type'            => 'select',
				'label'           => esc_html__( 'Shop Sidebar Side', 'cocoon' ),
				'description'     => esc_html__( 'Choose on which side you want the sidebar to be.', 'cocoon' ),
				'section'         => 'shop_general',
				'default'         => 'sidebar-right',
				'priority'        => 10,
				'choices'         => [
					'sidebar-right' => esc_html__( 'Sidebar Right', 'cocoon' ),
					'sidebar-left'  => esc_html__( 'Sidebar Left', 'cocoon' ),
				],
				'active_callback' => [
					[
						'setting'  => 'cocoon_shop_sidebar',
						'value'    => true,
						'operator' => '==',
					],
				],
			],

			'cocoon_shop_custom'                 => [
				'type'     => 'custom',
				'section'  => 'shop_general',
				'default'  => '<hr>',
				'priority' => 10,
			],

			'cocoon_shop_nav_type'               => [
				'type'        => 'select',
				'label'       => esc_html__( 'Navigation Type', 'cocoon' ),
				'description' => esc_html__( 'Choose on which type of navigation you want for your shop.', 'cocoon' ),
				'section'     => 'shop_general',
				'default'     => 'ajax',
				'priority'    => 10,
				'choices'     => [
					'links'    => esc_html__( 'Numeric', 'cocoon' ),
					'ajax'     => esc_html__( 'Load More Button', 'cocoon' ),
					'infinite' => esc_html__( 'Infinite Scroll', 'cocoon' ),
				],
			],

			// BADGES.
			'cocoon_show_badges'                 => [
				'type'        => 'toggle',
				'label'       => esc_html__( 'Show Badges', 'cocoon' ),
				'description' => esc_html__( 'Turn the switch "OFF" if you want to hide badges on every product.', 'cocoon' ),
				'section'     => 'shop_badges',
				'default'     => 1,
				'priority'    => 20,
			],

			'cocoon_badges'                      => [
				'type'            => 'multicheck',
				'label'           => esc_html__( 'Badges', 'cocoon' ),
				'description'     => esc_html__( 'Select which badges you want to show', 'cocoon' ),
				'section'         => 'shop_badges',
				'default'         => [ 'hot', 'sale', 'outofstock' ],
				'priority'        => 20,
				'choices'         => [
					'hot'        => esc_html__( 'Hot', 'cocoon' ),
					'sale'       => esc_html__( 'Sale', 'cocoon' ),
					'outofstock' => esc_html__( 'Out Of Stock', 'cocoon' ),
				],
				'active_callback' => [
					[
						'setting'  => 'cocoon_show_badges',
						'operator' => '==',
						'value'    => 1,
					],
				],
			],

			'cocoon_hot_text'                    => [
				'type'            => 'text',
				'label'           => esc_html__( 'Custom Hot Text', 'cocoon' ),
				'section'         => 'shop_badges',
				'default'         => 'Hot',
				'priority'        => 20,
				'active_callback' => [
					[
						'setting'  => 'cocoon_show_badges',
						'operator' => '==',
						'value'    => 1,
					],
					[
						'setting'  => 'cocoon_badges',
						'operator' => 'contains',
						'value'    => 'hot',
					],
				],
			],

			'cocoon_outofstock_text'             => [
				'type'            => 'text',
				'label'           => esc_html__( 'Custom Out Of Stock Text', 'cocoon' ),
				'section'         => 'shop_badges',
				'default'         => 'Sold Out',
				'priority'        => 20,
				'active_callback' => [
					[
						'setting'  => 'cocoon_show_badges',
						'operator' => '==',
						'value'    => 1,
					],
					[
						'setting'  => 'cocoon_badges',
						'operator' => 'contains',
						'value'    => 'outofstock',
					],
				],
			],

			// Product Grid.
			'cocoon_secondary_thumb'             => [
				'type'        => 'toggle',
				'label'       => esc_html__( 'Secondary Product Thumbnail', 'cocoon' ),
				'description' => esc_html__( 'Turn the switch "OFF" to disable secondary product thumbnail when hover over the main product image.', 'cocoon' ),
				'section'     => 'product_grid',
				'default'     => 1,
				'priority'    => 20,
			],

			'cocoon_product_quick_view'          => [
				'type'        => 'toggle',
				'label'       => esc_html__( 'Quick View', 'cocoon' ),
				'description' => esc_html__( 'Turn the switch "OFF" to disable the quick view in every product.', 'cocoon' ),
				'section'     => 'product_grid',
				'default'     => 1,
				'priority'    => 20,
			],

			'cocoon_product_category'            => [
				'type'        => 'toggle',
				'label'       => esc_html__( 'Categories', 'cocoon' ),
				'description' => esc_html__( 'Turn the switch "OFF" to hide the categories in every product.', 'cocoon' ),
				'section'     => 'product_grid',
				'default'     => 1,
				'priority'    => 20,
			],

			'shop_expert_length'                 => [
				'type'     => 'number',
				'label'    => esc_html__( 'Product Description Expert Length', 'cocoon' ),
				'section'  => 'product_grid',
				'default'  => 15,
				'priority' => 20,
			],

			// Single Product.
			'cocoon_product_nav'                 => [
				'type'        => 'switch',
				'label'       => esc_html__( 'Product Navigation', 'cocoon' ),
				'description' => esc_html__( 'Turn the switch "OFF" to disable product navigation', 'cocoon' ),
				'section'     => 'single_product',
				'default'     => 1,
				'priority'    => 20,
			],

			'product_zoom'                       => [
				'type'        => 'switch',
				'label'       => esc_html__( 'Product Zoom', 'cocoon' ),
				'description' => esc_html__( 'Check this option to show a bigger size product image on mouseover.', 'cocoon' ),
				'section'     => 'single_product',
				'default'     => 1,
				'priority'    => 20,
			],

			'single_product_badges'              => [
				'type'        => 'switch',
				'label'       => esc_html__( 'Show Badges', 'cocoon' ),
				'description' => esc_html__( 'Turn the switch "OFF" to disable the badges on single product pages.', 'cocoon' ),
				'section'     => 'single_product',
				'default'     => 1,
				'priority'    => 20,
			],

			'product_share'                      => [
				'type'        => 'switch',
				'label'       => esc_html__( 'Show Sharing Buttons', 'cocoon' ),
				'description' => esc_html__( 'Turn the switch "OFF" if you want to hide the sharing buttons.', 'cocoon' ),
				'section'     => 'single_product',
				'default'     => 1,
				'priority'    => 20,
			],

			'product_upsells_custom'             => [
				'type'     => 'custom',
				'section'  => 'single_product',
				'default'  => '<hr>',
				'priority' => 20,
			],

			'product_upsells'                    => [
				'type'        => 'switch',
				'label'       => esc_html__( 'Show Up-sells Products', 'cocoon' ),
				'description' => esc_html__( 'Turn the switch "OFF" if you want to hide Up-sells products.', 'cocoon' ),
				'section'     => 'single_product',
				'default'     => 1,
				'priority'    => 20,
			],

			'product_related_custom'             => [
				'type'     => 'custom',
				'section'  => 'single_product',
				'default'  => '<hr>',
				'priority' => 20,
			],

			'product_related'                    => [
				'type'        => 'switch',
				'label'       => esc_html__( 'Show Related Products', 'cocoon' ),
				'description' => esc_html__( 'Turn the switch "OFF" if you want to hide related products.', 'cocoon' ),
				'section'     => 'single_product',
				'default'     => 1,
				'priority'    => 20,
			],

			'custom_product_tab_hr'              => [
				'type'     => 'custom',
				'section'  => 'single_product',
				'default'  => '<hr>',
				'priority' => 20,
			],

			'custom_product_tab_1'               => [
				'type'        => 'text',
				'label'       => esc_html__( 'Custom Product Tab 1', 'cocoon' ),
				'description' => esc_html__( 'Enter the text for custom product tab 1', 'cocoon' ),
				'section'     => 'single_product',
				'default'     => esc_html__( 'Size Guide', 'cocoon' ),
				'priority'    => 20,
			],

			'custom_product_tab_2'               => [
				'type'        => 'text',
				'label'       => esc_html__( 'Custom Product Tab 2', 'cocoon' ),
				'description' => esc_html__( 'Enter the text for custom product tab 2', 'cocoon' ),
				'section'     => 'single_product',
				'default'     => esc_html__( 'Shipping', 'cocoon' ),
				'priority'    => 20,
			],

			// SUBSCRIPTION POPUP OPTIONS.
			'cocoon_subscription_popup'          => [
				'type'        => 'switch',
				'label'       => esc_html__( 'Subscription Popup', 'cocoon' ),
				'description' => esc_html__( 'Turn the switch "OFF" if you want to disable the subscription popup.', 'cocoon' ),
				'section'     => 'subscription_popup',
				'default'     => 0,
				'priority'    => 20,
			],

			'subscription_image'                 => [
				'type'            => 'upload',
				'label'           => esc_html__( 'Subscription Image', 'cocoon' ),
				'description'     => esc_html__( 'Upload a Image for the subscription popup.', 'cocoon' ),
				'section'         => 'subscription_popup',
				'priority'        => 20,
				'active_callback' => [
					[
						'setting'  => 'cocoon_subscription_popup',
						'operator' => '==',
						'value'    => 1,
					],
				],
			],

			'subscription_title'                 => [
				'type'            => 'text',
				'label'           => esc_html__( 'Title', 'cocoon' ),
				'description'     => esc_html__( 'Enter the title for the subscription popup.', 'cocoon' ),
				'section'         => 'subscription_popup',
				'default'         => esc_html__( 'Newsletter', 'cocoon' ),
				'priority'        => 20,
				'active_callback' => [
					[
						'setting'  => 'cocoon_subscription_popup',
						'operator' => '==',
						'value'    => 1,
					],
				],
			],

			'subscription_description'           => [
				'type'            => 'textarea',
				'label'           => esc_html__( 'Description', 'cocoon' ),
				'description'     => esc_html__( 'Enter the description for the subscription popup.', 'cocoon' ),
				'section'         => 'subscription_popup',
				'default'         => esc_html__( 'Subscribe now and receive a -50% coupon code.', 'cocoon' ),
				'priority'        => 20,
				'active_callback' => [
					[
						'setting'  => 'cocoon_subscription_popup',
						'operator' => '==',
						'value'    => 1,
					],
				],
			],

			'subscription_form'                  => [
				'type'            => 'textarea',
				'label'           => esc_html__( 'Subscription NewsLetter', 'cocoon' ),
				'description'     => sprintf( wp_kses_post( 'Please go to <a href="%s">MailChimp Forms</a> to get shortcode and paste it in the textarea below.', 'cocoon' ), admin_url( 'admin.php?page=mailchimp-for-wp-forms' ) ),
				'section'         => 'subscription_popup',
				'default'         => esc_html__( 'Paste the Mailchimp shortcode here.', 'cocoon' ),
				'priority'        => 20,
				'active_callback' => [
					[
						'setting'  => 'cocoon_subscription_popup',
						'operator' => '==',
						'value'    => 1,
					],
				],
			],

			'subscription_custom'                => [
				'type'            => 'custom',
				'section'         => 'subscription_popup',
				'default'         => '<hr>',
				'priority'        => 20,
				'active_callback' => [
					[
						'setting'  => 'cocoon_subscription_popup',
						'operator' => '==',
						'value'    => 1,
					],
				],
			],

			'subscription_style'                 => [
				'type'            => 'select',
				'label'           => esc_html__( 'Subscription Style', 'cocoon' ),
				'description'     => esc_html__( 'Choose how you want the subscription popup to appear. After a certain time or after scrolling on the website.', 'cocoon' ),
				'section'         => 'subscription_popup',
				'default'         => 'delay',
				'priority'        => 20,
				'choices'         => [
					'delay'  => esc_html__( 'Delay', 'cocoon' ),
					'scroll' => esc_html__( 'Scroll', 'cocoon' ),
				],
				'active_callback' => [
					[
						'setting'  => 'cocoon_subscription_popup',
						'operator' => '==',
						'value'    => 1,
					],
				],
			],

			'subscription_delay'                 => [
				'type'            => 'text',
				'label'           => esc_html__( 'Delay', 'cocoon' ),
				'description'     => esc_html__( 'Enter after how many seconds you want the subscription popup to appear.', 'cocoon' ),
				'section'         => 'subscription_popup',
				'default'         => '5',
				'priority'        => 20,
				'active_callback' => [
					[
						'setting'  => 'cocoon_subscription_popup',
						'operator' => '==',
						'value'    => 1,
					],
					[
						'setting'  => 'subscription_style',
						'operator' => 'contains',
						'value'    => 'delay',
					],
				],
			],

			'subscription_scroll'                => [
				'type'            => 'text',
				'label'           => esc_html__( 'Scroll', 'cocoon' ),
				'description'     => esc_html__( 'Enter after how many pixels of scrolling you want the subscription popup to appear.', 'cocoon' ),
				'section'         => 'subscription_popup',
				'default'         => '1000',
				'priority'        => 20,
				'active_callback' => [
					[
						'setting'  => 'cocoon_subscription_popup',
						'operator' => '==',
						'value'    => 1,
					],
					[
						'setting'  => 'subscription_style',
						'operator' => 'contains',
						'value'    => 'scroll',
					],
				],
			],

			// COOKIE NOTICE OPTIONS.
			'cocoon_cookie_notice'               => [
				'type'        => 'switch',
				'label'       => esc_html__( 'Cookie Notice', 'cocoon' ),
				'description' => esc_html__( 'Turn the switch "OFF" if you want to disable the cookie notice.', 'cocoon' ),
				'section'     => 'cookie_bar',
				'default'     => 0,
				'priority'    => 20,
			],

			'cookie_notice_message'              => [
				'type'            => 'textarea',
				'label'           => esc_html__( 'Cookie Text Message', 'cocoon' ),
				'description'     => esc_html__( 'Write the message that you want to show up in the Cookie Notice.', 'cocoon' ),
				'section'         => 'cookie_bar',
				'default'         => esc_html__( 'We use cookies to improve your experience on our website. By browsing this website, you agree to our use of cookies.', 'cocoon' ),
				'priority'        => 20,
				'active_callback' => [
					[
						'setting'  => 'cocoon_cookie_notice',
						'operator' => '==',
						'value'    => 1,
					],
				],
			],

			'cookie_policy_page'                 => [
				'type'            => 'dropdown-pages',
				'label'           => esc_html__( 'Cookie Details Page', 'cocoon' ),
				'description'     => esc_html__( 'Choose page that will contain detailed information about your Privacy Policy.', 'cocoon' ),
				'section'         => 'cookie_bar',
				'default'         => '',
				'priority'        => 20,
				'active_callback' => [
					[
						'setting'  => 'cocoon_cookie_notice',
						'operator' => '==',
						'value'    => 1,
					],
				],
			],

		], // end of fields array.
	]; // end of return array.
} // end of function cocoon_customize_settings.


function cocoon_customize_init() {
	$cocoon_customize = new Cocoon_Customize( cocoon_customize_settings() );
}

if ( class_exists( 'Kirki' ) ) {
	add_action( 'init', 'cocoon_customize_init', 30 );
} else {
	$cocoon_customize = new Cocoon_Customize( cocoon_customize_settings() );
}
