<?php

/**
 *
 * @package Cocoon
 *
 * @since 1.0
 *
 * ========================
 * ENQUEUE FUNCTIONS
 * ========================
 **/

 // Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/*
=====================================================
ENQUEUE STYLES
=====================================================
*/

function cocoon_styles() {
	wp_enqueue_style( 'bootstrap', get_template_directory_uri() . '/assets/vendor/bootstrap/bootstrap.min.css' );
	wp_enqueue_style( 'mmenu', get_template_directory_uri() . '/assets/vendor/mmenu/jquery.mmenu.css' );
	wp_enqueue_style( 'owl-slider', get_template_directory_uri() . '/assets/vendor/owl-carousel/owl.carousel.min.css' );
	wp_enqueue_style( 'magnific-popup', get_template_directory_uri() . '/assets/vendor/magnific-popup/magnific-popup.css' );

	/* Icons */
	wp_enqueue_style( 'font-awesome', get_template_directory_uri() . '/assets/vendor/font-icons/font-awesome.min.css' );
	wp_enqueue_style( 'simple-line-icons', get_template_directory_uri() . '/assets/vendor/font-icons/simple-line-icons.min.css' );
	wp_enqueue_style( 'iconsmind', get_template_directory_uri() . '/assets/vendor/font-icons/iconsmind.min.css' );

	/* Main Styles */
	wp_enqueue_style( 'cocoon-style', get_template_directory_uri() . '/style.css', [], COCOON_VERSION );
    wp_enqueue_style( 'cocoon-woocommerce', get_template_directory_uri() . '/assets/dist/css/woocommerce.css', [], COCOON_VERSION );
	wp_enqueue_style( 'cocoon-frontend', get_template_directory_uri() . '/assets/dist/css/frontend.css', [], COCOON_VERSION );
}

add_action( 'wp_enqueue_scripts', 'cocoon_styles' );

/*
=====================================================
ENQUEUE SCRIPTS
=====================================================
*/

function cocoon_scripts() {
	wp_enqueue_script( 'bootstrap', get_template_directory_uri() . '/assets/vendor/bootstrap/bootstrap.min.js', [ 'jquery' ], false, true );
	wp_enqueue_script( 'mmenu', get_template_directory_uri() . '/assets/vendor/mmenu/jquery.mmenu.js', [ 'jquery' ], false, true );
	wp_enqueue_script( 'owl-slider', get_template_directory_uri() . '/assets/vendor/owl-carousel/owl.carousel.min.js', [ 'jquery' ], false, true );
	wp_enqueue_script( 'imagesloaded' );
	wp_enqueue_script( 'magnific-popup', get_template_directory_uri() . '/assets/vendor/magnific-popup/jquery.magnific-popup.min.js', [ 'jquery' ], false, true );
	wp_enqueue_script( 'isotope', get_template_directory_uri() . '/assets/vendor/isotope/isotope.min.js', [ 'jquery' ], false, true );
	wp_enqueue_script( 'zoom', get_template_directory_uri() . '/assets/vendor/zoom/jquery.zoom.min.js', [ 'jquery' ], false, true );
	wp_enqueue_script( 'cookie', get_template_directory_uri() . '/assets/vendor/cookie/jquery.cookie.min.js', [ 'jquery' ], false, true );
	wp_enqueue_script( 'lazyload', get_template_directory_uri() . '/assets/vendor/lazyload/jquery.lazyload.min.js', [ 'jquery' ], false, true );
	wp_enqueue_script( 'wc-add-to-cart-variation' );

	// Google Maps.
	$google_api = cocoon_get_option( 'cocoon_gmap_api_key' );
	if ( ! empty( $google_api ) ) {
		wp_enqueue_script( 'google-maps', 'https://maps.google.com/maps/api/js?key=' . esc_attr( $google_api ) . '&libraries=places' );
	}

	// Comment Reply Script.
	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}

	// Slick Slider.
	if ( is_singular( 'product' ) ) {
		wp_enqueue_script( 'slick', get_template_directory_uri() . '/assets/vendor/slick/slick.min.js', [ 'jquery' ], false, true );
	}

	// Photoswipe.
	if ( is_singular() ) {

		$photoswipe = 'photoswipe';
		if ( wp_style_is( $photoswipe, 'registered' ) && ! wp_style_is( $photoswipe, 'enqueued' ) ) {
			wp_enqueue_style( $photoswipe );
		}

		$photoswipe_skin = 'photoswipe-default-skin';
		if ( wp_style_is( $photoswipe_skin, 'registered' ) && ! wp_style_is( $photoswipe_skin, 'enqueued' ) ) {
			wp_enqueue_style( $photoswipe_skin );
		}

		$photoswipe_ui = 'photoswipe-ui-default';
		if ( wp_script_is( $photoswipe_ui, 'registered' ) && ! wp_script_is( $photoswipe_ui, 'enqueued' ) ) {
			wp_enqueue_script( $photoswipe_ui );
		}
	}

	// Main Theme JS File.
	wp_enqueue_script( 'cocoon-main', get_template_directory_uri() . '/assets/dist/js/frontend.js', [ 'jquery' ], COCOON_VERSION, true );

	$ajax_url     = admin_url( 'admin-ajax.php', 'relative' );
	$ajax_search  = intval( cocoon_get_option( 'cocoon_ajax_search' ) );
	$product_zoom = intval( cocoon_get_option( 'product_zoom' ) );
	$wc_active    = intval( cocoon_wc_is_activated() );
	if ( cocoon_wc_is_activated() ) {
		$wc_account = get_permalink( wc_get_page_id( 'myaccount' ) );
	} else {
		$wc_account = '';
	}

	$translations = [
		'ajax_url'            => esc_url( $ajax_url ),
		'nonce'               => wp_create_nonce( '_cocoon_nonce' ),
		'ajax_search'         => $ajax_search,
		'cart_message'        => esc_html__( ' has been added to your cart.', 'cocoon' ),
		'product_zoom'        => $product_zoom,
		'wc_active'           => $wc_active,
		'wc_account'          => $wc_account,
		'subscription_popup'  => intval( cocoon_get_option( 'cocoon_subscription_popup' ) ),
		'cocoon_popup_style'  => cocoon_get_option( 'subscription_style' ),
		'cocoon_popup_delay'  => intval( cocoon_get_option( 'subscription_delay' ) ),
		'cocoon_popup_scroll' => intval( cocoon_get_option( 'subscription_scroll' ) ),
		'shop_nav_type'       => cocoon_get_option( 'cocoon_shop_nav_type' ),
		'cookie_notice'       => intval( cocoon_get_option( 'cocoon_cookie_notice' ) ),
		'ajax_shop'           => intval( cocoon_get_option( 'cocoon_ajax_shop' ) ),
	];

	wp_localize_script( 'cocoon-main', 'cocoon_settings', $translations );
}

add_action( 'wp_enqueue_scripts', 'cocoon_scripts' );

/*
=====================================================
ADMIN ENQUEUE SCRIPTS
=====================================================
*/

function cocoon_admin_scripts( $hook ) {

}

// add_action( 'admin_enqueue_scripts', 'cocoon_admin_scripts' );
