<?php
/**
 *
 * @package Cocoon
 *
 * @since 1.0
 *
 * ========================
 * POPUPS TEMPLATE
 * ========================
 **/

$back_top                 = cocoon_get_option( 'cocoon_back_top' );
$preload                  = cocoon_get_option( 'cocoon_preloader' );
$subscription_popup       = cocoon_get_option( 'cocoon_subscription_popup' );
$subscription_image       = cocoon_get_option( 'subscription_image' );
$subscription_title       = cocoon_get_option( 'subscription_title' );
$subscription_description = cocoon_get_option( 'subscription_description' );
$subscription_form        = cocoon_get_option( 'subscription_form' );
?>




<!-- =============== START OF RESPONSIVE - MAIN NAV =============== -->
<nav id="main-mobile-nav"></nav>
<!-- =============== END OF RESPONSIVE - MAIN NAV =============== -->


<?php
if ( $back_top == true ) {
	?>
	<!-- ===== Start of Back to Top Button ===== -->
	<div id="backtotop">
		<a href="#"></a>
	</div>
	<!-- ===== End of Back to Top Button ===== -->
	<?php
}


if ( $preload == 1 ) {
	?>
	<!-- ===== Start of Preloader ===== -->
	<div id="preloader"><div data-loader="circle-side"></div></div>
	<!-- ===== End of Preloader ===== -->
	<?php
}


if ( shortcode_exists( 'woocommerce_my_account' ) && ! is_user_logged_in() && ! is_account_page() ) {
	?>
	<!-- ===== Start of Login Modal ===== -->
	<div id="login-modal" class="login-modal" tabindex="-1" role="dialog">

		<h5><?php esc_html_e( 'My Account', 'cocoon' ); ?></h5>
		<div class="container">
			<?php echo do_shortcode( '[woocommerce_my_account]' ); ?>
		</div>
		<a href="#" class="close-modal"><i class="icon-close"></i></a>
	</div>
	<!-- ===== End of Login Modal ===== -->
	<?php
}


if ( $subscription_popup == 1 ) {
	?>
	<!-- ===== Start of Subscription Popup ===== -->
	<div class="subscription-popup zoom-anim-dialog">
			<div class="row">
				<div class="col-md-6 col-sm-12 col-xs-12 subscription-image-wrapper">
					<div class="subscription-image" style="background-image: url(<?php echo esc_attr( $subscription_image ); ?>);"></div>
				</div>

				<div class="col-md-6 col-sm-12 col-xs-12 subscription-content">
					<div class="content-wrapper">
						<h3 class="title"><?php echo esc_html( $subscription_title ); ?></h3>
						<p><?php echo esc_html( $subscription_description ); ?></p>

						<div class="subscription-form">
							<?php echo do_shortcode( wp_kses( $subscription_form, wp_kses_allowed_html( 'post' ) ) ); ?>
						</div>
					</div>
				</div>

			</div>
	</div>
	<!-- ===== End of Subscription Popup ===== -->
	<?php
}
