<?php
/**
*
* @package Cocoon
*
* @since 1.2.0
* 
* ========================
* TEMPLATE FOR HEADER VERSION 2
* ========================
*     
**/
?>

<header class="header2">

    <!-- =============== Start of Header Content =============== -->
    <div class="header-content">
        <div class="container">

            <!-- ====== Start of Logo Wrapper ====== -->
            <div class="logo-wrapper">
                <?php if ( cocoon_get_option('logo') ) { ?>
                    <a class="navbar-brand logo-wrapper" href="<?php echo esc_url( home_url('/') ); ?>" title="<?php esc_attr(bloginfo('name')); ?>" rel="home">
                        <!-- Logo -->
                        <img src="<?php echo esc_url( cocoon_get_option('logo') ); ?>" class="logo" alt="<?php esc_attr(bloginfo('name')); ?>" />
                    </a>
                <?php } elseif ( cocoon_get_option('logo_text') ) { ?>
                    <h1 class="logo">
                        <a href="<?php echo esc_url( home_url('/') ); ?>" rel="home"><?php echo esc_html( cocoon_get_option('logo_text') ); ?></a>
                    </h1>
                <?php } else { ?>
                    <a class="navbar-brand" href="<?php echo esc_url( home_url('/') ); ?>" title="<?php esc_html(bloginfo('name')); ?>" rel="home">
                        <!-- INSERT YOUR LOGO HERE -->
                        <img src="<?php echo esc_url(get_template_directory_uri()  . '/assets/images/logo.svg'); ?>" alt="<?php esc_attr(bloginfo('name')); ?>" width="150" class="logo">
                    </a>
                <?php } ?>
            </div>
            <!-- ====== End of Logo Wrapper ====== -->
            
            <!-- ====== Start of Search Wrapper ====== -->
            <div class="general-search-wrapper">
                <form class="general-search" role="search" method="get" action="<?php echo esc_url( home_url( '/' ) ); ?>">
                    <input type="text" class="search-field" name="s" placeholder="<?php esc_attr_e( 'Search Products', 'cocoon'); ?>" autocomplete="off">
                    <input type="hidden" name="post_type" value="product">
                    <span id="general-search-close" class="icon-close toggle-search"></span>
                </form>

                <div class="search-results">
                    <div class="loading"></div>
                    <div class="woocommerce"></div>
                </div>
            </div>
            <!-- ====== End of Search Wrapper ====== -->

            <!-- ====== Start of Extra Menu Items Wrapper ====== -->
            <div class="extra-menu-items navbar-expand-lg">                
                <?php 
                $header_btns    = cocoon_get_option('menu_extras'); 
                $catalog_mode   = cocoon_get_option('cocoon_catalog_mode');
                ?>

                <!-- ====== Start of Extra Nav ====== -->
                <ul class="navbar-nav extra-nav">
                    <?php
                    //Show language switcher in the header when it is enabled.
                    if (in_array('lang', $header_btns)) { ?>
                        <!-- Menu Item -->
                        <li class="nav-item menu-item-language">
                            <?php echo cocoon_language_switcher(); ?>
                        </li>
                    <?php }

                    //Show currency switcher in the header when it is enabled.
                    if (in_array('currency', $header_btns)) { ?>
                        <!-- Menu Item -->
                        <li class="nav-item menu-item-currency">
                            <?php echo cocoon_currency_switcher(); ?>
                        </li>
                    <?php }

                    //Show Wishlist in the header when it is enabled.
                    if (in_array('wishlist', $header_btns)) {
                        if ( function_exists( 'YITH_WCWL' ) ) { ?>
                            <!-- Menu Item -->
                            <li class="nav-item menu-item-wishlist">
                                <a class="nav-link wishlist" href="<?php echo esc_url( get_permalink( get_option( 'yith_wcwl_wishlist_page_id' ) ) ); ?>">
                                    <i class="icon-heart"></i>
                                    <span class="notification-count"><?php echo esc_html(intval( YITH_WCWL()->count_products() )); ?></span>
                                </a>
                            </li>
                        <?php }
                    }

                    //Show Cart in the header when it is enabled.
                    if (in_array('cart', $header_btns) && !$catalog_mode ) {
                        if ( function_exists( 'woocommerce_mini_cart' ) ) {

                            global $woocommerce; ?>

                            <!-- Menu Item -->
                            <li class="nav-item menu-item-cart">
                                <a class="nav-link cart" href="<?php echo esc_url( wc_get_cart_url() ); ?>">
                                    <i class="icon-bag"></i>
                                    <span class="notification-count">
                                        <?php echo esc_html(intval( $woocommerce->cart->cart_contents_count )); ?>
                                    </span>
                                </a>
                            </li>
                        <?php }
                    }


                    //Show account in the header when it is enabled.
                    if (in_array('account', $header_btns)) { ?>
                        <?php
                        if( cocoon_wc_is_activated() ) {
                            $account_link = get_permalink( get_option('woocommerce_myaccount_page_id') );
                        } else {
                            $account_link = '#';
                        }

                        // If user is logged in
                        if ( is_user_logged_in() ) {
                            $user_id = get_current_user_id();
                            ?>

                            <!-- Menu Item -->
                            <li class="nav-item menu-item-account loggedin">
                                <a href="<?php echo esc_url($account_link); ?>" class="nav-link login-btn">
                                    <?php echo get_avatar( get_the_author_meta( 'ID', $user_id ), 30 ); ?>
                                </a>
                            </li>

                        <?php // When user is not logged in
                        } else { ?>
                            <!-- Menu Item -->
                            <li class="nav-item menu-item-account">
                                <a href="#" class="nav-link login-btn">
                                    <i class="icon-user"></i>
                                </a>
                            </li>
                        <?php }
                    } ?>
                </ul>
                <!-- ====== End of Extra Nav ====== -->                
            </div>
            <!-- ====== End of Extra Menu Items Wrapper ====== -->

            <?php if ( cocoon_wc_is_activated() ) { 
                global $woocommerce; ?>
                <a href="<?php echo esc_url( wc_get_cart_url() ); ?>" class="mobile-cart">
                    <i class="icon-bag"></i>
                    <span class="notification-count">
                        <?php echo esc_html(intval( $woocommerce->cart->cart_contents_count )); ?>
                    </span>
                </a>
            <?php } ?>

            <button id="mobile-nav-toggler" class="hamburger hamburger--collapse" type="button">
               <span class="hamburger-box">
                  <span class="hamburger-inner"></span>
               </span>
            </button>
            
        </div>
    </div>
    <!-- ====== End of Header Content ====== -->


    <!-- =============== Start of Navigation Wrapper =============== -->
    <div class="navigation-wrapper">
        <div class="container">
            
            <!-- ====== Start of Navbar ====== -->
            <nav class="navbar navbar-expand-lg">
                <!-- ====== Start of #main-nav ====== -->
                <div class="navbar-collapse" id="main-nav">


                    <?php 
                    // Main Menu
                    wp_nav_menu( array(
                        'theme_location'    => 'primary',
                        'container'         => false,
                        'menu_class'        => 'navbar-nav main-nav mx-auto',
                        'walker'            => new Cocoon_Mega_Menu_Walker(),
                        'fallback_cb'       => 'cocoon_menu_fallback'
                    ) );
                    ?>

                </div>
                <!-- ====== End of #main-nav ====== -->
            </nav>
            <!-- ====== End of Navbar ====== -->
        
        </div>
    </div>
    <!-- ====== End of Navigation Wrapper ====== -->

</header>
