<?php

$options = apply_filters(
	'colormag_breadcrumb_options',
	array(
		'colormag_breadcrumb_enable'               => array(
			'title'   => esc_html__( 'Enable', 'colormag' ),
			'default' => 0,
			'type'    => 'customind-toggle',
			'section' => 'colormag_breadcrumb_section',
		),
		'colormag_breadcrumb_type'                 => array(
			'default'   => 'colormag_breadcrumb',
			'type'      => 'customind-select',
			'title'     => esc_html__( 'Type', 'colormag' ),
			'section'   => 'colormag_breadcrumb_section',
			'choices'   => array(
				'colormag_breadcrumb' => esc_html__( 'ColorMag Theme', 'colormag' ),
				'yoast_seo_navxt'     => esc_html__( 'Yoast SEO/NavXT', 'colormag' ),
			),
			'condition' => array(
				'colormag_breadcrumb_enable' => true,
			),
		),
		'colormag_breadcrumb_label'                => array(
			'title'     => esc_html__( 'Label', 'colormag' ),
			'default'   => esc_html__( 'You are here:', 'colormag' ),
			'type'      => 'customind-text',
			'section'   => 'colormag_breadcrumb_section',
			'partial'   => array(
				'selector'        => '.breadcrumbs .breadcrumb-title',
				'render_callback' => array(
					'ColorMag_Customizer_Partials',
					'render_breadcrumb_label',
				),
			),
			'condition' => array(
				'colormag_breadcrumb_enable' => true,
			),
		),
		'colormag_breadcrumb_label_color'          => array(
			'default'   => '',
			'type'      => 'customind-color',
			'title'     => esc_html__( 'Label Color', 'colormag' ),
			'transport' => 'postMessage',
			'section'   => 'colormag_breadcrumb_section',
			'condition' => array(
				'colormag_breadcrumb_enable' => true,
				'colormag_breadcrumb_type'   => 'colormag_breadcrumb',
			),
		),
		'colormag_breadcrumb_link_color'           => array(
			'default'   => '',
			'type'      => 'customind-color',
			'title'     => esc_html__( 'Link Color', 'colormag' ),
			'transport' => 'postMessage',
			'section'   => 'colormag_breadcrumb_section',
			'condition' => array(
				'colormag_breadcrumb_enable' => true,
				'colormag_breadcrumb_type'   => 'colormag_breadcrumb',
			),
		),
		'colormag_breadcrumb_active_color'         => array(
			'default'   => '',
			'type'      => 'customind-color',
			'title'     => esc_html__( 'Active Color', 'colormag' ),
			'transport' => 'postMessage',
			'section'   => 'colormag_breadcrumb_section',
			'condition' => array(
				'colormag_breadcrumb_enable' => true,
				'colormag_breadcrumb_type'   => 'colormag_breadcrumb',
			),
		),
		'colormag_breadcrumb_typography'           => array(
			'default'   => array(
				'font-family'    => 'inherit',
				'font-weight'    => '400',
				'subsets'        => array( 'latin' ),
				'font-size'      => array(
					'desktop' => array(
						'size' => '',
						'unit' => 'px',
					),
					'tablet'  => array(
						'size' => '',
						'unit' => '',
					),
					'mobile'  => array(
						'size' => '',
						'unit' => '',
					),
				),
				'line-height'    => array(
					'desktop' => array(
						'size' => '1.5',
						'unit' => '-',
					),
					'tablet'  => array(
						'size' => '',
						'unit' => '',
					),
					'mobile'  => array(
						'size' => '',
						'unit' => '',
					),
				),
				'font-style'     => 'normal',
				'text-transform' => 'none',
			),
			'type'      => 'customind-typography',
			'title'     => esc_html__( 'Typography', 'colormag' ),
			'section'   => 'colormag_breadcrumb_section',
			'transport' => 'postMessage',
			'condition' => array(
				'colormag_breadcrumb_enable' => true,
				'colormag_breadcrumb_type'   => 'colormag_breadcrumb',
			),
		),
		'colormag_breadcrumb_separator_icon_color' => array(
			'default'   => '',
			'type'      => 'customind-color',
			'title'     => esc_html__( 'Color', 'colormag' ),
			'transport' => 'postMessage',
			'section'   => 'colormag_breadcrumb_section',
			'condition' => array(
				'colormag_breadcrumb_enable' => true,
			),
		),
		'colormag_breadcrumb_separator_icon'       => array(
			'default'   => 'fa fa-angle-right',
			'type'      => 'customind-fontawesome',
			'title'     => esc_html__( 'Separator Icon', 'colormag' ),
			'section'   => 'colormag_breadcrumb_section',
			'condition' => array(
				'colormag_breadcrumb_enable' => true,
			),
		),
	)
);

colormag_customind()->add_controls( $options );
