<?php
$container_layout_choices = apply_filters(
	'colormag_container_layout_choices',
	array(
		'default'                      => array(
			'label' => 'Inherit',
			'url'   => COLORMAG_PARENT_URL . '/assets/img/sidebar/inherit.svg',
		),
		'no_sidebar_full_width'        => array(
			'label' => 'Normal',
			'url'   => COLORMAG_PARENT_URL . '/assets/img/sidebar/normal.svg',
		),
		'no_sidebar_content_centered'  => array(
			'label' => 'Narrow',
			'url'   => COLORMAG_PARENT_URL . '/assets/img/sidebar/narrow.svg',
		),
		'no_sidebar_content_stretched' => array(
			'label' => 'Full Width',
			'url'   => COLORMAG_PARENT_URL . '/assets/img/sidebar/full-width.svg',
		),
	)
);

$sidebar_layout_choices = apply_filters(
	'colormag_site_layout_choices',
	array(
		'default'       => array(
			'label' => 'Inherit',
			'url'   => COLORMAG_PARENT_URL . '/assets/img/sidebar/inherit.svg',
		),
		'no_sidebar'    => array(
			'label' => 'No Sidebar',
			'url'   => COLORMAG_PARENT_URL . '/assets/img/sidebar/no-sidebar.svg',
		),
		'right_sidebar' => array(
			'label' => 'Right Sidebar',
			'url'   => COLORMAG_PARENT_URL . '/assets/img/sidebar/right-sidebar.svg',
		),
		'left_sidebar'  => array(
			'label' => 'Left Sidebar',
			'url'   => COLORMAG_PARENT_URL . '/assets/img/sidebar/left-sidebar.svg',
		),
		'two_sidebars'  => array(
			'label' => 'Both Sidebar',
			'url'   => COLORMAG_PARENT_URL . '/assets/img/sidebar/both-sidebar.svg',
		),
	)
);
$options                = array(
	'colormag_search_container_tab_group'            => array(
		'type'    => 'customind-tabs',
		'title'   => esc_html__( 'Blog', 'colormag' ),
		'section' => 'colormag_search_section',
		'tabs'    => array(
			'general' => esc_html__( 'General', 'colormag' ),
			'style'   => esc_html__( 'Style', 'colormag' ),
		),
		'default' => 'general',
	),
	'colormag_search_container_layout'               => array(
		'default'   => 'default',
		'type'      => 'customind-radio-image',
		'title'     => esc_html__( 'Container Layout', 'colormag' ),
		'section'   => 'colormag_search_section',
		'tab_group' => 'colormag_search_container_tab_group',
		'tab'       => 'general',
		'choices'   => $container_layout_choices,
		'columns'   => 2,
		'priority'  => 10,
	),
	'colormag_search_sidebar_layout_divider'         => array(
		'type'      => 'customind-divider',
		'variant'   => 'dashed',
		'tab_group' => 'colormag_search_container_tab_group',
		'tab'       => 'general',
		'section'   => 'colormag_search_section',
	),
	'colormag_search_sidebar_layout'                 => array(
		'default'    => 'default',
		'type'       => 'customind-radio-image',
		'title'      => esc_html__( 'Sidebar Layout', 'colormag' ),
		'section'    => 'colormag_search_section',
		'tab_group'  => 'colormag_search_container_tab_group',
		'tab'        => 'general',
		'choices'    => $sidebar_layout_choices,
		'columns'    => 2,
		'priority'   => 10,
		'conditions' => array(
			'relation' => 'OR',
			'terms'    => array(
				// Simple condition
				array(
					'id'       => 'colormag_search_container_layout',
					'operator' => '===',
					'value'    => 'no_sidebar_full_width',
				),
				// Nested condition
				array(
					'relation' => 'AND',
					'terms'    => array(
						array(
							'id'       => 'colormag_search_container_layout',
							'operator' => '===',
							'value'    => 'default',
						),
						array(
							'id'       => 'colormag_global_container_layout',
							'operator' => '===',
							'value'    => 'no_sidebar_full_width',
						),
					),
				),
			),
		),
	),
	'colormag_search_layout_divider'                 => array(
		'type'      => 'customind-divider',
		'variant'   => 'dashed',
		'tab'       => 'general',
		'tab_group' => 'colormag_search_container_tab_group',
		'section'   => 'colormag_search_section',
	),
	'colormag_search_page_style_heading'             => array(
		'type'      => 'customind-heading',
		'title'     => esc_html__( 'Search', 'colormag' ),
		'section'   => 'colormag_search_section',
		'tab_group' => 'colormag_search_container_tab_group',
		'tab'       => 'general',
	),
	'colormag_search_style'                          => array(
		'default'   => 'style-3',
		'title'     => esc_html__( 'Layout', 'colormag' ),
		'type'      => 'customind-radio-image',
		'section'   => 'colormag_search_section',
		'tab_group' => 'colormag_search_container_tab_group',
		'tab'       => 'general',
		'choices'   => apply_filters(
			'colormag_search_layout_style_choices',
			array(
				'style-1' => array(
					'label' => 'Style 1',
					'url'   => COLORMAG_IMG_URL . '/blog/layout-1/style-1.svg',
				),
				'style-2' => array(
					'label' => 'Style 2',
					'url'   => COLORMAG_IMG_URL . '/blog/layout-1/style-2.svg',
				),
				'style-3' => array(
					'label' => 'Style 3',
					'url'   => COLORMAG_IMG_URL . '/blog/layout-2/style-1.svg',
				),
				'style-4' => array(
					'label' => 'Style 4',
					'url'   => COLORMAG_IMG_URL . '/blog/layout-2/style-2.svg',
				),
			)
		),
		'columns'   => 2,
	),
	'colormag_search_page_meta_heading'              => array(
		'type'        => 'customind-heading',
		'title'       => esc_html__( 'Post Meta', 'colormag' ),
		'section'     => 'colormag_search_section',
		'tab_group'   => 'colormag_search_container_tab_group',
		'description' => esc_html__( 'Manage the post meta elements such as Categories, Author, Date, Comments, Tags, etc.', 'colormag' ),
		'tab'         => 'general',
	),
	'colormag_search_page_meta_structure'            => array(
		'type'      => 'customind-sortable',
		'section'   => 'colormag_search_section',
		'tab_group' => 'colormag_search_container_tab_group',
		'tab'       => 'general',
		'choices'   => array(
			'author'      => esc_attr__( 'Author', 'colormag' ),
			'date'        => esc_attr__( 'Date', 'colormag' ),
			'views'       => esc_attr__( 'Views', 'colormag' ),
			'comments'    => esc_attr__( 'Comments', 'colormag' ),
			'tags'        => esc_attr__( 'Tags', 'colormag' ),
			'read-time'   => esc_attr__( 'Reading Time', 'colormag' ),
			'edit-button' => esc_attr__( 'Edit button', 'colormag' ),
		),
		'default'   => array(
			'categories',
			'date',
			'author',
		),
		'condition' => apply_filters( 'colormag_post_meta_elements_title_order', false ),
	),
	'colormag_search_page_date_heading'              => array(
		'type'      => 'customind-heading',
		'title'     => esc_html__( 'Post Date', 'colormag' ),
		'section'   => 'colormag_search_section',
		'tab_group' => 'colormag_search_container_tab_group',
		'tab'       => 'general',
	),
	'colormag_search_page_meta_date_style'           => array(
		'default'   => 'style-1',
		'type'      => 'customind-select',
		'title'     => esc_html__( 'Style', 'colormag' ),
		'section'   => 'colormag_search_section',
		'tab_group' => 'colormag_search_container_tab_group',
		'tab'       => 'general',
		'choices'   => array(
			'style-1' => esc_html__( 'Style 1', 'colormag' ),
			'style-2' => esc_html__( 'Style 2', 'colormag' ),
		),
	),
	'colormag_search_page_meta_author_title_heading' => array(
		'type'      => 'customind-heading',
		'title'     => esc_html__( 'Author', 'colormag' ),
		'section'   => 'colormag_search_section',
		'tab_group' => 'colormag_search_container_tab_group',
		'tab'       => 'general',
	),
	'colormag_search_page_meta_author_style'         => array(
		'default'   => 'style-1',
		'type'      => 'customind-select',
		'title'     => esc_html__( 'Style', 'colormag' ),
		'section'   => 'colormag_search_section',
		'tab_group' => 'colormag_search_container_tab_group',
		'tab'       => 'general',
		'choices'   => array(
			'style-1' => esc_html__( 'Style 1', 'colormag' ),
			'style-2' => esc_html__( 'Style 2', 'colormag' ),
		),
	),
	'colormag_search_page_meta_color'                => array(
		'title'     => esc_html__( 'Post Meta Text Color', 'colormag' ),
		'default'   => '#71717A',
		'type'      => 'customind-color',
		'tab'       => 'style',
		'section'   => 'colormag_search_section',
		'tab_group' => 'colormag_search_container_tab_group',
	),
	'colormag_search_page_meta_typography'           => array(
		'default'   => array(
			'font-family'    => 'inherit',
			'font-weight'    => 'regular',
			'subsets'        => array( 'latin' ),
			'font-size'      => array(
				'desktop' => array(
					'size' => '12',
					'unit' => 'px',
				),
				'tablet'  => array(
					'size' => '',
					'unit' => 'px',
				),
				'mobile'  => array(
					'size' => '',
					'unit' => 'px',
				),
			),
			'line-height'    => array(
				'desktop' => array(
					'size' => '1.6',
					'unit' => '-',
				),
				'tablet'  => array(
					'size' => '',
					'unit' => '-',
				),
				'mobile'  => array(
					'size' => '',
					'unit' => '-',
				),
			),
			'font-style'     => 'normal',
			'text-transform' => 'none',
		),
		'type'      => 'customind-typography',
		'tab'       => 'style',
		'title'     => esc_html__( 'Font', 'colormag' ),
		'section'   => 'colormag_search_section',
		'tab_group' => 'colormag_search_container_tab_group',
	),
);
colormag_customind()->add_controls( $options );
