<?php
// Footer copyright default value.
$default_footer_value = esc_html__( 'Copyright &copy; ', 'colormag' ) . '[the-year] [site-link]. ' . esc_html__( 'All rights reserved.', 'colormag' ) . '<br>' . esc_html__( 'Theme: ', 'colormag' ) . '[tg-link]' . esc_html__( ' by ThemeGrill. Powered by ', 'colormag' ) . '[wp-link].';

$options = array(
	'colormag_footer_bar_title'                => array(
		'type'         => 'customind-accordion',
		'title'        => esc_html__( 'Footer Bar', 'colormag' ),
		'section'      => 'colormag_footer_bar_section',
		'sub_controls' => apply_filters(
			'colormag_footer_bar_controls',
			array(
				'colormag_footer_bar_general_subtitle' => array(
					'title'   => esc_html__( 'General', 'colormag' ),
					'type'    => 'customind-title',
					'section' => 'colormag_footer_bar_section',
				),
				'colormag_footer_bar_alignment'        => array(
					'default' => 'layout-1',
					'type'    => 'customind-radio-image',
					'title'   => esc_html__( 'Alignment', 'colormag' ),
					'section' => 'colormag_footer_bar_section',
					'choices' => apply_filters(
						'colormag_footer_bar_alignment_choices',
						array(
							'left'   => array(
								'label' => '',
								'url'   => COLORMAG_IMG_URL . '/footer-bar-alignment/left.svg',
							),
							'right'  => array(
								'label' => '',
								'url'   => COLORMAG_IMG_URL . '/footer-bar-alignment/right.svg',
							),
							'center' => array(
								'label' => '',
								'url'   => COLORMAG_IMG_URL . '/footer-bar-alignment/center.svg',
							),
						)
					),
					'columns' => 2,
				),
				'colormag_footer_bar_style_divider'    => array(
					'type'    => 'customind-divider',
					'variant' => 'dashed',
					'section' => 'colormag_footer_bar_section',
				),
				'colormag_footer_bar_style_subtitle'   => array(
					'title'   => esc_html__( 'Style', 'colormag' ),
					'type'    => 'customind-title',
					'section' => 'colormag_footer_bar_section',
				),
				'colormag_footer_copyright_background' => array(
					'default'   => array(
						'background-color'      => '',
						'background-image'      => '',
						'background-repeat'     => 'repeat',
						'background-position'   => 'center center',
						'background-size'       => 'contain',
						'background-attachment' => 'scroll',
					),
					'type'      => 'customind-background',
					'title'     => esc_html__( 'Background', 'colormag' ),
					'transport' => 'postMessage',
					'section'   => 'colormag_footer_bar_section',
				),
			),
		),
		'collapsible'  => apply_filters( 'colormag_footer_bar_title_accordion_collapsible', false ),
	),
	'colormag_footer_copyright_heading'        => array(
		'type'         => 'customind-accordion',
		'title'        => esc_html__( 'Footer Copyright', 'colormag' ),
		'section'      => 'colormag_footer_bar_section',
		'sub_controls' => apply_filters(
			'colormag_schema_markup_controls',
			array(
				'colormag_enable_schema_markup'         => array(
					'title'     => esc_html__( 'Enable', 'colormag' ),
					'default'   => false,
					'type'      => 'customind-toggle',
					'section'   => 'colormag_footer_bar_section',
					'transport' => 'refresh',
				),
				'colormag_footer_editor'                => array(
					'default' => $default_footer_value,
					'type'    => 'customind-editor',
					'title'   => esc_html__( 'Text/HTML for Column 1', 'colormag' ),
					'section' => 'colormag_footer_bar_section',
					'partial' => array(
						'selector'        => '.copyright',
						'render_callback' => array(
							'ColorMag_Customizer_Partials',
							'render_footer_copyright_text',
						),
					),
				),
				'colormag_footer_copyright_color_group' => array(
					'type'         => 'customind-color-group',
					'title'        => esc_html__( 'Color', 'colormag' ),
					'section'      => 'colormag_footer_bar_section',
					'sub_controls' => apply_filters(
						'colormag_footer_copyright_color_controls',
						array(
							'colormag_footer_copyright_text_color' => array(
								'default'   => '#b1b6b6',
								'type'      => 'customind-color',
								'title'     => esc_html__( 'Normal', 'colormag' ),
								'transport' => 'postMessage',
								'section'   => 'colormag_footer_bar_section',
							),
							'colormag_footer_copyright_link_text_color' => array(
								'default'   => '#289dcc',
								'type'      => 'customind-color',
								'title'     => esc_html__( 'Link Color', 'colormag' ),
								'transport' => 'postMessage',
								'section'   => 'colormag_footer_bar_section',
							),
						)
					),
				),
				'colormag_footer_copyright_typography'  => array(
					'default'   => array(
						'font-family'    => 'inherit',
						'font-weight'    => '400',
						'font-size'      => array(
							'desktop' => array(
								'size' => '14',
								'unit' => 'px',
							),
							'tablet'  => array(
								'size' => '',
								'unit' => '',
							),
							'mobile'  => array(
								'size' => '',
								'unit' => '',
							),
						),
						'line-height'    => array(
							'desktop' => array(
								'size' => '1.8',
								'unit' => '-',
							),
							'tablet'  => array(
								'size' => '',
								'unit' => '',
							),
							'mobile'  => array(
								'size' => '',
								'unit' => '',
							),
						),
						'font-style'     => 'normal',
						'text-transform' => 'none',
					),
					'type'      => 'customind-typography',
					'transport' => 'postMessage',
					'title'     => esc_html__( 'Typography', 'colormag' ),
					'section'   => 'colormag_footer_bar_section',
				),
			),
		),
		'collapsible'  => apply_filters( 'colormag_footer_copyright_accordion_collapsible', false ),
	),
	'colormag_footer_menu_heading'             => array(
		'type'         => 'customind-accordion',
		'title'        => esc_html__( 'Footer Menu', 'colormag' ),
		'section'      => 'colormag_footer_bar_section',
		'sub_controls' => apply_filters(
			'colormag_footer_menu_controls',
			array(
				'colormag_footer_menu_color_group' => array(
					'type'         => 'customind-color-group',
					'title'        => esc_html__( 'Color', 'colormag' ),
					'section'      => 'colormag_footer_bar_section',
					'sub_controls' => apply_filters(
						'colormag_footer_menu_color_controls',
						array(
							'colormag_footer_menu_color' => array(
								'default'   => '#b1b6b6',
								'type'      => 'customind-color',
								'title'     => esc_html__( 'Normal', 'colormag' ),
								'transport' => 'postMessage',
								'section'   => 'colormag_footer_bar_section',
							),
							'colormag_footer_menu_hover_color' => array(
								'default'   => 'var(--cm-color-1)',
								'type'      => 'customind-color',
								'title'     => esc_html__( 'Hover', 'colormag' ),
								'transport' => 'postMessage',
								'section'   => 'colormag_footer_bar_section',
							),
						)
					),
				),
				'colormag_footer_menu_typography'  => array(
					'default'   => array(
						'font-family'    => 'inherit',
						'font-weight'    => '400',
						'font-size'      => array(
							'desktop' => array(
								'size' => '14',
								'unit' => 'px',
							),
							'tablet'  => array(
								'size' => '',
								'unit' => '',
							),
							'mobile'  => array(
								'size' => '',
								'unit' => '',
							),
						),
						'line-height'    => array(
							'desktop' => array(
								'size' => '1.8',
								'unit' => '-',
							),
							'tablet'  => array(
								'size' => '',
								'unit' => '',
							),
							'mobile'  => array(
								'size' => '',
								'unit' => '',
							),
						),
						'font-style'     => 'normal',
						'text-transform' => 'none',
					),
					'type'      => 'customind-typography',
					'transport' => 'postMessage',
					'title'     => esc_html__( 'Typography', 'colormag' ),
					'section'   => 'colormag_footer_bar_section',
				),
			),
		),
		'collapsible'  => apply_filters( 'colormag_footer_menu_accordion_collapsible', false ),
	),
	'colormag_footer_bar_social_icons_heading' => array(
		'type'         => 'customind-accordion',
		'title'        => esc_html__( 'Social Icons', 'colormag' ),
		'section'      => 'colormag_top_bar_section',
		'sub_controls' => apply_filters(
			'colormag_top_bar_news_ticker_sub_controls',
			array(
				'colormag_footer_bar_social_icons_navigate' => array(
					'title'    => esc_html__( 'Social Icons', 'colormag' ),
					'type'     => 'customind-navigation',
					'section'  => 'colormag_footer_bar_section',
					'to'       => 'colormag_social_icons_section',
					'nav_type' => 'section',
				),
			)
		),
		'collapsible'  => apply_filters( 'colormag_top_bar_news_ticker_accordion_collapsible', false ),
		'condition'    => array(
			'colormag_enable_top_bar' => true,
		),
	),
);

colormag_customind()->add_controls( $options );
