<?php


$options = array(
	'colormag_form_element_color_group'            => array(
		'type'         => 'customind-color-group',
		'title'        => esc_html__( 'Color', 'colormag' ),
		'section'      => 'colormag_form_element_section',
		'sub_controls' => apply_filters(
			'colormag_form_element_color_controls',
			array(
				'colormag_form_element_text_color'       => array(
					'default'   => '',
					'type'      => 'customind-color',
					'title'     => esc_html__( 'Normal', 'colormag' ),
					'transport' => 'postMessage',
					'section'   => 'colormag_form_element_section',
				),
				'colormag_form_element_text_focus_color' => array(
					'default'   => '',
					'type'      => 'customind-color',
					'title'     => esc_html__( 'Focus', 'colormag' ),
					'transport' => 'postMessage',
					'section'   => 'colormag_form_element_section',
				),
			)
		),
	),
	'colormag_form_element_background_color_group' => array(
		'type'         => 'customind-color-group',
		'title'        => esc_html__( 'Background', 'colormag' ),
		'section'      => 'colormag_form_element_section',
		'sub_controls' => apply_filters(
			'colormag_form_element_background_color_controls',
			array(
				'colormag_form_element_background_color' => array(
					'default'   => '',
					'type'      => 'customind-color',
					'title'     => esc_html__( 'Normal', 'colormag' ),
					'transport' => 'postMessage',
					'section'   => 'colormag_form_element_section',
				),
				'colormag_form_element_background_focus_color' => array(
					'default'   => '',
					'type'      => 'customind-color',
					'title'     => esc_html__( 'Focus', 'colormag' ),
					'transport' => 'postMessage',
					'section'   => 'colormag_form_element_section',
				),
			)
		),
	),
	'colormag_form_element_typography'             => array(
		'default'   => array(
			'font-family'    => 'inherit',
			'font-weight'    => '400',
			'font-size'      => array(
				'desktop' => array(
					'size' => '',
					'unit' => 'px',
				),
				'tablet'  => array(
					'size' => '',
					'unit' => '',
				),
				'mobile'  => array(
					'size' => '',
					'unit' => '',
				),
			),
			'line-height'    => array(
				'desktop' => array(
					'size' => '',
					'unit' => '-',
				),
				'tablet'  => array(
					'size' => '',
					'unit' => '',
				),
				'mobile'  => array(
					'size' => '',
					'unit' => '',
				),
			),
			'font-style'     => 'normal',
			'text-transform' => 'none',
		),
		'type'      => 'customind-typography',
		'transport' => 'postMessage',
		'title'     => esc_html__( 'Typography', 'colormag' ),
		'section'   => 'colormag_form_element_section',
	),
	'colormag_form_element_border_divider'         => array(
		'type'    => 'customind-divider',
		'variant' => 'dashed',
		'section' => 'colormag_form_element_section',
	),
	'colormag_form_element_border_subtitle'        => array(
		'title'   => esc_html__( 'Border', 'colormag' ),
		'type'    => 'customind-title',
		'section' => 'colormag_form_element_section',
	),
	'colormag_form_element_border_style'           => array(
		'default' => 'solid',
		'type'    => 'customind-select',
		'title'   => esc_html__( 'Style', 'colormag' ),
		'section' => 'colormag_form_element_section',
		'choices' => array(
			'none'   => esc_html__( 'None', 'colormag' ),
			'solid'  => esc_html__( 'Solid', 'colormag' ),
			'double' => esc_html__( 'Double', 'colormag' ),
			'dashed' => esc_html__( 'Dashed', 'colormag' ),
			'dotted' => esc_html__( 'Dotted', 'colormag' ),
		),
	),
	'colormag_form_element_border_width'           => array(
		'default'     => array(
			'size' => '',
			'unit' => 'px',
		),
		'type'        => 'customind-slider',
		'title'       => esc_html__( 'Width', 'colormag' ),
		'section'     => 'colormag_form_element_section',
		'transport'   => 'postMessage',
		'units'       => array( 'px' ),
		'defaultUnit' => 'px',
		'input_attrs' => array(
			'min'  => 0,
			'max'  => 10,
			'step' => 1,
		),
	),
	'colormag_form_element_border_color'           => array(
		'default'   => '',
		'type'      => 'customind-color',
		'title'     => esc_html__( 'Color', 'colormag' ),
		'transport' => 'postMessage',
		'section'   => 'colormag_form_element_section',
	),
);

colormag_customind()->add_controls( $options );
