<?php
$typography_preset_choices = apply_filters(
	'cm_site_layout_choices',
	array(
		'preset-1' => array(
			'label'              => '',
			'body_typography'    => array(
				'font-family'    => 'Open Sans',
				'font-weight'    => '400',
				'font-size'      => array(
					'desktop' => array(
						'size' => '15',
						'unit' => 'px',
					),
					'tablet'  => array(
						'size' => '',
						'unit' => 'px',
					),
					'mobile'  => array(
						'size' => '',
						'unit' => 'px',
					),
				),
				'line-height'    => array(
					'desktop' => array(
						'size' => '1.8',
						'unit' => '-',
					),
					'tablet'  => array(
						'size' => '',
						'unit' => '',
					),
					'mobile'  => array(
						'size' => '',
						'unit' => '',
					),
				),
				'letter-spacing' => array(
					'desktop' => array(
						'size' => '',
						'unit' => 'px',
					),
					'tablet'  => array(
						'size' => '',
						'unit' => 'px',
					),
					'mobile'  => array(
						'size' => '',
						'unit' => 'px',
					),
				),
				'font-style'     => 'inherit',
				'text-transform' => 'none',
			),
			'heading_typography' => array(
				'font-family'    => 'Open Sans',
				'font-weight'    => '500',
				'line-height'    => array(
					'desktop' => array(
						'size' => '1.3',
						'unit' => '-',
					),
					'tablet'  => array(
						'size' => '',
						'unit' => '',
					),
					'mobile'  => array(
						'size' => '',
						'unit' => '',
					),
				),
				'letter-spacing' => array(
					'desktop' => array(
						'size' => '',
						'unit' => 'px',
					),
					'tablet'  => array(
						'size' => '',
						'unit' => 'px',
					),
					'mobile'  => array(
						'size' => '',
						'unit' => 'px',
					),
				),
				'font-style'     => 'inherit',
				'text-transform' => 'none',
			),
		),
		'preset-2' => array(
			'label'              => '',
			'body_typography'    => array(
				'font-family'    => 'Lato',
				'font-size'      => array(
					'desktop' => array(
						'size' => '16',
						'unit' => 'px',
					),
					'tablet'  => array(
						'size' => '',
						'unit' => 'px',
					),
					'mobile'  => array(
						'size' => '',
						'unit' => 'px',
					),
				),
				'subsets'        => array( 'latin' ),
				'line-height'    => array(
					'desktop' => array(
						'size' => '1.8',
						'unit' => '-',
					),
					'tablet'  => array(
						'size' => '',
						'unit' => '',
					),
					'mobile'  => array(
						'size' => '',
						'unit' => '',
					),
				),
				'letter-spacing' => array(
					'desktop' => array(
						'size' => '',
						'unit' => 'px',
					),
					'tablet'  => array(
						'size' => '',
						'unit' => 'px',
					),
					'mobile'  => array(
						'size' => '',
						'unit' => 'px',
					),
				),
				'font-style'     => 'inherit',
				'text-transform' => 'none',
			),
			'heading_typography' => array(
				'font-family'    => 'Rubik',
				'font-weight'    => '400',
				'line-height'    => array(
					'desktop' => array(
						'size' => '1.3',
						'unit' => '-',
					),
					'tablet'  => array(
						'size' => '',
						'unit' => '',
					),
					'mobile'  => array(
						'size' => '',
						'unit' => '',
					),
				),
				'letter-spacing' => array(
					'desktop' => array(
						'size' => '',
						'unit' => 'px',
					),
					'tablet'  => array(
						'size' => '',
						'unit' => 'px',
					),
					'mobile'  => array(
						'size' => '',
						'unit' => 'px',
					),
				),
				'font-style'     => 'inherit',
				'text-transform' => 'none',
			),
		),
		'preset-3' => array(
			'label'              => '',
			'body_typography'    => array(
				'font-family'    => 'Roboto',
				'font-weight'    => '400',
				'subsets'        => array( 'latin' ),
				'font-size'      => array(
					'desktop' => array(
						'size' => '16',
						'unit' => 'px',
					),
					'tablet'  => array(
						'size' => '',
						'unit' => 'px',
					),
					'mobile'  => array(
						'size' => '',
						'unit' => 'px',
					),
				),
				'line-height'    => array(
					'desktop' => array(
						'size' => '1.8',
						'unit' => '-',
					),
					'tablet'  => array(
						'size' => '',
						'unit' => '',
					),
					'mobile'  => array(
						'size' => '',
						'unit' => '',
					),
				),
				'letter-spacing' => array(
					'desktop' => array(
						'size' => '',
						'unit' => 'px',
					),
					'tablet'  => array(
						'size' => '',
						'unit' => 'px',
					),
					'mobile'  => array(
						'size' => '',
						'unit' => 'px',
					),
				),
				'font-style'     => 'inherit',
				'text-transform' => 'none',
			),
			'heading_typography' => array(
				'font-family'    => 'PT Serif',
				'font-weight'    => '700',
				'line-height'    => array(
					'desktop' => array(
						'size' => '1.3',
						'unit' => '-',
					),
					'tablet'  => array(
						'size' => '',
						'unit' => '',
					),
					'mobile'  => array(
						'size' => '',
						'unit' => '',
					),
				),
				'letter-spacing' => array(
					'desktop' => array(
						'size' => '',
						'unit' => 'px',
					),
					'tablet'  => array(
						'size' => '',
						'unit' => 'px',
					),
					'mobile'  => array(
						'size' => '',
						'unit' => 'px',
					),
				),
				'font-style'     => 'inherit',
				'text-transform' => 'none',
			),
		),
		'preset-4' => array(
			'label'              => '',
			'body_typography'    => array(
				'font-family'    => 'Inter',
				'font-weight'    => '400',
				'subsets'        => array( 'latin' ),
				'font-size'      => array(
					'desktop' => array(
						'size' => '16',
						'unit' => 'px',
					),
					'tablet'  => array(
						'size' => '',
						'unit' => 'px',
					),
					'mobile'  => array(
						'size' => '',
						'unit' => 'px',
					),
				),
				'line-height'    => array(
					'desktop' => array(
						'size' => '1.8',
						'unit' => '-',
					),
					'tablet'  => array(
						'size' => '',
						'unit' => '',
					),
					'mobile'  => array(
						'size' => '',
						'unit' => '',
					),
				),
				'letter-spacing' => array(
					'desktop' => array(
						'size' => '',
						'unit' => 'px',
					),
					'tablet'  => array(
						'size' => '',
						'unit' => 'px',
					),
					'mobile'  => array(
						'size' => '',
						'unit' => 'px',
					),
				),
				'font-style'     => 'inherit',
				'text-transform' => 'none',
			),
			'heading_typography' => array(
				'font-family'    => 'IBM Plex Serif',
				'font-weight'    => '700',
				'line-height'    => array(
					'desktop' => array(
						'size' => '1.3',
						'unit' => '-',
					),
					'tablet'  => array(
						'size' => '',
						'unit' => '',
					),
					'mobile'  => array(
						'size' => '',
						'unit' => '',
					),
				),
				'letter-spacing' => array(
					'desktop' => array(
						'size' => '',
						'unit' => 'px',
					),
					'tablet'  => array(
						'size' => '',
						'unit' => 'px',
					),
					'mobile'  => array(
						'size' => '',
						'unit' => 'px',
					),
				),
				'font-style'     => 'inherit',
				'text-transform' => 'none',
			),
		),
		'preset-5' => array(
			'label'              => '',
			'body_typography'    => array(
				'font-family'    => 'Public Sans',
				'font-weight'    => '400',
				'font-size'      => array(
					'desktop' => array(
						'size' => '16',
						'unit' => 'px',
					),
					'tablet'  => array(
						'size' => '',
						'unit' => 'px',
					),
					'mobile'  => array(
						'size' => '',
						'unit' => 'px',
					),
				),
				'line-height'    => array(
					'desktop' => array(
						'size' => '1.8',
						'unit' => '-',
					),
					'tablet'  => array(
						'size' => '',
						'unit' => '',
					),
					'mobile'  => array(
						'size' => '',
						'unit' => '',
					),
				),
				'letter-spacing' => array(
					'desktop' => array(
						'size' => '',
						'unit' => 'px',
					),
					'tablet'  => array(
						'size' => '',
						'unit' => 'px',
					),
					'mobile'  => array(
						'size' => '',
						'unit' => 'px',
					),
				),
				'font-style'     => 'inherit',
				'text-transform' => 'none',
			),
			'heading_typography' => array(
				'font-family'    => 'Bitter',
				'font-weight'    => '700',
				'line-height'    => array(
					'desktop' => array(
						'size' => '1.3',
						'unit' => '-',
					),
					'tablet'  => array(
						'size' => '',
						'unit' => '',
					),
					'mobile'  => array(
						'size' => '',
						'unit' => '',
					),
				),
				'letter-spacing' => array(
					'desktop' => array(
						'size' => '',
						'unit' => 'px',
					),
					'tablet'  => array(
						'size' => '',
						'unit' => 'px',
					),
					'mobile'  => array(
						'size' => '',
						'unit' => 'px',
					),
				),
				'font-style'     => 'inherit',
				'text-transform' => 'none',
			),
		),
		'preset-6' => array(
			'label'              => '',
			'body_typography'    => array(
				'font-family'    => 'DM Sans',
				'font-weight'    => '400',
				'font-size'      => array(
					'desktop' => array(
						'size' => '16',
						'unit' => 'px',
					),
					'tablet'  => array(
						'size' => '',
						'unit' => 'px',
					),
					'mobile'  => array(
						'size' => '',
						'unit' => 'px',
					),
				),
				'line-height'    => array(
					'desktop' => array(
						'size' => '1.8',
						'unit' => '-',
					),
					'tablet'  => array(
						'size' => '',
						'unit' => '',
					),
					'mobile'  => array(
						'size' => '',
						'unit' => '',
					),
				),
				'letter-spacing' => array(
					'desktop' => array(
						'size' => '',
						'unit' => 'px',
					),
					'tablet'  => array(
						'size' => '',
						'unit' => 'px',
					),
					'mobile'  => array(
						'size' => '',
						'unit' => 'px',
					),
				),
				'font-style'     => 'inherit',
				'text-transform' => 'none',
			),
			'heading_typography' => array(
				'font-family'    => 'Outfit',
				'font-weight'    => '700',
				'line-height'    => array(
					'desktop' => array(
						'size' => '1.3',
						'unit' => '-',
					),
					'tablet'  => array(
						'size' => '',
						'unit' => '',
					),
					'mobile'  => array(
						'size' => '',
						'unit' => '',
					),
				),
				'letter-spacing' => array(
					'desktop' => array(
						'size' => '',
						'unit' => 'px',
					),
					'tablet'  => array(
						'size' => '',
						'unit' => 'px',
					),
					'mobile'  => array(
						'size' => '',
						'unit' => 'px',
					),
				),
				'font-style'     => 'inherit',
				'text-transform' => 'none',
			),
		),
	)
);
$options                   = apply_filters(
	'colormag_typography_options',
	array(
		'colormag_typography_presets'           => array(
			'type'       => 'customind-typography-preset',
			'title'      => esc_html__( 'Presets', 'colormag' ),
			'default'    => colormag_typography_should_migrate() ? '' : 'preset-1',
			'body_id'    => 'colormag_base_typography',
			'heading_id' => 'colormag_headings_typography',
			'section'    => 'colormag_global_typography_section',
			'choices'    => $typography_preset_choices,
			'columns'    => 3,
		),
		'colormag_headings_typography_heading'  => array(
			'type'    => 'customind-heading',
			'title'   => esc_html__( 'Fonts', 'colormag' ),
			'section' => 'colormag_global_typography_section',
		),
		'colormag_base_typography'              => array(
			'default'   => array(
				'font-family'    => 'inherit',
				'font-weight'    => 'regular',
				'subsets'        => array( 'latin' ),
				'font-size'      => array(
					'desktop' => array(
						'size' => '15',
						'unit' => 'px',
					),
					'tablet'  => array(
						'size' => '',
						'unit' => 'px',
					),
					'mobile'  => array(
						'size' => '',
						'unit' => 'px',
					),
				),
				'line-height'    => array(
					'desktop' => array(
						'size' => '1.6',
						'unit' => '-',
					),
					'tablet'  => array(
						'size' => '',
						'unit' => '-',
					),
					'mobile'  => array(
						'size' => '',
						'unit' => '-',
					),
				),
				'letter-spacing' => array(
					'desktop' => array(
						'size' => '',
						'unit' => 'px',
					),
					'tablet'  => array(
						'size' => '',
						'unit' => 'px',
					),
					'mobile'  => array(
						'size' => '',
						'unit' => 'px',
					),
				),
			),
			'type'      => 'customind-typography',
			'transport' => 'postMessage',
			'title'     => esc_html__( 'Body', 'colormag' ),
			'section'   => 'colormag_global_typography_section',
		),
		'colormag_headings_typography'          => array(
			'default'            => array(
				'font-family'    => 'inherit',
				'font-weight'    => 'regular',
				'subsets'        => array( 'latin' ),
				'line-height'    => array(
					'desktop' => array(
						'size' => '1.2',
						'unit' => '-',
					),
					'tablet'  => array(
						'size' => '',
						'unit' => '',
					),
					'mobile'  => array(
						'size' => '',
						'unit' => '',
					),
				),
				'letter-spacing' => array(
					'desktop' => array(
						'size' => '',
						'unit' => 'px',
					),
					'tablet'  => array(
						'size' => '',
						'unit' => 'px',
					),
					'mobile'  => array(
						'size' => '',
						'unit' => 'px',
					),
				),
				'font-style'     => 'normal',
				'text-transform' => 'none',
			),
			'type'               => 'customind-typography',
			'title'              => esc_html__( 'Heading', 'colormag' ),
			'transport'          => 'postMessage',
			'section'            => 'colormag_global_typography_section',
			'allowed_properties' => array(
				'font-family',
				'font-weight',
				'line-height',
				'font-style',
				'text-transform',
			),
		),
		'colormag_headings_typography_subtitle' => array(
			'type'    => 'customind-divider',
			'variant' => 'solid',
			'section' => 'colormag_global_typography_section',
		),
		'colormag_h1_typography'                => array(
			'default'   => array(
				'font-family'    => 'inherit',
				'font-weight'    => 'Inherit',
				'subsets'        => array( 'latin' ),
				'font-size'      => array(
					'desktop' => array(
						'size' => '36',
						'unit' => 'px',
					),
					'tablet'  => array(
						'size' => '',
						'unit' => 'px',
					),
					'mobile'  => array(
						'size' => '',
						'unit' => 'px',
					),
				),
				'line-height'    => array(
					'desktop' => array(
						'size' => '1.2',
						'unit' => '-',
					),
					'tablet'  => array(
						'size' => '',
						'unit' => '',
					),
					'mobile'  => array(
						'size' => '',
						'unit' => '',
					),
				),
				'font-style'     => 'normal',
				'text-transform' => 'none',
			),
			'type'      => 'customind-typography',
			'transport' => 'postMessage',
			'title'     => esc_html__( 'H1', 'colormag' ),
			'section'   => 'colormag_global_typography_section',
		),
		'colormag_h2_typography'                => array(
			'default'   => array(
				'font-family'    => 'inherit',
				'font-weight'    => 'Inherit',
				'subsets'        => array( 'latin' ),
				'font-size'      => array(
					'desktop' => array(
						'size' => '32',
						'unit' => 'px',
					),
					'tablet'  => array(
						'size' => '',
						'unit' => '',
					),
					'mobile'  => array(
						'size' => '',
						'unit' => '',
					),
				),
				'line-height'    => array(
					'desktop' => array(
						'size' => '1.2',
						'unit' => '-',
					),
					'tablet'  => array(
						'size' => '',
						'unit' => '',
					),
					'mobile'  => array(
						'size' => '',
						'unit' => '',
					),
				),
				'font-style'     => 'normal',
				'text-transform' => 'none',
			),
			'type'      => 'customind-typography',
			'transport' => 'postMessage',
			'title'     => esc_html__( 'H2', 'colormag' ),
			'section'   => 'colormag_global_typography_section',
		),
		'colormag_h3_typography'                => array(
			'default'   => array(
				'font-family'    => 'inherit',
				'font-weight'    => 'Inherit',
				'subsets'        => array( 'latin' ),
				'font-size'      => array(
					'desktop' => array(
						'size' => '24',
						'unit' => 'px',
					),
					'tablet'  => array(
						'size' => '',
						'unit' => '',
					),
					'mobile'  => array(
						'size' => '',
						'unit' => '',
					),
				),
				'line-height'    => array(
					'desktop' => array(
						'size' => '1.2',
						'unit' => '-',
					),
					'tablet'  => array(
						'size' => '',
						'unit' => '',
					),
					'mobile'  => array(
						'size' => '',
						'unit' => '',
					),
				),
				'font-style'     => 'normal',
				'text-transform' => 'none',
			),
			'type'      => 'customind-typography',
			'title'     => esc_html__( 'H3', 'colormag' ),
			'transport' => 'postMessage',
			'section'   => 'colormag_global_typography_section',
		),
		'colormag_h4_typography'                => array(
			'default'   => array(
				'font-family' => 'Inherit',
				'font-weight' => 'Inherit',
				'subsets'     => array( 'latin' ),
				'font-size'   => array(
					'desktop' => array(
						'size' => '24',
						'unit' => 'px',
					),
					'tablet'  => array(
						'size' => '',
						'unit' => '',
					),
					'mobile'  => array(
						'size' => '',
						'unit' => '',
					),
				),
				'line-height' => array(
					'desktop' => array(
						'size' => '1.2',
						'unit' => '-',
					),
					'tablet'  => array(
						'size' => '',
						'unit' => '',
					),
					'mobile'  => array(
						'size' => '',
						'unit' => '',
					),
				),
			),
			'type'      => 'customind-typography',
			'title'     => esc_html__( 'H4', 'colormag' ),
			'transport' => 'postMessage',
			'section'   => 'colormag_global_typography_section',
		),
		'colormag_h5_typography'                => array(
			'default'   => array(
				'font-family' => 'Inherit',
				'font-weight' => 'Inherit',
				'subsets'     => array( 'latin' ),
				'font-size'   => array(
					'desktop' => array(
						'size' => '22',
						'unit' => 'px',
					),
					'tablet'  => array(
						'size' => '',
						'unit' => '',
					),
					'mobile'  => array(
						'size' => '',
						'unit' => '',
					),
				),
				'line-height' => array(
					'desktop' => array(
						'size' => '1.2',
						'unit' => '-',
					),
					'tablet'  => array(
						'size' => '',
						'unit' => '',
					),
					'mobile'  => array(
						'size' => '',
						'unit' => '',
					),
				),
			),
			'type'      => 'customind-typography',
			'title'     => esc_html__( 'H5', 'colormag' ),
			'transport' => 'postMessage',
			'section'   => 'colormag_global_typography_section',
		),
		'colormag_h6_typography'                => array(
			'default'   => array(
				'font-family' => 'Inherit',
				'font-weight' => 'Inherit',
				'subsets'     => array( 'latin' ),
				'font-size'   => array(
					'desktop' => array(
						'size' => '18',
						'unit' => 'px',
					),
					'tablet'  => array(
						'size' => '',
						'unit' => '',
					),
					'mobile'  => array(
						'size' => '',
						'unit' => '',
					),
				),
				'line-height' => array(
					'desktop' => array(
						'size' => '1.2',
						'unit' => '-',
					),
					'tablet'  => array(
						'size' => '',
						'unit' => '',
					),
					'mobile'  => array(
						'size' => '',
						'unit' => '',
					),
				),
			),
			'type'      => 'customind-typography',
			'title'     => esc_html__( 'H6', 'colormag' ),
			'transport' => 'postMessage',
			'section'   => 'colormag_global_typography_section',
		),
	),
);

colormag_customind()->add_controls( $options );
