<?php
$categories       = get_categories();
$category_choices = array();

foreach ( $categories as $category ) {
	$category_choices[ $category->term_id ] = $category->name;
}

$options = apply_filters(
	'colormag_news_ticker_options',
	array(
		'colormag_news_ticker_heading' => array(
			'type'         => 'customind-accordion',
			'title'        => esc_html__( 'News Ticker', 'colormag' ),
			'section'      => 'colormag_news_ticker_section',
			'priority'     => 5,
			'sub_controls' => apply_filters(
				'colormag_news_ticker_sub_controls',
				array(
					'colormag_news_ticker_general_subtitle' => array(
						'type'    => 'customind-title',
						'title'   => esc_html__( 'General', 'colormag' ),
						'section' => 'colormag_news_ticker_section',
					),
					'colormag_enable_news_ticker'          => array(
						'title'   => esc_html__( 'Enable', 'colormag' ),
						'default' => 0,
						'type'    => 'customind-toggle',
						'section' => 'colormag_news_ticker_section',
					),
					'colormag_news_ticker_position'        => array(
						'default'   => 'top-bar',
						'type'      => 'customind-select',
						'title'     => esc_html__( 'Position', 'colormag' ),
						'section'   => 'colormag_news_ticker_section',
						'choices'   => array(
							'top-bar'      => esc_html__( 'Top Bar', 'colormag' ),
							'below-header' => esc_html__( 'Below Header', 'colormag' ),
						),
						'condition' => array(
							'colormag_enable_news_ticker' => true,
						),
					),
					'colormag_news_ticker_query'           => array(
						'default'   => 'latest',
						'type'      => 'customind-select',
						'title'     => esc_html__( 'Filter', 'colormag' ),
						'section'   => 'colormag_news_ticker_section',
						'choices'   => array(
							'latest'   => esc_html__( 'Latest Posts', 'colormag' ),
							'category' => esc_html__( 'Category', 'colormag' ),
						),
						'condition' => array(
							'colormag_enable_news_ticker' => true,
						),
					),
					'colormag_news_ticker_category'        => array(
						'type'      => 'customind-select',
						'title'     => esc_html__( 'Category', 'colormag' ),
						'section'   => 'colormag_news_ticker_section',
						'choices'   => $category_choices,
						'condition' => array(
							'colormag_enable_news_ticker' => true,
							'colormag_news_ticker_query'  => 'category',
						),
					),
					'colormag_news_ticker_label'           => array(
						'title'     => esc_html__( 'Label', 'colormag' ),
						'default'   => esc_html__( 'Latest:', 'colormag' ),
						'type'      => 'customind-text',
						'section'   => 'colormag_news_ticker_section',
						'partial'   => array(
							'selector'        => '.breaking-news-latest',
							'render_callback' => array(
								'ColorMag_Customizer_Partials',
								'render_breaking_news_text',
							),
						),
						'condition' => array(
							'colormag_enable_news_ticker' => true,
						),
					),
					'colormag_news_ticker_style_divider'   => array(
						'type'      => 'customind-divider',
						'variant'   => 'dashed',
						'section'   => 'colormag_news_ticker_section',
						'condition' => array(
							'colormag_enable_news_ticker' => true,
						),
					),
					'colormag_news_ticker_style_subtitle'  => array(
						'title'     => esc_html__( 'Style', 'colormag' ),
						'type'      => 'customind-title',
						'section'   => 'colormag_news_ticker_section',
						'condition' => array(
							'colormag_enable_news_ticker' => true,
						),
					),
					'colormag_news_ticker_label_typography' => array(
						'default'   => array(
							'font-family'    => 'inherit',
							'font-weight'    => 'regular',
							'subsets'        => array( 'latin' ),
							'font-size'      => array(
								'desktop' => array(
									'size' => '15',
									'unit' => 'px',
								),
								'tablet'  => array(
									'size' => '',
									'unit' => 'px',
								),
								'mobile'  => array(
									'size' => '',
									'unit' => 'px',
								),
							),
							'line-height'    => array(
								'desktop' => array(
									'size' => '',
									'unit' => '-',
								),
								'tablet'  => array(
									'size' => '',
									'unit' => '-',
								),
								'mobile'  => array(
									'size' => '',
									'unit' => '-',
								),
							),
							'font-style'     => 'normal',
							'text-transform' => 'none',
						),
						'type'      => 'customind-typography',
						'transport' => 'postMessage',
						'title'     => esc_html__( 'Label Typography', 'colormag' ),
						'section'   => 'colormag_news_ticker_section',
						'condition' => array(
							'colormag_enable_news_ticker' => true,
						),
					),
					'colormag_news_ticker_label_background' => array(
						'default'   => '',
						'type'      => 'customind-color',
						'title'     => esc_html__( 'Label Background', 'colormag' ),
						'transport' => 'postMessage',
						'section'   => 'colormag_news_ticker_section',
						'condition' => array(
							'colormag_enable_news_ticker' => true,
						),
					),
					'colormag_news_ticker_background'      => array(
						'default'   => '',
						'type'      => 'customind-color',
						'title'     => esc_html__( 'Background', 'colormag' ),
						'transport' => 'postMessage',
						'section'   => 'colormag_news_ticker_section',
						'condition' => array(
							'colormag_enable_news_ticker' => true,
						),
					),
					'colormag_news_ticker_content_typography' => array(
						'default'   => array(
							'font-family'    => 'inherit',
							'font-weight'    => 'regular',
							'subsets'        => array( 'latin' ),
							'font-size'      => array(
								'desktop' => array(
									'size' => '15',
									'unit' => 'px',
								),
								'tablet'  => array(
									'size' => '',
									'unit' => 'px',
								),
								'mobile'  => array(
									'size' => '',
									'unit' => 'px',
								),
							),
							'line-height'    => array(
								'desktop' => array(
									'size' => '',
									'unit' => '-',
								),
								'tablet'  => array(
									'size' => '',
									'unit' => '-',
								),
								'mobile'  => array(
									'size' => '',
									'unit' => '-',
								),
							),
							'font-style'     => 'normal',
							'text-transform' => 'none',
						),
						'type'      => 'customind-typography',
						'transport' => 'postMessage',
						'title'     => esc_html__( 'Content Typography', 'colormag' ),
						'section'   => 'colormag_news_ticker_section',
						'condition' => array(
							'colormag_enable_news_ticker' => true,
						),
					),
					'colormag_news_ticker_animation_direction' => array(
						'default'   => 'down',
						'type'      => 'customind-select',
						'title'     => esc_html__( 'Animation Style', 'colormag' ),
						'section'   => 'colormag_news_ticker_section',
						'choices'   => array(
							'up'    => esc_html__( 'Up', 'colormag' ),
							'down'  => esc_html__( 'Down', 'colormag' ),
							'left'  => esc_html__( 'Left', 'colormag' ),
							'right' => esc_html__( 'Right', 'colormag' ),
						),
						'condition' => array(
							'colormag_enable_news_ticker' => true,
						),
					),
					'colormag_news_ticker_animation_duration' => array(
						'title'       => esc_html__( 'Transition Duration', 'colormag' ),
						'default'     => 4,
						'type'        => 'customind-text',
						'section'     => 'colormag_news_ticker_section',
						'input_attrs' => array(
							'type' => 'number',
						),
						'condition'   => array(
							'colormag_enable_news_ticker' => true,
						),
					),
					'colormag_news_ticker_animation_speed' => array(
						'title'       => esc_html__( 'Transition Speed', 'colormag' ),
						'default'     => 1,
						'type'        => 'customind-text',
						'section'     => 'colormag_news_ticker_section',
						'input_attrs' => array(
							'type' => 'number',
						),
						'condition'   => array(
							'colormag_enable_news_ticker' => true,
						),
					),
				)
			),
			'collapsible'  => apply_filters( 'colormag_news_ticker_accordion_collapsible', false ),
		),
	)
);

colormag_customind()->add_controls( $options );
