<?php

$options = apply_filters(
	'colormag_transparent_options',
	array(
		'colormag_transparent_header_heading' => array(
			'type'         => 'customind-accordion',
			'title'        => esc_html__( 'Transparent Header', 'colormag' ),
			'section'      => 'colormag_transparent_header_section',
			'sub_controls' => apply_filters(
				'colormag_transparent_controls',
				array(
					'colormag_transparent_header_general_subtitle' => array(
						'type'    => 'customind-title',
						'title'   => esc_html__( 'General', 'colormag' ),
						'section' => 'colormag_transparent_header_section',
					),
					'colormag_enable_transparent_header'   => array(
						'title'   => esc_html__( 'Enable', 'colormag' ),
						'default' => false,
						'type'    => 'customind-toggle',
						'section' => 'colormag_transparent_header_section',
					),
					'colormag_transparent_header_conditions_heading' => array(
						'type'      => 'customind-title',
						'title'     => esc_html__( 'Conditions', 'colormag' ),
						'section'   => 'colormag_transparent_header_section',
						'condition' => array(
							'colormag_enable_transparent_header' => true,
						),
					),
					'colormag_front_page_transparent_header' => array(
						'default'   => '',
						'type'      => 'customind-checkbox',
						'title'     => esc_html__( 'Front Page (Latest Posts)', 'colormag' ),
						'section'   => 'colormag_transparent_header_section',
						'condition' => array(
							'colormag_enable_transparent_header' => true,
						),
					),
					'colormag_404_page_transparent_header' => array(
						'default'   => '',
						'type'      => 'customind-checkbox',
						'title'     => esc_html__( '404 Page', 'colormag' ),
						'section'   => 'colormag_transparent_header_section',
						'condition' => array(
							'colormag_enable_transparent_header' => true,
						),
					),
					'colormag_search_page_transparent_header' => array(
						'default'   => '',
						'type'      => 'customind-checkbox',
						'title'     => esc_html__( 'Search Page', 'colormag' ),
						'section'   => 'colormag_transparent_header_section',
						'condition' => array(
							'colormag_enable_transparent_header' => true,
						),
					),
					'colormag_archive_page_transparent_header' => array(
						'default'   => '',
						'type'      => 'customind-checkbox',
						'title'     => esc_html__( 'Archive Page', 'colormag' ),
						'section'   => 'colormag_transparent_header_section',
						'condition' => array(
							'colormag_enable_transparent_header' => true,
						),
					),
				),
			),
			'collapsible'  => apply_filters( 'colormag_transparent_accordion_collapsible', false ),
		),
	)
);

colormag_customind()->add_controls( $options );
