<?php

$options = array(
	'colormag_language_switcher_heading' => array(
		'type'         => 'customind-accordion',
		'title'        => esc_html__( 'Language Switcher', 'colormag' ),
		'section'      => 'colormag_header_builder_language_switcher',
		'sub_controls' => apply_filters(
			'colormag_language_switcher_sub_controls',
			array(
				'colormag_header_language_switcher_type'   => array(
					'default' => 'polylang',
					'type'    => 'customind-select',
					'title'   => esc_html__( 'Language Type', 'colormag' ),
					'section' => 'colormag_header_builder_language_switcher',
					'choices' => array(
						'polylang' => esc_html__( 'Polylang', 'colormag' ),
						'wpml'     => esc_html__( 'Wpml', 'colormag' ),
					),
				),
				'colormag_enable_language_flag'            => array(
					'title'    => esc_html__( 'Show Flag', 'colormag' ),
					'default'  => true,
					'type'     => 'customind-toggle',
					'section'  => 'colormag_header_builder_language_switcher',
					'priority' => 10,
				),
				'colormag_enable_language_name'            => array(
					'title'    => esc_html__( 'Show Name', 'colormag' ),
					'default'  => true,
					'type'     => 'customind-toggle',
					'section'  => 'colormag_header_builder_language_switcher',
					'priority' => 10,
				),
				'colormag_enable_language_translated_name' => array(
					'title'     => esc_html__( 'Translated Name', 'colormag' ),
					'default'   => false,
					'type'      => 'customind-toggle',
					'section'   => 'colormag_header_builder_language_switcher',
					'priority'  => 10,
					'condition' => array(
						'colormag_header_language_switcher_type' => 'wpml',
					),
				),
				'colormag_enable_language_code'            => array(
					'title'    => esc_html__( 'Show Code', 'colormag' ),
					'default'  => true,
					'type'     => 'customind-toggle',
					'section'  => 'colormag_header_builder_language_switcher',
					'priority' => 10,
				),
			)
		),
		'collapsible'  => apply_filters( 'colormag_language_switcher_accordion_collapsible', false ),
	),
);

colormag_customind()->add_controls( $options );
