import apiFetch from '@wordpress/api-fetch';
import {
	Button,
	__experimentalInputControl as InputControl,
	TabPanel,
	TextareaControl,
	ToggleControl,
} from '@wordpress/components';
import { __ } from '@wordpress/i18n';
import { MediaUpload } from '@wordpress/media-utils';
import React, { useEffect, useState } from 'react';
import { Controller, FormProvider, useForm } from 'react-hook-form';
import { toast, ToastContainer } from 'react-toastify';
import 'react-toastify/dist/ReactToastify.css';
import { localized as globalLocalized } from '../../utils/global';
import { localized } from '../../utils/utils';

const Settings: React.FC = () => {
	const form = useForm({
		defaultValues: {
			enable_white_label: localized.enable_white_label,
			hide_starter_templates: localized.hide_starter_templates,
			hide_products_tab: localized.hide_products_tab,
			hide_white_label: localized.hide_white_label,
			hide_helps_tab: localized.hide_helps_tab,
			hide_license_tab: localized.hide_license_tab,
			hide_documentation: localized.hide_documentation,
			hide_review_section: localized.hide_review_section,
			hide_feature_section: localized.hide_feature_section,
			hide_support_section: localized.hide_support_section,
			hide_user_ful_section: localized.hide_user_ful_section,
			hide_community_section: localized.hide_community_section,
			hide_starter_template_section: localized.hide_starter_template_section,
			agency_name: localized.agency_name,
			agency_url: localized.agency_url,
			theme_description: localized.theme_description,
			theme_name: localized.theme_name,
			theme_screenshot: localized.theme_screenshot,
			theme_icon: localized.theme_icon,
			dashboard_icon: localized.dashboard_icon,
		},
	});

	const [isLoading, setIsLoading] = useState(false);
	const [showWhiteLabel, setShowWhiteLabel] = useState(
		!localized.hide_white_label,
	);

	const ALLOWED_MEDIA_TYPES = ['image'];

	const [onSaveChange, onSaveSetChange] = useState(false);

	const onSubmit = (data: any) => {
		return apiFetch({
			method: 'POST',
			path: 'colormag/v1/settings',
			data: data,
		}).catch((error) => {
			console.error('Settings update failed:', error);
			toast.error('Failed to update settings.');
		});
	};

	const handleToggleChange = (value: boolean, field: any) => {
		field.onChange(value);
		const formData = form.getValues();
		formData.enable_white_label = value;
		onSubmit(formData);
	};

	const onSave = () => {
		onSaveSetChange(true);
		setIsLoading(true);
		const formData = form.getValues();
		const hideWhiteLabel = form.getValues('hide_white_label');
		onSubmit(formData).finally(() => {
			setIsLoading(false);
			if (hideWhiteLabel) {
				window.location.href =
					globalLocalized.adminUrl + '/admin.php?page=colormag';
			} else {
				setTimeout(() => {
					window.location.reload();
				}, 1500);
			}
		});
	};

	useEffect(() => {
		if (onSaveChange) {
			toast.success('Settings updated successfully!');
		}
	}, [onSaveChange]);

	const white_label = form.watch('enable_white_label');
	const hide_white_label = form.watch('hide_white_label');

	return (
		<>
			<FormProvider {...form}>
				<form onSubmit={form.handleSubmit(onSubmit)}>
					<TabPanel
						style={{ marginTop: '1rem' }}
						className={
							'cm-setting-tab border border-solid border-[#E1E1E1] [&>div]:transition-none'
						}
						onSelect={() => {}}
						tabs={[
							...(showWhiteLabel
								? [
										{
											name: 'white-label',
											title: __('White Label', 'colormag'),
											className: 'cm-colormag-setting-tabpanel__general',
										},
									]
								: []),
						]}
					>
						{(tab) => {
							return (
								<>
									<div
										className={`${tab.name === 'white-label' ? 'block' : 'hidden'} p-6`}
									>
										<div className="border rounded border-solid border-[#E1E1E1]">
											<div className=" p-[24px]">
												<Controller
													name={'enable_white_label'}
													control={form.control}
													render={({ field }) => (
														<ToggleControl
															className="[&>div>div]:flex-row-reverse cm-setting-label"
															__nextHasNoMarginBottom
															checked={field.value ?? false}
															label={__('White Label', 'colormag')}
															onChange={(value) =>
																handleToggleChange(value, field)
															}
														/>
													)}
												/>
												<p className="text-[#6B6B6B] w-9/12">
													{__(
														'Modern and professional WordPress magazine and news portal-styled theme perfect for creating websites for your user-engaging magazines, news channels, etc.',
														'colormag',
													)}
												</p>
											</div>
											{/*<div className="flex items-center gap-3 py-[20px] px-[24px] border-x-0 border-b-0 border-t border-solid border-[#E1E1E1]">*/}
											{/*	<a*/}
											{/*		className="cm-setting-learn-more text-[#7A7A7A]"*/}
											{/*		href="#"*/}
											{/*	>*/}
											{/*		{__('Documentation', 'colormag')}*/}
											{/*	</a>*/}
											{/*	<a className="text-[#7A7A7A]" href="#">*/}
											{/*		{__('Live Demo', 'colormag')}*/}
											{/*	</a>*/}
											{/*</div>*/}
										</div>

										{white_label && (
											<>
												<TabPanel
													style={{ marginTop: '1rem' }}
													className="cm-white-label-setting [&>div]:transition-none mt-8"
													onSelect={() => {}}
													tabs={[
														{
															name: 'general',
															title: __('General', 'colormag'),
															className:
																'cm-colormag-setting-tabpanel__general',
														},
														{
															name: 'advanced',
															title: __('Advanced', 'colormag'),
															className: 'cm-colormag-setting-tabpanel__style',
														},
													]}
												>
													{(tab) => {
														return (
															<>
																<div
																	className={`${tab.name === 'general' ? 'block' : 'hidden'} p-6`}
																>
																	<div className="mb-12">
																		<h2>{__('Agency Details', 'colormag')}</h2>
																		<Controller
																			name={'agency_name'}
																			control={form.control}
																			render={({ field }) => (
																				<InputControl
																					className="mt-4 cm-dashboard-input cm-label border-[#E1E1E1]"
																					label={__('Agency Name', 'colormag')}
																					labelPosition="top"
																					onChange={field.onChange}
																					value={field.value}
																				/>
																			)}
																		/>
																		<Controller
																			name={'agency_url'}
																			control={form.control}
																			render={({ field }) => (
																				<InputControl
																					className="mt-4 cm-dashboard-input cm-label border-[#E1E1E1]"
																					label={__('Agency URL', 'colormag')}
																					labelPosition="top"
																					onChange={field.onChange}
																					value={field.value}
																				/>
																			)}
																		/>
																	</div>
																	<hr />
																	<div className="mt-12 mb-12">
																		<h2>{__('Theme Details', 'colormag')}</h2>
																		<Controller
																			name={'theme_name'}
																			control={form.control}
																			render={({ field }) => (
																				<InputControl
																					className="mt-4 cm-dashboard-input cm-label border-[#E1E1E1]"
																					label={__('Theme Name', 'colormag')}
																					labelPosition="top"
																					onChange={field.onChange}
																					value={field.value}
																				/>
																			)}
																		/>
																		<Controller
																			name={'theme_description'}
																			control={form.control}
																			render={({ field }) => (
																				<TextareaControl
																					className="mt-4 cm-dashboard-input cm-label border-[#E1E1E1]"
																					label={__(
																						'Theme Description',
																						'colormag',
																					)}
																					onChange={field.onChange}
																					value={field.value}
																				/>
																			)}
																		/>

																		<Controller
																			name={'theme_screenshot'}
																			control={form.control}
																			render={({ field }) => (
																				<div className="flex justify-center items-center gap-2">
																					<div className="basis-[86%]">
																						<InputControl
																							className="mt-4 cm-dashboard-input cm-label border-[#E1E1E1]"
																							label={__(
																								'Theme Screenshot URL',
																								'colormag',
																							)}
																							labelPosition="top"
																							onChange={field.onChange}
																							value={field.value}
																						/>
																					</div>
																					<div className="media-upload flex justify-center items-center mt-[42px] border border-solid border-[#E1E1E1] rounded-[4px]">
																						<MediaUpload
																							onSelect={(media: any) => {
																								field.onChange(media.url);
																							}}
																							allowedTypes={ALLOWED_MEDIA_TYPES}
																							value={field.value}
																							// @ts-ignore
																							render={({ open }) => (
																								<Button onClick={open}>
																									{__(
																										'Choose Image',
																										'colormag',
																									)}
																								</Button>
																							)}
																						/>
																					</div>
																				</div>
																			)}
																		/>

																		<Controller
																			name={'theme_icon'}
																			control={form.control}
																			render={({ field }) => (
																				<>
																					<div className="flex justify-center items-center gap-2">
																						<div className="basis-[86%]">
																							<InputControl
																								className="mt-4 cm-dashboard-input cm-label border-[#E1E1E1]"
																								label={__(
																									'Theme Icon',
																									'colormag',
																								)}
																								labelPosition="top"
																								onChange={field.onChange}
																								value={field.value}
																							/>
																						</div>
																						<div className="media-upload flex justify-center items-center mt-[44px] border border-solid border-[#E1E1E1] rounded-[4px]">
																							<MediaUpload
																								onSelect={(media: any) =>
																									field.onChange(media.url)
																								}
																								allowedTypes={
																									ALLOWED_MEDIA_TYPES
																								}
																								value={field.value}
																								// @ts-ignore
																								render={({ open }) => (
																									<Button onClick={open}>
																										{__(
																											'Choose Image',
																											'colormag',
																										)}
																									</Button>
																								)}
																							/>
																						</div>
																					</div>
																					<p className="border border-dashed border-[#e1e1e1] p-1 italic text-[12px] w-fit">
																						{__(
																							'Recommended size for logo is 150 x 150 px.',
																							'colormag',
																						)}
																					</p>
																				</>
																			)}
																		/>
																		<Controller
																			name={'dashboard_icon'}
																			control={form.control}
																			render={({ field }) => (
																				<div className="flex justify-center items-center gap-2">
																					<div className="basis-[86%]">
																						<InputControl
																							className="mt-4 cm-dashboard-input cm-label border-[#E1E1E1]"
																							label={__(
																								'Dashboard Icon',
																								'colormag',
																							)}
																							labelPosition="top"
																							onChange={field.onChange}
																							value={field.value}
																						/>
																					</div>
																					<div className="media-upload flex justify-center items-center mt-[44px] border border-solid border-[#E1E1E1] rounded-[4px]">
																						<MediaUpload
																							onSelect={(media: any) =>
																								field.onChange(media.url)
																							}
																							allowedTypes={ALLOWED_MEDIA_TYPES}
																							value={field.value}
																							// @ts-ignore
																							render={({ open }) => (
																								<Button onClick={open}>
																									{__(
																										'Choose Image',
																										'colormag',
																									)}
																								</Button>
																							)}
																						/>
																					</div>
																				</div>
																			)}
																		/>
																	</div>
																</div>
																<div
																	className={`${tab.name === 'advanced' ? 'block' : 'hidden'} p-6`}
																>
																	<Controller
																		name={'hide_starter_templates'}
																		control={form.control}
																		render={({ field }) => (
																			<ToggleControl
																				className="[&>div>div]:flex-row-reverse cm-setting-label"
																				__nextHasNoMarginBottom
																				checked={field.value ?? false}
																				label={__(
																					'Hide Starter Templates',
																					'colormag',
																				)}
																				onChange={field.onChange}
																			/>
																		)}
																	/>
																	<Controller
																		name={'hide_products_tab'}
																		control={form.control}
																		render={({ field }) => (
																			<ToggleControl
																				className="[&>div>div]:flex-row-reverse cm-setting-label"
																				__nextHasNoMarginBottom
																				checked={field.value ?? false}
																				label={__(
																					'Hide Products Tab',
																					'colormag',
																				)}
																				onChange={field.onChange}
																			/>
																		)}
																	/>
																	<Controller
																		name={'hide_helps_tab'}
																		control={form.control}
																		render={({ field }) => (
																			<ToggleControl
																				className="[&>div>div]:flex-row-reverse cm-setting-label"
																				__nextHasNoMarginBottom
																				checked={field.value ?? false}
																				label={__('Hide Help Tab', 'colormag')}
																				onChange={field.onChange}
																			/>
																		)}
																	/>
																	<Controller
																		name={'hide_license_tab'}
																		control={form.control}
																		render={({ field }) => (
																			<ToggleControl
																				className="[&>div>div]:flex-row-reverse cm-setting-label"
																				__nextHasNoMarginBottom
																				checked={field.value ?? false}
																				label={__(
																					'Hide License Tab',
																					'colormag',
																				)}
																				onChange={field.onChange}
																			/>
																		)}
																	/>
																	<Controller
																		name={'hide_starter_template_section'}
																		control={form.control}
																		render={({ field }) => (
																			<ToggleControl
																				className="[&>div>div]:flex-row-reverse cm-setting-label"
																				__nextHasNoMarginBottom
																				checked={field.value ?? false}
																				label={__(
																					'Hide Starter Template Section',
																					'colormag',
																				)}
																				onChange={field.onChange}
																			/>
																		)}
																	/>
																	<Controller
																		name={'hide_documentation'}
																		control={form.control}
																		render={({ field }) => (
																			<ToggleControl
																				className="[&>div>div]:flex-row-reverse cm-setting-label"
																				__nextHasNoMarginBottom
																				checked={field.value ?? false}
																				label={__(
																					'Hide Documentation',
																					'colormag',
																				)}
																				onChange={field.onChange}
																			/>
																		)}
																	/>

																	<Controller
																		name={'hide_review_section'}
																		control={form.control}
																		render={({ field }) => (
																			<ToggleControl
																				className="[&>div>div]:flex-row-reverse cm-setting-label"
																				__nextHasNoMarginBottom
																				checked={field.value ?? false}
																				label={__(
																					'Hide Review Section',
																					'colormag',
																				)}
																				onChange={field.onChange}
																			/>
																		)}
																	/>

																	<Controller
																		name={'hide_feature_section'}
																		control={form.control}
																		render={({ field }) => (
																			<ToggleControl
																				className="[&>div>div]:flex-row-reverse cm-setting-label"
																				__nextHasNoMarginBottom
																				checked={field.value ?? false}
																				label={__(
																					'Hide Feature request Section',
																					'colormag',
																				)}
																				onChange={field.onChange}
																			/>
																		)}
																	/>

																	<Controller
																		name={'hide_support_section'}
																		control={form.control}
																		render={({ field }) => (
																			<ToggleControl
																				className="[&>div>div]:flex-row-reverse cm-setting-label"
																				__nextHasNoMarginBottom
																				checked={field.value ?? false}
																				label={__(
																					'Hide Support Section',
																					'colormag',
																				)}
																				onChange={field.onChange}
																			/>
																		)}
																	/>
																	<Controller
																		name={'hide_user_ful_section'}
																		control={form.control}
																		render={({ field }) => (
																			<ToggleControl
																				className="[&>div>div]:flex-row-reverse cm-setting-label"
																				__nextHasNoMarginBottom
																				checked={field.value ?? false}
																				label={__(
																					'Hide Useful Section',
																					'colormag',
																				)}
																				onChange={field.onChange}
																			/>
																		)}
																	/>

																	<Controller
																		name={'hide_community_section'}
																		control={form.control}
																		render={({ field }) => (
																			<ToggleControl
																				className="[&>div>div]:flex-row-reverse cm-setting-label"
																				__nextHasNoMarginBottom
																				checked={field.value ?? false}
																				label={__(
																					'Hide Community Section',
																					'colormag',
																				)}
																				onChange={field.onChange}
																			/>
																		)}
																	/>
																	<Controller
																		name={'hide_white_label'}
																		control={form.control}
																		render={({ field }) => (
																			<ToggleControl
																				className="[&>div>div]:flex-row-reverse cm-setting-label"
																				__nextHasNoMarginBottom
																				checked={field.value ?? false}
																				label={__(
																					'Hide White Label',
																					'colormag',
																				)}
																				onChange={field.onChange}
																			/>
																		)}
																	/>
																	{hide_white_label && (
																		<>
																			<p className="border border-dashed border-[#e1e1e1] p-2 italic">
																				{__(
																					'Please note that the white label extension will be hidden if this option is enabled. In order to bring it back you have to hit the SHIFT key and click on Header Section and reload after click.',
																					'colormag',
																				)}
																			</p>
																		</>
																	)}
																</div>
															</>
														);
													}}
												</TabPanel>

												<Button
													onClick={onSave}
													className="cm-save-setting !bg-[#0377B5] roundness mx-6"
													type="submit"
													variant="primary"
													disabled={isLoading}
												>
													{isLoading
														? __('Saving...', 'colormag')
														: __('Save Settings', 'colormag')}
												</Button>
											</>
										)}
									</div>
									<div className={tab.name === 'style' ? 'block' : 'hidden'}>
										{'style'}
									</div>
								</>
							);
						}}
					</TabPanel>
					<ToastContainer position="bottom-center" />
				</form>
			</FormProvider>
		</>
	);
};

export default Settings;
