<?php

$home_icon_class = 'cm-home-icon';
$menu_logo       = colormag_get_image_src_by_url( get_theme_mod( 'colormag_primary_menu_logo' ), 'full' );
$home_icon_type  = get_theme_mod( 'colormag_menu_icon_logo', 'home-icon' );
if ( is_front_page() ) {
	$home_icon_class = 'cm-home-icon front_page_on';
}
if ( 'logo' === $home_icon_type ) {
	if ( isset( $menu_logo[0] ) ) :
		?>
			<div class="menu-logo">
				<a href="<?php echo esc_url( home_url( '/' ) ); ?>"
					title="<?php esc_attr( bloginfo( 'name' ) ); ?>">
					<img src="<?php echo esc_url( $menu_logo[0] ); ?>"
						alt="<?php esc_attr( bloginfo( 'name' ) ); ?>">
				</a>
			</div>
		<?php
endif;
}
if ( 'home-icon' === $home_icon_type ) {
	?>

<div class="<?php echo esc_attr( $home_icon_class ); ?>">
	<a href="<?php echo esc_url( home_url( '/' ) ); ?>"
		title="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>"
	>
		<?php colormag_get_icon( 'home' ); ?>
	</a>
</div>
<?php } ?>
