<?php
/**
 * Language Switcher Element.
 *
 * @package ColorMag Pro
 */

// Get customizer options.
$lang_type             = get_theme_mod( 'colormag_header_language_switcher_type', 'polylang' );
$show_flag             = get_theme_mod( 'colormag_enable_language_flag', true );
$show_label            = get_theme_mod( 'colormag_enable_language_name', true );
$show_translated_label = get_theme_mod( 'colormag_enable_language_translated_name', false );
$show_code             = get_theme_mod( 'colormag_enable_language_code', true );

// Only render if we have languages to display.
?>
	<div class="cm-builder-language-switcher-element">
		<nav class="cm-builder-language-switcher" aria-label="<?php esc_attr_e( 'Language Switcher', 'colormag' ); ?>">
			<ul class="cm-builder-language-switcher-menu">
				<?php
				// Render Polylang languages.
				if ( 'polylang' === $lang_type && is_callable( 'pll_the_languages' ) ) {
					$languages = pll_the_languages( array( 'raw' => true ) );
					foreach ( $languages as $language ) :
						$is_current    = isset( $language['current_lang'] ) && '1' === $language['current_lang'];
						$current_class = $is_current ? 'cm-builder-language-switcher-item__active' : '';
						?>
						<li class="cm-builder-language-switcher-menu-list">
							<a href="<?php echo esc_url( $language['url'] ); ?>" class="cm-item <?php echo esc_attr( $current_class ); ?>">
								<?php if ( $show_flag && ! empty( $language['flag'] ) ) : ?>
									<span class="cm-lang-item-flag">
								<img src="<?php echo esc_url( $language['flag'] ); ?>" alt="<?php echo esc_attr( $language['slug'] ); ?>" width="18" height="12" />
							</span>
								<?php endif; ?>

								<?php if ( $show_label && ! empty( $language['name'] ) ) : ?>
									<span class="cm-lang-item-name cm-language-native-name">
									<?php echo esc_html( $language['name'] ); ?>
							</span>
								<?php endif; ?>

								<?php if ( $show_code && ! empty( $language['slug'] ) ) : ?>
									<span class="cm-lang-item-code cm-language-code">
								(<?php echo esc_html( $language['slug'] ); ?>)
							</span>
								<?php endif; ?>
							</a>
						</li>
						<?php
					endforeach;
				} elseif ( 'wpml' === $lang_type ) {
					$languages = apply_filters(
						'wpml_active_languages', // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedHooknameFound
						null,
						array(
							'skip_missing' => 0,
						)
					);
					if ( ! empty( $languages ) ) {
						foreach ( $languages as $language ) :
							$is_current    = isset( $language['active'] ) && '1' === $language['active'];
							$current_class = $is_current ? 'cm-builder-language-switcher-item__active' : '';
							?>
							<li class="cm-builder-language-switcher-menu-list">
								<a href="<?php echo esc_url( $language['url'] ); ?>" class="cm-item <?php echo esc_attr( $current_class ); ?>">
									<?php if ( $show_flag ) : ?>
										<span class="cm-lang-item-flag">
									<img src="<?php echo esc_url( $language['country_flag_url'] ); ?>" alt="<?php echo esc_attr( $language['language_code'] ); ?>" width="18" height="12" />
										</span>
									<?php endif; ?>

									<?php if ( $show_label ) : ?>
										<span class="cm-lang-item-name cm-language-native-name">
										<?php echo esc_html( $language['native_name'] ); ?>
										</span>
									<?php endif; ?>

									<?php if ( $show_translated_label ) : ?>
										<span class="cm-lang-item-name cm-translated-name">
										<?php echo esc_html( $language['translated_name'] ); ?>
										</span>
									<?php endif; ?>

									<?php if ( $show_code ) : ?>
										<span class="cm-lang-item-code cm-language-code">
									(<?php echo esc_html( $language['language_code'] ); ?>)
										</span>
									<?php endif; ?>
								</a>
							</li>
							<?php
						endforeach;
					}
				}
				?>
			</ul>
		</nav>
	</div>
