<?php
$off_canvas_text     = get_theme_mod( 'colormag_off_canvas_text', '' );
$off_canvas_position = get_theme_mod( 'colormag_off_canvas_text_position', 'right' );

?>

<div class="cm-off-canvas">
	<div class="cm-off-canvas-toggle-button">
		<button class="cm-off-canvas-toggle" aria-expanded="false" aria-label="<?php esc_attr_e( 'Off Canvas', 'colormag' ); ?>">
			<?php
			if ( 'left' === $off_canvas_position ) {
				?>
			<span class="cm-off-canvas-toggle-text">
					<?php
					if ( ! empty( $off_canvas_text ) ) {
						echo esc_html( $off_canvas_text );
					}
					?>
				</span>
				<?php
			}
			?>
			<span class="cm-off-canvas-toggle-icon">
						<svg class="cm-icon--bars-sort" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M9 19H3a1 1 0 0 1 0-2h6a1 1 0 0 1 0 2Zm6-6H3a1 1 0 0 1 0-2h12a1 1 0 0 1 0 2Zm6-6H3a.94.94 0 0 1-1-1 .94.94 0 0 1 1-1h18a.94.94 0 0 1 1 1 .94.94 0 0 1-1 1Z"></path></svg>
			</span>
			<?php
			if ( 'right' === $off_canvas_position ) {
				?>
				<span class="cm-off-canvas-toggle-text">
					<?php
					if ( ! empty( $off_canvas_text ) ) {
						echo esc_html( $off_canvas_text );
					}
					?>
				</span>
				<?php
			}
			?>
		</button>
	</div><!-- .cm-off-canvas-toggle-button -->

	<div class="cm-header-off-canvas">
		<div class="cm-off-canvas-inner">
			<button class="cm-off-canvas-close" aria-label="<?php esc_attr_e( 'Close Menu', 'colormag' ); ?>">
				<span aria-hidden="true"><svg class="cm-icon--x-mark" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="m14 12 7.6-7.6c.6-.6.6-1.5 0-2-.6-.6-1.5-.6-2 0L12 10 4.4 2.4c-.6-.6-1.5-.6-2 0s-.6 1.5 0 2L10 12l-7.6 7.6c-.6.6-.6 1.5 0 2 .3.3.6.4 1 .4s.7-.1 1-.4L12 14l7.6 7.6c.3.3.6.4 1 .4s.7-.1 1-.4c.6-.6.6-1.5 0-2L14 12z"></path></svg></span>
			</button>

			<div class="cm-header-blocks-container">
				<?php
				if ( ! is_active_sidebar( 'colormag-off-canvas-area' ) ) :

					the_widget( 'WP_Widget_Text',
						array(
							'title'  => esc_html__( 'Example Widget', 'colormag' ),
							'text'   => sprintf( esc_html__( 'This is an example widget to show how the Secondary sidebar looks by default. You can add custom widgets from the %swidgets screen%s in the admin. If custom widgets are added then this will be replaced by those widgets', 'colormag' ), current_user_can( 'edit_theme_options' ) ? '<a href="' . admin_url( 'widgets.php' ) . '">' : '', current_user_can( 'edit_theme_options' ) ? '</a>' : '' ),
							'filter' => true,
						),
						array(
							'before_widget' => '<section class="widget widget_text">',
							'after_widget'  => '</section>',
							'before_title'  => '<h3 class="cm-widget-title"><span>',
							'after_title'   => '<span></h3>',
						)
					);
				else :
					dynamic_sidebar( 'colormag-off-canvas-area' );
				endif;
				?>
			</div>
		</div>
	</div><!-- .cm-header-off-canvas -->

	<div class="cm-off-canvas-overlay"></div>
</div><!-- .cm-off-canvas -->
