<?php

function anps_get_custom_styles()
{
    // Try to get from cache
    $styles = get_transient('anps_theme_options_styles');
    if ($styles !== false) {
        return $styles;
    }

    $styles = array();
    /**
     * Get font family styles from theme options
     */
    // Set default font styles
    $styles['font_1'] = 'Montserrat';
    $styles['font_1_source'] = 'Google fonts';

    $styles['font_2'] = 'PT Sans';
    $styles['font_2_source'] = 'Google fonts';

    $styles['font_3'] = 'Montserrat';
    $styles['font_3_source'] = 'Google fonts';

    $styles['logo_font'] = 'Arial, sans-serif';
    $styles['logo_font_source'] = 'System fonts';

    // Adjust default font families based on theme options
    $valid_font_sources = array('System fonts', 'Custom fonts', 'Google fonts');

    $font_1_source = get_option('font_source_1');
    if (in_array($font_1_source, $valid_font_sources)) {
        $styles['font_1'] = urldecode(get_option('font_type_1'));
        $styles['font_1_source'] = $font_1_source;
    }

    $font_2_source = get_option('font_source_2');
    if (in_array($font_2_source, $valid_font_sources)) {
        $styles['font_2'] = urldecode(get_option('font_type_2'));
        $styles['font_2_source'] = $font_2_source;
    }

    $font_3_source = get_option('font_source_navigation');
    if (in_array($font_3_source, $valid_font_sources)) {
        $styles['font_3'] = urldecode(get_option('font_type_navigation'));
        $styles['font_3_source'] = $font_3_source;
    }

    // Adjust logo font based on theme options
    $logo_font_option = explode('|', get_option('anps_text_logo_font', ''));
    if (isset($logo_font_option[1])) {
        $styles['logo_font'] = urldecode($logo_font_option[0]);
        $styles['logo_font_source'] = $logo_font_option[1];
    }

    /**
     * Get font size styles from theme options
     */
    $styles['body_font_size'] = get_option('anps_body_font_size', '14');
    $styles['menu_font_size'] = get_option('anps_menu_font_size', '14');
    $styles['submenu_font_size'] = get_option('anps_submenu_font_size', '12');
    $styles['h1_font_size'] = get_option('anps_h1_font_size', '31');
    $styles['h2_font_size'] = get_option('anps_h2_font_size', '24');
    $styles['h3_font_size'] = get_option('anps_h3_font_size', '21');
    $styles['h4_font_size'] = get_option('anps_h4_font_size', '18');
    $styles['h5_font_size'] = get_option('anps_h5_font_size', '16');
    $styles['page_heading_h1_font_size'] = get_option('anps_page_heading_h1_font_size', '24');
    $styles['blog_heading_h1_font_size'] = get_option('anps_blog_heading_h1_font_size', '28');
    $styles['top_bar_font_size'] = get_option('anps_top_bar_font_size', '14');
    $styles['anps_portfolio_title_font_size'] = get_option('anps_portfolio_title_font_size', '16');

    /**
     * Get all colors from theme options
     */
    $styles['text_color'] = get_option('anps_text_color', '#727272');
    $styles['primary_color'] = get_option('anps_primary_color', '#292929');
    $styles['hovers_color'] = get_option('anps_hovers_color', '#d54900');
    $styles['headings_color'] = get_option('anps_headings_color', '#000000');
    $styles['main_divider_color'] = get_option('anps_main_divider_color', '#d54900');
    $styles['side_submenu_background_color'] = get_option('anps_side_submenu_background_color', '');
    $styles['side_submenu_text_color'] = get_option('anps_side_submenu_text_color', '');
    $styles['side_submenu_text_hover_color'] = get_option('anps_side_submenu_text_hover_color', '');

    $styles['menu_text_color'] = get_option('anps_menu_text_color', '#000');
    $styles['top_bar_color'] = get_option('anps_top_bar_color', '#c1c1c1');
    $styles['top_bar_bg_color'] = get_option('anps_top_bar_bg_color', '#f9f9f9');
    $styles['nav_background_color'] = get_option('anps_nav_background_color', '#fff');
    $styles['submenu_background_color'] = get_option('anps_submenu_background_color', '#fff');
    $styles['anps_submenu_divider_color'] = get_option('anps_submenu_divider_color', '#ececec');
    $styles['curent_menu_color'] = get_option('anps_curent_menu_color', '#d54900');
    $styles['submenu_text_color'] = get_option('anps_submenu_text_color', '#000');
    $styles['anps_woo_cart_items_number_bg_color'] = get_option('anps_woo_cart_items_number_bg_color', $styles['primary_color']);
    $styles['anps_woo_cart_items_number_color'] = get_option('anps_woo_cart_items_number_color', '#fff');
    $styles['anps_logo_bg_color'] = get_option('anps_logo_bg_color', '');
    $styles['anps_above_menu_bg_color'] = get_option('anps_above_menu_bg_color', '');
    $styles['anps_heading_bg_color'] = get_option('anps_page_heading_bg_color', '');
    $styles['page_heading_color'] = get_option('anps_page_heading_text_color', $styles['headings_color']);

    $styles['footer_bg_color'] = get_option('anps_footer_bg_color', '#242424');
    $styles['footer_text_color'] = get_option('anps_footer_text_color', '#d9d9d9');
    $styles['anps_heading_text_color'] = get_option('anps_heading_text_color', '#fff');
    $styles['footer_selected_color'] = get_option('anps_footer_selected_color', '');
    $styles['footer_hover_color'] = get_option('anps_footer_hover_color', '');
    $styles['footer_divider_color'] = get_option('anps_footer_divider_color', '#fff');
    $styles['copyright_footer_text_color'] = get_option('anps_copyright_footer_text_color', '#c4c4c4');
    $styles['copyright_footer_bg_color'] = get_option('anps_copyright_footer_bg_color', '#0f0f0f');

    $styles['anps_front_text_color'] = get_option('anps_front_text_color', '');
    $styles['anps_front_text_hover_color'] = get_option('anps_front_text_hover_color', '');
    $styles['anps_front_curent_menu_color'] = get_option('anps_front_curent_menu_color', '');
    $styles['anps_front_bg_color'] = get_option('anps_front_bg_color', '');
    $styles['anps_front_topbar_color'] = get_option('anps_front_topbar_color', '#fff');
    $styles['anps_front_topbar_hover_color'] = get_option('anps_front_topbar_hover_color', '#d54900');
    $styles['anps_front_topbar_bg_color'] = get_option('anps_front_topbar_bg_color', '');

    /**
     * Get any other styles from theme options
     */
    $styles['container_width'] = intval(get_option('anps_container_width', '1170') ?: '1170');
    $styles['anps_top_bar_height'] = get_option('anps_top_bar_height', '60') ?: '60';

    // Cache results
    set_transient('anps_theme_options_styles', $styles);

    // Return all styles in array format
    return $styles;
}

function anps_custom_styles()
{
    // Try cache because compiling and formatting this css string is expensive
    $css = get_transient('anps_theme_options_styles_css');
    if ($css !== false && !empty($css)) {
        return $css;
    }


    $styles = anps_get_custom_styles();

    // Collect all CSS into a variable so we can cache it
    ob_start();

    // Print @font-face styles for custom (uploaded) fonts
    if ($styles['font_1_source'] === 'Custom fonts') {
        echo anps_custom_font($styles['font_1']);
    }
    if ($styles['font_2_source'] === 'Custom fonts') {
        echo anps_custom_font($styles['font_2']);
    }
    if ($styles['font_3_source'] === 'Custom fonts') {
        echo anps_custom_font($styles['font_3']);
    }
    if ($styles['logo_font_source'] === 'Custom fonts') {
        echo anps_custom_font($styles['logo_font']);
    }

    $menu_type = get_option('anps_menu_type', '2') ?: '2';
    $is_menu_type_1_or_3 = $menu_type === '1' || $menu_type === '3';

    // Output CSS to apply theme options styles
    ?>
    <?php if ($styles['text_color']) : ?>
body,
ol.list > li > *,
.recent-portfolio--modern-1 .recent-portfolio__excerpt,
.testimonial-modern__link,
.testimonial-modern__link:hover,
.testimonial-modern__link:focus,
.product_meta span span,
.f-content__content {
    color: <?php echo esc_attr($styles['text_color']); ?>;
}
    <?php endif; if ($styles['container_width']) : ?>
@media (min-width: <?php echo esc_attr($styles['container_width'] + 30); ?>px) {
    .container {
        width: <?php echo esc_attr($styles['container_width']); ?>px;
    }
    .site-header-layout-normal .nav-bar-wrapper {
        width: <?php echo esc_attr($styles['container_width'] + 30); ?>px;
    }
}
    <?php endif; if ($styles['top_bar_font_size']) : ?>
.top-bar, .top-bar a {
    font-size: <?php echo esc_attr($styles['top_bar_font_size']); ?>px;
}
    <?php endif; ?>
@media(min-width: 992px) {
    <?php if ($styles['anps_above_menu_bg_color']) : ?>
    .site-header-style-boxed,
    .site-header-style-full-width {
        background-color: <?php echo esc_attr($styles['anps_above_menu_bg_color']); ?>;
    }
    <?php endif; if ($styles['menu_text_color']) : ?>
    .mini-cart-wrap .cart-contents > i,
    .nav-wrap .site-search-toggle button,
    .nav-bar .site-search-toggle button {
        color: <?php echo esc_attr($styles['menu_text_color']); ?>;
    }
    .site-navigation a,
    .home .site-header-sticky-active .site-navigation .menu-item-depth-0 > a:not(:hover):not(:focus),
    .paralax-header .site-header-style-transparent.site-header-sticky-active .site-navigation .menu-item-depth-0 > a:not(:hover):not(:focus),
    .nav-empty {
        color: <?php echo esc_attr($styles['menu_text_color']); ?>;
    }
    .menu-button {
        color: <?php echo esc_attr($styles['menu_text_color']); ?> !important;
    }
    <?php endif; ?>
}
    <?php if ($styles['nav_background_color']) : ?>
.site-header-style-normal .nav-wrap {
    background-color: <?php echo esc_attr($styles['nav_background_color']); ?>;
}
    <?php endif; ?>
@media(min-width: 992px) {
    <?php if ($styles['submenu_background_color']) : ?>
    .site-navigation .sub-menu {
        background-color: <?php echo esc_attr($styles['submenu_background_color']); ?>;
    }
    <?php endif; if ($styles['submenu_text_color']) : ?>
    .site-navigation .sub-menu a {
        color: <?php echo esc_attr($styles['submenu_text_color']); ?>;
    }
    <?php endif; ?>
}
    <?php if ($styles['main_divider_color']) : ?>
.heading-left.divider-sm span:before,
.heading-middle.divider-sm span:before,
.heading-middle span:before,
.heading-left span:before,
.divider-modern:not(.heading-content) span:after,
.recent-portfolio__title::after,
.portfolio-modern__title::after,
.rp-modern__header::after {
    background-color: <?php echo esc_attr($styles['main_divider_color']); ?>;
}
    <?php endif; if ($styles['curent_menu_color']) : ?>
.site-navigation .current-menu-item > a:not(:focus):not(:hover),
.home .site-navigation .current-menu-item > a:not(:focus):not(:hover),
.home .site-header.site-header-sticky-active .menu-item-depth-0.current-menu-item > a:not(:focus):not(:hover) {
    color: <?php echo esc_attr($styles['curent_menu_color']); ?> !important;
}
    <?php endif; ?>
@media(min-width: 992px) {
    <?php if ($styles['hovers_color']) : ?>
    .site-search-toggle button:hover, .site-search-toggle button:focus, .site-navigation ul:not(.sub-menu) > li > a:hover,
    .site-navigation ul:not(.sub-menu) > li > a:focus {
        color: <?php echo esc_attr($styles['hovers_color']); ?>;
    }
    <?php endif; if ($styles['anps_front_bg_color']) : ?>
    .site-header-style-boxed .nav-bar-wrapper {
        background-color: <?php echo esc_attr($styles['anps_front_bg_color']); ?>;
    }
    <?php endif; ?>
}
@media(max-width: 991px) {
    <?php if ($styles['hovers_color']) : ?>
    .site-search-toggle button:hover, .site-search-toggle button:focus,
    .navbar-toggle:hover, .navbar-toggle:focus {
        background-color: <?php echo esc_attr($styles['hovers_color']); ?>;
    }
    <?php endif; if ($styles['primary_color']) : ?>
    .site-search-toggle button,
    .navbar-toggle {
        background-color: <?php echo esc_attr($styles['primary_color']); ?>;
    }
    <?php endif; ?>
}

    <?php if ($is_menu_type_1_or_3) : ?>
@media(min-width: 992px) {
        <?php if ($styles['anps_front_text_color']) : ?>
    .home .site-navigation .menu-item-depth-0 > a, .home header:not(.site-header-sticky-active) .site-search-toggle button:not(:hover):not(:focus),
    .nav-empty {
        color: <?php echo esc_attr($styles['anps_front_text_color']); ?>;
    }
    .home .site-navigation ul:not(.sub-menu) > li > a,
    .home .nav-empty,
    .home header:not(.site-header-sticky-active) .mini-cart-wrap .cart-contents > i,
    .home header:not(.site-header-sticky-active) .site-search-toggle button {
        color: <?php echo esc_attr($styles['anps_front_text_color']); ?>;
    }
        <?php endif; if ($styles['anps_front_curent_menu_color']) : ?>
    .home .site-header .menu-item-depth-0.current-menu-item > a {
        color: <?php echo esc_attr($styles['anps_front_curent_menu_color']); ?> !important;
    }
        <?php endif; if ($styles['anps_front_text_hover_color']) : ?>
    .home .site-search-toggle button:focus,
    .home .site-search-toggle button:hover {
        color: <?php echo esc_attr($styles['anps_front_text_hover_color']); ?>;
    }
        <?php endif; ?>
}
        <?php if ($styles['anps_front_text_hover_color']) : ?>
.home .site-header .menu-item-depth-0 > a:hover,
.home .site-header .menu-item-depth-0 > a:focus {
    color: <?php echo esc_attr($styles['anps_front_text_hover_color']); ?>;
}
.site-navigation a:hover,
.site-navigation a:focus,
.site-navigation .current-menu-item > a,
.home .site-navigation ul:not(.sub-menu) > li > a:hover,
.home .site-navigation ul:not(.sub-menu) > li > a:focus,
.home header:not(.site-header-sticky-active) .site-search-toggle button:hover {
    color: <?php echo esc_attr($styles['anps_front_text_hover_color']); ?>;
}
        <?php endif; ?>
    <?php elseif ($styles['anps_front_bg_color']) : ?>
.site-header-style-normal .nav-wrap {
    background-color: <?php echo esc_attr($styles['anps_front_bg_color']); ?>;
}
@media(min-width: 992px) {
    .site-header-style-full-width.site-header-sticky-active .header-wrap,
    .site-header-style-full-width .header-wrap {
        background-color: <?php echo esc_attr($styles['anps_front_bg_color']); ?>;
    }
}
    <?php endif; ?>

.top-bar {
    <?php if ($styles['top_bar_bg_color']) : ?>
    background-color: <?php echo esc_attr($styles['top_bar_bg_color']); ?>;
    <?php endif; if ($styles['top_bar_color']) : ?>
    color: <?php echo esc_attr($styles['top_bar_color']); ?>;
    <?php endif; ?>
}

    <?php if (is_front_page() && $styles['anps_front_topbar_color'] && $is_menu_type_1_or_3) : ?>
    .top-bar a:not(:hover) {
        color: <?php echo esc_attr($styles['anps_front_topbar_color']); ?>;
    }
    <?php else : ?>
    .top-bar a:not(:hover) {
        color: <?php echo esc_attr($styles['top_bar_color']); ?>;
    }
    <?php endif; ?>

    <?php if (is_front_page() && $styles['anps_front_topbar_hover_color'] && $is_menu_type_1_or_3) : ?>
    .top-bar a:hover,
    .top-bar a:focus {
        color: <?php echo esc_attr($styles['anps_front_topbar_hover_color']); ?> !important;
    }
    .top-bar {
        color: <?php echo esc_attr($styles['anps_front_topbar_color']); ?>;
    }
    .top-bar {
        background-color: <?php echo esc_attr($styles['anps_front_topbar_bg_color']); ?>;
    }
    <?php endif; if ($styles['top_bar_font_size']) : ?>
.top-bar, .top-bar a {
    font-size: <?php echo esc_attr($styles['top_bar_font_size']); ?>px;
}
    <?php endif; ?>
@media(min-width: 992px) {
    <?php if ($styles['anps_top_bar_height']) : ?>
    .top-bar,
    .top-bar > .container {
        height: <?php echo esc_attr($styles['anps_top_bar_height']); ?>px;
    }
    <?php endif; if (!get_option('anps_menu_dividers', '1')) : ?>
    .site-header:not(.site-header-vertical-menu) .site-navigation > ul > li:after { display: none; }
    <?php endif; ?>
}

    <?php
    $anps_main_menu_height = get_option('anps_main_menu_height', '');
    $anps_above_menu_height = get_option('anps_above_menu_height', '');

    if ($anps_main_menu_height) : ?>
@media(min-width: 992px) {
    .transparent.top-bar + .site-header-style-transparent:not(.site-header-sticky-active) .nav-wrap {
        height: <?php echo esc_attr($anps_main_menu_height); ?>px;
        max-height: <?php echo esc_attr($anps_main_menu_height); ?>px;
    }
    .site-header-style-normal:not(.site-header-sticky-active) .nav-wrap,
    .site-header-style-transparent:not(.site-header-sticky-active) .nav-wrap {
        height: <?php echo esc_attr($anps_main_menu_height); ?>px;
        max-height: <?php echo esc_attr($anps_main_menu_height); ?>px;
        transition: height .3s ease-out;
    }
    .site-header-style-full-width .nav-bar-wrapper,
    .site-header-style-boxed .nav-bar,
    .site-header-style-full-width .cartwrap {
        height: <?php echo esc_attr($anps_main_menu_height); ?>px;
    }
    .site-header-style-full-width .menu-item-depth-0 > a,
    .site-header-style-boxed .menu-item-depth-0 > a,
    .site-header-style-full-width .site-search-toggle button,
    .site-header-style-boxed .site-search-toggle button,
    .site-header-style-full-width .cart-contents,
    .site-header-style-boxed .menu-button {
        line-height: <?php echo esc_attr($anps_main_menu_height); ?>px;
    }
    .site-header-style-boxed .site-logo,
    .site-header-style-boxed .large-above-menu {
        padding-bottom: <?php echo intval($anps_main_menu_height) / 2; ?>px;
    }
        <?php if ($anps_above_menu_height) : ?>
    .site-header-style-full-width .preheader-wrap, .site-header-style-boxed .preheader-wrap {
        height: <?php echo esc_attr($anps_above_menu_height); ?>px;
    }
    .site-header-style-full-width .site-logo:after, .site-header-style-boxed .site-logo:after {
        border-top: <?php echo esc_attr($anps_above_menu_height); ?>px solid currentColor;
    }
        <?php endif; ?>
}
    <?php endif; ?>

    <?php if ($styles['anps_logo_bg_color'] && get_option('anps_logo_background') == '1') : ?>
@media(min-width: 992px) {
    .site-header .site-logo {
        color: <?php echo esc_attr($styles['anps_logo_bg_color']); ?>
    }
}
    <?php endif;?>

    <?php if ($styles['anps_submenu_divider_color']) : ?>
@media (min-width: 992px) {
    .site-header-dropdown-2 .sub-menu .menu-item + .menu-item > a::before,
    .site-header-dropdown-3 .sub-menu .menu-item + .menu-item > a::before {
        background-color: <?php echo esc_attr($styles['anps_submenu_divider_color']); ?>;
    }
}
    <?php endif; if ($styles['footer_bg_color']) : ?>
.site-footer {
    background: <?php echo esc_attr($styles['footer_bg_color']); ?>;
}
    <?php endif;?>
.site-footer .copyright-footer {
    <?php if ($styles['copyright_footer_text_color']) : ?>
    color: <?php echo esc_attr($styles['copyright_footer_text_color']); ?>;
    <?php endif; if ($styles['copyright_footer_bg_color']) : ?>
    background: <?php echo esc_attr($styles['copyright_footer_bg_color']); ?>;
    <?php endif;?>
}
    <?php if ($styles['footer_divider_color']) : ?>
footer.site-footer .copyright-footer > .container:before,
.site-footer.style-4 .working-hours td::after, .site-footer.style-4 .working-hours th::after {
    background: <?php echo esc_attr($styles['footer_divider_color']); ?>;
}
.site-footer.style-4 .tagcloud a,
.site-footer.style-4 .menu-item {
    border-color: <?php echo esc_attr($styles['footer_divider_color']); ?>;
}
    <?php endif; if ($styles['footer_text_color']) : ?>
.site-footer, .site-footer h3, .site-footer h4, .site-wrap .site-footer .recentcomments a,
.site-wrap .site-footer caption, .site-wrap .site-footer th, .site-wrap .site-footer span, .site-wrap .site-footer cite,
.site-wrap .site-footer strong, .site-wrap .site-footer #today {
    color: <?php echo esc_attr($styles['footer_text_color']); ?> !important;
}
    <?php endif; if ($styles['footer_selected_color']) : ?>
.site-footer .row .menu .current_page_item > a,
.site-footer.style-4 .working-hours td {
    color: <?php echo esc_attr($styles['footer_selected_color']); ?>;
}
    <?php endif; if ($styles['footer_hover_color']) : ?>
.site-footer .row a:hover,
.site-footer .row a:focus,
.site-footer.style-4 .menu-item a::before,
.site-footer.style-4 .social a,
.site-footer.style-4 .socialize a {
    color: <?php echo esc_attr($styles['footer_hover_color']); ?> !important;
}
.site-footer.style-4 .widget-title::after {
    background-color: <?php echo esc_attr($styles['footer_hover_color']); ?>;
}
.site-footer.style-4 .tagcloud a:hover,
.site-footer.style-4 .tagcloud a:focus {
    border-color: <?php echo esc_attr($styles['footer_hover_color']); ?>;
}
    <?php endif; if ($styles['anps_heading_text_color']) : ?>
.site-footer .row .widget-title {
    color: <?php echo esc_attr($styles['anps_heading_text_color']); ?>
}
    <?php endif; if ($styles['primary_color']) : ?>
a,
.btn-link,
.icon.style-2 .fa,
.error-404 h2,
.page-heading,
.statement .style-3,
.dropcaps.style-2:first-letter,
.list li:before,
ol.list,
.post.style-2 header > span,
.post.style-2 header .fa,
.page-numbers span,
.nav-links span,
.team .socialize a,
blockquote.style-2:before,
.panel-group.style-2 .panel-title a:before,
.contact-info .fa,
blockquote.style-1:before,
.comment-list .comment header h1,
.faq .panel-title a.collapsed:before,
.faq .panel-title a:after,
.faq .panel-title a,
.filter button.selected,
.filter:before,
.primary,
.search-posts i,
.counter .counter-number,
#wp-calendar th,
#wp-calendar caption,
.testimonials blockquote p:before,
.testimonials blockquote p:after,
.heading-left span:before,
.heading-middle span:before,
.price,
.widget-price,
.star-rating,
section.container .widget_shopping_cart .quantity,
.tab-pane .commentlist .meta strong, .woocommerce-tabs .commentlist .meta strong,
.widget_recent_comments .recentcomments a {
    color: <?php echo esc_attr($styles['primary_color']); ?>;
}
.testimonials.white blockquote p:before,
.testimonials.white blockquote p:after {
    color: #fff;
}
.counter .wrapbox {
    border-color:<?php echo esc_attr($styles['primary_color']); ?>;
}
body .tp-bullets.simplebullets.round .bullet.selected {
    border-color: <?php echo esc_attr($styles['primary_color']); ?>;
}
.carousel-indicators li.active,
.ls-michell .ls-bottom-slidebuttons a.ls-nav-active {
    border-color: <?php echo esc_attr($styles['primary_color']); ?> !important;
}
.icon .fa,
.posts div a,
.progress-bar,
.nav-tabs > li.active:after,
.vc_tta-style-anps_tabs .vc_tta-tabs-list > li.vc_active:after,
section.container .menu li.current-menu-item .sub-menu a,
section.container .menu li.current-menu-ancestor .sub-menu a,
.pricing-table header,
.mark,
.post .post-meta button,
blockquote.style-2:after,
.panel-style-1 .panel-title a:before,
.carousel-indicators li,
.carousel-indicators .active,
.ls-michell .ls-bottom-slidebuttons a,
.twitter .carousel-indicators li,
.twitter .carousel-indicators li.active,
#wp-calendar td a,
body .tp-bullets.simplebullets.round .bullet,
.site-search,
.onsale,
.plus, .minus,
.widget_price_filter .ui-slider .ui-slider-range,
.mini-cart-wrap .cart-contents > span,
.form-submit #submit,
.testimonials blockquote header:before,
div.woocommerce-tabs ul.tabs li.active:before ,
mark,
.woocommerce-product-gallery__trigger {
    background-color: <?php echo esc_attr($styles['primary_color']); ?>;
}
.testimonials.white blockquote header:before {
    background-color: #fff;
}
    <?php endif; if ($styles['headings_color']) : ?>
h1, h2, h3, h4, h5, h6,
.nav-tabs > li > a,
.nav-tabs > li.active > a,
.vc_tta-tabs-list > li > a span,
.statement,
.page-heading a,
.page-heading a:after,
p strong,
.dropcaps:first-letter,
.page-numbers a,
.nav-links a,
.searchform,
.searchform input[type="text"],
.socialize a,
.widget_rss .rss-date,
.widget_rss cite,
.panel-title,
.panel-group.style-2 .panel-title a.collapsed:before,
blockquote.style-1,
.comment-list .comment header,
.faq .panel-title a:before,
.faq .panel-title a.collapsed,
.filter button,
.carousel .carousel-control,
#wp-calendar #today,
.woocommerce-result-count,
input.qty,
.product_meta,
.woocommerce-review-link,
.woocommerce-before-loop .woocommerce-ordering:after,
.widget_price_filter .price_slider_amount .button,
.widget_price_filter .price_label,
section.container .product_list_widget li h4 a,
.shop_table.table thead th,
.shop_table.table tfoot,
.product-single-header .variations label,
.tab-pane .commentlist .meta, .woocommerce-tabs .commentlist .meta,
.f-content__title,
.icon-m__title,
table.table > thead th,
.recent-portfolio__title,
a:hover .recent-portfolio__title,
a:focus .recent-portfolio__title,
.portfolio-modern__title,
a:hover .portfolio-modern__title,
a:focus .portfolio-modern__title {
    color: <?php echo esc_attr($styles['headings_color']); ?>;
}
.ls-michell .ls-nav-next,
.ls-michell .ls-nav-prev {
    color:#fff;
}
.contact-form input[type="text"]:focus,
.contact-form textarea:focus {
    border-color: <?php echo esc_attr($styles['headings_color']); ?> !important;
}
.pricing-table header h2,
.mark.style-2,
.btn.dark,
.twitter .carousel-indicators li,
.added_to_cart {
    background-color: <?php echo esc_attr($styles['headings_color']); ?>;
}
.price_slider_wrapper .ui-widget-content {
    background-color: #ececec;
}
    <?php endif; if ($styles['font_2']) : ?>
body,
.alert .close,
.post header,
#lang_sel_list a.lang_sel_sel, #lang_sel_list ul a, #lang_sel_list_list ul a:visited,
.widget_icl_lang_sel_widget #lang_sel ul li ul li a, .widget_icl_lang_sel_widget #lang_sel a,
.heading-subtitle {
    font-family: <?php echo esc_attr($styles['font_2']); ?>;
        <?php if ($styles['font_2'] === 'Montserrat') :
            ?>font-weight: 500;<?php
        endif; ?>
}
    <?php endif; if ($styles['logo_font']) : ?>
.site-logo { font-family: <?php echo esc_attr($styles['logo_font']); ?>; }
    <?php endif; if ($styles['font_1']) : ?>
h1, h2, h3, h4, h5, h6,
.btn,
.woocommerce-page .button,
.page-heading,
.team em,
blockquote.style-1,
.onsale,
.added_to_cart,
.price,
.widget-price,
.woocommerce-review-link,
.product_meta,
.tab-pane .commentlist .meta, .woocommerce-tabs .commentlist .meta,
.wpcf7-submit,
.f-content__title,
.icon-m__title,
.icon-m__link,
button.single_add_to_cart_button,
.important,
.shipping-calculator-button,
.pricing-table header h2,
.pricing-table header .price,
.pricing-table header .currency,
.table thead,
h1.style-3,
h2.style-3,
h3.style-3,
h4.style-3,
h5.style-3,
h6.style-3,
.page-numbers a,
.page-numbers span,
.nav-links a,
.nav-links span,
.alert,
.comment-list .comment header,
.woocommerce-result-count,
.product_list_widget li > a,
.product_list_widget li p.total strong,
.cart_list + .total,
.shop_table.table tfoot,
.product-single-header .variations label,
.site-search #searchform-header input[type="text"] {
    font-family: <?php echo esc_attr($styles['font_1']); ?>;
        <?php if ($styles['font_1'] === 'Montserrat') :
            ?>font-weight: 500;<?php
        endif; ?>
}
    <?php endif; if ($styles['font_3']) : ?>
.nav-tabs > li > a,
.site-navigation > ul a,
.menu-button,
.vc_tta-tabs-list > li > a,
.tp-arr-titleholder,
.above-nav-bar.top-bar ul li {
    font-family: <?php echo esc_attr($styles['font_3']); ?>;
        <?php if ($styles['font_3'] === 'Montserrat') :
            ?>font-weight: 500;<?php
        endif; ?>
}
    <?php endif; if ($styles['hovers_color']) : ?>
.testimonials.carousel .white ~ .carousel-control:hover,
.testimonials.carousel .white ~ .carousel-control:focus {
    color: <?php echo esc_attr($styles['hovers_color']); ?> !important;
}
    <?php endif; if ($styles['primary_color']) : ?>
.testimonials blockquote p {
    border-bottom: 1px solid <?php echo esc_attr($styles['primary_color']); ?>;
}
    <?php endif; ?>
.testimonials.white blockquote p {
    border-bottom: 1px solid #fff;
}
    <?php if ($styles['primary_color']) : ?>
div.testimonials blockquote.item.active p,
.testimonials blockquote cite {
    color: <?php echo esc_attr($styles['primary_color']); ?>;
}
    <?php endif; ?>
div.testimonials.white blockquote.item.active p,
div.testimonials.white blockquote.item.active cite a,
div.testimonials.white blockquote.item.active cite, .wpb_content_element .widget .tagcloud a,
div.testimonials.white blockquote.item p,
div.testimonials.white blockquote.item cite,
.testimonials.carousel .white ~ .carousel-control {
    color: #fff;
}
    <?php if ($styles['hovers_color']) : ?>
a:hover, a:focus,
.a:hover,
.site-header a:hover,
.icon a:hover h2,
.nav-tabs > li > a:hover,
.top-bar a:hover,
.page-heading a:hover,
.menu a:hover,
.menu .is-active a,
.page-numbers a:hover,
.nav-links a:hover,
.widget-categories a:hover,
.product-categories a:hover,
.widget_archive a:hover,
.widget_categories a:hover,
.widget_recent_entries a:hover,
.socialize a:hover,
.faq .panel-title a.collapsed:hover,
.carousel .carousel-control:hover,
a:hover h1, a:hover h2, a:hover h3, a:hover h4, a:hover h5,
.ls-michell .ls-nav-next:hover,
.ls-michell .ls-nav-prev:hover,
body .tp-leftarrow.default:hover,
body .tp-rightarrow.default:hover,
.product_list_widget li h4 a:hover,
.cart-contents:hover i,
.icon.style-2 a:hover .fa,
.team .socialize a:hover,
.recentblog header a:hover h2,
.scrollup a:hover,
.hovercolor, i.hovercolor, .post.style-2 header i.hovercolor.fa,
article.post-sticky header:before,
.wpb_content_element .widget a:hover,
.star-rating,
.menu .current_page_item > a,
.vc_tta-tab:hover > a > span,
.page-numbers.current,
.widget_layered_nav a:hover,
.widget_layered_nav a:focus,
.widget_layered_nav .chosen a,
.widget_layered_nav_filters a:hover,
.widget_layered_nav_filters a:focus,
.widget_rating_filter .star-rating:hover,
.widget_rating_filter .star-rating:focus,
.icon-m__link,
.bg-primary,
.logos .owl-nav > *:hover,
.logos .owl-nav > *:focus,
.testimonials-modern .owl-nav > *:hover,
.testimonials-modern .owl-nav > *:focus,
.rp-modern__icon {
    color: <?php echo esc_attr($styles['hovers_color']); ?>;
}

.filter button.selected {
    color: <?php echo esc_attr($styles['hovers_color']); ?>!important;
}

.logos--style-3 .logos__wrap:hover,
.logos--style-3 .logos__wrap:focus,
.logos--style-5 .logos__wrap:hover,
.logos--style-5 .logos__wrap:focus,
.scrollup a:hover,
.panel-style-3 .panel-heading a,
.gallery-fs .owl-item a:hover:after, .gallery-fs .owl-item a:focus:after, .gallery-fs .owl-item a.selected:after, blockquote:not([class]) p, .blockquote-style-1 p, .blockquote-style-2 p, .featured-content, .post-minimal-wrap {
    border-color: <?php echo esc_attr($styles['hovers_color']); ?>;
}

.site-footer:not(.style-4) .tagcloud a:hover,
.twitter .carousel-indicators li:hover,
.added_to_cart:hover,
.icon a:hover .fa,
.posts div a:hover,
#wp-calendar td a:hover,
.plus:hover, .minus:hover,
.widget_price_filter .price_slider_amount .button:hover,
.form-submit #submit:hover,
.anps_download > a span.anps_download_icon,
.onsale,
.mini-cart-wrap .cart-contents > span,
.woocommerce-product-gallery__trigger:hover,
.woocommerce-product-gallery__trigger:focus,
.f-content__icon,
.f-content__divider,
.icon-m__media,
.panel-style-3 .panel-heading a,
.logos .owl-dot:hover,
.logos .owl-dot:focus,
.logos .owl-dot.active,
.testimonials-modern .owl-dot:hover,
.testimonials-modern .owl-dot:focus,
.testimonials-modern .owl-dot.active,
.large-above-menu-style-5 .widget_anpstext .fa,
.large-above-menu-style-5 .widget_anpssocial ul,
.menu-button {
    background-color: <?php echo esc_attr($styles['hovers_color']); ?>;
}
.comment-list .bypostauthor .author {
    color: <?php echo esc_attr($styles['hovers_color']); ?>;
}
    <?php endif; if ($styles['body_font_size']) : ?>
body { font-size: <?php echo esc_attr($styles['body_font_size']); ?>px; }
    <?php endif; if ($styles['h1_font_size']) : ?>
h1, .h1 { font-size: <?php echo esc_attr($styles['h1_font_size']); ?>px; }
    <?php endif; if ($styles['h2_font_size']) : ?>
h2, .h2 { font-size: <?php echo esc_attr($styles['h2_font_size']); ?>px; }
    <?php endif; if ($styles['h3_font_size']) : ?>
h3, .h3 { font-size: <?php echo esc_attr($styles['h3_font_size']); ?>px; }
    <?php endif; if ($styles['h4_font_size']) : ?>
h4, .h4 {font-size: <?php echo esc_attr($styles['h4_font_size']); ?>px; }
    <?php endif; if ($styles['h5_font_size']) : ?>
h5, .h5 { font-size: <?php echo esc_attr($styles['h5_font_size']); ?>px; }
    <?php endif; if ($styles['menu_font_size']) : ?>
.site-navigation,
.site-navigation ul li a {
    font-size: <?php echo esc_attr($styles['menu_font_size']); ?>px;
}
    <?php endif; if ($styles['hovers_color']) : ?>
@media (min-width: 992px) {
    .site-header-dropdown-3 .site-navigation > ul > .menu-item:not(.megamenu) .sub-menu a:hover,
    .site-header-dropdown-3 .site-navigation > ul > .menu-item:not(.megamenu) .sub-menu a:focus {
        background-color: <?php echo esc_attr($styles['hovers_color']); ?>;
    }
}
    <?php endif; if ($styles['submenu_font_size']) : ?>
@media (min-width: 1200px) {
    .site-navigation .sub-menu a,
    .site-navigation .main-menu .megamenu {
        font-size: <?php echo esc_attr($styles['submenu_font_size']); ?>px;
    }
}
    <?php endif; if ($styles['page_heading_h1_font_size']) : ?>
.page-heading h1 {
    font-size: <?php echo esc_attr($styles['page_heading_h1_font_size']); ?>px;
    line-height: 34px;
}
    <?php endif; if ($styles['anps_portfolio_title_font_size']) : ?>
.recent-portfolio__title,
.recentportfolio h2,
.portfolio h2,
.portfolio-modern__title {
    font-size: <?php echo esc_attr($styles['anps_portfolio_title_font_size']); ?>px;
}
    <?php endif; if ($styles['nav_background_color']) : ?>
article.post-sticky header .stickymark i.nav_background_color {
    color: <?php echo esc_attr($styles['nav_background_color']); ?>;
}
    <?php endif; if ($styles['hovers_color']) : ?>
.triangle-topleft.hovercolor {
    border-top: 60px solid <?php echo esc_attr($styles['hovers_color']); ?>;
}
    <?php endif; if ($styles['blog_heading_h1_font_size']) : ?>
h1.single-blog, article.post h1.single-blog {
    font-size: <?php echo esc_attr($styles['blog_heading_h1_font_size']); ?>px;
}
    <?php endif; if ($styles['anps_front_topbar_color']) : ?>
.home .site-header .above-nav-bar.top-bar,
.home div.site-wrapper div.transparent.top-bar, .home div.site-wrapper div.transparent.top-bar #lang_sel a.lang_sel_sel {
    color: <?php echo esc_attr($styles['anps_front_topbar_color']); ?>;
}
    <?php endif; if ($styles['anps_front_topbar_hover_color']) : ?>
.home div.site-wrapper div.transparent.top-bar a:hover, .home div.site-wrapper div.transparent.top-bar #lang_sel a.lang_sel_sel:hover {
    color: <?php echo esc_attr($styles['anps_front_topbar_hover_color']); ?>;
}
    <?php endif; if ($styles['side_submenu_background_color'] && $styles['side_submenu_text_color']) : ?>
section.container .menu li.current-menu-item .sub-menu a,
section.container .menu li.current-menu-ancestor .sub-menu a {
    background: <?php echo esc_attr($styles['side_submenu_background_color']); ?>;
    color: <?php echo esc_attr($styles['side_submenu_text_color']); ?>;
}
    <?php endif; if ($styles['side_submenu_text_hover_color']) : ?>
section.container ul.menu ul.sub-menu > li > a:hover,
section.container ul.menu li.current_page_item > a,
section.container ul.menu ul.sub-menu > li.current_page_item > a {
    color: <?php echo esc_attr($styles['side_submenu_text_hover_color']); ?>;
}
    <?php endif; ?>
    <?php
    global $anps_options_data;
    if (isset($anps_options_data['hide_slider_on_mobile']) && $anps_options_data['hide_slider_on_mobile'] === 'on') : ?>
@media (max-width: 786px) {
    .wpb_layerslider_element, .wpb_revslider_element {
        display: none;
    }
}
    <?php endif; if (get_option('search_icon', '1') != '1') : ?>
.site-navigation .fa-search, .fa-search.desktop, body.vertical-menu header.site-header.vertical-menu .fa-search.desktop  { display:none; }
.responsive .site-navigation > ul > li:last-child:after { border-right: none!important; }
    <?php endif; if (get_option('search_icon_mobile', '1') != '1') : ?>
.nav-wrap > .container > button.fa-search.mobile { display:none!important; }
    <?php endif; ?>

@media (min-width: 993px) {
    <?php if ($styles['submenu_background_color']) : ?>
    .responsive .site-navigation .sub-menu {
        background:<?php echo esc_attr($styles['submenu_background_color']); ?>;
    }
    <?php endif; if ($styles['submenu_text_color']) : ?>
    .responsive .site-navigation .sub-menu a {
        color: <?php echo esc_attr($styles['submenu_text_color']); ?>;
    }
    <?php endif; ?>
}

    <?php
    global $anps_media_data;
    if (isset($anps_media_data['auto_adjust_logo']) && $anps_media_data['auto_adjust_logo'] == 'on') : ?>
@media (max-width: 400px) {
    .nav-wrap .site-logo a img {
        height: 60px!important;
        width: auto;
        max-width: 175px;
    }
}
    <?php endif;

    echo get_option('anps_custom_css', '');

// Done. Collect buffer, clean it up, cache and output
    $css_buffer = ob_get_clean();
    $css = trim(preg_replace('/\s+/', ' ', $css_buffer));

    set_transient('anps_theme_options_styles_css', $css);

    return $css;
}

function anps_get_custom_styles_buttons()
{
    // Try to get from cache
    $styles = get_transient('anps_theme_options_buttons');
    if ($styles !== false) {
        return $styles;
    }

    $styles = array();

    $styles['default_button_bg'] = get_option('anps_default_button_bg', '#292929');
    $styles['default_button_color'] = get_option('anps_default_button_color', '#fff');
    $styles['default_button_hover_bg'] = get_option('anps_default_button_hover_bg', '#d54900');
    $styles['default_button_hover_color'] = get_option('anps_default_button_hover_color', '#fff');

    $styles['style_1_button_bg'] = get_option('anps_style_1_button_bg', '#292929');
    $styles['style_1_button_color'] = get_option('anps_style_1_button_color', '#fff');
    $styles['style_1_button_hover_bg'] = get_option('anps_style_1_button_hover_bg', '#d54900');
    $styles['style_1_button_hover_color'] = get_option('anps_style_1_button_hover_color', '#fff');


    $styles['style_slider_button_bg'] = get_option('anps_style_slider_button_bg', '#292929');
    $styles['style_slider_button_color'] = get_option('anps_style_slider_button_color', '#fff');
    $styles['style_slider_button_hover_bg'] = get_option('anps_style_slider_button_hover_bg', '#d54900');
    $styles['style_slider_button_hover_color'] = get_option('anps_style_slider_button_hover_color', '#fff');

    $styles['style_2_button_bg'] = get_option('anps_style_2_button_bg', '#292929');
    $styles['style_2_button_color'] = get_option('anps_style_2_button_color', '#fff');
    $styles['style_2_button_hover_bg'] = get_option('anps_style_2_button_hover_bg', '#d54900');
    $styles['style_2_button_hover_color'] = get_option('anps_style_2_button_hover_color', '#fff');

    $styles['style_3_button_color'] = get_option('anps_style_3_button_color', '#000');
    $styles['style_3_button_hover_bg'] = get_option('anps_style_3_button_hover_bg', '#fafafa');
    $styles['style_3_button_hover_color'] = get_option('anps_style_3_button_hover_color', '#000');
    $styles['style_3_button_border_color'] = get_option('anps_style_3_button_border_color', '#000');

    $styles['style_4_button_color'] = get_option('anps_style_4_button_color', '#d54900');
    $styles['style_4_button_hover_color'] = get_option('anps_style_4_button_hover_color', '#000');

    $styles['style_5_button_bg'] = get_option('anps_style_5_button_bg', '#c3c3c3');
    $styles['style_5_button_color'] = get_option('anps_style_5_button_color', '#fff');
    $styles['style_5_button_hover_bg'] = get_option('anps_style_5_button_hover_bg', '#737373');
    $styles['style_5_button_hover_color'] = get_option('anps_style_5_button_hover_color', '#fff');

    // Cache the values
    set_transient('anps_theme_options_buttons', $styles);
    return $styles;
}

function anps_custom_styles_buttons()
{
    // Try cache because compiling and formatting this css string is expensive
    $css = get_transient('anps_theme_options_buttons_css');
    if ($css !== false && !empty($css)) {
        return $css;
    }

    // Collect all CSS into a variable so we can cache it
    $styles = anps_get_custom_styles_buttons();
    ob_start();

    if ($styles['default_button_bg']) : ?>
input#place_order {
    background-color: <?php echo esc_attr($styles['default_button_bg']); ?>;
}
    <?php endif; if ($styles['default_button_hover_bg']) : ?>
input#place_order:hover,
input#place_order:focus {
    background-color: <?php echo esc_attr($styles['default_button_hover_bg']); ?>;
}
.btn, .wpcf7-submit, button.single_add_to_cart_button,
p.form-row input.button, .woocommerce-page .button {
    user-select: none;
    background-image: none;
    border: 0;
    color: #fff;
    cursor: pointer;
    display: inline-block;
    line-height: 1.5;
    margin-bottom: 0;
    max-width: 100%;
    text-align: center;
    text-transform: uppercase;
    text-decoration: none;
    transition: background-color 0.2s ease 0s;
    text-overflow: ellipsis;
    vertical-align: middle;
    overflow: hidden;
    white-space: nowrap;
}
.btn.btn-sm, .wpcf7-submit {
    padding: 11px 17px;
    font-size: 14px;
}
    <?php endif; ?>
.btn, .wpcf7-submit, button.single_add_to_cart_button,
p.form-row input.button, .woocommerce-page .button {
    border-radius: 4px;
    <?php if ($styles['default_button_bg']) : ?>
    background-color: <?php echo esc_attr($styles['default_button_bg']); ?>;
    <?php endif; if ($styles['default_button_color']) : ?>
    color: <?php echo esc_attr($styles['default_button_color']); ?>;
    <?php endif; ?>
}

.btn:hover, .btn:active, .btn:focus, .wpcf7-submit:hover, .wpcf7-submit:active, .wpcf7-submit:focus, button.single_add_to_cart_button:hover, button.single_add_to_cart_button:active, button.single_add_to_cart_button:focus,
p.form-row input.button:hover, p.form-row input.button:focus, .woocommerce-page .button:hover, .woocommerce-page .button:focus {
    <?php if ($styles['default_button_hover_bg']) : ?>
    background-color: <?php echo esc_attr($styles['default_button_hover_bg']); ?>;
    <?php endif; if ($styles['default_button_hover_color']) : ?>
    color: <?php echo esc_attr($styles['default_button_hover_color']); ?>;
    <?php endif; ?>
    border:0;
}

.btn.style-1, .vc_btn.style-1 {
    border-radius: 4px;
    <?php if ($styles['default_button_hover_bg']) : ?>
    background-color: <?php echo esc_attr($styles['style_1_button_bg']); ?>;
    color: <?php echo esc_attr($styles['style_1_button_color']); ?>!important;
    <?php endif; ?>
}

.btn.style-1:hover, .btn.style-1:active, .btn.style-1:focus, .vc_btn.style-1:hover, .vc_btn.style-1:active, .vc_btn.style-1:focus  {
    <?php if ($styles['style_1_button_hover_bg']) : ?>
    background-color: <?php echo esc_attr($styles['style_1_button_hover_bg']); ?>;
    <?php endif; if ($styles['style_1_button_hover_color']) : ?>
    color: <?php echo esc_attr($styles['style_1_button_hover_color']); ?>!important;
    <?php endif; ?>
}

.btn.slider  {
    border-radius: 4px;
    <?php if ($styles['style_slider_button_bg']) : ?>
    background-color: <?php echo esc_attr($styles['style_slider_button_bg']); ?>;
    <?php endif; if ($styles['style_slider_button_color']) : ?>
    color: <?php echo esc_attr($styles['style_slider_button_color']); ?>;
    <?php endif; ?>
}
.btn.slider:hover, .btn.slider:active, .btn.slider:focus  {
    <?php if ($styles['style_slider_button_hover_bg']) : ?>
    background-color: <?php echo esc_attr($styles['style_slider_button_hover_bg']); ?>;
    <?php endif; if ($styles['style_slider_button_hover_color']) : ?>
    color: <?php echo esc_attr($styles['style_slider_button_hover_color']); ?>;
    <?php endif; ?>
}

.btn.style-2, .vc_btn.style-2  {
    border-radius: 4px;
    <?php if ($styles['style_2_button_bg']) : ?>
    border: 2px solid <?php echo esc_attr($styles['style_2_button_bg']); ?>;
    background-color: <?php echo esc_attr($styles['style_2_button_bg']); ?>;
    <?php endif; if ($styles['style_2_button_color']) : ?>
    color: <?php echo esc_attr($styles['style_2_button_color']); ?>!important;
    <?php endif; ?>
}

.btn.style-2:hover, .btn.style-2:active, .btn.style-2:focus, .vc_btn.style-2:hover, .vc_btn.style-2:active, .vc_btn.style-2:focus   {
    <?php if ($styles['style_2_button_hover_bg']) : ?>
    background-color: <?php echo esc_attr($styles['style_2_button_hover_bg']); ?>;
    <?php endif; if ($styles['style_2_button_hover_color']) : ?>
    color: <?php echo esc_attr($styles['style_2_button_hover_color']); ?>!important;
    <?php endif; if ($styles['style_2_button_bg']) : ?>
    border-color: <?php echo esc_attr($styles['style_2_button_bg']); ?>;
    border: 2px solid <?php echo esc_attr($styles['style_2_button_bg']); ?>;
    <?php endif; ?>
}

.btn.style-3, .vc_btn.style-3 {
    <?php if ($styles['style_3_button_border_color']) : ?>
    border: 2px solid <?php echo esc_attr($styles['style_3_button_border_color']); ?>;
    <?php endif; ?>
    border-radius: 4px;
    background-color: transparent;
    <?php if ($styles['style_3_button_color']) : ?>
    color: <?php echo esc_attr($styles['style_3_button_color']); ?>!important;
    <?php endif; ?>
}
.btn.style-3:hover, .btn.style-3:active, .btn.style-3:focus, .vc_btn.style-3:hover, .vc_btn.style-3:active, .vc_btn.style-3:focus  {
    <?php if ($styles['style_3_button_border_color']) : ?>
    border: 2px solid <?php echo esc_attr($styles['style_3_button_border_color']); ?>;
    <?php endif; if ($styles['style_3_button_hover_bg']) : ?>
    background-color: <?php echo esc_attr($styles['style_3_button_hover_bg']); ?>;
    <?php endif; if ($styles['style_3_button_hover_color']) : ?>
    color: <?php echo esc_attr($styles['style_3_button_hover_color']); ?>!important;
    <?php endif; ?>
}
    <?php if ($styles['style_4_button_color']) : ?>
.btn.style-4, .vc_btn.style-4   {
    padding-left: 0 !important;
    background-color: transparent;
    color: <?php echo esc_attr($styles['style_4_button_color']); ?>!important;
    border: none;
}
    <?php endif; if ($styles['style_4_button_hover_color']) : ?>
.btn.style-4:hover, .btn.style-4:active, .btn.style-4:focus, .vc_btn.style-4:hover, .vc_btn.style-4:active, .vc_btn.style-4:focus   {
    background: none;
    color: <?php echo esc_attr($styles['style_4_button_hover_color']); ?>!important;
    border: none;
    border-color: transparent;
    outline: none;
}
    <?php endif; ?>
.btn.style-5, .vc_btn.style-5 {
    <?php if ($styles['style_5_button_bg']) : ?>
    background-color: <?php echo esc_attr($styles['style_5_button_bg']); ?>!important;
    <?php endif; if ($styles['style_5_button_color']) : ?>
    color: <?php echo esc_attr($styles['style_5_button_color']); ?>!important;
    <?php endif; ?>
    border: none;
}

.btn.style-5:hover, .btn.style-5:active, .btn.style-5:focus, .vc_btn.style-5:hover, .vc_btn.style-5:active, .vc_btn.style-5:focus   {
    <?php if ($styles['style_5_button_hover_bg']) : ?>
    background-color: <?php echo esc_attr($styles['style_5_button_hover_bg']); ?>!important;
    <?php endif; if ($styles['style_5_button_hover_color']) : ?>
    color: <?php echo esc_attr($styles['style_5_button_hover_color']); ?>!important;
    <?php endif; ?>
}

.post-page-numbers {
    <?php if ($styles['style_1_button_color']) : ?>
    color: <?php echo esc_attr($styles['style_1_button_color']); ?>;
    <?php endif; if ($styles['style_1_button_bg']) : ?>
    background: <?php echo esc_attr($styles['style_1_button_bg']); ?>;
    <?php endif; ?>
}
.post-page-numbers:hover,
.post-page-numbers:focus,
.post-page-numbers.current {
    <?php if ($styles['style_1_button_hover_color']) : ?>
    color: <?php echo esc_attr($styles['style_1_button_hover_color']); ?>;
    <?php endif; if ($styles['style_1_button_hover_bg']) : ?>
    background: <?php echo esc_attr($styles['style_1_button_hover_bg']); ?>;
    <?php endif; ?>
}
    <?php
    $css_buffer = ob_get_clean();
    $css = trim(preg_replace('/\s+/', ' ', $css_buffer));

    set_transient('anps_theme_options_buttons_css', $css);

    return $css;
}

function anps_custom_block_editor_styles()
{
    $styles = anps_get_custom_styles();
    ob_start();
    if ($styles['font_1_source'] === 'Custom fonts') {
        echo anps_custom_font($styles['font_1']);
    }
    if ($styles['font_2_source'] === 'Custom fonts') {
        echo anps_custom_font($styles['font_2']);
    }
    ?>
    <?php if ($styles['page_heading_h1_font_size']) : ?>
.post-type-page .editor-styles-wrapper .editor-post-title__input {
    font-size: <?php echo esc_attr($styles['page_heading_h1_font_size']); ?>px;
}
    <?php endif; if ($styles['blog_heading_h1_font_size']) : ?>
.post-type-post .editor-styles-wrapper .editor-post-title__input {
    font-size: <?php echo esc_attr($styles['blog_heading_h1_font_size']); ?>px;
}
    <?php endif; ?>
:root .editor-styles-wrapper {
    <?php if ($styles['text_color']) : ?>
    color: <?php echo esc_attr($styles['text_color']); ?> !important;
    <?php endif; if ($styles['body_font_size']) : ?>
    font-size: <?php echo esc_attr($styles['body_font_size']); ?>px !important;
    <?php endif; if ($styles['font_2']) : ?>
    font-family: <?php echo anps_wrap_font($styles['font_2']); ?> !important;
    <?php endif; ?>
}
    <?php if ($styles['h1_font_size']) : ?>
:root .editor-styles-wrapper h1.wp-block { font-size: <?php echo esc_attr($styles['h1_font_size']); ?>px; }
    <?php endif; if ($styles['h2_font_size']) : ?>
:root .editor-styles-wrapper h2.wp-block { font-size: <?php echo esc_attr($styles['h2_font_size']); ?>px; }
    <?php endif; if ($styles['h3_font_size']) : ?>
:root .editor-styles-wrapper h3.wp-block { font-size: <?php echo esc_attr($styles['h3_font_size']); ?>px; }
    <?php endif; if ($styles['h4_font_size']) : ?>
:root .editor-styles-wrapper h4.wp-block { font-size: <?php echo esc_attr($styles['h4_font_size']); ?>px; }
    <?php endif; if ($styles['blog_heading_h1_fh5_font_sizeont_size']) : ?>
:root .editor-styles-wrapper h5.wp-block { font-size: <?php echo esc_attr($styles['h5_font_size']); ?>px; }
    <?php endif; if ($styles['headings_color']) : ?>
:root .editor-styles-wrapper .editor-post-title__input,
:root .editor-styles-wrapper h1,
:root .editor-styles-wrapper h2,
:root .editor-styles-wrapper h3,
:root .editor-styles-wrapper h4,
:root .editor-styles-wrapper h5,
:root .editor-styles-wrapper h6,
:root .editor-styles-wrapper p strong { color: <?php echo esc_attr($styles['headings_color']); ?>; }
    <?php endif; if ($styles['font_1']) : ?>
:root .editor-styles-wrapper .editor-post-title__input,
:root .editor-styles-wrapper h1,
:root .editor-styles-wrapper h2,
:root .editor-styles-wrapper h3,
:root .editor-styles-wrapper h4,
:root .editor-styles-wrapper h5,
:root .editor-styles-wrapper h6 {
    font-family: <?php echo anps_wrap_font($styles['font_1']); ?>;
        <?php if ($styles['font_1'] === 'Montserrat') :
            ?>font-weight: 500;<?php
        endif; ?>
}
    <?php endif; if ($styles['primary_color']) : ?>
:root .editor-styles-wrapper a,
:root .editor-styles-wrapper b,
:root .editor-styles-wrapper .wp-block-file__textlink { color: <?php echo esc_attr($styles['primary_color']); ?>; }
:root .editor-styles-wrapper mark:not(.has-background) {
    color: #fff !important;
    background-color: <?php echo esc_attr($styles['primary_color']); ?> !important;
}
    <?php endif; if ($styles['hovers_color']) : ?>
:root .editor-styles-wrapper a:hover,
:root .editor-styles-wrapper .wp-block-file__textlink:hover { color: <?php echo esc_attr($styles['hovers_color']); ?>; }
    <?php endif;

    return ob_get_clean();
}

/** Build Google font URI */
function anps_get_google_fonts_uri($fonts_list = array())
{
    if (empty($fonts_list)) {
        return false;
    }
    $uri = 'https://fonts.googleapis.com/css2?display=swap';
    foreach ($fonts_list as $font) {
        $uri .= '&family=' . urlencode($font) . ':ital,wght@0,300;0,400;0,500;0,600;0,700;1,400';
    }
    return $uri;
}
