<?php
add_action('add_meta_boxes', 'anps_portfolio_content_add_custom_box');
add_action('save_post', 'anps_portfolio_content_save_postdata');
function anps_portfolio_content_add_custom_box() {
    $screens = array('portfolio');
    foreach ($screens as $screen) {
        add_meta_box('anps_portfolio_meta', __('Portfolio subtitle', 'constructo'), 'display_portfolio_meta_box_content', $screen, 'normal', 'high');
        add_meta_box('anps_hide_portfolio_meta', __('Hide portfolio image / video / gallery', 'constructo'), 'anps_hide_portolio', $screen, 'side', 'core');
    }
    $pages = array('portfolio', 'post');
    foreach($pages as $screen) {
        add_meta_box('anps_portfolio_side_meta', __('Breadcrumbs parent page', 'constructo'), 'display_portfolio_breadcrumbs_meta_box', $screen, 'side', 'core');
    }
}
function display_portfolio_meta_box_content( $post ) {
        $value2 = get_post_meta( $post -> ID, $key = 'anps_subtitle', $single = true );
        //$portfolio_shorttext = get_post_meta( $post -> ID, $key = 'anps_portfolio_shorttext', $single = true );
        //echo '<label for="anps_portfolio_shorttext">Portfolio Shorttext</label>';
        /*wp_editor($portfolio_shorttext, 'portfolio_single_footer', array(
                                                        'wpautop' => true,
                                                        'media_buttons' => false,
                                                        'textarea_name' => 'anps_portfolio_shorttext',
                                                        'textarea_rows' => 10,
                                                        'teeny' => true ));*/
	echo "<p>
                <label for='anps_subtitle'>Portfolio subtitle</label>
                <input type='text' name='anps_subtitle' value='$value2' style='width: 350px' />
               </p>";
}
function anps_hide_portolio($post) {
    $value2 = get_post_meta($post->ID, $key ='anps_hide_portfolio_img', $single = true );
    $checked = '';
    if($value2=='1') {
        $checked = 'checked';
    }
    echo "Hide <input type='checkbox' name='anps_hide_portfolio_img' value='1' $checked />";
}
function display_portfolio_breadcrumbs_meta_box($post) {
    $custom_breadcrumbs = get_post_meta( $post -> ID, $key = 'custom_breadcrumbs', $single = true );
    ?>
    <select name="custom_breadcrumbs">
            <option value="0">*** Select ***</option>
            <?php
                    $pages = get_pages();
                    foreach ($pages as $item) :
                            if ($custom_breadcrumbs == $item->ID) {
                                    $selected = 'selected="selected"';
                            }
                            else {
                                    $selected = '';
                            }
            ?>      <option value="<?php echo esc_attr($item->ID); ?>" <?php echo $selected; ?>><?php echo esc_html($item->post_title); ?></option>
            <?php endforeach; ?>
    </select>
<?php }
function anps_portfolio_content_save_postdata($post_id) {
    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return;
    if (empty($_POST)) return;

    $pid = isset($_POST['post_ID']) ? intval(sanitize_text_field($_POST['post_ID'])) : false;
    if (!$pid) {
        if (!$post_id) return;
        $pid = $post_id;
    }

    if (isset($_POST['post_type']) && 'portfolio' === $_POST['post_type']) {
        if (!current_user_can('edit_page', $pid)) return;
    }
    else {
        if (!current_user_can('edit_post', $pid)) return;
    }

    $anps_hide_portfolio_img = isset($_POST['anps_hide_portfolio_img']) ? sanitize_text_field($_POST['anps_hide_portfolio_img']) : '';
    $anps_subtitle = isset($_POST['anps_subtitle']) ? sanitize_text_field($_POST['anps_subtitle']) : '';
    $anps_portfolio_shorttext = isset($_POST['anps_portfolio_shorttext']) ? sanitize_text_field($_POST['anps_portfolio_shorttext']) : '';
    $custom_breadcrumbs = isset($_POST['custom_breadcrumbs']) ? sanitize_text_field($_POST['custom_breadcrumbs']) : '';

    if (!anps_is_demo_import()) {
        update_post_meta($pid, 'anps_hide_portfolio_img', $anps_hide_portfolio_img);
        update_post_meta($pid, 'anps_subtitle', $anps_subtitle);
        update_post_meta($pid, 'anps_portfolio_shorttext', $anps_portfolio_shorttext);
        update_post_meta($pid, 'custom_breadcrumbs', $custom_breadcrumbs);
    }
}
