<?php
add_action('add_meta_boxes', 'anps_team_content_add_custom_box');
add_action('save_post', 'anps_team_content_save_postdata');
function anps_team_content_add_custom_box() {
    $screens = array('team');
    foreach ($screens as $screen) {
        add_meta_box(
                'anps_breadcrumbs_sectionid', __('Team subtitle', 'constructo'), 'display_team_meta_box_content', $screen
        );
    }
}
function display_team_meta_box_content( $post ) {
        $value2 = get_post_meta( $post -> ID, $key = 'anps_team_subtitle', $single = true );
	echo "<input type='text' name='anps_team_subtitle' value='".esc_attr($value2)."' style='width: 350px' />";
}
function anps_team_content_save_postdata($post_id) {
    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return;
    if (empty($_POST)) return;

    $pid = isset($_POST['post_ID']) ? intval(sanitize_text_field($_POST['post_ID'])) : false;
    if (!$pid) {
        if (!$post_id) return;
        $pid = $post_id;
    }

    if (isset($_POST['post_type']) && 'team' === $_POST['post_type']) {
        if (!current_user_can('edit_page', $post_id)) return;
    }
    else {
        if (!current_user_can('edit_post', $post_id)) return;
    }

    $anps_team_subtitle = isset($_POST['anps_team_subtitle']) ? sanitize_text_field($_POST['anps_team_subtitle']) : '';

    if (!anps_is_demo_import()) update_post_meta($pid, 'anps_team_subtitle', $anps_team_subtitle);
}
