<?php
get_header();
while(have_posts()) :
    the_post();
    $meta = get_post_meta(get_the_ID());
    $sidebars = anps_parse_sidebars_from_meta($meta);

    $left_sidebar = $sidebars['left_sidebar'];
    $right_sidebar = $sidebars['right_sidebar'];
    $num_of_sidebars = $sidebars['num_of_sidebars'];
?>
    <section class="container portfolio-single">
        <div class="row">
            <?php if ($left_sidebar) anps_sidebar_html($left_sidebar); ?>
            <div class='col-md-<?php echo esc_attr(12 - $num_of_sidebars * 3); ?>'>
                <?php
                    global $row_inner, $num_of_sidebars;
                    $row_inner = true;
                    get_template_part( 'templates/portfolio', anps_get_option('', 'style-1', "portfolio_single"));
                ?>
            </div>
            <?php if ($right_sidebar) anps_sidebar_html($right_sidebar); ?>
        </div>
    </section>
<?php
endwhile;
$portfolio_footer = anps_get_option('', '', 'portfolio_single_footer');
if( $portfolio_footer != "" ): ?>
    <p>&nbsp;</p><p>&nbsp;</p>
<?php
endif;
echo do_shortcode(stripslashes($portfolio_footer));
get_footer();
