<?php
/*
Plugin Name: Anps Theme plugin
Plugin URI: https://anpsthemes.com
Description: Anps theme plugin
Author: AnpsThemes
Version: 1.1.4
Author URI: https://anpsthemes.com
*/

if(!defined('WPINC')) {
    die;
}


/*updates*/
require 'plugin-updates/plugin-update-checker.php';
$AnpsUpdateChecker = PucFactory::buildUpdateChecker(
    'https://anpsthemes.com/tf_pro_plugins/constructo/update.json',
    __FILE__
);

/* Widgets */
include_once plugin_dir_path( __FILE__ ) . '/widgets/widgets.php';

/**
 * Initialize plugin - Load all files on init hook
 */
function anps_theme_plugin_init() {
    // Load plugin textdomain first
    load_plugin_textdomain( 'anps_theme_plugin', false, dirname( plugin_basename( __FILE__ ) ) . '/languages/' );
    
    /* Portfolio and Team */
    require_once plugin_dir_path( __FILE__ ) . 'portfolio.php';
    require_once plugin_dir_path( __FILE__ ) . 'team.php';
    
	/* Shortcodes */
	include_once plugin_dir_path( __FILE__ ) . '/shortcodes.php';
    
	/* Meta includes */
	include_once plugin_dir_path( __FILE__ ) . '/meta/header_options_meta.php';
    include_once plugin_dir_path( __FILE__ ) . '/meta/team_meta.php';
    include_once plugin_dir_path( __FILE__ ) . '/meta/portfolio_meta.php';
    include_once plugin_dir_path( __FILE__ ) . '/meta/metaboxes.php';
    include_once plugin_dir_path( __FILE__ ) . '/meta/menu_meta.php';
    include_once plugin_dir_path( __FILE__ ) . '/meta/heading_meta.php';
    include_once plugin_dir_path( __FILE__ ) . '/meta/featured_video_meta.php';
    include_once plugin_dir_path( __FILE__ ) . '/meta/gallery_images.php';
    
    // Initialize Portfolio and Team post types
    if ( class_exists( 'Team' ) && class_exists( 'Portfolio' ) ) {
        new Team();
        new Portfolio();
    }
}
add_action( 'init', 'anps_theme_plugin_init', 1 );

/* Check if is demo import */
if (!function_exists('anps_is_demo_import')) {
    function anps_is_demo_import() {
        return isset($_POST['anps-demo-import']);
    }
}
