<?php
add_action('add_meta_boxes', 'anps_featured_video_add_custom_box');
add_action('save_post', 'anps_featured_video_save_postdata');

function anps_featured_video_add_custom_box() {
    $screens = array( 'post' );
    foreach($screens as $screen) {
        add_meta_box('anps_featured_video_meta', __('Featured video', 'anps_theme_plugin'), 'display_meta_box_featured_video', $screen, 'side');
    }
}

function display_meta_box_featured_video( $post ) {
    $value2 = get_post_meta($post->ID, $key ='anps_featured_video', $single = true );
    echo "<input type='text' name='anps_featured_video' value='".esc_attr($value2)."' style='width: 255px'/>";
}

function anps_featured_video_save_postdata($post_id) {
    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return;
    if (empty($_POST)) return;

    $pid = isset($_POST['post_ID']) ? intval(sanitize_text_field($_POST['post_ID'])) : false;
    if (!$pid) {
        if (!$post_id) return;
        $pid = $post_id;
    }

    $anps_featured_video = isset($_POST['anps_featured_video']) ? sanitize_text_field($_POST['anps_featured_video']) : '';

    if (!anps_is_demo_import()) update_post_meta($pid, 'anps_featured_video', $anps_featured_video);
}
