<?php
if (isset($_GET['save_css'])) {
    if (!current_user_can('administrator') || !check_admin_referer('anps_nonce', '_wpnonce')) return;
    update_option("anps_custom_css", stripcslashes($_POST['anps_custom_css']));
    delete_transient('anps_theme_options_styles_css');
    die("<script>(function(w){w.location.assign(w.location.pathname+'?page=theme_options&sub_page=theme_style_custom_css')})(window)</script>");
}
?>
<form action="themes.php?page=theme_options&sub_page=theme_style_custom_css&save_css" method="post">
    <?php wp_nonce_field('anps_nonce'); ?>
    <div class="content-inner">
        <h3><?php esc_html_e("Custom css", 'constructo'); ?></h3>
        <div class="input fullwidth hidden" id="anps_custom_css_wrapper">
            <label for="anps_custom_css"><?php esc_html_e("Custom css", 'constructo'); ?></label>
            <textarea name="anps_custom_css" id="anps_custom_css" class="fullwidth"><?php echo get_option('anps_custom_css', ''); ?></textarea>
        </div>
        <div class="input fullwidth">
            <div class="anps-editor-wrapper">
                <div class="anps-editor" id="editor"><?php echo get_option('anps_custom_css', ''); ?></div>
            </div>
        </div>
        <div class="clear"></div>
    </div>
    <?php anps_admin_save_buttons(); ?>
</form>

<script>
    jQuery(function ($) {
        ace.config.set('basePath', '<?php echo get_template_directory_uri(); ?>/anps-framework/js')
        var editor = ace.edit('editor')
        editor.getSession().setMode('ace/mode/css')
        $('#anps_custom_css_wrapper').hide()
        var textarea = $('#anps_custom_css')
        editor.getSession().on('change', function() {
            textarea.val(editor.getSession().getValue())
        })
    })
</script>
