<?php
$coming_soon = anps_get_option('', '0', 'coming_soon');
get_header();

if (($coming_soon || $coming_soon != "0") && !is_super_admin()) {
    $post_soon = get_post($coming_soon);
    echo do_shortcode($post_soon->post_content);
} else {
    $meta = get_post_meta(get_queried_object_id());
    $sidebars = anps_parse_sidebars_from_meta($meta, 'post');
    $left_sidebar = $sidebars['left_sidebar'];
    $right_sidebar = $sidebars['right_sidebar'];
    $num_of_sidebars = $sidebars['num_of_sidebars'];

    global $row_inner;
    if ($num_of_sidebars > 0) {
        $row_inner = true;
    }
?>
    <section class="container">
        <div class="row">
            <?php if ($num_of_sidebars === 0) echo '<div class="col-md-12">'; ?>
            <?php if (have_posts()) : ?>
                <?php if ($num_of_sidebars === 0) : ?>
                    <?php
                    while (have_posts()) {
                        the_post();
                        get_template_part('content', get_post_format());
                    }
                    the_posts_pagination(array(
                        'prev_text' => '<i class="fa fa-angle-left"></i> ' . esc_html__( 'Previous ', 'constructo' ),
                        'next_text' => esc_html__( 'Next', 'constructo' ) . ' <i class="fa fa-angle-right"></i>',
                    ));
                    ?>
                <?php else : ?>
                    <?php if ($left_sidebar) anps_sidebar_html($left_sidebar); ?>
                    <div class='col-md-<?php echo esc_attr(12 - $num_of_sidebars * 3); ?>'>
                        <?php
                        while (have_posts()) {
                            the_post();
                            get_template_part('content', get_post_format());
                        }
                        the_posts_pagination(array(
                            'prev_text' => '<i class="fa fa-angle-left"></i> ' . esc_html__( 'Previous ', 'constructo' ),
                            'next_text' => esc_html__( 'Next', 'constructo' ) . ' <i class="fa fa-angle-right"></i>',
                        ));
                        ?>
                    </div>
                    <?php if ($right_sidebar) anps_sidebar_html($right_sidebar); ?>
                <?php endif; ?>
            <?php endif; /* end if posts */ ?>
            <?php if ($num_of_sidebars == 0) echo '</div>'; /* end no sidebars wrapper */ ?>
        </div>
    </section>
<?php
}

get_footer();
