<?php

if (! defined('ABSPATH')) {
    die('-1');
}

/**
 * Shortcode attributes
 * @var $atts
 * @var $content - shortcode content
 * @var $this WPBakeryShortCode_VC_Tta_Accordion|WPBakeryShortCode_VC_Tta_Tabs|WPBakeryShortCode_VC_Tta_Tour|WPBakeryShortCode_VC_Tta_Pageable
 */
$el_class = $css = '';
$atts = vc_map_get_attributes($this->getShortcode(), $atts);
$this->resetVariables($atts, $content);
extract($atts);

$this->setGlobalTtaInfo();

if (method_exists($this, 'enqueueTtaStyles')) {
    $this->enqueueTtaStyles();
}
$this->enqueueTtaScript();

// It is required to be before tabs-list-top/left/bottom/right for tabs/tours
$prepareContent = $this->getTemplateVariable('content');

$class_to_filter = $this->getTtaGeneralClasses();
$class_to_filter .= vc_shortcode_custom_css_class($css, ' ') . $this->getExtraClass($el_class);
$css_class = apply_filters(VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, $class_to_filter, $this->settings['base'], $atts);

$output = '<div ' . $this->getWrapperAttributes() . '>';
$output .= $this->getTemplateVariable('title');
$output .= '<div class="' . esc_attr($css_class) . '">';

if ($this->getShortcode() == 'vc_tta_tabs' && $atts['type'] == 'vertical') {
    $output .= str_replace('vc_tta-tabs-container', 'vc_tta-tabs-container col-sm-3 vertical', $this->getTemplateVariable('tabs-list-top'));
} else {
    $output .= $this->getTemplateVariable('tabs-list-top');
}

$output .= $this->getTemplateVariable('tabs-list-left');

if ($this->getShortcode() == 'vc_tta_tabs' && $atts['type'] == 'vertical') {
    $output .= '<div class="vc_tta-panels-container col-sm-9">';
} else {
    $output .= '<div class="vc_tta-panels-container">';
}

$output .= $this->getTemplateVariable('pagination-top');
$output .= '<div class="vc_tta-panels">';
$output .= $prepareContent;
$output .= '</div>';
$output .= $this->getTemplateVariable('pagination-bottom');
$output .= '</div>';

if ($this->getShortcode() == 'vc_tta_tabs' && $atts['type'] == 'vertical') {
    $output .= str_replace('vc_tta-tabs-container', 'vc_tta-tabs-container col-sm-3 vertical', $this->getTemplateVariable('tabs-list-bottom'));
} else {
    $output .= $this->getTemplateVariable('tabs-list-bottom');
}

$output .= $this->getTemplateVariable('tabs-list-right');
$output .= '</div>';
$output .= '</div>';

$allowed_tags = wp_kses_allowed_html('post');
echo wp_kses($output, $allowed_tags); //PHPCS: XSS ok.
