<?php

if (!function_exists('curly_mkdf_page_options_map')) {
    function curly_mkdf_page_options_map() {

        curly_mkdf_add_admin_page(
            array(
                'slug' => '_page_page',
                'title' => esc_html__('Page', 'curly'),
                'icon' => 'fa fa-file-text-o'
            )
        );

        /***************** Page Layout - begin **********************/

        $panel_sidebar = curly_mkdf_add_admin_panel(
            array(
                'page' => '_page_page',
                'name' => 'panel_sidebar',
                'title' => esc_html__('Page Style', 'curly')
            )
        );

        curly_mkdf_add_admin_field(
            array(
                'name' => 'page_show_comments',
                'type' => 'yesno',
                'label' => esc_html__('Show Comments', 'curly'),
                'description' => esc_html__('Enabling this option will show comments on your page', 'curly'),
                'default_value' => 'yes',
                'parent' => $panel_sidebar
            )
        );

        /***************** Page Layout - end **********************/

        /***************** Content Layout - begin **********************/

        $panel_content = curly_mkdf_add_admin_panel(
            array(
                'page' => '_page_page',
                'name' => 'panel_content',
                'title' => esc_html__('Content Style', 'curly')
            )
        );

        curly_mkdf_add_admin_field(
            array(
                'type' => 'text',
                'name' => 'content_padding',
                'default_value' => '',
                'label' => esc_html__('Content Padding for Template in Full Width', 'curly'),
                'description' => esc_html__('Enter padding for content area for templates in full width. If you set this value then it\'s important to set also Content padding for mobile header value in format: top right bottom left (e.g. 10px 5px 10px 5px)', 'curly'),
                'args' => array(
                    'col_width' => 3
                ),
                'parent' => $panel_content
            )
        );

        curly_mkdf_add_admin_field(
            array(
                'type' => 'text',
                'name' => 'content_padding_in_grid',
                'default_value' => '',
                'label' => esc_html__('Content Padding for Templates in Grid', 'curly'),
                'description' => esc_html__('Enter padding for content area for Templates in grid. If you set this value then it\'s important to set also Content padding for mobile header value in format: top right bottom left (e.g. 10px 5px 10px 5px)', 'curly'),
                'args' => array(
                    'col_width' => 3
                ),
                'parent' => $panel_content
            )
        );

        curly_mkdf_add_admin_field(
            array(
                'type' => 'text',
                'name' => 'content_padding_mobile',
                'default_value' => '',
                'label' => esc_html__('Content Padding for Mobile Header', 'curly'),
                'description' => esc_html__('Enter padding for content area for Mobile Header in format: top right bottom left (e.g. 10px 5px 10px 5px)', 'curly'),
                'args' => array(
                    'col_width' => 3
                ),
                'parent' => $panel_content
            )
        );

        /***************** Content Layout - end **********************/

        /***************** Additional Page Layout - start *****************/

        do_action('curly_mkdf_additional_page_options_map');

        /***************** Additional Page Layout - end *****************/
    }

    add_action('curly_mkdf_options_map', 'curly_mkdf_page_options_map', 8);
}