(function ($) {
    'use strict';

    var woocommerce = {};
    mkdf.modules.woocommerce = woocommerce;

    woocommerce.mkdfOnDocumentReady = mkdfOnDocumentReady;
    woocommerce.mkdfOnWindowLoad = mkdfOnWindowLoad;
    woocommerce.mkdfOnWindowResize = mkdfOnWindowResize;

    $(document).ready(mkdfOnDocumentReady);
    $(window).on('load',mkdfOnWindowLoad);
    $(window).resize(mkdfOnWindowResize);

    /* 
     All functions to be called on $(document).ready() should be in this function
     */
    function mkdfOnDocumentReady() {
        mkdfInitQuantityButtons();
        mkdfInitSelect2();
        mkdfInitSingleProductLightbox();
        mkdfInitSingleProductFeaturedImage();
    }

    /* 
     All functions to be called on $(window).on('load',) should be in this function
     */
    function mkdfOnWindowLoad() {
        mkdfInitProductListMasonryShortcode();
    }

    /* 
     All functions to be called on $(window).resize() should be in this function
     */
    function mkdfOnWindowResize() {
        mkdfInitProductListMasonryShortcode();
    }

    /*
     ** Init quantity buttons to increase/decrease products for cart
     */
    function mkdfInitQuantityButtons() {
        $(document).on('click', '.mkdf-quantity-minus, .mkdf-quantity-plus', function (e) {
            e.stopPropagation();

            var button = $(this),
                inputField = button.siblings('.mkdf-quantity-input'),
                step = parseFloat(inputField.data('step')),
                max = parseFloat(inputField.data('max')),
                min = parseFloat(inputField.data('min')),
                minus = false,
                inputValue = typeof Number.isNaN === 'function' && Number.isNaN(parseFloat(inputField.val())) ? min : parseFloat(inputField.val()),
                newInputValue;

            if (button.hasClass('mkdf-quantity-minus')) {
                minus = true;
            }

            if (minus) {
                newInputValue = inputValue - step;
                if (newInputValue >= 1) {
                    inputField.val(newInputValue);
                } else {
                    inputField.val(0);
                }
            } else {
                newInputValue = inputValue + step;
                if (max === undefined) {
                    inputField.val(newInputValue);
                } else {
                    if (newInputValue >= max) {
                        inputField.val(max);
                    } else {
                        inputField.val(newInputValue);
                    }
                }
            }

            inputField.trigger('change');
        });
    }

    /*
     ** Init select2 script for select html dropdowns
     */
    function mkdfInitSelect2() {
        var orderByDropDown = $('.woocommerce-ordering .orderby');
        if (orderByDropDown.length) {
            orderByDropDown.select2({
                minimumResultsForSearch: Infinity
            });
        }

        var variableProducts = $('.mkdf-woocommerce-page .mkdf-content .variations td.value select');
        if (variableProducts.length) {
            variableProducts.select2();
        }

        var shippingCountryCalc = $('#calc_shipping_country');
        if (shippingCountryCalc.length) {
            shippingCountryCalc.select2();
        }

        var shippingStateCalc = $('.cart-collaterals .shipping select#calc_shipping_state');
        if (shippingStateCalc.length) {
            shippingStateCalc.select2();
        }
    }

    /*
     ** Init Product Single Pretty Photo attributes
     */
    function mkdfInitSingleProductLightbox() {
        var item = $('.mkdf-woo-single-page.mkdf-woo-single-has-pretty-photo .images .woocommerce-product-gallery__image');

        if (item.length) {
            item.children('a').attr('data-rel', 'prettyPhoto[woo_single_pretty_photo]');

            if (typeof mkdf.modules.common.mkdfPrettyPhoto === "function") {
                mkdf.modules.common.mkdfPrettyPhoto();
            }
        }
    }

    /*
     ** Init Product List Masonry Shortcode Layout
     */
    function mkdfInitProductListMasonryShortcode() {
        var container = $('.mkdf-pl-holder.mkdf-masonry-layout .mkdf-pl-outer');

        if (container.length) {
            container.each(function () {
                var thisContainer = $(this),
                    size = thisContainer.find('.mkdf-pl-sizer').width();

                thisContainer.waitForImages(function () {
                    thisContainer.isotope({
                        itemSelector: '.mkdf-pli',
                        resizable: false,
                        masonry: {
                            columnWidth: '.mkdf-pl-sizer',
                            gutter: '.mkdf-pl-gutter'
                        }
                    });

                    if (thisContainer.find('.mkdf-woo-fixed-masonry').length) {
                        mkdf.modules.common.setFixedImageProportionSize(thisContainer, thisContainer.find('.mkdf-pli'), size, true);
                    }

                    thisContainer.isotope('layout').css('opacity', 1);
                });
            });
        }
    }

    /**
     * init single product featured image as background image
     */

    function mkdfInitSingleProductFeaturedImage() {
        var featuredContainer = $('body.single-product .woocommerce-product-gallery--with-images .woocommerce-product-gallery__wrapper div:first-child img');

        if (featuredContainer.length) {
            var image = featuredContainer.attr('src');

            featuredContainer.parent().css('background-image', 'url(' + image + ')');
        }
    }

})(jQuery);