<?php

if ( ! defined( 'ABSPATH' ) ) {
	// Exit if accessed directly.
	exit;
}

if ( ! class_exists( 'Curly_Mikado_Qode_Quick_View_For_WooCommerce' ) ) {
	class Curly_Mikado_Qode_Quick_View_For_WooCommerce {
		private static $instance;

		public function __construct() {
			add_action( 'init', array( $this, 'init' ), 21 );
		}

		/**
		 * @return Curly_Mikado_Qode_Quick_View_For_WooCommerce
		 */
		public static function get_instance() {
			if ( is_null( self::$instance ) ) {
				self::$instance = new self();
			}

			return self::$instance;
		}

		public function init() {

			// Unset default templates modules.
			$this->unset_templates_modules();

			// Change default templates position.
			$this->change_templates_position();
		}

		public function unset_templates_modules() {
			// Override product title.
			add_filter( 'qode_quick_view_for_woocommerce_filter_is_product_title_enabled', '__return_false' );
			add_action( 'qode_quick_view_for_woocommerce_action_product_summary', array( $this, 'quick_view_template_single_title'  ), 5 );

			// Remove product meta.
			add_filter( 'qode_quick_view_for_woocommerce_filter_is_product_meta_enabled', '__return_false', 30 );
		}

		public function quick_view_template_single_title() {
			the_title( '<h3  itemprop="name" class="mkdf-qode-quick-view-product-title entry-title">', '</h3>' );
		}

		public function change_templates_position() {

			// Remove qode quick view button button on shop page.
			add_filter( 'qode_quick_view_for_woocommerce_filter_button_loop_position_default_value', array( $this, 'set_default_button_loop_position' ) );

			if ( class_exists( 'Qode_Quick_View_For_WooCommerce_Module' ) ) {
				$quick_view_object = Qode_Quick_View_For_WooCommerce_Module::get_instance();

				// Add qode quick view button shop archive pages.
				add_action( 'curly_mkdf_woo_pl_info_below_image', array( $quick_view_object, 'add_button' ), 30 );
				add_action( 'curly_mkdf_action_product_list_shortcode', array( $quick_view_object, 'add_button' ), 9 );
			}
		}

		public function set_default_button_loop_position() {
			// or empty, in order to remove default quick view button.
			return 'shortcode';
		}
	}
}

if ( ! function_exists( 'curly_mkdf_init_quick_view_module' ) ) {
	/**
	 * Init main quick view module instance.
	 */
	function curly_mkdf_init_quick_view_module() {
		Curly_Mikado_Qode_Quick_View_For_WooCommerce::get_instance();
	}

	add_action( 'init', 'curly_mkdf_init_quick_view_module', 15 );
}
