<?php

if ( ! defined( 'ABSPATH' ) ) {
	// Exit if accessed directly.
	exit;
}

if ( ! class_exists( 'Curly_Mikado_Qode_Wishlist_For_WooCommerce' ) ) {
	class Curly_Mikado_Qode_Wishlist_For_WooCommerce {
		private static $instance;

		public function __construct() {

			add_filter( 'qode_wishlist_for_woocommerce_filter_add_to_wishlist_behavior_default_value', array( $this, 'set_default_add_to_wishlist_behavior' ) );

			add_filter( 'qode_wishlist_for_woocommerce_filter_button_loop_position_default_value', array( $this, 'set_default_button_loop_position' ) );

			add_action( 'init', array( $this, 'set_button_loop_position' ), 15 );

			add_filter( 'qode_wishlist_for_woocommerce_filter_show_table_title_default_value', array( $this, 'disable_wishlist_page_title' ) );
			add_filter( 'qode_wishlist_for_woocommerce_filter_enable_share_default_value', array( $this, 'disable_wishlist_page_social_share' ) );

			add_filter( 'qode_wishlist_for_woocommerce_filter_add_to_wishlist_wrapper_classes', array( $this, 'set_add_to_wishlist_theme_class' ) );
			add_filter( 'qode_wishlist_for_woocommerce_filter_wishlist_table_holder_classes', array( $this, 'set_add_to_wishlist_theme_class' ) );

			add_filter( 'qode_wishlist_for_woocommerce_filter_add_to_wishlist_button_loop_position', array( $this, 'set_add_to_wishlist_button_loop_position' ), 10, 3 );
		}

		/**
		 * @return Curly_Mikado_Qode_Wishlist_For_WooCommerce
		 */
		public static function get_instance() {
			if ( is_null( self::$instance ) ) {
				self::$instance = new self();
			}

			return self::$instance;
		}

		public function set_default_add_to_wishlist_behavior() {
			return 'view';
		}

		public function set_default_button_loop_position() {
			return 'shortcode';
		}

		public function set_button_loop_position() {
			$button_loop_position = qode_wishlist_for_woocommerce_get_option_value( 'admin', 'qode_wishlist_for_woocommerce_button_loop_position' ) ?? '';

			// Add Qode wishlist button shop archive pages.
			if ( 'shortcode' === $button_loop_position ) {
				add_action( 'curly_mkdf_woo_pl_info_below_image', array( $this, 'render_button' ), 31 );
			}

			// Add Qode wishlist button product list shortcode.
			add_action( 'curly_mkdf_action_product_list_shortcode', array( $this, 'render_button' ), 10 );
		}

		public function render_button() {

			if ( class_exists( 'Qode_Wishlist_For_WooCommerce_Add_To_Wishlist_Shortcode' ) ) {
				// phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
				echo Qode_Wishlist_For_WooCommerce_Add_To_Wishlist_Shortcode::call_shortcode();
			}
		}

		public function set_add_to_wishlist_button_loop_position( $button_position_map, $button_position, $is_block_template ) {

			if ( 'on-thumbnail' === $button_position && ! $is_block_template ) {
				$button_position_map[ $button_position ] = array(
					'hook'     => 'woocommerce_before_shop_loop_item_title',
					'priority' => 6,
				);
			}
			if ( 'after-add-to-cart' === $button_position && ! $is_block_template ) {
				$button_position_map[ $button_position ] = array(
					'hook'     => 'curly_mkdf_woo_pl_info_below_image',
					'priority' => 31,
				);
			}
			if ( 'before-add-to-cart' === $button_position && ! $is_block_template ) {
				$button_position_map[ $button_position ] = array(
					'hook'     => 'curly_mkdf_woo_pl_info_below_image',
					'priority' => 24,
				);
			}
			if ( 'above-thumbnail' === $button_position && ! $is_block_template ) {
				$button_position_map[ $button_position ] = array(
					'hook'     => 'woocommerce_before_shop_loop_item',
					'priority' => 4,
				);
			}

			return $button_position_map;
		}

		public function disable_wishlist_page_title() {
			return 'no';
		}

		public function disable_wishlist_page_social_share() {
			return 'no';
		}

		public function set_add_to_wishlist_theme_class( $classes ) {
			$classes[] = 'mkdf-curly-theme';

			return $classes;
		}
	}

	Curly_Mikado_Qode_Wishlist_For_WooCommerce::get_instance();
}
