<?php
// **********************************************************************// 
// ! Customize the VC rows and columns to use theme's Foundation framework
// **********************************************************************//
if (!function_exists('nasa_customize_custom_css_classes')) {

    function nasa_customize_vc_rows_columns($class_string, $tag) {
        // vc_row 
        if ($tag == 'vc_row' || $tag == 'vc_row_inner') {

            $replace = array(
                'vc_row-fluid' => 'row',
                'wpb_row' => '',
                'vc_row' => '',
                'vc_inner' => '',
            );

            $class_string = nasa_replace_string_with_assoc_array($replace, $class_string);
        }

        // vc_column
        if ($tag == 'vc_column' || $tag == 'vc_column_inner') {
            $replace = array(
                'wpb_column' => '',
                'column_container' => '',
            );

            $class_string = nasa_replace_string_with_assoc_array(
                $replace, preg_replace('/vc_span(\d{1,2})/', 'nasa-col large-$1 columns', $class_string)
            );

            // Custom columns	
            $class_string = nasa_replace_string_with_assoc_array(
                $replace, preg_replace('/vc_(\d{1,2})\\/12/', 'nasa-col large-$1 columns', $class_string)
            );

            $class_string = nasa_replace_string_with_assoc_array(
                $replace, preg_replace('/vc_hidden-xs/', 'hide-for-small', $class_string)
            );

            // VC 4.3.x (it changed the tags)
            $class_string = nasa_replace_string_with_assoc_array(
                $replace, preg_replace('/vc_col-(xs|sm|md|lg)-(\d{1,2})/', 'nasa-col large-$2 columns', $class_string)
            );
            
            /**
             * Support 5 columns
             */
            $class_string = str_replace('large-1 columns/5', 'nasa-5-col columns', $class_string);
        }

        return trim($class_string);
    }

}

// Used in "nasa_customize_vc_rows_columns()" [plugin-custom-functions.php]
if (!function_exists('nasa_replace_string_with_assoc_array')) {

    function nasa_replace_string_with_assoc_array(array $replace, $subject) {
        return str_replace(array_keys($replace), array_values($replace), $subject);
    }

}

// **********************************************************************// 
// ! Visual Composer Setup
// **********************************************************************//
if (!function_exists('getCSSAnimation')) {

    function getCSSAnimation($css_animation) {
        $output = '';
        if ($css_animation != '') {
            wp_enqueue_script('waypoints');
            $output = ' wpb_animate_when_almost_visible wpb_' . $css_animation;
        }
        return $output;
    }

}

if (!function_exists('buildStyle')) {

    function buildStyle($bg_image = '', $bg_color = '', $bg_image_repeat = '', $font_color = '', $padding = '', $margin_bottom = '') {
        $has_image = false;
        $style = '';
        if ((int) $bg_image > 0 && ($image_url = wp_get_attachment_url($bg_image, 'large')) !== false) {
            $has_image = true;
            $style .= "background-image: url(" . $image_url . ");";
        }
        if (!empty($bg_color)) {
            $style .= vc_get_css_color('background-color', $bg_color);
        }
        if (!empty($bg_image_repeat) && $has_image) {
            if ($bg_image_repeat === 'cover') {
                $style .= "background-repeat:no-repeat;background-size: cover;";
            } elseif ($bg_image_repeat === 'contain') {
                $style .= "background-repeat:no-repeat;background-size: contain;";
            } elseif ($bg_image_repeat === 'no-repeat') {
                $style .= 'background-repeat: no-repeat;';
            }
        }
        if (!empty($font_color)) {
            $style .= vc_get_css_color('color', $font_color); // 'color: '.$font_color.';';
        }
        if ($padding != '') {
            $style .= 'padding: ' . (preg_match('/(px|em|\%|pt|cm)$/', $padding) ? $padding : $padding . 'px') . ';';
        }
        if ($margin_bottom != '') {
            $style .= 'margin-bottom: ' . (preg_match('/(px|em|\%|pt|cm)$/', $margin_bottom) ? $margin_bottom : $margin_bottom . 'px') . ';';
        }
        return empty($style) ? $style : ' style="' . $style . '"';
    }
}

// Hook for frontend editor
add_action('vc_load_shortcode', 'nasa_vc_remove_woocommerce', 11);
/* Remove Woocommerce elements */
function nasa_vc_remove_woocommerce() {
    if (class_exists('WooCommerce')) {
        vc_remove_element('recent_products');
        vc_remove_element('featured_products');
        vc_remove_element('best_selling');
        vc_remove_element('product');
        vc_remove_element('products');
        vc_remove_element('sale_products');
        vc_remove_element('best_selling_products');
        vc_remove_element('top_rated_products');
    }
}

add_action('init', 'nasa_vc_setup');
if (!function_exists('nasa_vc_setup')) {

    function nasa_vc_setup() {
        if (!class_exists('WPBakeryVisualComposerAbstract')){
            return;
        }
        
        //Your "container" content element should extend WPBakeryShortCodesContainer class to inherit all required functionality
        if (class_exists('WPBakeryShortCodesContainer')) {
            class WPBakeryShortCode_nasa_slider extends WPBakeryShortCodesContainer {}
            class WPBakeryShortCode_nasa_banner_grid extends WPBakeryShortCodesContainer {}
            class WPBakeryShortCode_nasa_col extends WPBakeryShortCodesContainer {}
            class WPBakeryShortCode_nasa_row extends WPBakeryShortCodesContainer {}
        }
        
        if (class_exists('WPBakeryShortCode')) {
            class WPBakeryShortCode_nasa_banner extends WPBakeryShortCode {}
        }
    }

}

// Visual Composer plugin
if (class_exists('Vc_Manager')) {
    add_filter('vc_shortcodes_css_class', 'nasa_customize_vc_rows_columns', 10, 2);
}

add_action('init', 'nasa_init_shortcode', 0);
function nasa_init_shortcode() {
    if (class_exists('WPBakeryVisualComposerAbstract')){
        // Include custom new shortcodes
        nasa_includes_files(glob(NASA_CORE_PLUGIN_PATH . 'includes/shortcodes/nasa_*.php'));
    }
}

if (!function_exists('nasa_getListProductDeals')) {

    function nasa_getListProductDeals() {
        global $woocommerce;
        
        $list = array();
        if (!$woocommerce) {
            return $list;
        }
        $args = array(
            'post_type' => array('product', 'product_variation'),
            'posts_per_page' => 100,
            'post_status' => 'publish',
            'paged' => 1,
            'meta_query'     => array(
                'relation' => 'OR',
                array( // Simple products type
                    'key'           => '_sale_price_dates_to',
                    'value'         => 0,
                    'compare'       => '>',
                    'type'          => 'numeric'
                )
            )
        );
        
        $args['post__in'] = wc_get_product_ids_on_sale();
        $products = new WP_Query($args);
        if ($products->have_posts()) {
            while ($products->have_posts()) {
                $products->the_post();
                
                global $product;
                if (!$product->is_visible()){
                    continue;
                }
                $title = html_entity_decode(get_the_title());
                $list[$title] = $product->get_id();
            }
        }

        return $list;
    }

}

if (!function_exists('nasa_get_cat_product_array')) {

    function nasa_get_cat_product_array() {
        $categories = get_categories(array(
            'taxonomy' => 'product_cat',
            'orderby' => 'name'
        ));
        $list = array(
            esc_html__('Select category', 'nasa-core') => ''
        );

        if (!empty($categories)) {
            foreach ($categories as $v) {
                $list[$v->name] = $v->term_id;
            }
        }

        return $list;
    }

}
