<?php
/**
* Liquid Themes Theme Framework
* The Liquid_Admin_Dashboard base class
*/

if ( !defined( 'ABSPATH' ) )
	exit; // Exit if accessed directly

class Docly_admin_dashboard extends Docly_admin_page {
	public string $id;
	public string $menu_title;
	public string $page_title;

	/**
	 * [__construct description]
	 * @method __construct
	 */
	public function __construct() {

		$this->id = 'docly';
		$this->position = '50';

		add_action( 'after_setup_theme', [ $this, 'set_titles' ] );

		parent::__construct();
	}

	public function set_titles() {
		$this->page_title = esc_html__( 'Docly Dashboard', 'docly' );
		$this->menu_title = esc_html__( 'Register/Verify', 'docly' );
	}

	/**
	 * [display description]
	 * @method display
	 * @return [type]  [description]
	 */
	public function display() {
		include_once( get_template_directory() . '/inc/admin/dashboard/dashboard.php' );
	}

	/**
	 * [save description]
	 * @method save
	 * @return [type] [description]
	 */
	public function save() {

	}
}
new Docly_admin_dashboard;
