<?php
/**
 * Template part for displaying search elementor templates
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Docly
 */
$opt                        = get_option('docly_opt');
$search_banner_el_layout    = isset($opt['search_banner_el_layout']) ? $opt['search_banner_el_layout'] : '';
if (empty($search_banner_el_layout)) {
    return;
}

$query = new \WP_Query( [
    'post_type' => 'elementor_library',
    'p'         => $search_banner_el_layout,
] );

if ( $query->have_posts() ) {
    while ( $query->have_posts() ) {
        $query->the_post();

        if ( did_action( 'elementor/loaded' ) ) {
            $parent_content = \Elementor\Plugin::instance()->frontend->get_builder_content(get_the_ID());
            echo !empty($parent_content) ? $parent_content : apply_filters('the_content', get_the_content());
        }
    }
}
wp_reset_postdata();