<?php
/**
 * Ecomus Addons Modules functions and definitions.
 *
 * @package Ecomus
 */

namespace Ecomus\Addons\Modules\Add_To_Cart_Ajax;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Addons Modules
 */
class Module {

	/**
	 * Instance
	 *
	 * @var $instance
	 */
	private static $instance;


	/**
	 * Initiator
	 *
	 * @since 1.0.0
	 * @return object
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	/**
	 * Instantiate the object.
	 *
	 * @since 1.0.0
	 *
	 * @return void
	 */
	public function __construct() {
		$this->includes();
		$this->actions();
	}

	/**
	 * Includes files
	 *
	 * @since 1.0.0
	 *
	 * @return void
	 */
	private function includes() {
		\Ecomus\Addons\Auto_Loader::register( [
			'Ecomus\Addons\Modules\Add_To_Cart_Ajax\Settings'   => ECOMUS_ADDONS_DIR . 'modules/add-to-cart-ajax/settings.php',
			'Ecomus\Addons\Modules\Add_To_Cart_Ajax\Frontend'   => ECOMUS_ADDONS_DIR . 'modules/add-to-cart-ajax/frontend.php',
		] );
	}

	/**
	 * Add Actions
	 *
	 * @since 1.0.0
	 *
	 * @return void
	 */
	public function actions() {
		if ( is_admin() ) {
			\Ecomus\Addons\Modules\Add_To_Cart_Ajax\Settings::instance();
		}

		if ( get_option( 'ecomus_add_to_cart_ajax', 'yes' ) == 'yes' ) {
			\Ecomus\Addons\Modules\Add_To_Cart_Ajax\Frontend::instance();
		}
	}

}
