<?php

	/**
	* The template for displaying 404 pages (not found)
	*
	* @link https://codex.wordpress.org/Creating_an_Error_404_Page
	*
	* @package WordPress
	* @subpackage Naturally
	* @since 1.0.0
	*/

	get_header();

	// you can use this action for add any content before container element
	do_action( 'naturally_before_404' );
	$naturally_default_background = !class_exists('Redux') ? get_template_directory_uri().'/images/bg-4.jpg' : '';
?>

	<div id="nt-404" class="nt-404 error">
		<div class="section section-404" data-ntr-background="<?php echo esc_url( $naturally_default_background ); ?>">
			<div class="container">
				<div class="section-404_inner">
					<div class="section-404_heading">
						<?php if ( '0' != naturally_settings( 'error_content_title_visibility', '1' ) ) { ?>
							<h1 class="nt-error-title"><?php echo esc_html( naturally_settings( 'error_content_title', 'Page not found' ) ); ?></h1>
						<?php } ?>
						<?php if ( '0' != naturally_settings('error_content_desc_visibility', '1' ) ) { ?>
							<p class="nt-error-desc"><?php echo esc_html( naturally_settings( 'error_content_desc', 'Sorry, but the page you are looking for does not exist or has been removed' ) ); ?></p>
						<?php } ?>
					</div>

					<?php echo naturally_content_custom_search_form(); ?>

					<?php if ( '0' != naturally_settings( 'error_content_btn_visibility', '1' ) ) { ?>
						<a class="link is-color-secondary"href="<?php echo esc_url( home_url('/') ); ?>">
							<span class="link_text"><?php echo esc_html( naturally_settings( 'error_content_btn_title', 'Go to home page' ) ); ?></span>
							<span class="link_icon icon is-next"></span>
						</a>
					<?php } ?>
				</div>
			</div>
		</div>
	</div>

<?php

	// use this action to add any content after 404 page container element
	do_action( 'naturally_after_404' );

	get_footer();

?>
