<?php
/**
* The template for displaying archive pages
*
* @link https://developer.wordpress.org/themes/basics/template-hierarchy/
*
* @package WordPress
* @subpackage Naturally
* @since 1.0.0
*/

get_header();

// Elementor `archive` location
if ( ! function_exists( 'elementor_theme_do_location' ) || ! elementor_theme_do_location( 'archive' ) ) {
    // you can use this action for add any content before container element
    do_action( 'naturally_before_archive' );

    $archive_layout = naturally_settings( 'archive_layout', 'full-width' );
    $archive_sidebar = naturally_sidebar( 'naturally-search-sidebar' );
    $archive_column = $archive_sidebar ? ' is-xl-8' : ' is-xl-10';

    ?>

    <!-- archive page general div -->
    <div id="nt-archive" class="nt-archive" >

        <?php naturally_hero_section(); ?>

        <div class="nt-theme-inner-container section">
            <div class="container">
                <div class="grid">
                    <div class="grid_row justify-center">

                        <!-- Left sidebar -->
                        <?php if ( $archive_sidebar && 'left-sidebar' == $archive_layout ) { ?>
                            <div id="nt-sidebar" class="nt-sidebar grid_col is-12 is-xl-4" data-aos="ntr-fade-up" data-aos-once="true">
                                <div class="blog-sidebar nt-sidebar-inner">
                                    <?php dynamic_sidebar( $archive_sidebar ); ?>
                                </div>
                            </div>
                        <?php } ?>

                        <!-- Content column -->
                        <div class="grid_col is-12 is-xl-8" data-aos="ntr-fade-up" data-aos-once="true">

                            <?php if ( have_posts() ) { ?>

                                <div class="grid">
                                    <div class="grid_row is-60">
                                        <?php
                                        while ( have_posts() ) : the_post();

                                            naturally_post_style_two();

                                        endwhile;

                                        // this function working with wp reading settins + posts
                                        naturally_index_loop_pagination();
                                        ?>
                                    </div>
                                </div>

                            <?php } else {
                                // if there are no posts, read content none function
                                naturally_content_none();
                            }
                            ?>

                        </div>
                        <!-- End content -->

                        <!-- Right sidebar -->
                        <?php if ( $archive_sidebar && 'right-sidebar' == $archive_layout ) { ?>
                            <div id="nt-sidebar" class="nt-sidebar grid_col is-12 is-xl-4" data-aos="ntr-fade-up" data-aos-once="true">
                                <div class="blog-sidebar nt-sidebar-inner">
                                    <?php dynamic_sidebar( $archive_sidebar ); ?>
                                </div>
                            </div>
                        <?php } ?>

                    </div><!-- End row -->
                </div><!-- End row -->
            </div><!-- End container -->
        </div><!-- End #blog-post -->
    </div>
    <!-- End archive page general div-->
    <?php

    do_action( 'naturally_after_archive' );

}

get_footer();

?>
