<?php
/**
 * The Template for displaying all single posts.
 *
 * @package dokan
 * @package dokan - 2014 1.0
 */

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

    get_header( 'shop' );

    $store_user   = dokan()->vendor->get( get_query_var( 'author' ) );
    $store_info   = $store_user->get_shop_info();
    $map_location = $store_user->get_location();

    $shop_layout = naturally_settings( 'shop_layout', 'right-sidebar' );

    ?>

    <?php
    if ( '0' != naturally_settings( 'breadcrumbs_visibility', '1' ) ) {
        remove_action( 'woocommerce_before_main_content', 'woocommerce_breadcrumb', 20 );

        if ( function_exists( 'yoast_breadcrumb' ) ) {
            yoast_breadcrumb( '<div id="breadcrumb">', '</div>' );
        } else {
        ?>
            <div class="section section-custom-8">
                <div class="container">
                    <div class="breadcrumb">
                        <?php woocommerce_breadcrumb(); ?>
                    </div>
                </div>
            </div>
            <?php
        }
    }
    ?>

    <?php do_action( 'woocommerce_before_main_content' ); ?>

    <!-- Single page general div -->
    <div id="dokan-primary" class="nt-single dokan-single-store">

        <?php dokan_get_template_part( 'store-header' ); ?>

        <?php do_action( 'dokan_store_profile_frame_after', $store_user->data, $store_info ); ?>

        <div id="dokan-content" class="section nt-single store-page-wrap woocommerce">
            <div class="container">
                <div class="grid">
                    <div class="grid_row is-60 justify-center">

                        <?php dokan_get_template_part( 'store', 'sidebar', array( 'store_user' => $store_user, 'store_info' => $store_info, 'map_location' => $map_location ) ); ?>

                        <div class="grid_col is-12 is-lg-8 is-xl-9 naturally-store-content">
                            <?php
                            if ( have_posts() ) {

                                    woocommerce_product_loop_start();

                                        while ( have_posts() ) : the_post();

                                            wc_get_template_part( 'content', 'product' );

                                        endwhile;

                                    woocommerce_product_loop_end();

                                    /**
                                    * Hook: woocommerce_after_shop_loop.
                                    *
                                    * @hooked woocommerce_pagination - 10
                                    */
                                    naturally_index_loop_pagination();


                            } else { ?>

                                <p class="dokan-info"><?php esc_html_e( 'No products were found of this vendor!', 'naturally' ); ?></p>

                            <?php } ?>

                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>

<?php
/**
 * Hook: woocommerce_after_main_content.
 *
 * @hooked woocommerce_output_content_wrapper_end - 10 (outputs closing divs for the content)
 */
do_action( 'woocommerce_after_main_content' );

get_footer( 'shop' );
?>
