<?php

/**
 *
 * @package WordPress
 * @subpackage naturally
 * @since Naturally 1.0
 *
**/

define('NATURALLY_DIRECTORY_URI', get_template_directory_uri());
define('NATURALLY_DIRECTORY', get_template_directory());

/*************************************************
## GOOGLE FONTS
*************************************************/

if (! function_exists('naturally_fonts_url')) {
    function naturally_fonts_url()
    {
        $fonts_url = '';

        $merriweather = _x('on', 'Merriweather font: on or off', 'naturally');

        if ('off' !== $merriweather ) {
            $font_families = array();

            if ('off' !== $merriweather) {
                $font_families[] = 'Merriweather:300,300i,400,400i,700,700i,900,900i';
            }

            $query_args = array(
                'family' => urlencode(implode('|', $font_families)),
                'subset' => urlencode('latin,latin-ext'),
            );

            $fonts_url = add_query_arg($query_args, "//fonts.googleapis.com/css");
        }

        return esc_url_raw( $fonts_url );
    }
}

/*************************************************
## STYLES AND SCRIPTS
*************************************************/

function naturally_theme_scripts()
{
    // theme inner pages files
    wp_enqueue_style( 'naturally-framework-style', NATURALLY_DIRECTORY_URI . '/css/framework-style.css', false, '1.0' );

    // plugins
    wp_enqueue_style( 'jquery-ui', NATURALLY_DIRECTORY_URI . '/libs/jquery-ui/jquery-ui.min.css', false, '1.0' );
    wp_enqueue_style( 'jquery-magnific-popup', NATURALLY_DIRECTORY_URI . '/libs/magnific/jquery.magnific-popup.css', false, '1.0' );
    wp_enqueue_style( 'slick', NATURALLY_DIRECTORY_URI . '/libs/slick/slick.css', false, '1.0' );
    wp_enqueue_style( 'aos', NATURALLY_DIRECTORY_URI . '/libs/aos/aos.css', false, '1.0' );
    wp_enqueue_style( 'nice-select', NATURALLY_DIRECTORY_URI . '/libs/nice-select/nice-select.css', false, '1.0' );
    wp_enqueue_style( 'naturally-font-awesome', NATURALLY_DIRECTORY_URI . '/libs/font-awesome/font-awesome.min.css', false, '1.0' );

    // naturally-main-style
    wp_enqueue_style( 'naturally-style', NATURALLY_DIRECTORY_URI . '/css/style.css', false, '1.0' );
    // naturally-update-style
    wp_register_style( 'naturally-elementor', NATURALLY_DIRECTORY_URI . '/css/elementor-custom.css', false, '1.0' );
    wp_enqueue_style( 'naturally-update', NATURALLY_DIRECTORY_URI . '/css/update.css', false, '1.0' );

    // upload Google Webfonts
    wp_enqueue_style( 'naturally-fonts', naturally_fonts_url(), array(), null );


    // ## JS
    // theme inner page files

    wp_enqueue_script( 'jquery-ui', NATURALLY_DIRECTORY_URI . '/libs/jquery-ui/jquery-ui.min.js', array('jquery'), '1.0', true );
    wp_enqueue_script( 'jquery-magnific-popup', NATURALLY_DIRECTORY_URI . '/libs/magnific/jquery.magnific-popup.min.js', array('jquery'), '1.0', true );
    wp_enqueue_script( 'jquery-waypoints', NATURALLY_DIRECTORY_URI . '/libs/waypoints/jquery.waypoints.min.js', array('jquery'), '1.0', true );
    wp_enqueue_script( 'jquery-countTo', NATURALLY_DIRECTORY_URI . '/libs/countTo/jquery.countTo.js', array('jquery'), '1.0', true );
    wp_enqueue_script( 'slick', NATURALLY_DIRECTORY_URI . '/libs/slick/slick.min.js', array('jquery'), '1.0', true );
    wp_enqueue_script( 'imagesloaded-pkgd', NATURALLY_DIRECTORY_URI . '/libs/isotope/imagesloaded.pkgd.min.js', array('jquery'), '1.0', true );
    wp_enqueue_script( 'isotope-pkgd', NATURALLY_DIRECTORY_URI . '/libs/isotope/isotope.pkgd.min.js', array('jquery'), '1.0', true );
    wp_enqueue_script( 'lazysizes', NATURALLY_DIRECTORY_URI . '/libs/aos/lazysizes.min.js', array('jquery'), '1.0', true );
    wp_enqueue_script( 'aos', NATURALLY_DIRECTORY_URI . '/libs/aos/aos.js', array('jquery'), '1.0', true );
    wp_enqueue_script( 'jarallax', NATURALLY_DIRECTORY_URI . '/libs/jarallax/jarallax.min.js', array('jquery'), '1.0', true );
    wp_enqueue_script( 'jquery-nice-select', NATURALLY_DIRECTORY_URI . '/libs/nice-select/jquery.nice-select.min.js', array('jquery'), '1.0', true );

    wp_enqueue_script( 'naturally-main', NATURALLY_DIRECTORY_URI . '/js/scripts.js', array('jquery'), '1.0', true );

    wp_enqueue_script( 'framework-settings', NATURALLY_DIRECTORY_URI . '/js/framework-settings.js', array('jquery'), '1.0', true );

    if( 'masonry' == naturally_settings( 'index_type', 'default' ) ) {
        wp_enqueue_script( 'masonry' );
    }

    // comment form reply
    if (is_singular()) {
        wp_enqueue_script('comment-reply');
    }
}
add_action('wp_enqueue_scripts', 'naturally_theme_scripts');


function naturally_resource_hints( $urls, $relation_type ) {

    if ( wp_style_is( 'naturally-fonts', 'queue' ) && 'preconnect' === $relation_type ) {
        $urls[] = array(
            'href' => 'https://fonts.gstatic.com',
            'crossorigin',
        );
    }

    return $urls;
}
add_filter( 'wp_resource_hints', 'naturally_resource_hints', 10, 2 );

add_filter('wpcf7_autop_or_not', '__return_false');

// Template-functions
include NATURALLY_DIRECTORY . '/inc/template-functions.php';


/*************************************************
## THEME SETUP
*************************************************/


if (! isset($content_width)) {
    $content_width = 960;
}

function naturally_theme_setup()
{
    /*
    * This theme styles the visual editor to resemble the theme style,
    * specifically font, colors, icons, and column width.
    */
    add_editor_style('custom-editor-style.css');

    // Add default posts and comments RSS feed links to head.
    add_theme_support('automatic-feed-links');
    add_image_size('naturally-square', 500, 500, true);
    add_image_size('naturally-single', 2400, 1200, true);
    /*
    * Enable support for Post Thumbnails on posts and pages.
    *
    * See: https://codex.wordpress.org/Function_Reference/add_theme_support#Post_Thumbnails
    */
    add_theme_support('post-thumbnails');
    add_theme_support( 'post-formats', array( 'gallery','link','image','quote','video','audio' ) );
    add_post_type_support('page', 'excerpt');

    // theme supports
    add_theme_support('title-tag');
    add_theme_support('custom-background');
    add_theme_support('custom-header');
    add_theme_support('html5', array( 'search-form' ));

    $options = get_option('naturally');
    if ( isset( $options['open_gutenberg'] ) && '1' != $options['open_gutenberg'] ) {
        remove_theme_support( 'widgets-block-editor' );
        add_filter( 'use_widgets_block_editor', '__return_false' );
        add_filter('use_block_editor_for_post', '__return_false', 10);
        add_filter('use_block_editor_for_page', '__return_false', 10);
    }

    // Make theme available for translation
    // Translations can be filed in the /languages/ directory
    load_theme_textdomain('naturally', NATURALLY_DIRECTORY . '/languages');

    register_nav_menus(array(
        'header_menu' => esc_html__('Header Menu', 'naturally'),
        'footer_menu' => esc_html__('Footer Menu', 'naturally'),
        'mobile_bottom_menu' => esc_html__('Mobile Bottom Menu', 'naturally'),
    ));

    if ( is_admin() ) {
        // Template admin menu
        require_once get_parent_theme_file_path( '/inc/admin.php' );
        require_once get_parent_theme_file_path( '/inc/core/merlin/admin-menu.php' );
        require_once get_parent_theme_file_path( '/inc/core/merlin/class-merlin.php' );
        require_once get_parent_theme_file_path( '/inc/core/demo-wizard-config.php' );
    }

    // Theme parts
    include NATURALLY_DIRECTORY . '/inc/template-parts/menu.php';
    include NATURALLY_DIRECTORY . '/inc/template-parts/post-formats.php';
    include NATURALLY_DIRECTORY . '/inc/template-parts/single-post-formats.php';
    include NATURALLY_DIRECTORY . '/inc/template-parts/paginations.php';
    include NATURALLY_DIRECTORY . '/inc/template-parts/comment-parts.php';
    include NATURALLY_DIRECTORY . '/inc/template-parts/small-parts.php';
    include NATURALLY_DIRECTORY . '/inc/template-parts/header-parts.php';
    include NATURALLY_DIRECTORY . '/inc/template-parts/footer-parts.php';
    include NATURALLY_DIRECTORY . '/inc/template-parts/page-hero.php';
    include NATURALLY_DIRECTORY . '/inc/template-parts/breadcrumbs.php';

    // Theme dynamic css setting file
    include NATURALLY_DIRECTORY . '/inc/template-parts/custom-style.php';

    // Theme post and page meta plugin for customization and more features
    include NATURALLY_DIRECTORY . '/inc/core/metaboxes.php';
    // TGM plugin activation
    include NATURALLY_DIRECTORY . '/inc/core/class-tgm-plugin-activation.php';
    // Redux theme options panel
    include NATURALLY_DIRECTORY . '/inc/core/theme-options/options.php';

    // WooCommerce init
    if ( class_exists( 'WooCommerce' ) ) {
        add_theme_support( 'woocommerce'  );
        add_theme_support( 'woocommerce', array(
            'single_image_width' => 980,
        ));
        add_theme_support( 'wc-product-gallery-zoom' );
        add_theme_support( 'wc-product-gallery-lightbox' );
        add_theme_support( 'wc-product-gallery-slider' );
        include NATURALLY_DIRECTORY . '/woocommerce/init.php';
    }
}
add_action('after_setup_theme', 'naturally_theme_setup');


/*************************************************
## WIDGET COLUMNS
*************************************************/

function naturally_widgets_init()
{
    register_sidebar(array(
        'name' => esc_html__('Blog Sidebar', 'naturally'),
        'id' => 'sidebar-1',
        'description' => esc_html__('These widgets for the Blog page.', 'naturally'),
        'before_widget' => '<div class="nt-sidebar-inner-widget blog-sidebar_widget %2$s">',
        'after_widget' => '</div>',
        'before_title' => '<h4 class="nt-sidebar-inner-widget-title blog-sidebar_widget_title">',
        'after_title' => '</h4>'
    ));
    register_sidebar(array(
        'name' => esc_html__('Default Page Sidebar', 'naturally'),
        'id' => 'naturally-page-sidebar',
        'description' => esc_html__('These widgets for the Default Page pages.', 'naturally'),
        'before_widget' => '<div class="nt-sidebar-inner-widget %2$s">',
        'after_widget' => '</div>',
        'before_title' => '<h4 class="nt-sidebar-inner-widget-title widget-title blog-sidebar_widget_title">',
        'after_title' => '</h4>'
    ));
    register_sidebar(array(
        'name' => esc_html__('Archive Sidebar', 'naturally'),
        'id' => 'naturally-archive-sidebar',
        'description' => esc_html__('These widgets for the Archive pages.', 'naturally'),
        'before_widget' => '<div class="nt-sidebar-inner-widget %2$s">',
        'after_widget' => '</div>',
        'before_title' => '<h4 class="nt-sidebar-inner-widget-title widget-title blog-sidebar_widget_title">',
        'after_title' => '</h4>'
    ));
    register_sidebar(array(
        'name' => esc_html__('Search Sidebar', 'naturally'),
        'id' => 'naturally-search-sidebar',
        'description' => esc_html__('These widgets for the Search pages.', 'naturally'),
        'before_widget' => '<div class="nt-sidebar-inner-widget %2$s">',
        'after_widget' => '</div>',
        'before_title' => '<h4 class="nt-sidebar-inner-widget-title widget-title blog-sidebar_widget_title">',
        'after_title' => '</h4>'
    ));
    register_sidebar(array(
        'name' => esc_html__('Blog Single Sidebar', 'naturally'),
        'id' => 'naturally-single-sidebar',
        'description' => esc_html__('These widgets for the Blog single page.', 'naturally'),
        'before_widget' => '<div class="nt-sidebar-inner-widget %2$s">',
        'after_widget' => '</div>',
        'before_title' => '<h4 class="nt-sidebar-inner-widget-title widget-title blog-sidebar_widget_title">',
        'after_title' => '</h4>'
    ));
    register_sidebar(array(
        'name' => esc_html__('Footer Widget Area', 'naturally'),
        'id' => 'footer-widget-area',
        'description' => esc_html__('These widgets for the footer top section.', 'naturally'),
        'before_widget' => '',
        'after_widget' => '',
        'before_title' => '<h4 class="nt-footer-widget-title nt-sidebar-inner-widget-title blog-sidebar_widget_title">',
        'after_title' => '</h4>'
    ));
} // end naturally_widgets_init
add_action('widgets_init', 'naturally_widgets_init');

function naturally_register_elementor_locations( $elementor_theme_manager ) {

    $elementor_theme_manager->register_location( 'header' );
    $elementor_theme_manager->register_location( 'footer' );
    $elementor_theme_manager->register_location( 'single' );
    $elementor_theme_manager->register_location( 'archive' );

}
add_action( 'elementor/theme/register_locations', 'naturally_register_elementor_locations' );
