<?php

/*************************************************
## ADMIN NOTICES
*************************************************/

add_action('admin_notices', 'naturally_theme_activation_notice');
function naturally_theme_activation_notice() {
    if (get_user_meta(get_current_user_id(), 'naturally-ignore-notice', true) == 'yes') {
        return;
    }
    $url = add_query_arg( 'naturally-ignore-notice', 'naturally_dismiss_admin_notices' );
    ?>
    <div class="updated notice notice-info is-dismissible naturally-admin-notice">
        <p><?php echo esc_html__( 'If you need help about demodata installation, please read docs and ', 'naturally' ); ?>
            <a target="_blank" href="<?php echo esc_url( 'https://ninetheme.com/contact/' ); ?>"><?php echo esc_html__( 'Open a ticket', 'naturally' ); ?></a>
            <?php echo esc_html__('or', 'naturally'); ?>
            <a href="<?php echo esc_url( $url ); ?>"><?php echo esc_html__( 'Dismiss this notice', 'naturally' ); ?></a>
            <button type="button" class="notice-dismiss hide-admin-notice"><span class="screen-reader-text"></span></button>
        </p>
    </div>
    <?php
}

add_action('admin_init', 'naturally_theme_activation_notice_ignore');
function naturally_theme_activation_notice_ignore() {
    if (isset($_GET['naturally-ignore-notice'])) {
        update_user_meta(get_current_user_id(), 'naturally-ignore-notice', 'yes');
    }
}

/*************************************************
## ADMIN STYLE AND SCRIPTS
*************************************************/

function naturally_admin_scripts()
{
    // Update CSS within in Admin
    wp_enqueue_script( 'naturally-custom-admin', NATURALLY_DIRECTORY_URI . '/js/framework-admin.js', array('jquery','jquery-ui-sortable') );

}
add_action('admin_enqueue_scripts', 'naturally_admin_scripts');


/*************************************************
## INCLUDE THE TGM_PLUGIN_ACTIVATION CLASS.
*************************************************/
// TGM plugin activation
include NATURALLY_DIRECTORY . '/inc/core/class-tgm-plugin-activation.php';
function naturally_register_required_plugins()
{
    $plugins = array(
        array(
            'name' => esc_html__('Contact Form 7', "naturally"),
            'slug' => 'contact-form-7'
        ),
        array(
            'name' => esc_html__('WooCommerce', "naturally"),
            'slug' => 'woocommerce'
        ),
        array(
            'name' => esc_html__('YITH WC Compare', "naturally"),
            'slug' => 'yith-woocommerce-compare'
        ),
        array(
            'name' => esc_html__('YITH WC Wishlist', "naturally"),
            'slug' => 'yith-woocommerce-wishlist'
        ),
        array(
            'name' => esc_html__('YITH WC Quick View', "naturally"),
            'slug' => 'yith-woocommerce-quick-view'
        ),
        array(
            'name' => esc_html__('Theme Options Panel', "naturally"),
            'slug' => 'redux-framework',
            'required' => true
        ),
        array(
            'name' => esc_html__('Elementor', "naturally"),
            'slug' => 'elementor',
            'required' => true
        ),
        array(
            'name' => esc_html__('ACF', "naturally"),
            'slug' => 'advanced-custom-fields',
            'required' => true
        ),
        array(
            'name' => esc_html__( 'Safe SVG', 'awam' ),
            'slug' => 'safe-svg',
            'required' => true
        ),
        array(
            'name' => esc_html__('Envato Update Theme', "naturally"),
            'slug' => 'envato-market',
            'source' => 'https://ninetheme.com/documentation/plugins/envato-market.zip',
            'required' => false
        ),
        array(
            'name' => esc_html__('Revolution Slider', "naturally"),
            'slug' => 'revslider',
            'source' => 'https://ninetheme.com/documentation/plugins/revslider.zip',
            'required' => false
        ),
        array(
            'name' => esc_html__('Naturally Core', "naturally"),
            'slug' => 'naturally-elementor-addons',
            'source' => NATURALLY_DIRECTORY . '/plugins/naturally-elementor-addons.zip',
            'required' => true,
            'version' => '1.3.9'
        )
        // end plugins list
    );

    $config = array(
        'id' => 'tgmpa',
        'default_path' => '',
        'menu' => 'tgmpa-install-plugins',
        'parent_slug' => apply_filters( 'ninetheme_parent_slug', 'themes.php' ),
        'has_notices' => true,
        'dismissable' => true,
        'dismiss_msg' => '',
        'is_automatic' => true,
        'message' => '',
    );

    tgmpa($plugins, $config);

}
add_action('tgmpa_register', 'naturally_register_required_plugins');


/*************************************************
## THEME SETUP WIZARD
    https://github.com/richtabor/MerlinWP
*************************************************/

function naturally_merlin_local_import_files() {
    return array(
        array(
            'import_file_name' => esc_html__( 'Demo Import','naturally' ),
            // XML data
            'local_import_file' => get_parent_theme_file_path( 'inc/core/merlin/demodata/data.xml' ),
            // Widget data
            'local_import_widget_file' => get_parent_theme_file_path( 'inc/core/merlin/demodata/widgets.wie' ),
            // Theme options
            'local_import_redux' => array(
                array(
                    'file_path' => trailingslashit( NATURALLY_DIRECTORY ). 'inc/core/merlin/demodata/redux.json',
                    'option_name' => 'naturally'
                )
            )
        )
    );
}
add_filter( 'merlin_import_files', 'naturally_merlin_local_import_files' );

function naturally_disable_size_images_during_import() {
    add_filter( 'intermediate_image_sizes_advanced', function( $sizes ){
        unset( $sizes['medium'] );
        unset( $sizes['medium_large'] );
        unset( $sizes['large'] );
        unset( $sizes['1536x1536'] );
        unset( $sizes['2048x2048'] );
        unset( $sizes['woocommerce_thumbnail'] );
        unset( $sizes['woocommerce_single'] );
        unset( $sizes['woocommerce_gallery_thumbnail'] );
        unset( $sizes['shop_catalog'] );
        unset( $sizes['shop_single'] );
        unset( $sizes['shop_thumbnail'] );
        return $sizes;
    } );
}
add_action( 'import_start', 'naturally_disable_size_images_during_import');


/**
 * Execute custom code after the whole import has finished.
 */
function naturally_merlin_after_import_setup() {
    // Assign menus to their locations.
    $primary = get_term_by( 'name', 'Header Menu', 'nav_menu' );
    $footer  = get_term_by( 'name', 'Footer Menu', 'nav_menu' );

    wp_update_term_count( $primary->term_id, 'nav_menu', true );
    wp_update_term_count( $footer->term_id, 'nav_menu', true );

    set_theme_mod('nav_menu_locations', array(
        'header_menu' => $primary->term_id,
        'footer_menu' => $footer->term_id
    ));

    update_option( 'show_on_front', 'page' );

    $front_pagequery = new WP_Query(array(
        'post_type' => 'page',
        'title' => 'Home',
    ));
    if ($front_pagequery->have_posts()) {
        $front_pagequery->the_post();
        update_option( 'page_on_front', get_the_ID() );
        wp_reset_postdata();
    }

    $blog_pagequery = new WP_Query(array(
        'post_type' => 'page',
        'title' => 'Blog',
    ));
    if ($blog_pagequery->have_posts()) {
        $blog_pagequery->the_post();
        update_option( 'page_for_posts', get_the_ID() );
        wp_reset_postdata();
    }

    if ( did_action( 'elementor/loaded' ) ) {
        // update some default elementor global settings after setup theme
        $kit_pagequery = new WP_Query(array(
            'post_type' => 'elementor_library',
            'title' => 'Default Kit',
        ));

        if ($kit_pagequery->have_posts()) {
            $kit_pagequery->the_post();
            update_option( 'elementor_active_kit', get_the_ID() );
            wp_reset_postdata();
        }
        // update some default elementor global settings after setup theme
        update_option( 'elementor_cpt_support', ['post','page','projects'] );
        update_option( 'elementor_experiment-e_font_icon_svg', 'active' );
        update_option( 'elementor_experiment-e_dom_optimization', 'active' );
        update_option( 'elementor_experiment-e_optimized_assets_loading', 'active' );
        update_option( 'elementor_experiment-e_optimized_css_loading', 'inactive' );
        update_option( 'elementor_experiment-a11y_improvements', 'active' );
        update_option( 'elementor_experiment-additional_custom_breakpoints', 'active' );
        update_option( 'elementor_experiment-e_import_export', 'active' );
        update_option( 'elementor_experiment-e_hidden_wordpress_widgets', 'active' );
        update_option( 'elementor_experiment-landing-pages', 'inactive' );
        update_option( 'elementor_experiment-elements-color-picker', 'active' );
        update_option( 'elementor_experiment-favorite-widgets', 'active' );
        update_option( 'elementor_experiment-admin-top-bar', 'active' );
        update_option( 'elementor_disable_color_schemes', 'yes' );
        update_option( 'elementor_disable_typography_schemes', 'yes' );
        update_option( 'elementor_global_image_lightbox', 'no' );
        update_option( 'elementor_load_fa4_shim', 'yes' );
    }

    if ( class_exists('woocommerce') ) {

        $cartPage = get_option('woocommerce_cart_page_id');
        $cart_page_data = array(
            'ID' => $cartPage,
            'post_content' => '[woocommerce_cart]'
        );
        wp_update_post( $cart_page_data );

        $checkoutPage = get_option('woocommerce_checkout_page_id');
        $checkout_page_data = array(
            'ID' => $checkoutPage,
            'post_content' => '[woocommerce_checkout]'
        );
        wp_update_post( $checkout_page_data );

        update_option( 'woocommerce_coming_soon', 'no' );
        update_option( 'woocommerce_thumbnail_cropping', 'uncropped' );
        add_action('woocommerce_init', 'naturally_update_product_term_counts', 20);

        if ( defined( 'YITH_WCWL' ) ) {
            update_option( 'yith_wcwl_show_on_loop', 'yes' );
            update_option( 'yith_woocompare_compare_button_in_products_list', 'yes' );
        }
    }
}
add_action( 'merlin_after_all_import', 'naturally_merlin_after_import_setup' );


function naturally_update_product_term_counts() {
    $args = array(
        'post_type'      => 'product',
        'posts_per_page' => 12,
        'post_status'    => 'publish',
        'orderby'        => 'date',
        'order'          => 'DESC',
        'fields'         => 'ids',
    );

    $product_ids = get_posts($args);

    if (empty($product_ids)) {
        return;
    }

    // Taksonomiler için terim sayımlarını güncelle
    $taxonomies = array('product_cat');

    $terms = get_terms(array(
        'taxonomy' => 'product_cat',
        'fields'   => 'ids',
        'hide_empty' => false,
    ));


    if (!is_wp_error($terms) && !empty($terms)) {
        wp_update_term_count_now($terms, $taxonomy);
    }

    if (function_exists('wc_update_product_lookup_tables')) {
        foreach ($product_ids as $product_id) {
            wc_update_product_lookup_tables($product_id);
        }
    }

    wp_cache_flush();
}

add_action('init', 'do_output_buffer'); function do_output_buffer() { ob_start(); }

add_filter( 'woocommerce_prevent_automatic_wizard_redirect', '__return_true' );

add_action( 'admin_init', function() {
    if ( did_action( 'elementor/loaded' ) ) {
        remove_action( 'admin_init', [ \Elementor\Plugin::$instance->admin, 'maybe_redirect_to_getting_started' ] );
    }
}, 1 );
