<?php

    /**
     * ReduxFramework Sample Config File
     * For full documentation, please visit: http://docs.reduxframework.com/
     */

    if (! class_exists('Redux')) {
        return;
    }

    // This is your option name where all the Redux data is stored.
    $naturally_pre = "naturally";

    /**
     * ---> SET ARGUMENTS
     * All the possible arguments for Redux.
     * For full documentation on arguments, please refer to: https://github.com/ReduxFramework/ReduxFramework/wiki/Arguments
     * */

    $naturally_theme = wp_get_theme(); // For use with some settings. Not necessary.

    $naturally_options_args = array(
        // TYPICAL -> Change these values as you need/desire
        'opt_name' => $naturally_pre,
        // This is where your data is stored in the database and also becomes your global variable name.
        'display_name' => $naturally_theme->get('Name'),
        // Name that appears at the top of your panel
        'display_version' => $naturally_theme->get('Version'),
        // Version that appears at the top of your panel
        'menu_type' => 'submenu',
        //Specify if the admin menu should appear or not. Options: menu or submenu (Under appearance only)
        'allow_sub_menu' => false,
        // Show the sections below the admin menu item or not
        'menu_title' => esc_html__('Theme Options', 'naturally'),
        'page_title' => esc_html__('Theme Options', 'naturally'),
        // You will need to generate a Google API key to use this feature.
        // Please visit: https://developers.google.com/fonts/docs/developer_api#Auth
        'google_api_key' => '',
        // Set it you want google fonts to update weekly. A google_api_key value is required.
        'google_update_weekly' => false,
        // Must be defined to add google fonts to the typography module
        'async_typography' => false,
        // Use a asynchronous font on the front end or font string
        'admin_bar' => false,
        // Show the panel pages on the admin bar
        'admin_bar_icon' => 'dashicons-admin-generic',
        // Choose an icon for the admin bar menu
        'admin_bar_priority' => 50,
        // Choose an priority for the admin bar menu
        'global_variable' => 'naturally',
        // Set a different name for your global variable other than the naturally_pre
        'dev_mode' => false,
        // Show the time the page took to load, etc
        'update_notice' => false,
        // If dev_mode is enabled, will notify developer of updated versions available in the GitHub Repo
        'customizer' => true,
        // Enable basic customizer support

        // OPTIONAL -> Give you extra features
        'page_priority' => 99,
        // Order where the menu appears in the admin area. If there is any conflict, something will not show. Warning.
        'page_parent' => 'ninetheme_theme_manage',
        // For a full list of options, visit: http://codex.wordpress.org/Function_Reference/add_submenu_page#Parameters
        'page_permissions' => 'manage_options',
        // Permissions needed to access the options panel.
        'menu_icon' => '',
        // Specify a custom URL to an icon
        'last_tab' => '',
        // Force your panel to always open to a specific tab (by id)
        'page_icon' => 'icon-themes',
        // Icon displayed in the admin panel next to your menu_title
        'page_slug' => '',
        // Page slug used to denote the panel, will be based off page title then menu title then naturally_pre if not provided
        'save_defaults' => true,
        // On load save the defaults to DB before user clicks save or not
        'default_show' => false,
        // If true, shows the default value next to each field that is not the default value.
        'default_mark' => '',
        // What to print by the field's title if the value shown is default. Suggested: *
        'show_import_export' => true,
        // Shows the Import/Export panel when not used as a field.

        // CAREFUL -> These options are for advanced use only
        'transient_time' => 60 * MINUTE_IN_SECONDS,
        'output' => true,
        // Global shut-off for dynamic CSS output by the framework. Will also disable google fonts output
        'output_tag' => true,
        // Allows dynamic CSS to be generated for customizer and google fonts, but stops the dynamic CSS from going to the head

        // FUTURE -> Not in use yet, but reserved or partially implemented. Use at your own risk.
        'database' => '',
        // possible: options, theme_mods, theme_mods_expanded, transient. Not fully functional, warning!
        'use_cdn' => true,
        // If you prefer not to use the CDN for Select2, Ace Editor, and others, you may download the Redux Vendor Support plugin yourself and run locally or embed it in your code.

        // HINTS
        'hints' => array(
            'icon' => 'el el-question-sign',
            'icon_position' => 'right',
            'icon_color' => 'lightgray',
            'icon_size' => 'normal',
            'tip_style' => array(
                'color' => 'dark',
                'shadow' => true,
                'rounded' => false,
                'style' => '',
            ),
            'tip_position' => array(
                'my' => 'top left',
                'at' => 'bottom right',
            ),
            'tip_effect' => array(
                'show' => array(
                    'effect' => 'slide',
                    'duration' => '500',
                    'event' => 'mouseover',
                ),
                'hide' => array(
                    'effect' => 'slide',
                    'duration' => '500',
                    'event' => 'click mouseleave',
                ),
            ),
        )
    );

    // ADMIN BAR LINKS -> Setup custom links in the admin bar menu as external items.
    $naturally_options_args['admin_bar_links'][] = array(
        'id' => 'ninetheme-naturally-docs',
        'href' => 'http://demo-ninetheme.com/naturally/doc.html',
        'title' => esc_html__('naturally Documentation', 'naturally'),
    );
    $naturally_options_args['admin_bar_links'][] = array(
        'id' => 'ninetheme-support',
        'href' => 'https://9theme.ticksy.com/',
        'title' => esc_html__('Support', 'naturally'),
    );
    $naturally_options_args['admin_bar_links'][] = array(
        'id' => 'ninetheme-portfolio',
        'href' => 'https://themeforest.net/user/ninetheme/portfolio',
        'title' => esc_html__('NineTheme Portfolio', 'naturally'),
    );

    // Add content after the form.
    $naturally_options_args['footer_text'] = esc_html__('If you need help please read docs and open a ticket on our support center.', 'naturally');

    Redux::setArgs($naturally_pre, $naturally_options_args);

    /* END ARGUMENTS */

    /* START SECTIONS */

    $el_args = array(
        'post_type'      => 'elementor_library',
        'posts_per_page' => -1,
        'orderby'        => 'title',
        'order'          => 'ASC',
        'tax_query' => array(
            array(
                'taxonomy' => 'elementor_library_type',
                'field'    => 'slug',
                'terms'    => 'section'
            )
        )
    );
    /*************************************************
    ## MAIN SETTING SECTION
    *************************************************/
    Redux::setSection($naturally_pre, array(
        'title' => esc_html__('Main Setting', 'naturally'),
        'id' => 'basic',
        'desc' => esc_html__('These are main settings for general theme!', 'naturally'),
        'customizer_width' => '400px',
        'icon' => 'el el-cog',
    ));
    //BREADCRUMBS SETTINGS SUBSECTION
    Redux::setSection($naturally_pre, array(
        'title' => esc_html__('Theme Color', 'naturally'),
        'id' => 'themebreadcrumbssubsection',
        'icon' => 'el el-brush',
        'subsection' => true,
        'customizer_width' => '450px',
        'fields' => array(
            array(
                'title' => esc_html__('Theme Main Color', 'naturally'),
                'subtitle' => esc_html__('Change theme main color.', 'naturally'),
                'id' => 'theme_main_color',
                'type' => 'color',
                'default' => '#2e3192'
            ),
        )
    ));
    //BREADCRUMBS SETTINGS SUBSECTION
    Redux::setSection($naturally_pre, array(
        'title' => esc_html__('Breadcrumbs', 'naturally'),
        'id' => 'thememaincolorsubsection',
        'icon' => 'el el-brush',
        'subsection' => true,
        'customizer_width' => '450px',
        'fields' => array(
            array(
                'title' => esc_html__('Breadcrumbs', 'naturally'),
                'subtitle' => esc_html__('If enabled, adds breadcrumbs navigation to bottom of page title.', 'naturally'),
                'id' => 'breadcrumbs_visibility',
                'type' => 'switch',
                'default' => true
            ),
            array(
                'title' => esc_html__('Breadcrumbs Typography', 'naturally'),
                'id' => 'breadcrumbs_typo',
                'type' => 'typography',
                'font-backup' => false,
                'letter-spacing' => true,
                'text-transform' => true,
                'all_styles' => true,
                'output' => array( '.nt-breadcrumbs, .nt-breadcrumbs .nt-breadcrumbs-list' ),
                'default' => array(
                    'color' => '',
                    'font-style' => '',
                    'font-family' => '',
                    'google' => true,
                    'font-size' => '',
                    'line-height' => ''
                ),
                'required' => array( 'breadcrumbs_visibility', '=', '1' )
            ),
            array(
                'title' => esc_html__('Breadcrumbs Current Color', 'naturally'),
                'id' => 'breadcrumbs_current',
                'type' => 'color',
                'default' => '#fff',
                'output' => array( '.nt-breadcrumbs .nt-breadcrumbs-list li.active' ),
                'required' => array( 'breadcrumbs_visibility', '=', '1' )
            ),
            array(
                'title' => esc_html__('Breadcrumbs Icon Color', 'naturally'),
                'id' => 'breadcrumbs_icon',
                'type' => 'color',
                'default' => '#fff',
                'output' => array( '.nt-breadcrumbs .nt-breadcrumbs-list i' ),
                'required' => array( 'breadcrumbs_visibility', '=', '1' )
            )
        )
    ));
    //PRELOADER SETTINGS SUBSECTION
    Redux::setSection($naturally_pre, array(
        'title' => esc_html__('Preloader', 'naturally'),
        'id' => 'themepreloadersubsection',
        'icon' => 'el el-brush',
        'subsection' => true,
        'fields' => array(
            array(
                'title' => esc_html__('Preloader', 'naturally'),
                'subtitle' => esc_html__('If enabled, adds preloader.', 'naturally'),
                'id' => 'preloader_visibility',
                'type' => 'switch',
                'default' => true
            ),
            array(
                'title' => esc_html__('Preloader Type', 'naturally'),
                'subtitle' => esc_html__('Select your site preloader type.', 'naturally'),
                'id' => 'pre_type',
                'type' => 'select',
                'customizer' => true,
                'options' => array(
                    '01' => esc_html__('Type 1', 'naturally'),
                    '02' => esc_html__('Type 2', 'naturally'),
                    '03' => esc_html__('Type 3', 'naturally'),
                    '04' => esc_html__('Type 4', 'naturally'),
                    '05' => esc_html__('Type 5', 'naturally'),
                    '06' => esc_html__('Type 6', 'naturally'),
                    '07' => esc_html__('Type 7', 'naturally'),
                    '08' => esc_html__('Type 8', 'naturally'),
                    '09' => esc_html__('Type 9', 'naturally'),
                    '10' => esc_html__('Type 10', 'naturally'),
                    '11' => esc_html__('Type 11', 'naturally'),
                    '12' => esc_html__('Type 12', 'naturally'),
                    'custom' => esc_html__('Custom Gif Image ', 'naturally')
                ),
                'default' => '01',
                'required' => array( 'preloader_visibility', '=', '1' )
            ),
            array(
                'title' => esc_html__('Custom preloder image', 'naturally'),
                'subtitle' => esc_html__('Upload your custom preloder image.', 'naturally'),
                'id' => 'pre_custom_img',
                'type' => 'media',
                'url' => true,
                'customizer' => true,
                'required' => array(
                    array( 'preloader_visibility', '=', '1' ),
                    array( 'pre_type', '=', 'custom' )
                ),
            ),
            array(
                'title' => esc_html__('Preloader Background Color', 'naturally'),
                'subtitle' => esc_html__('Add preloader background color.', 'naturally'),
                'id' => 'pre_bg',
                'type' => 'color',
                'default' => '#fff',
                'required' => array(
                    array( 'preloader_visibility', '=', '1' )
                ),
            ),
            array(
                'title' => esc_html__('Preloader Spin Color', 'naturally'),
                'subtitle' => esc_html__('Add preloader spin color.', 'naturally'),
                'id' => 'pre_spin',
                'type' => 'color',
                'default' => '#0d73fc',
                'required' => array(
                    array( 'preloader_visibility', '=', '1' ),
                    array( 'pre_type', '!=', 'custom' )
                )
            )
        )
    ));
    //BREADCRUMBS SETTINGS SUBSECTION
    Redux::setSection($naturally_pre, array(
        'title' => esc_html__('Gutenberg Editor', 'naturally'),
        'id' => 'themegutenbergsubsection',
        'icon' => 'el el-brush',
        'subsection' => true,
        'customizer_width' => '450px',
        'fields' => array(
            array(
                'title' => esc_html__('Gutenberg Editor', 'naturally'),
                'subtitle' => esc_html__( 'This theme does not support gutenberg so some css files are filtered, if you want to use gutenberg you can use this option', 'naturally' ),
                'id' => 'open_gutenberg',
                'type' => 'switch',
                'default' => 0
            ),
        )
    ));
    //MAIN THEME TYPOGRAPHY SUBSECTION
    Redux::setSection($naturally_pre, array(
    'title' => esc_html__('Typograhy General', 'naturally'),
    'id' => 'themetypographysection',
    'icon' => 'el el-fontsize',
    'subsection' => true,
    'fields' => array(
        array(
            'title' => esc_html__('H1 Headings', 'naturally'),
            'subtitle' => esc_html__("Choose Size and Style for h1", 'naturally'),
            'id' => 'font_h1',
            'type' => 'typography',
            'font-backup' => false,
            'letter-spacing' => true,
            'text-transform' => true,
            'all_styles' => true,
            'output' => array( 'h1' ),
            'default' => array(
                'color' => '',
                'font-style' => '',
                'font-family' => '',
                'google' => true,
                'font-size' => '',
                'line-height' => ''
            )
        ),
        array(
            'title' => esc_html__('H2 Headings', 'naturally'),
            'subtitle' => esc_html__("Choose Size and Style for h2", 'naturally'),
            'id' => 'font_h2',
            'type' => 'typography',
            'font-backup' => false,
            'letter-spacing' => true,
            'text-transform' => true,
            'all_styles' => true,
            'output' => array( 'h2' ),
            'default' => array(
                'color' => '',
                'font-style' => '',
                'font-family' => '',
                'google' => true,
                'font-size' => '',
                'line-height' => ''
            )
        ),
        array(
            'title' => esc_html__('H3 Headings', 'naturally'),
            'subtitle' => esc_html__("Choose Size and Style for h3", 'naturally'),
            'id' => 'font_h3',
            'type' => 'typography',
            'font-backup' => false,
            'letter-spacing' => true,
            'text-transform' => true,
            'all_styles' => true,
            'output' => array( 'h3' ),
            'default' => array(
                'color' => '',
                'font-style' => '',
                'font-family' => '',
                'google' => true,
                'font-size' => '',
                'line-height' => ''
            )
        ),
        array(
            'title' => esc_html__('H4 Headings', 'naturally'),
            'subtitle' => esc_html__("Choose Size and Style for h4", 'naturally'),
            'id' => 'font_h4',
            'type' => 'typography',
            'font-backup' => false,
            'letter-spacing' => true,
            'text-transform' => true,
            'all_styles' => true,
            'output' => array( 'h4' ),
            'default' => array(
                'color' => '',
                'font-style' => '',
                'font-family' => '',
                'google' => true,
                'font-size' => '',
                'line-height' => ''
            )
        ),
        array(
            'title' => esc_html__('H5 Headings', 'naturally'),
            'subtitle' => esc_html__("Choose Size and Style for h5", 'naturally'),
            'id' => 'font_h5',
            'type' => 'typography',
            'font-backup' => false,
            'letter-spacing' => true,
            'text-transform' => true,
            'all_styles' => true,
            'output' => array( 'h5' ),
            'default' => array(
                'color' => '',
                'font-style' => '',
                'font-family' => '',
                'google' => true,
                'font-size' => '',
                'line-height' => ''
            )
        ),
        array(
            'title' => esc_html__('H6 Headings', 'naturally'),
            'subtitle' => esc_html__("Choose Size and Style for h6", 'naturally'),
            'id' => 'font_h6',
            'type' => 'typography',
            'font-backup' => false,
            'letter-spacing' => true,
            'text-transform' => true,
            'all_styles' => true,
            'output' => array( 'h6' ),
            'units' => 'px',
            'default' => array(
                'color' => '',
                'font-style' => '',
                'font-family' => '',
                'google' => true,
                'font-size' => '',
                'line-height' => ''
            )
        ),
        array(
            'id' =>'info_body_font',
            'type' => 'info',
            'customizer' => false,
            'desc' => esc_html__('Body Font Options', 'naturally')
        ),
        array(
            'title' => esc_html__('Paragraph', 'naturally'),
            'subtitle' => esc_html__("Choose Size and Style for paragraph", 'naturally'),
            'id' => 'font_p',
            'type' => 'typography',
            'font-backup' => false,
            'letter-spacing' => true,
            'text-transform' => true,
            'all_styles' => true,
            'output' => array( 'p' ),
            'default' => array(
                'font-family' =>'',
                'color' =>"",
                'font-style' =>'',
                'font-size' =>'',
                'line-height' =>''
            )
        ),
        array(
            'title' => esc_html__('Link (a)', 'naturally'),
            'subtitle' => esc_html__("Choose Size and Style for paragraph", 'naturally'),
            'id' => 'font_a',
            'type' => 'typography',
            'font-backup' => false,
            'letter-spacing' => true,
            'text-transform' => true,
            'all_styles' => true,
            'output' => array( 'a' ),
            'default' => array(
                'font-family' =>'',
                'color' =>"",
                'font-style' =>'',
                'font-size' =>'',
                'line-height' =>''
            )
        )
    )));
    //BACKTOTOP BUTTON SUBSECTION
    Redux::setSection($naturally_pre, array(
    'title' => esc_html__('Back-to-top Button', 'naturally'),
    'id' => 'backtotop',
    'icon' => 'el el-brush',
    'subsection' => true,
    'fields' => array(
        array(
            'title' => esc_html__('Back-to-top', 'naturally'),
            'subtitle' => esc_html__('Switch On-off', 'naturally'),
            'desc' => esc_html__('If enabled, adds preloader.', 'naturally'),
            'id' => 'backtotop_visibility',
            'type' => 'switch',
            'default' => true
        ),
        array(
            'title' => esc_html__('Top Offset', 'naturally'),
            'subtitle' => esc_html__('Set custom top offset for the back-to-top button', 'naturally'),
            'desc' => esc_html__('If enabled, adds preloader.', 'naturally'),
            'id' => 'backtotop_offset',
            'type' => 'slider',
            'default' => 800,
            'min' => 10,
            'step' => 1,
            'max'=> 2000,
            'required' => array( 'backtotop_visibility', '=', '1' )
        ),
        array(
            'title' => esc_html__('Back-to-top Background', 'naturally'),
            'id' => 'backtotop_bg',
            'type' => 'color',
            'mode' => 'background',
            'output' => array( '.back-top' ),
            'default' =>  '#045fa0',
            'required' => array( 'backtotop_visibility', '=', '1' )
        ),
        array(
            'title' => esc_html__('Hover Back-to-top Background', 'naturally'),
            'id' => 'backtotop_hbg',
            'type' => 'color',
            'mode' => 'background',
            'output' => array( '.back-top:hover' ),
            'default' =>  '#045fa0',
            'required' => array( 'backtotop_visibility', '=', '1' )
        ),
        array(
            'title' => esc_html__('Back-to-top Icon Color', 'naturally'),
            'id' => 'backtotop_icon',
            'type' => 'color',
            'mode' => 'color',
            'output' => array( '.back-top' ),
            'default' =>  '',
            'required' => array( 'backtotop_visibility', '=', '1' )
        ),
        array(
            'title' => esc_html__('Hover Back-to-top Icon Color', 'naturally'),
            'id' => 'backtotop_hvricon',
            'type' => 'color',
            'mode' => 'color',
            'output' => array( '.back-top:hover' ),
            'default' =>  '',
            'required' => array( 'backtotop_visibility', '=', '1' )
        ),
    )));

    // THEME PAGINATION SUBSECTION
    Redux::setSection($naturally_pre, array(
    'title' => esc_html__('Pagination', 'naturally'),
    'desc' => esc_html__('These are main settings for general theme!', 'naturally'),
    'id' => 'pagination',
    'subsection' => true,
    'icon' => 'el el-link',
    'fields' => array(
        array(
            'title' => esc_html__('Pagination', 'naturally'),
            'subtitle' => esc_html__('Switch On-off', 'naturally'),
            'desc' => esc_html__('If enabled, adds pagination.', 'naturally'),
            'id' => 'pagination_visibility',
            'type' => 'switch',
            'default' => true
        ),
        array(
            'title' => esc_html__('Pagination Type', 'naturally'),
            'subtitle' => esc_html__('Select type.', 'naturally'),
            'id' => 'pag_type',
            'type' => 'select',
            'customizer' => true,
            'options' => array(
                'default' => esc_html__('Default', 'naturally'),
                'outline' => esc_html__('Outline', 'naturally')
            ),
            'default' => 'outline',
            'required' => array( 'pagination_visibility', '=', '1' )
        ),
        array(
            'title' => esc_html__('Pagination size', 'naturally'),
            'subtitle' => esc_html__('Select size.', 'naturally'),
            'id' => 'pag_size',
            'type' => 'select',
            'customizer' => true,
            'options' => array(
                'small' => esc_html__('small', 'naturally'),
                'medium' => esc_html__('medium', 'naturally'),
                'large' => esc_html__('large', 'naturally')
            ),
            'default' => 'medium',
            'required' => array( 'pagination_visibility', '=', '1' )
        ),
        array(
            'title' => esc_html__('Pagination group', 'naturally'),
            'subtitle' => esc_html__('Select group.', 'naturally'),
            'id' => 'pag_group',
            'type' => 'select',
            'customizer' => true,
            'options' => array(
                'yes' => esc_html__('Yes', 'naturally'),
                'no' => esc_html__('No', 'naturally')
            ),
            'default' => 'no',
            'required' => array( 'pagination_visibility', '=', '1' )
        ),
        array(
            'title' => esc_html__('Pagination corner', 'naturally'),
            'subtitle' => esc_html__('Select corner type.', 'naturally'),
            'id' => 'pag_corner',
            'type' => 'select',
            'customizer' => true,
            'options' => array(
                'square' => esc_html__('square', 'naturally'),
                'rounded' => esc_html__('rounded', 'naturally'),
                'circle' => esc_html__('circle', 'naturally')
            ),
            'default' => 'circle',
            'required' => array( 'pagination_visibility', '=', '1' )
        ),
        array(
            'title' => esc_html__('Pagination align', 'naturally'),
            'subtitle' => esc_html__('Select align.', 'naturally'),
            'id' => 'pag_align',
            'type' => 'select',
            'customizer' => true,
            'options' => array(
                'left' => esc_html__('left', 'naturally'),
                'right' => esc_html__('right', 'naturally'),
                'center' => esc_html__('center', 'naturally')
            ),
            'default' => 'center',
            'required' => array( 'pagination_visibility', '=', '1' )
        ),
        array(
            'title' => esc_html__('Pagination default/outline color', 'naturally'),
            'id' => 'pag_clr',
            'type' => 'color',
            'mode' => 'color',
            'required' => array( 'pagination_visibility', '=', '1' )
        ),
        array(
            'title' => esc_html__('Active and Hover pagination color', 'naturally'),
            'id' => 'pag_hvrclr',
            'type' => 'color',
            'mode' => 'color',
            'required' => array( 'pagination_visibility', '=', '1' )
        ),
        array(
            'title' => esc_html__('Pagination number color', 'naturally'),
            'id' => 'pag_nclr',
            'type' => 'color',
            'mode' => 'color',
            'required' => array( 'pagination_visibility', '=', '1' )
        ),
        array(
            'title' => esc_html__('Active and Hover pagination number color', 'naturally'),
            'id' => 'pag_hvrnclr',
            'type' => 'color',
            'mode' => 'color',
            'required' => array( 'pagination_visibility', '=', '1' )
        )
    )));

    /*************************************************
    ## LOGO SECTION
    *************************************************/
    Redux::setSection($naturally_pre, array(
        'title' => esc_html__('Logo', 'naturally'),
        'id' => 'logosections',
        'icon' => 'el el-star-empty',
    ));
    Redux::setSection($naturally_pre, array(
        'title' => esc_html__('Logo Static', 'naturally'),
        'desc' => esc_html__('These are main settings for general theme!', 'naturally'),
        'id' => 'logosection',
        'customizer_width' => '400px',
        'subsection' => true,
        'icon' => 'el el-brush',

        'fields' => array(
            array(
                'title' => esc_html__('Logo Switch', 'naturally'),
                'subtitle' => esc_html__('You can select logo on or off.', 'naturally'),
                'id' => 'logo_visibility',
                'type' => 'switch',
                'default' => true
            ),
            array(
                'title' => esc_html__('Logo Type', 'naturally'),
                'subtitle' => esc_html__('Select your logo type.', 'naturally'),
                'id' => 'logo_type',
                'type' => 'select',
                'customizer' => true,
                'options' => array(
                    'img' => esc_html__('Image Logo', 'naturally'),
                    'sitename' => esc_html__('Site Name', 'naturally'),
                    'customtext' => esc_html__('Custom HTML', 'naturally')
                ),
                'default' => 'sitename',
                'required' => array( 'logo_visibility', '=', '1' )
            ),
            array(
                'title' => esc_html__('Custom text for logo', 'naturally'),
                'desc' => esc_html__('Text entered here will be used as logo', 'naturally'),
                'id' => 'text_logo',
                'type' => 'editor',
                'args'   => array(
                    'teeny' => false,
                    'textarea_rows' => 10
                ),
                'required' => array(
                    array( 'logo_visibility', '=', '1' ),
                    array( 'logo_type', '=', 'customtext' )
                ),
            ),
            array(
                'title' => esc_html__('Sitename or Custom Text Logo Font', 'naturally'),
                'desc' => esc_html__("Choose size and style your sitename, if you don't use an image logo.", 'naturally'),
                'id' =>'logo_style',
                'type' => 'typography',
                'font-family' => true,
                'google' => true, // Disable google fonts. Won't work if you haven't defined your google api key
                'font-backup' => false, // Select a backup non-google font in addition to a google font
                'font-style' => true, // Includes font-style and weight. Can use font-style or font-weight to declare
                'subsets' => true, // Only appears if google is true and subsets not set to false
                'font-size' => true,
                'line-height' => true,
                'text-transform' => true,
                'text-align' => false,
                'customizer' => true,
                'color' => true,
                'preview' => true, // Disable the previewer
                'output' => array('#nt-logo.logo-type-customtext, #nt-logo.logo-type-sitename'),
                'default' => array(
                    'font-family' =>'',
                    'color' =>"",
                    'font-style' =>'',
                    'font-size' =>'',
                    'line-height' =>''
                ),
                'required' => array(
                    array( 'logo_visibility', '=', '1' ),
                    array( 'logo_type', '!=', 'img' )
                )
            ),
            array(
                'title' => esc_html__('Hover Text Logo Color', 'naturally'),
                'desc' => esc_html__('Set your own hover color for the text logo.', 'naturally'),
                'id' => 'text_logo_hvr',
                'type' => 'color',
                'output' => array( '#nt-logo.logo-type-customtext:hover, #nt-logo.logo-type-sitename:hover' ),
                'required' => array(
                    array( 'logo_visibility', '=', '1' ),
                    array( 'logo_type', '!=', 'img' )
                )
            ),
            array(
                'title' => esc_html__('Logo image', 'naturally'),
                'subtitle' => esc_html__('Upload your Logo. If left blank theme will use site default logo.', 'naturally'),
                'id' => 'img_logo',
                'type' => 'media',
                'url' => true,
                'customizer' => true,
                'required' => array(
                    array( 'logo_visibility', '=', '1' ),
                    array( 'logo_type', '=', 'img' ),
                    array( 'logo_type', '!=', '' )
                )
            ),
            array(
                'title' => esc_html__('Logo Dimensions', 'naturally'),
                'subtitle' => esc_html__('Set the logo width and height of the image.', 'naturally'),
                'id' => 'img_logo_dimensions',
                'type' => 'dimensions',
                'customizer' => true,
                'output' => array('#nt-logo img'),
                'required' => array(
                    array( 'logo_visibility', '=', '1' ),
                    array( 'logo_type', '!=', '' )
                )
            ),
    )));
    Redux::setSection($naturally_pre, array(
        'title' => esc_html__('Logo Sticky', 'naturally'),
        'desc' => esc_html__('These are main settings for general theme!', 'naturally'),
        'id' => 'logosectionsticky',
        'customizer_width' => '400px',
        'subsection' => true,
        'icon' => 'el el-brush',

        'fields' => array(
            array(
                'title' => esc_html__('Sticky Logo Switch', 'naturally'),
                'subtitle' => esc_html__('You can select logo on or off.', 'naturally'),
                'id' => 'slogo_visibility',
                'default' =>0,
                'type' => 'switch',
                'default' => true
            ),
            array(
                'title' => esc_html__('Sticky Logo Type', 'naturally'),
                'subtitle' => esc_html__('Select your logo type.', 'naturally'),
                'id' => 'slogo_type',
                'type' => 'select',
                'customizer' => true,
                'options' => array(
                    'img' => esc_html__('Image Logo', 'naturally'),
                    'sitename' => esc_html__('Site Name', 'naturally'),
                    'customtext' => esc_html__('Custom HTML', 'naturally')
                ),
                'default' => 'sitename',
                'required' => array( 'slogo_visibility', '=', '1' )
            ),
            array(
                'title' => esc_html__('Custom text for sticky logo', 'naturally'),
                'desc' => esc_html__('Text entered here will be used as logo', 'naturally'),
                'id' => 'stext_logo',
                'type' => 'editor',
                'args'   => array(
                    'teeny' => false,
                    'textarea_rows' => 10
                ),
                'required' => array(
                    array( 'slogo_visibility', '=', '1' ),
                    array( 'slogo_type', '=', 'customtext' )
                ),
            ),
            array(
                'title' => esc_html__('Sitename or Custom Text Sticky Logo Font', 'naturally'),
                'desc' => esc_html__("Choose size and style your sitename, if you don't use an image logo.", 'naturally'),
                'id' =>'slogo_style',
                'type' => 'typography',
                'font-family' => true,
                'google' => true, // Disable google fonts. Won't work if you haven't defined your google api key
                'font-backup' => false, // Select a backup non-google font in addition to a google font
                'font-style' => true, // Includes font-style and weight. Can use font-style or font-weight to declare
                'subsets' => true, // Only appears if google is true and subsets not set to false
                'font-size' => true,
                'line-height' => true,
                'text-transform' => true,
                'text-align' => false,
                'customizer' => true,
                'color' => true,
                'preview' => true, // Disable the previewer
                'output' => array('#nt-logo.sticky-logo.logo-type-customtext, #nt-logo.sticky-logo.logo-type-sitename'),
                'default' => array(
                    'font-family' =>'',
                    'color' =>"",
                    'font-style' =>'',
                    'font-size' =>'',
                    'line-height' =>''
                ),
                'required' => array(
                    array( 'slogo_visibility', '=', '1' ),
                    array( 'slogo_type', '!=', 'img' )
                )
            ),
            array(
                'title' => esc_html__('Hover Text Sticky Logo Color', 'naturally'),
                'desc' => esc_html__('Set your own hover color for the text logo.', 'naturally'),
                'id' => 'stext_logo_hvr',
                'type' => 'color',
                'output' => array( '#nt-logo.sticky-logo.logo-type-customtext:hover, #nt-logo.sticky-logo.logo-type-sitename:hover' ),
                'required' => array(
                    array( 'slogo_visibility', '=', '1' ),
                    array( 'slogo_type', '!=', 'img' )
                )
            ),
            array(
                'title' => esc_html__('Sticky Logo image', 'naturally'),
                'subtitle' => esc_html__('Upload your Logo. If left blank theme will use site default logo.', 'naturally'),
                'id' => 'simg_logo',
                'type' => 'media',
                'url' => true,
                'customizer' => true,
                'required' => array(
                    array( 'slogo_visibility', '=', '1' ),
                    array( 'slogo_type', '=', 'img' ),
                    array( 'slogo_type', '!=', '' )
                )
            ),
            array(
                'title' => esc_html__('Sticky Logo Dimensions', 'naturally'),
                'subtitle' => esc_html__('Set the logo width and height of the image.', 'naturally'),
                'id' => 'simg_logo_dimensions',
                'type' => 'dimensions',
                'customizer' => true,
                'output' => array('#nt-logo.sticky-logo img'),
                'required' => array(
                    array( 'slogo_visibility', '=', '1' ),
                    array( 'slogo_type', '!=', '' )
                )
            ),
    )));
    /*************************************************
    ## HEADER & NAV SECTION
    *************************************************/
    Redux::setSection($naturally_pre, array(
        'title' => esc_html__('Header', 'naturally'),
        'id' => 'headersection',
        'icon' => 'fa fa-bars',
    ));
    //HEADER MENU
    Redux::setSection($naturally_pre, array(
        'title' => esc_html__('General', 'naturally'),
        'id' => 'headernavgeneralsection',
        'subsection' => true,
        'icon' => 'fa fa-cog',
        'fields' => array(
            array(
                'title' => esc_html__('Header Display', 'naturally'),
                'subtitle' => esc_html__('You can enable or disable the site navigation.', 'naturally'),
                'id' => 'nav_visibility',
                'type' => 'switch',
                'default' => 1,
                'on' => 'On',
                'off' => 'Off'
            ),
            array(
                'title' => esc_html__('Header Template?', 'naturally'),
                'subtitle' => esc_html__('Select the elementor template if you want to use the custom elementor header instead of the theme default header.', 'naturally'),
                'id' => 'site_header_template',
                'type' => 'select',
                'customizer' => true,
                'options' => array(
                    'default' => esc_html__('Deafult Site Header', 'naturally'),
                    'elementor' => esc_html__('Elementor Templates', 'naturally'),
                ),
                'default' => 'default',
                'required' => array( 'nav_visibility', '=', '1' )
            ),
            array(
                'title' => esc_html__('Elementor Templates', 'naturally'),
                'subtitle' => esc_html__('Select a template from elementor templates.', 'naturally'),
                'id' => 'header_elementor_templates',
                'type' => 'select',
                'customizer' => true,
                'options' => naturally_get_elementorTemplates(),
                'required' => array(
                    array( 'nav_visibility', '=', '1' ),
                    array( 'site_header_template', '=', 'elementor' )
                ),
            ),
            array(
                'title' => esc_html__('Header Background Type', 'naturally'),
                'id' => 'nav_type',
                'type' => 'select',
                'options'  => array(
                    'default' => esc_html__('Solid', 'naturally'),
                    'is-overlay' => esc_html__('Transparent', 'naturally'),
                ),
                'default' => 'default',
                'required' => array(
                    array( 'nav_visibility', '=', '1' ),
                    array( 'site_header_template', '=', 'default' )
                ),
            ),
            array(
                'title' => esc_html__('Header Search Type', 'naturally'),
                'subtitle' => esc_html__('Select your search type.', 'naturally'),
                'id' => 'header_search_type',
                'type' => 'select',
                'customizer' => true,
                'options' => array(
                    'default' => esc_html__('Default', 'naturally'),
                    'product' => esc_html__('Product', 'naturally'),
                ),
                'default' => 'default',
            ),
            //information on-off
            array(
                'id' =>'info_nav0',
                'type' => 'info',
                'style' => 'success',
                'title' => esc_html__('Success!', 'naturally'),
                'icon' => 'el el-info-circle',
                'customizer' => false,
                'desc' => sprintf(esc_html__('%s is disabled on the site. Please activate to view options.', 'naturally'), '<b>Navigation</b>'),
                'required' => array( 'nav_visibility', '=', '0' )
            )
    )));
    //HEADER MENU
    Redux::setSection($naturally_pre, array(
        'title' => esc_html__('Header Topbar', 'naturally'),
        'id' => 'headertopbarsubsection',
        'subsection' => true,
        'icon' => 'fa fa-cog',
        'fields' => array(
            array(
                'title' => esc_html__('Header Topbar Display', 'naturally'),
                'subtitle' => esc_html__('You can enable or disable the site header topbar.', 'naturally'),
                'id' => 'header_topbar_visibility',
                'type' => 'switch',
                'default' => 0,
                'on' => 'On',
                'off' => 'Off',
                'required' => array(
                    array( 'nav_visibility', '=', '1' ),
                    array( 'site_header_template', '=', 'default' )
                ),
            ),
            array(
                'title' => esc_html__('Header Phone Number', 'naturally'),
                'subtitle' => esc_html__('Add your phone number here.', 'naturally'),
                'id' => 'header_topbar_phone',
                'type' => 'text',
                'default' => '+1-800-123-45-67',
                'required' => array(
                    array( 'nav_visibility', '=', '1' ),
                    array( 'site_header_template', '=', 'default' ),
                    array( 'header_topbar_visibility', '=', '1' )
                ),
            ),
            array(
                'title' => esc_html__('Header Search Display', 'naturally'),
                'subtitle' => esc_html__('You can enable or disable the site header search form.', 'naturally'),
                'id' => 'header_search_visibility',
                'type' => 'switch',
                'default' => 0,
                'on' => 'On',
                'off' => 'Off',
                'required' => array(
                    array( 'nav_visibility', '=', '1' ),
                    array( 'site_header_template', '=', 'default' ),
                    array( 'header_topbar_visibility', '=', '1' )
                ),
            ),
            array(
                'title' => esc_html__('Header Account Display', 'naturally'),
                'subtitle' => esc_html__('You can enable or disable the site header account.', 'naturally'),
                'id' => 'header_account_visibility',
                'type' => 'switch',
                'default' => 0,
                'on' => 'On',
                'off' => 'Off',
                'required' => array(
                    array( 'nav_visibility', '=', '1' ),
                    array( 'site_header_template', '=', 'default' ),
                    array( 'header_topbar_visibility', '=', '1' )
                ),
            ),
            array(
                'title' => esc_html__('Header Minicart Display', 'naturally'),
                'subtitle' => esc_html__('You can enable or disable header minicart.', 'naturally'),
                'id' => 'header_minicart_visibility',
                'type' => 'switch',
                'default' => true,
                'required' => array(
                    array( 'nav_visibility', '=', '1' ),
                    array( 'site_header_template', '=', 'default' ),
                )
            ),
            array(
                'title' => esc_html__('Wishlist Button Display', 'naturally'),
                'subtitle' => esc_html__('You can enable or disable yith wishlist button.', 'naturally'),
                'id' => 'wishlist_btn_visibility',
                'type' => 'switch',
                'default' => false,
                'required' => array(
                    array( 'nav_visibility', '=', '1' ),
                    array( 'site_header_template', '=', 'default' ),
                )
            ),
            array(
                'title' => esc_html__('Header Language Display', 'naturally'),
                'subtitle' => esc_html__('You can enable or disable the site header language.', 'naturally'),
                'id' => 'nav_lang_visibility',
                'type' => 'switch',
                'default' => 1,
                'on' => 'On',
                'off' => 'Off',
                'required' => array(
                    array( 'nav_visibility', '=', '1' ),
                    array( 'site_header_template', '=', 'default' ),
                    array( 'header_topbar_visibility', '=', '1' )
                ),
            ),
            array(
                'title' => esc_html__('Language Type', 'naturally'),
                'subtitle' => esc_html__('Select your language type.', 'naturally'),
                'id' => 'lang_type',
                'type' => 'select',
                'customizer' => true,
                'options' => array(
                    'default' => esc_html__('Deafult', 'naturally'),
                    'polylang' => esc_html__('Polylang Plugin', 'naturally'),
                ),
                'default' => 'default',
                'required' => array(
                    array( 'nav_visibility', '=', '1' ),
                    array( 'site_header_template', '=', 'default' ),
                    array( 'header_topbar_visibility', '=', '1' ),
                    array( 'nav_lang_visibility', '=', '1' )
                )
            ),
            array(
                'title' => esc_html__('First Lang Item', 'naturally'),
                'subtitle' => esc_html__('Add first lang item.', 'naturally'),
                'id' => 'header_first_lang_item',
                'type' => 'text',
                'default' => 'English',
                'required' => array(
                    array( 'nav_visibility', '=', '1' ),
                    array( 'site_header_template', '=', 'default' ),
                    array( 'header_topbar_visibility', '=', '1' ),
                    array( 'nav_lang_visibility', '=', '1' ),
                    array( 'lang_type', '=', 'default' )
                )
            ),
            array(
                'title' => esc_html__('Header Language', 'naturally'),
                'subtitle' => esc_html__('Create header language list', 'naturally'),
                'id' => 'header_lang',
                'type' => 'nt_multi_field',
                'add_text' => esc_html__('Add Language', 'naturally'),
                'add_number' => 1,
                'class' => 'block',
                'placeholder'=> array(
                    'lang name',
                    'flag image URL',
                    'page link'
                ),
                'show_empty'=> false,
                'required' => array(
                    array( 'nav_visibility', '=', '1' ),
                    array( 'site_header_template', '=', 'default' ),
                    array( 'header_topbar_visibility', '=', '1' ),
                    array( 'nav_lang_visibility', '=', '1' ),
                    array( 'lang_type', '=', 'default' )
                )
            ),
            array(
                'title' => esc_html__('Phone Color', 'naturally'),
                'desc' => esc_html__('Please select phone text color.', 'naturally'),
                'id' => 'nav_p_c',
                'type' => 'color',
                'output' => array( '.header_container .header_phone' ),
                'required' => array(
                    array( 'nav_visibility', '=', '1' ),
                    array( 'site_header_template', '=', 'default' ),
                    array( 'header_topbar_visibility', '=', '1' )
                )
            ),
            array(
                'title' => esc_html__('Phone Hover Color', 'naturally'),
                'desc' => esc_html__('Please select phone text hover color.', 'naturally'),
                'id' => 'nav_p_hc',
                'type' => 'color',
                'output' => array( '.header_container .header_phone:hover' ),
                'required' => array(
                    array( 'nav_visibility', '=', '1' ),
                    array( 'site_header_template', '=', 'default' ),
                    array( 'header_topbar_visibility', '=', '1' )
                )
            ),
            array(
                'title' => esc_html__('Search Color', 'naturally'),
                'desc' => esc_html__('Please select search hover color.', 'naturally'),
                'id' => 'nav_s_c',
                'type' => 'color',
                'output' => array( '.header_container .header_search_open' ),
                'required' => array(
                    array( 'nav_visibility', '=', '1' ),
                    array( 'site_header_template', '=', 'default' ),
                    array( 'header_topbar_visibility', '=', '1' )
                )
            ),
            array(
                'title' => esc_html__('Search Hover Color', 'naturally'),
                'desc' => esc_html__('Please select search hover color.', 'naturally'),
                'id' => 'nav_s_hc',
                'type' => 'color',
                'output' => array( '.header_container .header_search_open:hover' ),
                'required' => array(
                    array( 'nav_visibility', '=', '1' ),
                    array( 'site_header_template', '=', 'default' ),
                    array( 'header_topbar_visibility', '=', '1' )
                )
            ),
            array(
                'title' => esc_html__('Account Color', 'naturally'),
                'desc' => esc_html__('Please select account hover color.', 'naturally'),
                'id' => 'nav_a_c',
                'type' => 'color',
                'output' => array( '.header_container .account-item' ),
                'required' => array(
                    array( 'nav_visibility', '=', '1' ),
                    array( 'site_header_template', '=', 'default' ),
                    array( 'header_topbar_visibility', '=', '1' )
                )
            ),
            array(
                'title' => esc_html__('Account Hover Color', 'naturally'),
                'desc' => esc_html__('Please select account hover color.', 'naturally'),
                'id' => 'nav_a_hc',
                'type' => 'color',
                'output' => array( '.header_container .account-item:hover' ),
                'required' => array(
                    array( 'nav_visibility', '=', '1' ),
                    array( 'site_header_template', '=', 'default' ),
                    array( 'header_topbar_visibility', '=', '1' )
                )
            ),
            array(
                'title' => esc_html__('Language Color', 'naturally'),
                'desc' => esc_html__('Please select language hover color.', 'naturally'),
                'id' => 'nav_l_c',
                'type' => 'color',
                'output' => array( '.header_container .header_lang_label' ),
                'required' => array(
                    array( 'nav_visibility', '=', '1' ),
                    array( 'site_header_template', '=', 'default' ),
                    array( 'header_topbar_visibility', '=', '1' )
                )
            ),
            array(
                'title' => esc_html__('Language Hover Color', 'naturally'),
                'desc' => esc_html__('Please select language hover color.', 'naturally'),
                'id' => 'nav_l_hc',
                'type' => 'color',
                'output' => array( '.header_container .header_lang_label:hover' ),
                'required' => array(
                    array( 'nav_visibility', '=', '1' ),
                    array( 'site_header_template', '=', 'default' ),
                    array( 'header_topbar_visibility', '=', '1' )
                )
            ),
            //information on-off
            array(
                'id' =>'info_nav10',
                'type' => 'info',
                'style' => 'success',
                'title' => esc_html__('Success!', 'naturally'),
                'icon' => 'el el-info-circle',
                'customizer' => false,
                'desc' => sprintf(esc_html__('%s is disabled on the site. Please activate to view options.', 'naturally'), '<b>Header Topbar</b>'),
                'required' => array(
                    array( 'nav_visibility', '=', '0' ),
                    array( 'header_topbar_visibility', '=', '0' )
                )
            )
    )));
    //HEADER MENU
    Redux::setSection($naturally_pre, array(
        'title' => esc_html__('Static Header Menu', 'naturally'),
        'id' => 'headernavsubsection',
        'subsection' => true,
        'icon' => 'el el-brush',
        'fields' => array(
            array(
                'title' => esc_html__('Header Background Color', 'naturally'),
                'id' => 'nav_bg',
                'type' => 'color_rgba',
                'mode' => 'background',
                'output' => array( 'div.header' ),
                'required' => array(
                    array( 'nav_visibility', '=', '1' ),
                    array( 'site_header_template', '=', 'default' )
                )
            ),
            array(
                'title' => esc_html__('Header Top and Bottom Spacing', 'naturally'),
                'id' => 'header_pad',
                'type' => 'spacing',
                'mode' => 'padding',
                'all' => false,
                'left' => false,
                'right' => false,
                'units' => array( 'em', 'px', '%' ),
                'units_extended' => 'true',
                'output' => array( '.header_container' )
            ),
            array(
                'title' => esc_html__('Menu Item Font and Color', 'naturally'),
                'subtitle' => esc_html__("Choose Size and Style for primary menu", 'naturally'),
                'id' => 'nav_a_typo',
                'type' => 'typography',
                'font-backup' => false,
                'letter-spacing' => true,
                'text-transform' => true,
                'all_styles' => true,
                'output' => array( '.header_nav > ul > li > a,.header_nav_sub a' ),
                'default' => array(
                    'color' => '',
                    'font-style' => '',
                    'font-family' => '',
                    'google' => true,
                    'font-size' => '',
                    'line-height' => ''
                ),
                'required' => array(
                    array( 'nav_visibility', '=', '1' ),
                    array( 'site_header_template', '=', 'default' )
                )
            ),
            array(
                'title' => esc_html__('Menu Item Color ( Hover and Active )', 'naturally'),
                'desc' => esc_html__('Set your own hover color for the navigation menu item.', 'naturally'),
                'id' => 'nav_hvr_a',
                'type' => 'color',
                'output' => array( '.header_nav > ul > li > a:hover,.header_nav_sub a:hover,.header_nav li.has-sub:hover > a' ),
                'required' => array(
                    array( 'nav_visibility', '=', '1' ),
                    array( 'site_header_template', '=', 'default' )
                )
            ),
            //information on-off
            array(
                'id' =>'info_nav1',
                'type' => 'info',
                'style' => 'success',
                'title' => esc_html__('Success!', 'naturally'),
                'icon' => 'el el-info-circle',
                'customizer' => false,
                'desc' => sprintf(esc_html__('%s is disabled on the site. Please activate to view options.', 'naturally'), '<b>Navigation</b>'),
                'required' => array( 'nav_visibility', '=', '0' )
            )
    )));
    //HEADER MENU
    Redux::setSection($naturally_pre, array(
        'title' => esc_html__('Sticky Header Menu', 'naturally'),
        'id' => 'headerstickynavsubsection',
        'subsection' => true,
        'icon' => 'el el-brush',
        'fields' => array(
            array(
                'title' => esc_html__('Sticky Menu Display', 'naturally'),
                'subtitle' => esc_html__('You can enable or disable the site navigation sticky option.', 'naturally'),
                'id' => 'nav_sticky_visibility',
                'type' => 'switch',
                'default' => 0,
                'on' => 'On',
                'off' => 'Off',
                'required' => array(
                    array( 'nav_visibility', '=', '1' ),
                    array( 'site_header_template', '=', 'default' )
                )
            ),
            array(
                'title' => esc_html__('Sticky Menu Background', 'naturally'),
                'id' => 'nav_bg_sticky',
                'type' => 'color_rgba',
                'mode' => 'background',
                'output' => array( 'div.header.is-sticky-active, .header.is-sticky.is-sticky-active .header_container' ),
                'required' => array(
                    array( 'nav_visibility', '=', '1' ),
                    array( 'site_header_template', '=', 'default' ),
                    array( 'nav_sticky_visibility', '=', '1' ),
                )
            ),
            array(
                'title' => esc_html__('Sticky Header Top Spacing', 'naturally'),
                'id' => 'sticky_header_martop',
                'type' => 'spacing',
                'mode' => 'margin',
                'all' => false,
                'left' => false,
                'right' => false,
                'bottom' => false,
                'units' => array( 'em', 'px', '%' ),
                'units_extended' => 'true',
                'output' => array( '.naturally-main-header.is-sticky.is-sticky-active .header_bottom' )
            ),
            array(
                'title' => esc_html__('Menu Item Font and Color', 'naturally'),
                'subtitle' => esc_html__("Choose Size and Style for primary menu", 'naturally'),
                'id' => 'snav_a_typo',
                'type' => 'typography',
                'font-backup' => false,
                'letter-spacing' => true,
                'text-transform' => true,
                'all_styles' => true,
                'output' => array( 'div.header.is-sticky-active .header_nav > ul > li > a,div.header.is-sticky-active .header_nav_sub a' ),
                'default' => array(
                    'color' => '',
                    'font-style' => '',
                    'font-family' => '',
                    'google' => true,
                    'font-size' => '',
                    'line-height' => ''
                ),
                'required' => array(
                    array( 'nav_visibility', '=', '1' ),
                    array( 'site_header_template', '=', 'default' ),
                    array( 'nav_sticky_visibility', '=', '1' )
                )
            ),
            array(
                'title' => esc_html__('Menu Item Color ( Hover and Active )', 'naturally'),
                'desc' => esc_html__('Set your own hover color for the navigation menu item.', 'naturally'),
                'id' => 'snav_hvr_a',
                'type' => 'color',
                'output' => array( 'div.header.is-sticky-active .header_nav > ul > li > a:hover,div.header.is-sticky-active .header_nav_sub a:hover' ),
                'required' => array(
                    array( 'nav_visibility', '=', '1' ),
                    array( 'site_header_template', '=', 'default' ),
                    array( 'nav_sticky_visibility', '=', '1' )
                )
            ),
            //information on-off
            array(
                'id' =>'info_nav2',
                'type' => 'info',
                'style' => 'success',
                'title' => esc_html__('Success!', 'naturally'),
                'icon' => 'el el-info-circle',
                'customizer' => false,
                'desc' => sprintf(esc_html__('%s is disabled on the site. Please activate to view options.', 'naturally'), '<b>Navigation</b>'),
                'required' => array( 'nav_visibility', '=', '0' )
            )
    )));
    //HEADER MENU
    Redux::setSection($naturally_pre, array(
        'title' => esc_html__('Dropdown Submenu', 'naturally'),
        'id' => 'headernavdropdaownsection',
        'subsection' => true,
        'icon' => 'el el-brush',
        'fields' => array(
            array(
                'title' => esc_html__('Dropdown Submenu Background Color', 'naturally'),
                'desc' => esc_html__('Set your own background-color for the navigation dropdown menu.', 'naturally'),
                'id' => 'nav_drop_bg',
                'type' => 'color_rgba',
                'mode' => 'background',
                'output' => array( '.header_nav > ul > li.has-sub:hover > a, .header_nav > ul > li.has-mega:hover > a, .header_nav_sub > ul' ),
                'required' => array(
                    array( 'nav_visibility', '=', '1' ),
                    array( 'site_header_template', '=', 'default' )
                )
            ),
            array(
                'title' => esc_html__('Dropdown Submenu Border Color', 'naturally'),
                'desc' => esc_html__('Set your own border-color for the navigation dropdown menu.', 'naturally'),
                'id' => 'nav_drop_bg',
                'type' => 'color',
                'mode' => 'border-color',
                'output' => array( '.header_nav > ul > li.has-sub:hover > a, .header_nav > ul > li.has-mega:hover > a, .header_nav_sub > ul' ),
                'required' => array(
                    array( 'nav_visibility', '=', '1' ),
                    array( 'site_header_template', '=', 'default' )
                )
            ),
            array(
                'title' => esc_html__('Dropdown Submenu Item Font and Color', 'naturally'),
                'subtitle' => esc_html__("Choose Size and Style for dropdown menu item", 'naturally'),
                'id' => 'nav_drop_typo',
                'type' => 'typography',
                'font-backup' => false,
                'letter-spacing' => true,
                'text-transform' => true,
                'all_styles' => true,
                'output' => array( 'div.header .header_nav_sub a,div.header.sticked .header_nav_sub a' ),
                'default' => array(
                    'color' => '',
                    'font-style' => '',
                    'font-family' => '',
                    'google' => true,
                    'font-size' => '',
                    'line-height' => ''
                ),
                'required' => array(
                    array( 'nav_visibility', '=', '1' ),
                    array( 'site_header_template', '=', 'default' )
                )
            ),
            array(
                'title' => esc_html__('Dropdown Item Color ( Hover )', 'naturally'),
                'desc' => esc_html__('Set your own hover color for the navigation dropdown menu item.', 'naturally'),
                'id' => 'nav_drop_i',
                'type' => 'color',
                'mode' => 'color',
                'output' => array( 'div.header .header_nav_sub a:hover, div.header .header_nav_sub ul li:hover > a,div.header.sticked .header_nav_sub a:hover' ),
                'required' => array(
                    array( 'nav_visibility', '=', '1' ),
                    array( 'site_header_template', '=', 'default' )
                )
            ),
            //information on-off
            array(
                'id' =>'info_nav3',
                'type' => 'info',
                'style' => 'success',
                'title' => esc_html__('Success!', 'naturally'),
                'icon' => 'el el-info-circle',
                'customizer' => false,
                'desc' => sprintf(esc_html__('%s is disabled on the site. Please activate to view options.', 'naturally'), '<b>Navigation</b>'),
                'required' => array( 'nav_visibility', '=', '0' )
            )
    )));
    //HEADER MOBILE MENU
    Redux::setSection($naturally_pre, array(
        'title' => esc_html__('Mobile Top Menu', 'naturally'),
        'id' => 'headermobilenavsection',
        'subsection' => true,
        'icon' => 'fa fa-mobile',
        'fields' => array(
            array(
                'title' => esc_html__('Mobile Menu Background', 'naturally'),
                'desc' => esc_html__('Set your own hover color for the navigation menu item.', 'naturally'),
                'id' => 'mob_nav_bg',
                'type' => 'color',
                'mode' => 'background-color',
                'output' => array( '#header.menu-opened,.mobile-nav .nav-inner' ),
                'required' => array(
                    array( 'nav_visibility', '=', '1' ),
                    array( 'site_header_template', '=', 'default' )
                )
            ),
            array(
                'title' => esc_html__('Background image', 'naturally'),
                'id' => 'header_mob_bg_img',
                'type' => 'media',
                'url' => true,
                'customizer' => true,
                'required' => array(
                    array( 'nav_visibility', '=', '1' ),
                    array( 'site_header_template', '=', 'default' )
                )
            ),
            array(
                'title' => esc_html__('Menu Item Font and Color', 'naturally'),
                'subtitle' => esc_html__("Choose Size and Style for primary menu", 'naturally'),
                'id' => 'mob_nav_a_typo',
                'type' => 'typography',
                'font-backup' => false,
                'letter-spacing' => true,
                'text-transform' => true,
                'all_styles' => true,
                'output' => array( '.mobile-menu > li > a' ),
                'default' => array(
                    'color' => '',
                    'font-style' => '',
                    'font-family' => '',
                    'google' => true,
                    'font-size' => '',
                    'line-height' => ''
                ),
                'required' => array(
                    array( 'nav_visibility', '=', '1' ),
                    array( 'site_header_template', '=', 'default' )
                )
            ),
            array(
                'title' => esc_html__('Menu Item Color ( Hover and Active )', 'naturally'),
                'desc' => esc_html__('Set your own hover color for the navigation menu item.', 'naturally'),
                'id' => 'mob_nav_hvr_a',
                'type' => 'color',
                'output' => array( '.mobile-menu > li > a:hover,.mobile-menu .sub-menu li a:hover' ),
                'required' => array(
                    array( 'nav_visibility', '=', '1' ),
                    array( 'site_header_template', '=', 'default' )
                )
            ),
            array(
                'title' => esc_html__('Menu Item Border Color ( Hover and Active )', 'naturally'),
                'desc' => esc_html__('Set your own hover color for the navigation menu item.', 'naturally'),
                'id' => 'mob_nav_hvr_a_brd',
                'type' => 'color',
                'mode' => 'background-color',
                'output' => array( '.mobile-menu > li > a::after,.mobile-menu > li.menu-item--has-child > a > span::before, .mobile-menu > li.menu-item--has-child > a > span::after' ),
                'required' => array(
                    array( 'nav_visibility', '=', '1' ),
                    array( 'site_header_template', '=', 'default' )
                )
            ),
            array(
                'title' => esc_html__('Menu Toggle Button Bar Color', 'naturally'),
                'desc' => esc_html__('Set your own color for mobile menu navbar toggle button.', 'naturally'),
                'id' => 'mob_nav_toggle',
                'type' => 'color',
                'mode' => 'background-color',
                'output' => array( '.hamburger-inner, .hamburger-inner::before, .hamburger-inner::after' ),
                'required' => array(
                    array( 'nav_visibility', '=', '1' ),
                    array( 'site_header_template', '=', 'default' )
                )
            ),
            array(
                'title' => esc_html__('Menu Toggle Button Bar Color ( Hover )', 'naturally'),
                'desc' => esc_html__('Set your own color for mobile menu navbar toggle button.', 'naturally'),
                'id' => 'mob_nav_toggle_hvr',
                'type' => 'color',
                'mode' => 'color',
                'output' => array( '.hamburger-inner, .hamburger-inner:before:hover, .hamburger-inner:after:hover' ),
                'required' => array(
                    array( 'nav_visibility', '=', '1' ),
                    array( 'site_header_template', '=', 'default' )
                )
            ),
            //information on-off
            array(
                'id' =>'info_nav4',
                'type' => 'info',
                'style' => 'success',
                'title' => esc_html__('Success!', 'naturally'),
                'icon' => 'el el-info-circle',
                'customizer' => false,
                'desc' => sprintf(esc_html__('%s is disabled on the site. Please activate to view options.', 'naturally'), '<b>Navigation</b>'),
                'required' => array( 'nav_visibility', '=', '0' )
            )
        )
    ));
    //FOOTER SECTION
    Redux::setSection($naturally_pre, array(
        'title' => esc_html__( 'Mobile Bottom Menu Bar', 'naturally' ),
        'desc' => esc_html__( 'These are main settings for general theme!', 'naturally' ),
        'id' => 'mobilebottommenusubsection',
        'subsection' => true,
        'icon' => 'el el-photo',
        'fields' => array(
            array(
                'title' => esc_html__( 'Mobile Bottom Menu Bar Display', 'naturally' ),
                'subtitle' => esc_html__( 'You can enable or disable the site mobile bottom menu bar.', 'naturally' ),
                'customizer' => true,
                'id' => 'bottom_mobile_nav_visibility',
                'type' => 'switch',
                'default' => 0
            ),
            array(
                'title' => esc_html__( 'Mobile Bottom Menu Type', 'naturally' ),
                'subtitle' => esc_html__( 'Select your mobile bottom menu popup search type.', 'naturally' ),
                'customizer' => true,
                'id' => 'bottom_mobile_menu_type',
                'type' => 'button_set',
                'customizer' => true,
                'options' => array(
                    'default' => esc_html__( 'Default', 'naturally' ),
                    'wp-menu' => esc_html__( 'WP Menu', 'naturally' ),
                    'elementor' => esc_html__( 'Elementor Template', 'naturally' ),
                ),
                'default' => 'default',
                'required' => array( 'bottom_mobile_nav_visibility', '=', '1' )
            ),
            array(
                'title' => esc_html__( 'Mobile Bottom Menu Display Type', 'naturally' ),
                'subtitle' => esc_html__( 'Select your mobile bottom menu popup search type.', 'naturally' ),
                'customizer' => true,
                'id' => 'bottom_mobile_menu_display_type',
                'type' => 'button_set',
                'customizer' => true,
                'options' => array(
                    'show-allways' => esc_html__( 'Always show', 'naturally' ),
                    'show-onscroll' => esc_html__( 'Show on scroll', 'naturally' ),
                ),
                'default' => 'show-allways',
                'required' => array( 'bottom_mobile_nav_visibility', '=', '1' )
            ),
            array(
                'title' => esc_html__( 'Elementor Templates', 'naturally' ),
                'subtitle' => esc_html__( 'Select a template from elementor templates.', 'naturally' ),
                'customizer' => true,
                'id' => 'mobile_bottom_menu_elementor_templates',
                'type' => 'select',
                'data' => 'posts',
                'args'  => $el_args,
                'required' => array(
                    array( 'bottom_mobile_nav_visibility', '=', '1' ),
                    array( 'bottom_mobile_menu_type', '=', 'elementor' )
                )
            ),
            array(
                'id' =>'mobile_bottom_menu_layouts',
                'type' => 'sorter',
                'title' => esc_html__( 'Layout Manager', 'naturally' ),
                'subtitle' => esc_html__( 'Organize how you want the layout to appear on the theme bottom mobile menu bar', 'naturally' ),
                'options' => array(
                    'show' => array(
                        'home' => esc_html__( 'Home', 'naturally' ),
                        'shop' => esc_html__( 'Shop', 'naturally' ),
                        'cart' => esc_html__( 'Cart', 'naturally' ),
                        'account' => esc_html__( 'Account', 'naturally' ),
                        'search' => esc_html__( 'Search', 'naturally' )
                    ),
                    'hide'  => array(
                    )
                ),
                'required' => array(
                    array( 'bottom_mobile_nav_visibility', '=', '1' ),
                    array( 'bottom_mobile_menu_type', '=', 'default' )
                )
            ),
            array(
                'desc' => sprintf( '%s <b>"%s"</b> <a class="button" href="'.admin_url('nav-menus.php?action=edit&menu=0').'" target="_blank">%s</a>',
                esc_html__( 'Please create new menu and assign it as', 'naturally' ),
                esc_html__( 'Mobile Bottom Menu', 'naturally' ),
                esc_html__( 'Create New Menu', 'naturally' )),
                'customizer' => true,
                'id' => 'mobile_bottom_menu_custom_menu_info',
                'type' => 'info',
                'required' => array(
                    array( 'bottom_mobile_nav_visibility', '=', '1' ),
                    array( 'bottom_mobile_menu_type', '=', 'wp-menu' )
                )
            ),
            array(
                'title' => esc_html__( 'Change Default Menu Item HTML', 'naturally' ),
                'subtitle' => esc_html__( 'You can change the site mobile bottom menu item html.', 'naturally' ),
                'customizer' => true,
                'id' => 'bottom_mobile_nav_item_customize',
                'type' => 'switch',
                'default' => 0,
                'required' => array(
                    array( 'bottom_mobile_nav_visibility', '=', '1' ),
                    array( 'bottom_mobile_menu_type', '=', 'default' )
                )
            ),
            array(
                'title' => esc_html__( 'Custom Home HTML ( optional )', 'naturally' ),
                'desc' => esc_html__( 'If you do not want to make any changes in this part, please clear the default html from the field.', 'naturally' ),
                'customizer' => true,
                'id' => 'mobile_bottom_menu_custom_home_html',
                'type' => 'textarea',
                'default' => sprintf( '<li class="menu-item"><a href="%s">%s<span>Home</span></a></li>',
                esc_url( home_url( '/' ) ),
                '<svg class="svgLeft styler-svg-icon" width="512" height="512" fill="currentColor" viewBox="0 0 128 128" enable-background="new 0 0 128 128" xmlns="http://www.w3.org/2000/svg"><path d="m64 0c-35.289 0-64 28.711-64 64s28.711 64 64 64 64-28.711 64-64-28.711-64-64-64zm0 120c-30.879 0-56-25.121-56-56s25.121-56 56-56 56 25.121 56 56-25.121 56-56 56zm28-56c0 2.211-1.791 4-4 4h-38.344l13.172 13.172c1.563 1.563 1.563 4.094 0 5.656-.781.781-1.805 1.172-2.828 1.172s-2.047-.391-2.828-1.172l-20-20c-1.563-1.563-1.563-4.094 0-5.656l20-20c1.563-1.563 4.094-1.563 5.656 0s1.563 4.094 0 5.656l-13.172 13.172h38.344c2.209 0 4 1.789 4 4z"></path></svg>'),
                'required' => array(
                    array( 'bottom_mobile_nav_visibility', '=', '1' ),
                    array( 'bottom_mobile_menu_type', '=', 'default' ),
                    array( 'bottom_mobile_nav_item_customize', '=', '1' )
                )
            ),
            array(
                'title' => esc_html__( 'Custom Shop HTML ( optional )', 'naturally' ),
                'desc' => esc_html__( 'If you do not want to make any changes in this part, please clear the default html from the field.', 'naturally' ),
                'customizer' => true,
                'id' => 'mobile_bottom_menu_custom_shop_html',
                'type' => 'textarea',
                'default' => sprintf( '<li class="menu-item"><a href="%s">%s<span>Shop</span></a></li>',
                function_exists('wc_get_page_permalink') ? esc_url( wc_get_page_permalink( 'shop' ) ) : '#0',
                '<svg class="svgStore styler-svg-icon" width="512" height="512" fill="currentColor" viewBox="0 0 512 512" xmlns="http://www.w3.org/2000/svg"><path d="M511.989,148.555c0-.107.007-.214.008-.322,0-.042,0-.083,0-.125h-.007a15.921,15.921,0,0,0-1.805-7.4L441.3,8.6A16,16,0,0,0,427.115,0H84.885A16,16,0,0,0,70.7,8.6L1.813,140.711a15.91,15.91,0,0,0-1.806,7.4H0c0,.042,0,.083,0,.125,0,.108.005.215.008.322a75.953,75.953,0,0,0,32.6,61.9V466a46.053,46.053,0,0,0,46,46H433.386a46.058,46.058,0,0,0,46-46V210.455A75.953,75.953,0,0,0,511.989,148.555Zm-32.15,3.167A43.994,43.994,0,0,1,392,148.108h-.016a16,16,0,0,0-.512-4.077L361.946,32h55.468ZM183.146,32H240V148.108A44,44,0,0,1,152.048,150ZM272,32h56.854l31.1,118A44,44,0,0,1,272,148.108ZM94.586,32h55.468L120.528,144.031a16,16,0,0,0-.512,4.077H120a43.994,43.994,0,0,1-87.839,3.614ZM380.331,480H298.96V306.347h81.371Zm67.054-14a14.058,14.058,0,0,1-14,14H412.331V290.347a16,16,0,0,0-16-16H282.96a16,16,0,0,0-16,16V480H78.615a14.016,14.016,0,0,1-14-14V223.253A75.917,75.917,0,0,0,136,194.673a75.869,75.869,0,0,0,120,0,75.869,75.869,0,0,0,120,0,75.917,75.917,0,0,0,71.385,28.58ZM215.215,274.347H115.67a16,16,0,0,0-16,16v99.545a16,16,0,0,0,16,16h99.545a16,16,0,0,0,16-16V290.347A16,16,0,0,0,215.215,274.347Zm-16,99.545H131.67V306.347h67.545Z"></path></svg>'),
                'required' => array(
                    array( 'bottom_mobile_nav_visibility', '=', '1' ),
                    array( 'bottom_mobile_menu_type', '=', 'default' ),
                    array( 'bottom_mobile_nav_item_customize', '=', '1' )
                )
            ),
            array(
                'title' => esc_html__( 'Custom Cart HTML ( optional )', 'naturally' ),
                'desc' => esc_html__( 'If you do not want to make any changes in this part, please clear the default html from the field.', 'naturally' ),
                'customizer' => true,
                'id' => 'mobile_bottom_menu_custom_cart_html',
                'type' => 'textarea',
                'default' => sprintf( '<li class="menu-item"><a href="%s">%s<span class="naturally-cart-count naturally-wc-count"></span><span>Cart</span></a></li>',
                function_exists('wc_get_page_permalink') ? esc_url( wc_get_page_permalink( 'cart' ) ) : '#0',
                '<svg class="shopBag styler-svg-icon" width="512" height="512" fill="currentColor" viewBox="0 0 32 32" xmlns="http://www.w3.org/2000/svg"><path d="m26 8.9a1 1 0 0 0 -1-.9h-3a6 6 0 0 0 -12 0h-3a1 1 0 0 0 -1 .9l-1.78 17.8a3 3 0 0 0 .78 2.3 3 3 0 0 0 2.22 1h17.57a3 3 0 0 0 2.21-1 3 3 0 0 0 .77-2.31zm-10-4.9a4 4 0 0 1 4 4h-8a4 4 0 0 1 4-4zm9.53 23.67a1 1 0 0 1 -.74.33h-17.58a1 1 0 0 1 -.74-.33 1 1 0 0 1 -.26-.77l1.7-16.9h2.09v3a1 1 0 0 0 2 0v-3h8v3a1 1 0 0 0 2 0v-3h2.09l1.7 16.9a1 1 0 0 1 -.26.77z"></path></svg>'),
                'required' => array(
                    array( 'bottom_mobile_nav_visibility', '=', '1' ),
                    array( 'bottom_mobile_menu_type', '=', 'default' ),
                    array( 'bottom_mobile_nav_item_customize', '=', '1' )
                )
            ),
            array(
                'title' => esc_html__( 'Custom Account HTML ( optional )', 'naturally' ),
                'desc' => esc_html__( 'If you do not want to make any changes in this part, please clear the default html from the field.', 'naturally' ),
                'customizer' => true,
                'id' => 'mobile_bottom_menu_custom_account_html',
                'type' => 'textarea',
                'default' => sprintf( '<li class="menu-item"><a href="%s">%s<span>Account</span></a></li>',
                function_exists('wc_get_page_permalink') ? esc_url( wc_get_page_permalink( 'myaccount' ) ) : '#0',
                '<svg class="svgUser2 styler-svg-icon" enable-background="new 0 0 512 512" height="512" viewBox="0 0 512 512" width="512" xmlns="http://www.w3.org/2000/svg"><g><g><path d="m256 253.7c-62 0-112.4-50.4-112.4-112.4s50.4-112.4 112.4-112.4 112.4 50.4 112.4 112.4-50.4 112.4-112.4 112.4zm0-195.8c-46 0-83.4 37.4-83.4 83.4s37.4 83.4 83.4 83.4 83.4-37.4 83.4-83.4-37.4-83.4-83.4-83.4z"></path></g><g><path d="m452.1 483.2h-392.2c-8 0-14.5-6.5-14.5-14.5 0-106.9 94.5-193.9 210.6-193.9s210.6 87 210.6 193.9c0 8-6.5 14.5-14.5 14.5zm-377-29.1h361.7c-8.1-84.1-86.1-150.3-180.8-150.3s-172.7 66.2-180.9 150.3z"></path></g></g></svg>'),
                'required' => array(
                    array( 'bottom_mobile_nav_visibility', '=', '1' ),
                    array( 'bottom_mobile_menu_type', '=', 'default' ),
                    array( 'bottom_mobile_nav_item_customize', '=', '1' )
                )
            ),
            array(
                'title' => esc_html__( 'Custom Search HTML ( optional )', 'naturally' ),
                'desc' => esc_html__( 'If you do not want to make any changes in this part, please clear the default html from the field.', 'naturally' ),
                'customizer' => true,
                'id' => 'mobile_bottom_menu_custom_search_html',
                'type' => 'textarea',
                'default' => sprintf( '<li class="menu-item"><a href="#0" data-name="search-popup">%s<span>Search</span></a></li>',
                '<svg class="svgSearch styler-svg-icon" width="512" height="512" fill="currentColor" viewBox="0 0 48 48" enable-background="new 0 0 48 48" xmlns="http://www.w3.org/2000/svg"><g><path d="m40.2850342 37.4604492-6.4862061-6.4862061c1.9657593-2.5733643 3.0438843-5.6947021 3.0443115-8.9884033 0-3.9692383-1.5458984-7.7011719-4.3530273-10.5078125-2.8066406-2.8066406-6.5380859-4.3525391-10.5078125-4.3525391-3.9692383 0-7.7011719 1.5458984-10.5078125 4.3525391-5.7939453 5.7944336-5.7939453 15.222168 0 21.015625 2.8066406 2.8071289 6.5385742 4.3530273 10.5078125 4.3530273 3.2937012-.0004272 6.4150391-1.0785522 8.9884033-3.0443115l6.4862061 6.4862061c.3901367.390625.9023438.5859375 1.4140625.5859375s1.0239258-.1953125 1.4140625-.5859375c.78125-.7807617.78125-2.0473633 0-2.828125zm-25.9824219-7.7949219c-4.234375-4.234375-4.2338867-11.1245117 0-15.359375 2.0512695-2.0507813 4.7788086-3.1806641 7.6796875-3.1806641 2.9013672 0 5.628418 1.1298828 7.6796875 3.1806641 2.0512695 2.0512695 3.1811523 4.7788086 3.1811523 7.6796875 0 2.9013672-1.1298828 5.628418-3.1811523 7.6796875s-4.7783203 3.1811523-7.6796875 3.1811523c-2.9008789.0000001-5.628418-1.1298827-7.6796875-3.1811523z"></path></g></svg>'),
                'required' => array(
                    array( 'bottom_mobile_nav_visibility', '=', '1' ),
                    array( 'bottom_mobile_menu_type', '=', 'default' ),
                    array( 'bottom_mobile_nav_item_customize', '=', '1' )
                )
            ),
            array(
                'title' => esc_html__( 'Backgroud Color', 'naturally' ),
                'customizer' => true,
                'id' => 'mobile_bottom_menu_bg_color',
                'type' => 'color',
                'mode' => 'background-color',
                'output' => array( '.bottom-mobile-nav' ),
                'required' => array( 'bottom_mobile_nav_visibility', '=', '1' )
            ),
            array(
                'title' => esc_html__( 'Menu Item Color', 'naturally' ),
                'customizer' => true,
                'id' => 'mobile_bottom_menu_item_color',
                'type' => 'color',
                'mode' => 'color',
                'output' => array( '.bottom-mobile-nav .menu-item a,.bottom-mobile-nav .menu-item a span' ),
                'required' => array(
                    array( 'bottom_mobile_nav_visibility', '=', '1' ),
                    array( 'bottom_mobile_menu_type', '!=', 'elementor' )
                )
            ),
            array(
                'title' => esc_html__( 'Menu Item Color ( Hover )', 'naturally' ),
                'customizer' => true,
                'id' => 'mobile_bottom_menu_item_hvrcolor',
                'type' => 'color',
                'mode' => 'color',
                'output' => array( '.bottom-mobile-nav .menu-item a:hover,.bottom-mobile-nav .menu-item a:hover span'),
                'required' => array(
                    array( 'bottom_mobile_nav_visibility', '=', '1' ),
                    array( 'bottom_mobile_menu_type', '!=', 'elementor' )
                )
            ),
            array(
                'title' => esc_html__( 'SVG Icon Color', 'naturally' ),
                'customizer' => true,
                'id' => 'mobile_bottom_menu_item_icon_color',
                'type' => 'color',
                'mode' => 'fill',
                'output' => array('.bottom-mobile-nav .menu-item svg,.bottom-mobile-nav svg'),
                'required' => array(
                    array( 'bottom_mobile_nav_visibility', '=', '1' ),
                    array( 'bottom_mobile_menu_type', '!=', 'elementor' )
                )
            ),
            array(
                'title' => esc_html__( 'SVG Icon Color ( Hover )', 'naturally' ),
                'customizer' => true,
                'id' => 'mobile_bottom_menu_item_icon_hvrcolor',
                'type' => 'color',
                'mode' => 'fill',
                'output' => array('.bottom-mobile-nav .menu-item a:hover svg,.bottom-mobile-nav a:hover svg'),
                'required' => array(
                    array( 'bottom_mobile_nav_visibility', '=', '1' ),
                    array( 'bottom_mobile_menu_type', '!=', 'elementor' )
                )
            ),
            array(
                'title' => esc_html__( 'Font Icon Color', 'naturally' ),
                'customizer' => true,
                'id' => 'mobile_bottom_menu_item_icon2_color',
                'type' => 'color',
                'mode' => 'color',
                'output' => array('.bottom-mobile-nav a i,.bottom-mobile-nav a span' ),
                'required' => array(
                    array( 'bottom_mobile_nav_visibility', '=', '1' ),
                    array( 'bottom_mobile_menu_type', '!=', 'elementor' )
                )
            ),
            array(
                'title' => esc_html__( 'Font Icon Color ( Hover )', 'naturally' ),
                'customizer' => true,
                'id' => 'mobile_bottom_menu_item_icon2_hvrcolor',
                'type' => 'color',
                'mode' => 'color',
                'output' => array('.bottom-mobile-nav a:hover i,.bottom-mobile-nav a:hover span' ),
                'required' => array(
                    array( 'bottom_mobile_nav_visibility', '=', '1' ),
                    array( 'bottom_mobile_menu_type', '!=', 'elementor' )
                )
            ),
            array(
                'title' => esc_html__( 'Cart Count Background Color', 'naturally' ),
                'customizer' => true,
                'id' => 'mobile_bottom_menu_item_cart_count_bg_color',
                'type' => 'color',
                'mode' => 'background-color',
                'output' => array( '.bottom-mobile-nav .menu-item a span.naturally-wc-count, .bottom-mobile-nav .naturally-wc-count' ),
                'required' => array(
                    array( 'bottom_mobile_nav_visibility', '=', '1' ),
                    array( 'bottom_mobile_menu_type', '!=', 'elementor' )
                )
            ),
            array(
                'title' => esc_html__( 'Cart Count Number Color', 'naturally' ),
                'customizer' => true,
                'id' => 'mobile_bottom_menu_item_cart_count_number_color',
                'type' => 'color',
                'mode' => 'color',
                'output' => array( '.bottom-mobile-nav .menu-item a span.naturally-wc-count, .bottom-mobile-nav .naturally-wc-count' ),
                'required' => array(
                    array( 'bottom_mobile_nav_visibility', '=', '1' ),
                    array( 'bottom_mobile_menu_type', '!=', 'elementor' )
                )
            )
        )
    ));

    /*************************************************
    ## SIDEBARS SECTION
    *************************************************/
    Redux::setSection($naturally_pre, array(
        'title' => esc_html__('Sidebars', 'naturally'),
        'id' => 'sidebarssection',
        'customizer_width' => '400px',
        'icon' => 'fa fa-th-list',
    ));
    // SIDEBAR LAYOUT SUBSECTION
    Redux::setSection($naturally_pre, array(
        'title' => esc_html__('Sidebars Layout', 'naturally'),
        'desc' => esc_html__('You can change the below default layout type.', 'naturally'),
        'id' => 'sidebarslayoutsection',
        'subsection' => true,
        'icon' => 'el el-cogs',
        'fields' => array(
            array(
                'title' => esc_html__('Sidebar type', 'naturally'),
                'subtitle' => esc_html__('Select sidebar type.', 'naturally'),
                'id' => 'sidebar_type',
                'type' => 'select',
                'customizer' => true,
                'options' => array(
                    '' => esc_html__('Select type', 'naturally'),
                    'default' => esc_html__('default', 'naturally'),
                    'bordered' => esc_html__('bordered', 'naturally')
                ),
                'default' => 'default',
            ),
            array(
                'title' => esc_html__('Blog Page Layout', 'naturally'),
                'subtitle' => esc_html__('Choose the blog index page layout.', 'naturally'),
                'id' => 'index_layout',
                'type' => 'image_select',
                'options' => array(
                    'left-sidebar' => array(
                        'alt' => 'Left Sidebar',
                        'img' => get_template_directory_uri() . '/inc/core/theme-options/img/2cl.png'
                    ),
                    'full-width' => array(
                        'alt' => 'Full Width',
                        'img' => get_template_directory_uri() . '/inc/core/theme-options/img/1col.png'
                    ),
                    'right-sidebar' => array(
                        'alt' => 'Right Sidebar',
                        'img' => get_template_directory_uri() . '/inc/core/theme-options/img/2cr.png'
                    )
                ),
                'default' => 'right-sidebar'
            ),
            array(
                'title' => esc_html__('Single Page Layout', 'naturally'),
                'subtitle' => esc_html__('Choose the single post page layout.', 'naturally'),
                'id' => 'single_layout',
                'type' => 'image_select',
                'options' => array(
                    'left-sidebar' => array(
                        'alt' => 'Left Sidebar',
                        'img' => get_template_directory_uri() . '/inc/core/theme-options/img/2cl.png'
                    ),
                    'full-width' => array(
                        'alt' => 'Full Width',
                        'img' => get_template_directory_uri() . '/inc/core/theme-options/img/1col.png'
                    ),
                    'right-sidebar' => array(
                        'alt' => 'Right Sidebar',
                        'img' => get_template_directory_uri() . '/inc/core/theme-options/img/2cr.png'
                    )
                ),
                'default' => 'full-width'
            ),
            array(
                'title' => esc_html__('Search Page Layout', 'naturally'),
                'subtitle' => esc_html__('Choose the search page layout.', 'naturally'),
                'id' => 'search_layout',
                'type' => 'image_select',
                'options' => array(
                    'left-sidebar' => array(
                        'alt' => 'Left Sidebar',
                        'img' => get_template_directory_uri() . '/inc/core/theme-options/img/2cl.png'
                    ),
                    'full-width' => array(
                        'alt' => 'Full Width',
                        'img' => get_template_directory_uri() . '/inc/core/theme-options/img/1col.png'
                    ),
                    'right-sidebar' => array(
                        'alt' => 'Right Sidebar',
                        'img' => get_template_directory_uri() . '/inc/core/theme-options/img/2cr.png'
                    )
                ),
                'default' => 'full-width'
            ),
            array(
                'title' => esc_html__('Archive Page Layout', 'naturally'),
                'subtitle' => esc_html__('Choose the archive page layout.', 'naturally'),
                'id' => 'archive_layout',
                'type' => 'image_select',
                'options' => array(
                    'left-sidebar' => array(
                        'alt' => 'Left Sidebar',
                        'img' => get_template_directory_uri() . '/inc/core/theme-options/img/2cl.png'
                    ),
                    'full-width' => array(
                        'alt' => 'Full Width',
                        'img' => get_template_directory_uri() . '/inc/core/theme-options/img/1col.png'
                    ),
                    'right-sidebar' => array(
                        'alt' => 'Right Sidebar',
                        'img' => get_template_directory_uri() . '/inc/core/theme-options/img/2cr.png'
                    )
                ),
                'default' => 'full-width'
            )
    )));
    // SIDEBAR COLORS SUBSECTION
    Redux::setSection($naturally_pre, array(
        'title' => esc_html__('Sidebar Customize', 'naturally'),
        'desc' => esc_html__('These are main settings for general theme!', 'naturally'),
        'id' => 'sidebarsgenaralsection',
        'subsection' => true,
        'icon' => 'el el-brush',
        'fields' => array(
            array(
                'title' => esc_html__('Sidebar Background', 'naturally'),
                'id' => 'sdbr_bg',
                'type' => 'color',
                'mode' => 'background',
                'output' => array( '.nt-sidebar' )
            ),
            array(
                'id' => 'sdbr_brd',
                'type' => 'border',
                'title' => esc_html__('Sidebar Border', 'naturally'),
                'output' => array( '.nt-sidebar' ),
                'all' => false
            ),
            array(
                'title' => esc_html__('Sidebar Padding', 'naturally'),
                'id' => 'sdbr_pad',
                'type' => 'spacing',
                'mode' => 'padding',
                'all' => false,
                'units' => array( 'em', 'px', '%' ),
                'units_extended' => 'true',
                'output' => array( '.nt-sidebar' ),
                'default' => array(
                    'margin-top' => '',
                    'margin-right' => '',
                    'margin-bottom' => '',
                    'margin-left' => ''
                )
            ),
            array(
                'title' => esc_html__('Sidebar Margin', 'naturally'),
                'id' => 'sdbr_mar',
                'type' => 'spacing',
                'mode' => 'margin',
                'all' => false,
                'units' => array( 'em', 'px', '%' ),
                'units_extended' => 'true',
                'output' => array( '.nt-sidebar' ),
                'default' => array(
                    'margin-top' => '',
                    'margin-right' => '',
                    'margin-bottom' => '',
                    'margin-left' => ''
                )
            ),
    )));
    // SIDEBAR WIDGET COLORS SUBSECTION
    Redux::setSection($naturally_pre, array(
        'title' => esc_html__('Widget Customize', 'naturally'),
        'desc' => esc_html__('These are main settings for general theme!', 'naturally'),
        'id' => 'sidebarwidgetsection',
        'subsection' => true,
        'icon' => 'el el-brush',
        'fields' => array(
            array(
                'title' => esc_html__('Sidebar Widgets Background Color', 'naturally'),
                'id' => 'sdbr_w_bg',
                'type' => 'color',
                'mode' => 'background',
                'output' => array( '.nt-sidebar .nt-sidebar-inner-widget' )
            ),
            array(
                'title' => esc_html__('Widgets Border', 'naturally'),
                'id' => 'sdbr_w_brd',
                'type' => 'border',
                'output' => array( '.nt-sidebar .nt-sidebar-inner-widget' ),
                'all' => false
            ),
            array(
                'title' => esc_html__('Widget Title Color', 'naturally'),
                'desc' => esc_html__('Set your own colors for the widgets.', 'naturally'),
                'id' => 'sdbr_wt',
                'type' => 'color',
                'output' => array( '#nt-sidebar .widget-title' )
            ),
            array(
                'title' => esc_html__('Widget Text Color', 'naturally'),
                'desc' => esc_html__('Set your own colors for the widgets.', 'naturally'),
                'id' => 'sdbr_wp',
                'type' => 'color',
                'output' => array( '.nt-sidebar .nt-sidebar-inner-widget, .nt-sidebar .nt-sidebar-inner-widget p' )
            ),
            array(
                'title' => esc_html__('Widget Link Color', 'naturally'),
                'desc' => esc_html__('Set your own colors for the widgets.', 'naturally'),
                'id' => 'sdbr_a',
                'type' => 'color',
                'output' => array( '.nt-sidebar .nt-sidebar-inner-widget a' )
            ),
            array(
                'title' => esc_html__('Widget Hover Link Color', 'naturally'),
                'desc' => esc_html__('Set your own hover colors for the widgets.', 'naturally'),
                'id' => 'sdbr_hvr_a',
                'type' => 'color',
                'output' => array( '.nt-sidebar .nt-sidebar-inner-widget a:hover' )
            ),
            array(
                'title' => esc_html__('Widget Padding', 'naturally'),
                'id' => 'sdbr_w_pad',
                'type' => 'spacing',
                'mode' => 'padding',
                'all' => false,
                'units' => array( 'em', 'px', '%' ),
                'units_extended' => 'true',
                'output' => array( '.nt-sidebar .nt-sidebar-inner-widget' ),
                'default' => array(
                    'margin-top' => '',
                    'margin-right' => '',
                    'margin-bottom' => '',
                    'margin-left' => ''
                )
            ),
            array(
                'title' => esc_html__('Widget Margin', 'naturally'),
                'id' => 'sdbr_w_mar',
                'type' => 'spacing',
                'mode' => 'margin',
                'all' => false,
                'units' => array( 'em', 'px', '%' ),
                'units_extended' => 'true',
                'output' => array( '.nt-sidebar .nt-sidebar-inner-widget' ),
                'default' => array(
                    'margin-top' => '',
                    'margin-right' => '',
                    'margin-bottom' => '',
                    'margin-left' => ''
                )
            )
    )));

    /*************************************************
    ## BLOG PAGE SECTION
    *************************************************/
    Redux::setSection($naturally_pre, array(
        'title' => esc_html__('Blog Page', 'naturally'),
        'id' => 'blogsection',
        'icon' => 'el el-home',
    ));
    // BLOG HERO SUBSECTION
    Redux::setSection($naturally_pre, array(
        'title' => esc_html__('Blog Hero', 'naturally'),
        'desc' => esc_html__('These are blog index page hero text settings!', 'naturally'),
        'id' => 'blogherosubsection',
        'subsection' => true,
        'icon' => 'el el-brush',
        'fields' => array(
            array(
                'title' => esc_html__('Blog Hero Display', 'naturally'),
                'subtitle' => esc_html__('You can enable or disable the site blog index page hero section with switch option.', 'naturally'),
                'id' => 'blog_hero_visibility',
                'type' => 'switch',
                'default' => 1,
                'on' => 'On',
                'off' => 'Off'
            ),
            array(
                'title' => esc_html__('Blog Hero Background', 'naturally'),
                'id' => 'blog_hero_bg',
                'type' => 'background',
                'preview' => true,
                'preview_media' => true,
                'default' => array(
                    'background-position' => '50% 50%'
                ),
                'required' => array( 'blog_hero_visibility', '=', '1' )
            ),
            array(
                'title' => esc_html__('Blog Title', 'naturally'),
                'subtitle' => esc_html__('Add your blog index page title here.', 'naturally'),
                'id' => 'blog_title',
                'type' => 'text',
                'default' => 'BLOG',
                'required' => array( 'blog_hero_visibility', '=', '1' )
            ),
            array(
                'title' => esc_html__('Blog Title Typography', 'naturally'),
                'id' => 'blog_title_typo',
                'type' => 'typography',
                'font-backup' => false,
                'letter-spacing' => true,
                'text-transform' => true,
                'all_styles' => true,
                'output' => array( '#nt-index .nt-hero-title' ),
                'default' => array(
                    'color' => '',
                    'font-style' => '',
                    'font-family' => '',
                    'google' => true,
                    'font-size' => '',
                    'line-height' => ''
                ),
                'required' => array( 'blog_hero_visibility', '=', '1' ),
            ),
            array(
                'title' => esc_html__('Blog Site Title', 'naturally'),
                'subtitle' => esc_html__('Add your blog index page site title here.', 'naturally'),
                'id' => 'blog_site_title',
                'type' => 'textarea',
                'default' => get_bloginfo('name'),
                'required' => array( 'blog_hero_visibility', '=', '1' )
            ),
            array(
                'title' => esc_html__('Blog Site Title Typography', 'naturally'),
                'id' => 'blog_site_title_typo',
                'type' => 'typography',
                'font-backup' => false,
                'letter-spacing' => true,
                'text-transform' => true,
                'all_styles' => true,
                'output' => array( '#nt-index .nt-hero-subtitle' ),
                'default' => array(
                    'color' => '',
                    'font-style' => '',
                    'font-family' => '',
                    'google' => true,
                    'font-size' => '',
                    'line-height' => ''
                ),
                'required' => array( 'blog_hero_visibility', '=', '1' )
            )
    )));
    // BLOG LAYOUT AND POST COLUMN STYLE
    Redux::setSection($naturally_pre, array(
        'title' => esc_html__('Blog Content', 'naturally'),
        'id' => 'blogcontentsubsection',
        'subsection' => true,
        'icon' => 'el el-brush',
        'fields' => array(
            array(
                'title' => esc_html__('Blog page type', 'naturally'),
                'subtitle' => esc_html__('Select blog page layout type.', 'naturally'),
                'id' => 'index_type',
                'type' => 'select',
                'customizer' => true,
                'options' => array(
                    '' => esc_html__('Select type', 'naturally'),
                    'default' => esc_html__('default', 'naturally'),
                    'masonry' => esc_html__('masonry', 'naturally'),
                ),
                'default' => 'masonry'
            ),
            array(
                'title' => esc_html__('Blog page masonry column width', 'naturally'),
                'subtitle' => esc_html__('Select a column number.', 'naturally'),
                'id' => 'index_masonry_column',
                'type' => 'select',
                'customizer' => true,
                'options' => array(
                    '' => esc_html__('Select type', 'naturally'),
                    'col-lg-6' => esc_html__('2 column', 'naturally'),
                    'col-lg-4' => esc_html__('3 column', 'naturally')
                ),
                'default' => 'col-lg-6',
                'required' => array( 'index_type', '=', 'masonry' )
            ),
            array(
                'title' => esc_html__('Blog Post Title Display', 'naturally'),
                'subtitle' => esc_html__('You can enable or disable the site blog index page post title with switch option.', 'naturally'),
                'id' => 'post_title_visibility',
                'type' => 'switch',
                'default' => 1,
                'on' => 'On',
                'off' => 'Off'
            ),
            array(
                'title' => esc_html__('Blog Post Meta Display', 'naturally'),
                'subtitle' => esc_html__('You can enable or disable the site blog index page post meta with switch option.', 'naturally'),
                'id' => 'post_meta_visibility',
                'type' => 'switch',
                'default' => 1,
                'on' => 'On',
                'off' => 'Off'
            ),
            array(
                'title' => esc_html__('Blog Post Category Display', 'naturally'),
                'subtitle' => esc_html__('You can enable or disable the site blog index page post category with switch option.', 'naturally'),
                'id' => 'post_category_visibility',
                'type' => 'switch',
                'default' => 1,
                'on' => 'On',
                'off' => 'Off'
            ),
            array(
                'title' => esc_html__('Blog Post Author Display', 'naturally'),
                'subtitle' => esc_html__('You can enable or disable the site blog index page post author with switch option.', 'naturally'),
                'id' => 'post_author_visibility',
                'type' => 'switch',
                'default' => 1,
                'on' => 'On',
                'off' => 'Off',
                'required' => array( 'post_meta_visibility', '=', '1' )
            ),
            array(
                'title' => esc_html__('Blog Post Date Display', 'naturally'),
                'subtitle' => esc_html__('You can enable or disable the site blog index page post date with switch option.', 'naturally'),
                'id' => 'post_date_visibility',
                'type' => 'switch',
                'default' => 1,
                'on' => 'On',
                'off' => 'Off',
                'required' => array( 'post_meta_visibility', '=', '1' )
            ),
            array(
                'title' => esc_html__('Blog Post Comments Display', 'naturally'),
                'subtitle' => esc_html__('You can enable or disable the site blog index page post comments with switch option.', 'naturally'),
                'id' => 'post_comments_visibility',
                'type' => 'switch',
                'default' => 1,
                'on' => 'On',
                'off' => 'Off',
                'required' => array( 'post_meta_visibility', '=', '1' )
            ),
            array(
                'title' => esc_html__('Blog Post Excerpt Display', 'naturally'),
                'subtitle' => esc_html__('You can enable or disable the site blog index page post meta with switch option.', 'naturally'),
                'id' => 'post_excerpt_visibility',
                'type' => 'switch',
                'default' => 1,
                'on' => 'On',
                'off' => 'Off'
            ),
            array(
                'title' => esc_html__('Post Excerpt Size (max word count)', 'naturally'),
                'subtitle' => esc_html__('You can control blog post excerpt size with this option.', 'naturally'),
                'id' => 'excerptsz',
                'type' => 'slider',
                'default' => 30,
                'min' => 0,
                'step' => 1,
                'max' => 100,
                'display_value' => 'text',
                'required' => array( 'post_excerpt_visibility', '=', '1' )
            ),
            array(
                'title' => esc_html__('Blog Post Button Display', 'naturally'),
                'subtitle' => esc_html__('You can enable or disable the site blog index page post read more button wityh switch option.', 'naturally'),
                'id' => 'post_button_visibility',
                'type' => 'switch',
                'default' => 1,
                'on' => 'On',
                'off' => 'Off'
            ),
            array(
                'title' => esc_html__('Blog Post Button Title', 'naturally'),
                'subtitle' => esc_html__('Add your blog post read more button title here.', 'naturally'),
                'id' => 'post_button_title',
                'type' => 'text',
                'default' => esc_html__('Read More', 'naturally'),
                'required' => array( 'post_button_visibility', '=', '1' )
            )
    )));

    /*************************************************
    ## SINGLE PAGE SECTION
    *************************************************/
    Redux::setSection($naturally_pre, array(
        'title' => esc_html__('Single Page', 'naturally'),
        'id' => 'singlesection',
        'icon' => 'el el-home-alt',
    ));
    // SINGLE HERO SUBSECTION
    Redux::setSection($naturally_pre, array(
        'title' => esc_html__('Single Hero', 'naturally'),
        'desc' => esc_html__('These are single page hero section settings!', 'naturally'),
        'id' => 'singleherosubsection',
        'subsection' => true,
        'icon' => 'el el-brush',
        'fields' => array(
            array(
                'title' => esc_html__('Single Hero display', 'naturally'),
                'subtitle' => esc_html__('You can enable or disable the site single page hero section with switch option.', 'naturally'),
                'id' => 'single_hero_visibility',
                'type' => 'switch',
                'default' => 1,
                'on' => 'On',
                'off' => 'Off',
            ),
            array(
                'title' => esc_html__('Single Hero Background', 'naturally'),
                'id' => 'single_hero_bg',
                'type' => 'background',
                'required' => array( 'single_hero_visibility', '=', '1' ),
            ),
            array(
                'title' => esc_html__('Single Title Typography', 'naturally'),
                'id' => 'single_title_typo',
                'type' => 'typography',
                'font-backup' => false,
                'letter-spacing' => true,
                'text-transform' => true,
                'all_styles' => true,
                'output' => array( '#nt-single .nt-hero-title' ),
                'units' => 'px',
                'default' => array(
                    'color' => '',
                    'font-style' => '',
                    'font-family' => '',
                    'google' => true,
                    'font-size' => '',
                    'line-height' => ''
                ),
                'required' => array( 'single_hero_visibility', '=', '1' ),
            ),
            array(
                'title' => esc_html__('Single Site Title', 'naturally'),
                'subtitle' => esc_html__('Add your single page site title here.', 'naturally'),
                'id' => 'single_site_title',
                'type' => 'textarea',
                'default' => get_bloginfo('name'),
                'required' => array( 'single_hero_visibility', '=', '1' ),
            ),
            array(
                'title' => esc_html__('Single Site Title Typography', 'naturally'),
                'id' => 'single_site_title_typo',
                'type' => 'typography',
                'font-backup' => false,
                'letter-spacing' => true,
                'text-transform' => true,
                'all_styles' => true,
                'output' => array( '#nt-single .nt-hero-subtitle' ),
                'default' => array(
                    'color' => '',
                    'font-style' => '',
                    'font-family' => '',
                    'google' => true,
                    'font-size' => '',
                    'line-height' => ''
                ),
                'required' => array( 'single_hero_visibility', '=', '1' ),
            )
    )));
    // SINGLE CONTENT SUBSECTION
    Redux::setSection($naturally_pre, array(
        'title' => esc_html__('Single Content', 'naturally'),
        'id' => 'singlecontentsubsection',
        'subsection' => true,
        'icon' => 'el el-brush',
        'fields' => array(
            array(
                'title' => esc_html__('Single Post Meta Display', 'naturally'),
                'subtitle' => esc_html__('You can enable or disable the site single page post meta with switch option.', 'naturally'),
                'id' => 'single_postmeta_all_visibility',
                'type' => 'switch',
                'default' => 1,
                'on' => 'On',
                'off' => 'Off'
            ),
            array(
                'title' => esc_html__('Single Post Date Display', 'naturally'),
                'subtitle' => esc_html__('You can enable or disable the site single page post date with switch option.', 'naturally'),
                'id' => 'single_postmeta_date_visibility',
                'type' => 'switch',
                'default' => 1,
                'on' => 'On',
                'off' => 'Off',
                'required' => array( 'single_postmeta_all_visibility', '=', '1' )
            ),
            array(
                'title' => esc_html__('Single Post Author Display', 'naturally'),
                'subtitle' => esc_html__('You can enable or disable the site single page post author with switch option.', 'naturally'),
                'id' => 'single_postmeta_author_visibility',
                'type' => 'switch',
                'default' => 1,
                'on' => 'On',
                'off' => 'Off',
                'required' => array( 'single_postmeta_all_visibility', '=', '1' )
            ),
            array(
                'title' => esc_html__('Single Post Categories Display', 'naturally'),
                'subtitle' => esc_html__('You can enable or disable the site single page post categories with switch option.', 'naturally'),
                'id' => 'single_postmeta_cats_visibility',
                'type' => 'switch',
                'default' => 1,
                'on' => 'On',
                'off' => 'Off',
                'required' => array( 'single_postmeta_all_visibility', '=', '1' )
            ),
            array(
                'title' => esc_html__('Single Post Comment Numbers Display', 'naturally'),
                'subtitle' => esc_html__('You can enable or disable the site single page post comments number with switch option.', 'naturally'),
                'id' => 'single_postmeta_comments_visibility',
                'type' => 'switch',
                'default' => 1,
                'on' => 'On',
                'off' => 'Off',
                'required' => array( 'single_postmeta_all_visibility', '=', '1' )
            ),
            array(
                'title' => esc_html__('Single Post Tags Display', 'naturally'),
                'subtitle' => esc_html__('You can enable or disable the site single page post meta tags with switch option.', 'naturally'),
                'id' => 'single_postmeta_tags_visibility',
                'type' => 'switch',
                'default' => 1,
                'on' => 'On',
                'off' => 'Off'
            ),
            array(
                'title' => esc_html__('Single Post Share Icon Display', 'naturally'),
                'subtitle' => esc_html__('You can enable or disable the site single page post share icons with switch option.', 'naturally'),
                'id' => 'single_postmeta_share_visibility',
                'type' => 'switch',
                'default' => 1,
                'on' => 'On',
                'off' => 'Off'
            ),
            array(
                'title' => esc_html__('Single Post Authorbox', 'naturally'),
                'subtitle' => esc_html__('You can enable or disable the site single page post authorbox with switch option.', 'naturally'),
                'id' => 'single_post_author_box_visibility',
                'type' => 'switch',
                'default' => 0,
                'on' => 'On',
                'off' => 'Off'
            ),
            array(
                'title' => esc_html__('Single Post Pagination Display', 'naturally'),
                'subtitle' => esc_html__('You can enable or disable the site single page post next and prev pagination with switch option.', 'naturally'),
                'id' => 'single_navigation_visibility',
                'type' => 'switch',
                'default' => 0,
                'on' => 'On',
                'off' => 'Off'
            ),
            array(
                'title' => esc_html__('Single Related Post Display', 'naturally'),
                'subtitle' => esc_html__('You can enable or disable the site single page related post with switch option.', 'naturally'),
                'id' => 'single_related_visibility',
                'type' => 'switch',
                'default' => 1,
                'on' => 'On',
                'off' => 'Off'
            ),
            array(
                'title' => esc_html__('Single Related Post Count', 'naturally'),
                'subtitle' => esc_html__('You can control related post count with this option.', 'naturally'),
                'id' => 'related_perpage',
                'type' => 'slider',
                'default' => 3,
                'min' => 1,
                'step' => 1,
                'max' => 24,
                'display_value' => 'text',
                'required' => array( 'single_related_visibility', '=', '1' )
            ),
            array(
                'title' => esc_html__('Related Section Title', 'naturally'),
                'subtitle' => esc_html__('Add your single page related post section title here.', 'naturally'),
                'id' => 'related_title',
                'type' => 'text',
                'default' => esc_html__('You May Also Like', 'naturally'),
                'required' => array( 'single_related_visibility', '=', '1' )
            )
    )));
    /*************************************************
    ## ARCHIVE PAGE SECTION
    *************************************************/
    Redux::setSection($naturally_pre, array(
        'title' => esc_html__('Archive Page', 'naturally'),
        'id' => 'archivesection',
        'icon' => 'el el-folder-open',
    ));
    // ARCHIVE PAGE SECTION
    Redux::setSection($naturally_pre, array(
        'title' => esc_html__('Archive Hero', 'naturally'),
        'desc' => esc_html__('These are archive page hero settings!', 'naturally'),
        'id' => 'archiveherosubsection',
        'subsection' => true,
        'icon' => 'el el-brush',
        'fields' => array(
            array(
                'title' => esc_html__('Archive Hero display', 'naturally'),
                'subtitle' => esc_html__('You can enable or disable the site archive page hero section with switch option.', 'naturally'),
                'id' => 'archive_hero_visibility',
                'type' => 'switch',
                'default' => 1,
                'on' => 'On',
                'off' => 'Off',
            ),
            array(
                'title' => esc_html__('Archive Hero Background', 'naturally'),
                'id' => 'archive_hero_bg',
                'type' => 'background',
                'required' => array( 'archive_hero_visibility', '=', '1' ),
            ),
            array(
                'title' => esc_html__('Custom Archive Title', 'naturally'),
                'subtitle' => esc_html__('Add your custom archive page title here.', 'naturally'),
                'id' => 'archive_title',
                'type' => 'text',
                'default' => esc_html__('ARCHIVE', 'naturally'),
                'required' => array( 'archive_hero_visibility', '=', '1' ),
            ),
            array(
                'title' => esc_html__('Archive Title Typography', 'naturally'),
                'id' => 'archive_title_typo',
                'type' => 'typography',
                'font-backup' => false,
                'letter-spacing' => true,
                'text-transform' => true,
                'all_styles' => true,
                'output' => array( '#nt-archive .nt-hero-title' ),
                'default' => array(
                    'color' => '',
                    'font-style' => '',
                    'font-family' => '',
                    'google' => true,
                    'font-size' => '',
                    'line-height' => ''
                ),
                'required' => array( 'archive_hero_visibility', '=', '1' ),
            ),
            array(
                'title' => esc_html__('Archive Site Title', 'naturally'),
                'subtitle' => esc_html__('Add your archive page site title here.', 'naturally'),
                'id' => 'archive_site_title',
                'type' => 'textarea',
                'default' => get_bloginfo('name'),
                'required' => array( 'archive_hero_visibility', '=', '1' ),
            ),
            array(
                'title' => esc_html__('Archive Site Title Typography', 'naturally'),
                'id' => 'archive_site_title_typo',
                'type' => 'typography',
                'font-backup' => false,
                'letter-spacing' => true,
                'text-transform' => true,
                'all_styles' => true,
                'output' => array( '#nt-archive .nt-hero-subtitle' ),
                'default' => array(
                    'color' => '',
                    'font-style' => '',
                    'font-family' => '',
                    'google' => true,
                    'font-size' => '',
                    'line-height' => ''
                ),
                'required' => array( 'archive_hero_visibility', '=', '1' ),
            )
    )));
    /*************************************************
    ## 404 PAGE SECTION
    *************************************************/
    Redux::setSection($naturally_pre, array(
        'title' => esc_html__('404 Page', 'naturally'),
        'id' => 'errorsection',
        'icon' => 'el el-error',
        'fields' => array(
            array(
                'title' => esc_html__('404 Background', 'naturally'),
                'id' => 'error_content_bg_img',
                'type' => 'background',
                'output' => array( '#nt-404 .section-404' ),
            ),
            array(
                'title' => esc_html__('Content Title Display', 'naturally'),
                'subtitle' => esc_html__('You can enable or disable the site 404 page content title with switch option.', 'naturally'),
                'id' => 'error_content_title_visibility',
                'type' => 'switch',
                'default' => 1,
                'on' => 'On',
                'off' => 'Off',
            ),
            array(
                'title' => esc_html__('Content Title', 'naturally'),
                'subtitle' => esc_html__('Add your 404 page content title here.', 'naturally'),
                'id' => 'error_content_title',
                'type' => 'textarea',
                'default' => 'Page not found',
                'required' => array( 'error_content_title_visibility', '=', '1' )
            ),
            array(
                'title' => esc_html__('Title Typography', 'naturally'),
                'id' => 'error_content_title_typo',
                'type' => 'typography',
                'font-backup' => false,
                'letter-spacing' => true,
                'text-transform' => true,
                'all_styles' => true,
                'output' => array( '#nt-404 .nt-error-title' ),
                'default' => array(
                    'color' => '',
                    'font-style' => '',
                    'font-family' => '',
                    'google' => true,
                    'font-size' => '',
                    'line-height' => ''
                ),
                'required' => array( 'error_content_title_visibility', '=', '1' )
            ),
            array(
                'title' => esc_html__('Content Description Display', 'naturally'),
                'subtitle' => esc_html__('You can enable or disable the site 404 page content description with switch option.', 'naturally'),
                'id' => 'error_content_desc_visibility',
                'type' => 'switch',
                'default' => 1,
                'on' => 'On',
                'off' => 'Off'
            ),
            array(
                'title' => esc_html__('Content Description', 'naturally'),
                'subtitle' => esc_html__('Add your 404 page content description here.', 'naturally'),
                'id' => 'error_content_desc',
                'type' => 'textarea',
                'default' => 'Sorry, but the page you are looking for does not exist or has been removed',
                'required' => array( 'error_content_desc_visibility', '=', '1' )
            ),
            array(
                'title' =>esc_html__('Description Typography', 'naturally'),
                'id' => 'error_page_content_desc_typo',
                'type' => 'typography',
                'font-backup' => false,
                'letter-spacing' => true,
                'text-transform' => true,
                'all_styles' => true,
                'output' => array( '#nt-404 .nt-error-desc' ),
                'default' => array(
                    'color' =>'',
                    'font-style' => '',
                    'font-family' => '',
                    'google' => true,
                    'font-size' => '',
                    'line-height' => ''
                ),
                'required' => array( 'error_content_desc_visibility', '=', '1' )
            ),
            array(
                'title' => esc_html__('Button Display', 'naturally'),
                'subtitle' => esc_html__('You can enable or disable the site 404 page content back to home button with switch option.', 'naturally'),
                'id' => 'error_content_btn_visibility',
                'type' => 'switch',
                'default' => 1,
                'on' => 'On',
                'off' => 'Off'
            ),
            array(
                'title' => esc_html__('Button Title', 'naturally'),
                'subtitle' => esc_html__('Add your 404 page content back to home button title here.', 'naturally'),
                'id' => 'error_content_btn_title',
                'type' => 'text',
                'default' => 'Home Page',
                'required' => array( 'error_content_btn_visibility', '=', '1' )
            ),
    )));
    /*************************************************
    ## SEARCH PAGE SECTION
    *************************************************/
    Redux::setSection($naturally_pre, array(
        'title' => esc_html__('Search Page', 'naturally'),
        'id' => 'searchsection',
        'icon' => 'el el-search',
    ));
    //SEARCH PAGE SECTION
    Redux::setSection($naturally_pre, array(
        'title' => esc_html__('Search Hero', 'naturally'),
        'id' => 'searchherosubsection',
        'desc' => esc_html__('These are main settings for general theme!', 'naturally'),
        'icon' => 'el el-search',
        'subsection' => true,
        'fields' => array(
            array(
                'title' => esc_html__('Search Hero display', 'naturally'),
                'subtitle' => esc_html__('You can enable or disable the site search page hero section with switch option.', 'naturally'),
                'id' => 'search_hero_visibility',
                'type' => 'switch',
                'default' => 1,
                'on' => 'On',
                'off' => 'Off'
            ),
            array(
                'title' => esc_html__('Search Hero Background', 'naturally'),
                'id' =>'search_hero_bg',
                'type' => 'background',
                'output' => array( '#nt-search .hero-container' ),
                'required' => array( 'search_hero_visibility', '=', '1' )
            ),
            array(
                'title' => esc_html__('Search Title', 'naturally'),
                'subtitle' => esc_html__('Add your search page title here.', 'naturally'),
                'id' => 'search_title',
                'type' => 'text',
                'default' => esc_html__('Search results for :', 'naturally'),
                'required' => array( 'search_hero_visibility', '=', '1' )
            ),
            array(
                'title' => esc_html__('Search Title Typography', 'naturally'),
                'id' => 'search_title_typo',
                'type' => 'typography',
                'font-backup' => false,
                'letter-spacing' => true,
                'text-transform' => true,
                'all_styles' => true,
                'output' => array( '#nt-search .nt-hero-title' ),
                'default' => array(
                    'color' => '',
                    'font-style' => '',
                    'font-family' => '',
                    'google' => true,
                    'font-size' => '',
                    'line-height' => ''
                ),
                'required' => array( 'search_hero_visibility', '=', '1' )
            ),
            array(
                'title' => esc_html__('Search Site Title', 'naturally'),
                'subtitle' => esc_html__('Add your search page site title here.', 'naturally'),
                'id' => 'search_site_title',
                'type' => 'textarea',
                'default' => get_bloginfo('name'),
                'required' => array( 'search_hero_visibility', '=', '1' )
            ),
            array(
                'title' => esc_html__('Search Site Title Typography', 'naturally'),
                'id' => 'search_site_title_typo',
                'type' => 'typography',
                'font-backup' => false,
                'letter-spacing' => true,
                'text-transform' => true,
                'all_styles' => true,
                'output' => array( '#nt-search .nt-hero-subtitle' ),
                'default' => array(
                    'color' => '',
                    'font-style' => '',
                    'font-family' => '',
                    'google' => true,
                    'font-size' => '',
                    'line-height' => ''
                ),
                'required' => array( 'search_hero_visibility', '=', '1' )
            )
    )));
    //FOOTER SECTION
    Redux::setSection($naturally_pre, array(
        'title' => esc_html__('Footer', 'naturally'),
        'desc' => esc_html__('These are main settings for general theme!', 'naturally'),
        'id' => 'footersection',
        'icon' => 'el el-photo',
        'fields' => array(
            array(
                'title' => esc_html__('Footer Section Display', 'naturally'),
                'subtitle' => esc_html__('You can enable or disable the site footer copyright and footer widget area on the site with switch option.', 'naturally'),
                'id' => 'footer_visibility',
                'type' => 'switch',
                'default' => 1,
                'on' => 'On',
                'off' => 'Off'
            ),
            array(
                'title' => esc_html__('Footer Type', 'naturally'),
                'subtitle' => esc_html__('Select your footer type.', 'naturally'),
                'id' => 'footer_type',
                'type' => 'select',
                'customizer' => true,
                'options' => array(
                    'default' => esc_html__('Deafult Site Footer', 'naturally'),
                    'elementor' => esc_html__('Elementor Templates', 'naturally'),
                    'custom' => esc_html__('Custom Footer', 'naturally'),
                ),
                'default' => 'default',
                'required' => array( 'footer_visibility', '=', '1' )
            ),
            array(
                'title' => esc_html__('Elementor Templates', 'naturally'),
                'subtitle' => esc_html__('Select a template from elementor templates.', 'naturally'),
                'id' => 'footer_elementor_templates',
                'type' => 'select',
                'customizer' => true,
                'multi' => function_exists('icl_object_id') ? true : false,
                'options' => naturally_get_elementorTemplates(),
                'required' => array(
                    array( 'footer_visibility', '=', '1' ),
                    array( 'footer_type', '=', 'elementor' )
                ),
            ),
            array(
                'title' => esc_html__('Create your custom footer', 'naturally'),
                'subtitle' => esc_html__('HTML allowed (wp_kses)', 'naturally'),
                'id' => 'custom_footer',
                'type' => 'textarea',
                'validate' => 'html',
                'placeholder' => esc_html__('Enter your custom footer here. Html can be entered in this field.', 'naturally'),
                'required' => array(
                    array( 'footer_visibility', '=', '1' ),
                    array( 'footer_type', '=', 'custom' )
                ),
            ),
            array(
                'title' => esc_html__('Footer Padding', 'naturally'),
                'subtitle' => esc_html__('You can set the top spacing of the site main footer.', 'naturally'),
                'id' => 'footer_pad',
                'type' => 'spacing',
                'output' => array('#nt-footer.footer'),
                'mode' => 'padding',
                'units' => array('em', 'px'),
                'units_extended' => 'false',
                'default' => array(
                    'padding-top' => '',
                    'padding-right' => '',
                    'padding-bottom' => '',
                    'padding-left' => '',
                    'units' => 'px'
                ),
                'required' => array(
                    array( 'footer_visibility', '=', '1' ),
                    array( 'footer_type', '=', 'default' )
                )
            ),
            array(
                'title' => esc_html__('Footer Background Color', 'naturally'),
                'desc' => esc_html__('Set your own colors for the footer.', 'naturally'),
                'id' => 'footer_bg_clr',
                'type' => 'color',
                'mode' => 'background-color',
                'output' => array( '#nt-footer.footer' ),
                'required' => array(
                    array( 'footer_visibility', '=', '1' ),
                    array( 'footer_type', '=', 'default' )
                )
            ),
            //information on-off
            array(
                'id' =>'info_f0',
                'type' => 'info',
                'style' => 'success',
                'title' => esc_html__('Success!', 'naturally'),
                'icon' => 'el el-info-circle',
                'customizer' => false,
                'desc' => sprintf(esc_html__('%s section is disabled on the site.Please activate to view subsection options.', 'naturally'), '<b>Site Main Footer</b>'),
                'required' => array( 'footer_visibility', '=', '0' )
            )
    )));
    //FOOTER SECTION
    Redux::setSection($naturally_pre, array(
        'title' => esc_html__('Footer Copyright', 'naturally'),
        'desc' => esc_html__('These are main settings for general theme!', 'naturally'),
        'id' => 'footercopyrightsubsection',
        'icon' => 'el el-photo',
        'subsection' => true,
        'fields' => array(
            array(
                'title' => esc_html__('Copyright Section Display', 'naturally'),
                'subtitle' => esc_html__('You can enable or disable the site footer section on the site with switch option.', 'naturally'),
                'id' => 'footer_copyright_visibility',
                'type' => 'switch',
                'default' => 1,
                'on' => 'On',
                'off' => 'Off',
                'required' => array( 'footer_visibility', '=', '1' )
            ),
            array(
                'title' => esc_html__('Copyright Text', 'naturally'),
                'subtitle' => esc_html__('HTML allowed (wp_kses)', 'naturally'),
                'desc' => esc_html__('Enter your site copyright here.', 'naturally'),
                'id' => 'footer_copyright',
                'type' => 'textarea',
                'validate' => 'html',
                'default' => sprintf('&copy; %1$s <a href="%2$s">%3$s</a> %4$s <a href="%5$s" target="_blank">%6$s</a>',
                    date('Y'),
                    esc_url( home_url( '/' ) ),
                    get_bloginfo( 'name' ),
                    esc_html__('All rights reserved by', 'naturally'),
                    esc_url( home_url( '/' ) ),
                    esc_html__('Ninetheme.', 'naturally')
                ),
                'required' => array(
                    array( 'footer_visibility', '=', '1' ),
                    array( 'footer_copyright_visibility', '=', '1' ),
                    array( 'footer_type', '=', 'default' )
                )
            ),
            array(
                'id' =>'footer_color_customize',
                'type' => 'info',
                'icon' => 'el el-brush',
                'customizer' => false,
                'desc' => sprintf(esc_html__('%s', 'naturally'), '<h2>Footer Color Customize</h2>'),
                'required' => array(
                    array( 'footer_visibility', '=', '1' ),
                    array( 'footer_copyright_visibility', '=', '1' ),
                    array( 'footer_type', '=', 'default' )
                )
            ),
            array(
                'title' => esc_html__('Copyright Text Color', 'naturally'),
                'desc' => esc_html__('Set your own colors for the copyright.', 'naturally'),
                'id' => 'footer_copy_clr',
                'type' => 'color',
                'transparent' => false,
                'output' => array( '#nt-footer.footer .copyright, #nt-footer.footer .copyright p' ),
                'required' => array(
                    array( 'footer_visibility', '=', '1' ),
                    array( 'footer_copyright_visibility', '=', '1' ),
                    array( 'footer_type', '=', 'default' )
                )
            ),
            array(
                'title' => esc_html__('Link Color', 'naturally'),
                'desc' => esc_html__('Set your own colors for the copyright.', 'naturally'),
                'id' => 'footer_link_clr',
                'type' => 'color',
                'transparent' => false,
                'output' => array( '#nt-footer.footer a' ),
                'required' => array(
                    array( 'footer_visibility', '=', '1' ),
                    array( 'footer_copyright_visibility', '=', '1' ),
                    array( 'footer_type', '=', 'default' )
                )
            ),
            array(
                'title' => esc_html__('Link Color ( Hover )', 'naturally'),
                'desc' => esc_html__('Set your own colors for the copyright.', 'naturally'),
                'id' => 'footer_link_hvr_clr',
                'type' => 'color',
                'transparent' => false,
                'output' => array( '#nt-footer.footer a:hover' ),
                'required' => array(
                    array( 'footer_visibility', '=', '1' ),
                    array( 'footer_copyright_visibility', '=', '1' ),
                    array( 'footer_type', '=', 'default' )
                )
            ),
            //information on-off
            array(
                'id' =>'info_fc0',
                'type' => 'info',
                'style' => 'success',
                'title' => esc_html__('Success!', 'naturally'),
                'icon' => 'el el-info-circle',
                'customizer' => false,
                'desc' => sprintf(esc_html__('%s section is disabled on the site.Please activate to view subsection options.', 'naturally'), '<b>Site Main Footer</b>'),
                'required' => array( 'footer_visibility', '=', '0' )
            ),
            array(
                'id' =>'info_fc1',
                'type' => 'info',
                'style' => 'success',
                'title' => esc_html__('Success!', 'naturally'),
                'icon' => 'el el-info-circle',
                'customizer' => false,
                'desc' => sprintf(esc_html__('%s section is disabled on the site. Please activate to view subsection options.', 'naturally'), '<b>Site Footer Copyright</b>'),
                'required' => array( 'footer_copyright_visibility', '=', '0' )
            )
    )));

    //FOOTER WIDGETIZE SUBSECTION
    Redux::setSection($naturally_pre, array(
        'title' => esc_html__('Footer Widget Area', 'naturally'),
        'id' => 'footerwidgetizesection',
        'icon' => 'el el-th-large',
        'subsection' => true,
        'fields' => array(
            array(
                'title' => esc_html__('Footer Widget Area Section Display', 'naturally'),
                'subtitle' => esc_html__('You can enable or disable the footer widget area with one option.', 'naturally'),
                'id' => 'footer_widgetize_visibility',
                'type' => 'switch',
                'default' => 0,
                'on' => 'On',
                'off' => 'Off',
                array( 'footer_visibility', '=', '1' ),
                array( 'footer_type', '=', 'default' )
            ),
            array(
                'title' => esc_html__('Footer Widget Area Background', 'naturally'),
                'id' => 'fw_bg',
                'type' => 'background',
                'output' => array( '.nt-footer-sidebar' ),
                'required' => array(
                    array( 'footer_visibility', '=', '1' ),
                    array( 'footer_widgetize_visibility', '=', '1' ),
                    array( 'footer_type', '=', 'default' )
                )
            ),
            array(
                'title' => esc_html__('Widget Title Colors', 'naturally'),
                'desc' => esc_html__('Set your own color for the widgets title.', 'naturally'),
                'id' => 'fw_w',
                'type' => 'color',
                'output' => array( '.nt-footer-sidebar .nt-footer-widget-title' ),
                'required' => array(
                    array( 'footer_visibility', '=', '1' ),
                    array( 'footer_widgetize_visibility', '=', '1' ),
                    array( 'footer_type', '=', 'default' )
                )
            ),
            array(
                'title' => esc_html__('Widget Link Color', 'naturally'),
                'desc' => esc_html__('Set your own color for the widgets link.', 'naturally'),
                'id' => 'fw_wa',
                'type' => 'color',
                'output' => array( '#nt-footer.nt-footer-sidebar ul li a' ),
                'required' => array(
                    array( 'footer_visibility', '=', '1' ),
                    array( 'footer_widgetize_visibility', '=', '1' ),
                    array( 'footer_type', '=', 'default' )
                )
            ),
            array(
                'title' => esc_html__('Widget Hover Link Color', 'naturally'),
                'desc' => esc_html__('Set your own hover colors for the widgets link.', 'naturally'),
                'id' => 'fw_wha',
                'type' => 'color',
                'output' => array( '#nt-footer.nt-footer-sidebar ul li a:hover' ),
                'required' => array(
                    array( 'footer_visibility', '=', '1' ),
                    array( 'footer_widgetize_visibility', '=', '1' ),
                    array( 'footer_type', '=', 'default' )
                )
            ),
            array(
                'title' => esc_html__('Widget Text Color', 'naturally'),
                'desc' => esc_html__('Set your own colors for the widgets.', 'naturally'),
                'id' => 'fw_wp',
                'type' => 'color',
                'output' => array( '#nt-footer.nt-footer-sidebar, #nt-footer.nt-footer-sidebar p' ),
                'required' => array(
                    array( 'footer_visibility', '=', '1' ),
                    array( 'footer_widgetize_visibility', '=', '1' ),
                    array( 'footer_type', '=', 'default' )
                )
            ),
            array(
                'title' => esc_html__('Widget Area Padding', 'naturally'),
                'subtitle' => esc_html__('You can set the top spacing of the widget area.', 'naturally'),
                'id' => 'fw_pad',
                'type' => 'spacing',
                'output' => array('#nt-footer.nt-footer-sidebar'),
                'mode' => 'padding',
                'units' => array('em', 'px'),
                'units_extended' => 'false',
                'default' => array(
                    'padding-top' => '',
                    'padding-right' => '',
                    'padding-bottom' => '',
                    'padding-left' => '',
                    'units' => 'px'
                ),
                'required' => array(
                    array( 'footer_visibility', '=', '1' ),
                    array( 'footer_widgetize_visibility', '=', '1' ),
                    array( 'footer_type', '=', 'default' )
                )
            ),
            //information on-off
            array(
                'id' =>'info_fw0',
                'type' => 'info',
                'style' => 'success',
                'title' => esc_html__('Success!', 'naturally'),
                'icon' => 'el el-info-circle',
                'customizer' => false,
                'desc' => sprintf(esc_html__('%s section is disabled on the site. Please activate to view subsection options.', 'naturally'), '<b>Site Main Footer</b>'),
                'required' => array( 'footer_visibility', '=', '0' )
            ),
            array(
                'id' =>'info_fw1',
                'type' => 'info',
                'style' => 'success',
                'title' => esc_html__('Success!', 'naturally'),
                'icon' => 'el el-info-circle',
                'customizer' => false,
                'desc' => sprintf(esc_html__('%s section is disabled on the site. Please activate to view subsection options.', 'naturally'), '<b>Footer Widget Area</b>'),
                'required' => array( 'footer_widgetize_visibility', '=', '0' )
            )
    )));

    Redux::setSection($naturally_pre, array(
        'id' => 'inportexport_settings',
        'title' => esc_html__('Import / Export', 'naturally'),
        'desc' => esc_html__('Import and Export your Theme Options from text or URL.', 'naturally'),
        'icon' => 'fa fa-download',
        'fields' => array(
            array(
                'id' => 'opt-import-export',
                'type' => 'import_export',
                'title' => '',
                'customizer' => false,
                'subtitle' => '',
                'full_width' => true
            )
    )));
    Redux::setSection($naturally_pre, array(
    'id' => 'nt_support_settings',
    'title' => esc_html__('Support', 'naturally'),
    'icon' => 'el el-idea',
    'fields' => array(
        array(
            'id' => 'doc',
            'type' => 'raw',
            'markdown' => true,
            'class' => 'theme_support',
            'content' => '<div class="support-section">
            <h5>'.esc_html__('WE RECOMMEND YOU READ IT BEFORE YOU START', 'naturally').'</h5>
            <h2><i class="el el-website"></i> '.esc_html__('DOCUMENTATION', 'naturally').'</h2>
            <a target="_blank" class="button" href="https://ninetheme.com/documentations/">'.esc_html__('READ MORE', 'naturally').'</a>
            </div>'
        ),
        array(
            'id' => 'support',
            'type' => 'raw',
            'markdown' => true,
            'class' => 'theme_support',
            'content' => '<div class="support-section">
            <h5>'.esc_html__('DO YOU NEED HELP?', 'naturally').'</h5>
            <h2><i class="el el-adult"></i> '.esc_html__('SUPPORT CENTER', 'naturally').'</h2>
            <a target="_blank" class="button" href="https://ninetheme.com/contact/">'.esc_html__('GET SUPPORT', 'naturally').'</a>
            </div>'
        ),
        array(
            'id' => 'portfolio',
            'type' => 'raw',
            'markdown' => true,
            'class' => 'theme_support',
            'content' => '<div class="support-section">
            <h5>'.esc_html__('SEE MORE THE NINETHEME WORDPRESS THEMES', 'naturally').'</h5>
            <h2><i class="el el-picture"></i> '.esc_html__('NINETHEME PORTFOLIO', 'naturally').'</h2>
            <a target="_blank" class="button" href="https://ninetheme.com/wordpress-themes/">'.esc_html__('SEE MORE', 'naturally').'</a>
            </div>'
        ),
        array(
            'id' => 'like',
            'type' => 'raw',
            'markdown' => true,
            'class' => 'theme_support',
            'content' => '<div class="support-section">
            <h5>'.esc_html__('WOULD YOU LIKE TO REWARD OUR EFFORT?', 'naturally').'</h5>
            <h2><i class="el el-thumbs-up"></i> '.esc_html__('PLEASE RATE US!', 'naturally').'</h2>
            <a target="_blank" class="button" href="https://themeforest.net/downloads/">'.esc_html__('GET STARS', 'naturally').'</a>
            </div>'
        )
    )));

    /*
     * <--- END SECTIONS
     */


    /** Action hook examples **/

    function naturally_remove_demo()
    {
        // Used to hide the demo mode link from the plugin page. Only used when Redux is a plugin.
        if (class_exists('ReduxFrameworkPlugin')) {
            // Used to hide the activation notice informing users of the demo panel. Only used when Redux is a plugin.
            remove_action('admin_notices', array( ReduxFrameworkPlugin::instance(), 'admin_notices' ));
        }
    }
    include get_template_directory() . '/inc/core/theme-options/redux-extensions/loader.php';
    function naturally_newIconFont() {
        // Uncomment this to remove elusive icon from the panel completely
        // wp_deregister_style( 'redux-elusive-icon' );
        // wp_deregister_style( 'redux-elusive-icon-ie7' );
        wp_register_style(
            'redux-font-awesome',
            '//stackpath.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css',
            array(),
            time(),
            'all'
        );
        wp_enqueue_style( 'redux-font-awesome' );
    }
    add_action( 'redux/page/naturally/enqueue', 'naturally_newIconFont' );
