<?php
/**
 * Functions which enhance the theme by hooking into WordPress
*/

/*************************************************
## DATA CONTROL FROM THEME-OPTIONS PANEL
*************************************************/
if (! function_exists('naturally_settings')) {
    function naturally_settings( $opt_id, $def_value='' )
    {
        global $naturally;

        $defval = '' != $def_value ? $def_value : false;
        $opt_id = trim( $opt_id );
        $opt    = isset( $naturally[$opt_id] ) ? $naturally[$opt_id] : $defval;

        if ( !class_exists( 'Redux' ) ) {
            return $defval;
        } else {
            return $opt;
        }
    }
}


/*************************************************
## Sidebar function
*************************************************/
if ( ! function_exists( 'naturally_sidebar' ) ) {
    function naturally_sidebar( $sidebar='', $default='' )
    {
        $sidebar = trim( $sidebar );
        $default = is_active_sidebar( $default ) ? $default : false;
        $sidebar = is_active_sidebar( $sidebar ) ? $sidebar : $default;
        if ( $sidebar ) {
            return $sidebar;
        }
        return false;
    }
}

/************************************************************
## DATA CONTROL FROM PAGE METABOX OR ELEMENTOR PAGE SETTINGS
*************************************************************/
if ( !function_exists( 'naturally_page_settings' ) ) {
    function naturally_page_settings( $opt_id, $def_value='' )
    {
        $defval = '' != $def_value ? $def_value : false;
        $page_settings = $defval;
        if( $opt_id ) {

            $template = get_post_meta( get_the_ID(), '_wp_page_template', true );

            switch ( $template ) {
                case 'naturally-elementor-page.php':

                    if ( class_exists( '\Elementor\Core\Settings\Manager' ) ) {
                        // Get the page settings manager
                        $page_settings = \Elementor\Core\Settings\Manager::get_settings_managers( 'page' )->get_model( get_the_ID() );
                        $page_settings = $page_settings->get_settings( 'naturally_elementor_'.trim( $opt_id ) );
                        if('yes' == $page_settings || 'no' == $page_settings ){
                            $page_settings = 'yes' == $page_settings ? '0' : '1';
                        } else {
                            $page_settings = $page_settings;
                        }
                    }

                break;

                case 'default':
                    if ( class_exists( 'ACF' ) && function_exists( 'get_field' ) ) {
                        $page_settings = get_field( 'naturally_'.trim( $opt_id ) );
                        if(is_bool($page_settings)){
                            $page_settings = true === get_field( 'naturally_'.trim( $opt_id ) ) ? '0' : '1';
                        } else {
                            $page_settings = get_field( 'naturally_'.trim( $opt_id ) );
                        }

                    }
                    break;

                default:
                    $page_settings = $defval;
                break;
            }
                return $page_settings;

        } else {

            return $defval;

        }
    }
}


/*************************************************
## GET ELEMENTOR PAGE CUSTOM CSS
*************************************************/
if ( !function_exists( 'naturally_elementor_page_custom_css' ) ) {
    function naturally_elementor_page_custom_css()
    {
        $theCSS = get_option('_naturally_elementor_page_custom_css');
        if ($theCSS ) {
            wp_register_style('naturally-custom-page-style', false);
            wp_enqueue_style('naturally-custom-page-style');
            wp_add_inline_style('naturally-custom-page-style', $theCSS);
        }
    }
}
add_action( 'wp_enqueue_scripts', 'naturally_elementor_page_custom_css' );

/*************************************************
## GET ALL ELEMENTOR PAGE TEMPLATES
# @return array
*************************************************/
if ( !function_exists( 'naturally_get_elementorTemplates' ) ) {
    function naturally_get_elementorTemplates( $type = null )
    {
        if (class_exists('\Elementor\Frontend')) {
            $args = [
                'post_type' => 'elementor_library',
                'posts_per_page' => -1,
            ];
            if ($type) {
                $args['tax_query'] = [
                    [
                        'taxonomy' => 'elementor_library_type',
                        'field' => 'slug',
                        'terms' => $type,
                    ],
                ];
            }
            $page_templates = get_posts($args);
            $options = array();
            if (!empty($page_templates) && !is_wp_error($page_templates)) {
                foreach ($page_templates as $post) {
                    $options[$post->ID] = $post->post_title;
                }
            } else {
                $options = array(
                    '' => esc_html__('No template exist.', 'naturally')
                );
            }
            return $options;
        }
    }
}


/*************************************************
## SANITIZE MODIFIED VC-ELEMENTS OUTPUT
*************************************************/

if ( !function_exists( 'naturally_sanitize_data' ) ) {
    function naturally_sanitize_data( $html_data )
    {
        return $html_data;
    }
}

/*************************************************
## CUSTOM BODY CLASSES
*************************************************/
if ( !function_exists( 'naturally_body_theme_classes' ) ) {
    function naturally_body_theme_classes( $classes )
    {
        global $post;

        $theme_name = wp_get_theme();
        $theme_version = 'nt-version-' . wp_get_theme()->get( 'Version' );
        $header_off = '0' == naturally_settings( 'nav_visibility', '1' ) ? 'header-off' : '';
        $has_block = is_singular( 'post' ) && has_blocks() ? 'nt-single-has-block' : '';
        $dom_opt = get_option( 'elementor_experiment-e_dom_optimization' );

        $classes[] =  class_exists('WooCommerce') && ! is_cart() && ! is_account_page() ? 'nt-page-default' : '';
        $classes[] = $theme_name;
        $classes[] = $theme_version;
        $classes[] = $header_off;
        $classes[] = $has_block;
        $classes[] = $dom_opt;

        return $classes;

    }
    add_filter( 'body_class', 'naturally_body_theme_classes' );
}


/*************************************************
## CUSTOM POST CLASS
*************************************************/
if (! function_exists('naturally_post_theme_class')) {
    function naturally_post_theme_class($classes)
    {
        if ( ! is_single() AND ! is_page() ) {
            $classes[] =  'nt-post-class';
            $classes[] =  is_search() || is_archive() ? 'masonry-item' : '';
            $classes[] =  !is_search() && !is_archive() && 'default' != naturally_settings( 'index_type', 'masonry' ) ? 'masonry-item' : '';
            $classes[] =  !is_search() && !is_archive() && 'default' != naturally_settings( 'index_type', 'masonry' ) ? naturally_settings( 'index_masonry_column' ) : '';
            $classes[] =  is_sticky() ? '-has-sticky ' : '';
            $classes[] =  !has_post_thumbnail() ? 'thumb-none' : '';
            $classes[] =  !get_the_title() ? 'title-none' : '';
            $classes[] =  !has_excerpt() ? 'excerpt-none' : '';
            $classes[] =  naturally_settings( 'format_box_type', '' );
            $classes[] =  wp_link_pages('echo=0') ? 'nt-is-wp-link-pages' : '';
        }
        return $classes;
    }
    add_filter('post_class', 'naturally_post_theme_class');
}

/*************************************************
## THEME HEADER SEARCH FORM
*************************************************/
if (! function_exists('naturally_header_search_form')) {
    function naturally_header_search_form()
    {
        $placeholder = esc_html__('Search...', 'naturally');
        $is_product = class_exists( 'WooCommerce' ) && 'product' == naturally_settings( 'header_search_type', 'default' ) ? '<input type="hidden" name="post_type" value="product" />' : '';
        $form = '<div class="header_search">
                    <div class="container">
                        <form class="header_search_form" role="search" method="get" id="header-widget-searchform" action="' . esc_url(home_url('/')) . '" >
                            <input class="header_search_input" type="text" value="' . get_search_query() . '" placeholder="'. esc_attr( $placeholder ) .'" name="s" id="hws">
                            '.$is_product.'
                            <button class="header_search_button" id="headersearchsubmit" type="submit"><span class="icon is-search"></span></button>
                            <button class="header_search_close" type="button"><span class="icon is-close"></span></button>
                        </form>
                    </div>
                </div>';
        return $form;
    }
    if ( class_exists( 'WooCommerce' ) && 'product' == naturally_settings( 'header_search_type', 'default' ) ) {
        add_filter('get_product_search_form', 'naturally_header_search_form');
    } else {
        add_filter('get_search_form', 'naturally_header_search_form');
    }
}


/*************************************************
## THEME SEARCH FORM
*************************************************/
if (! function_exists('naturally_content_custom_search_form')) {
    function naturally_content_custom_search_form()
    {
        $placeholder = esc_html__('Search...', 'naturally');
        $form = '<form class="section-404_search" role="search" method="get" id="content-widget-searchform" action="' . esc_url(home_url('/')) . '" >
        <input class="section-404_search_input" type="text" value="' . get_search_query() . '" placeholder="'. esc_attr( $placeholder ) .'" name="s" id="cws">
        <button class="section-404_search_button" id="contentsearchsubmit" type="submit"><span class="icon is-search"></span></button>
        </form>';
        return $form;
    }
    add_filter('get_search_form', 'naturally_content_custom_search_form');
}


/*************************************************
## THEME SEARCH FORM
*************************************************/
if (! function_exists('naturally_nav_custom_search_form')) {
    function naturally_nav_custom_search_form()
    {
        $placeholder = esc_html__('Search...', 'naturally');
        $form = '<form class="nav2_search" role="search" method="get" id="nav-widget-searchform" action="' . esc_url(home_url('/')) . '" >
        <input class="nav2_search_input" type="text" value="' . get_search_query() . '" placeholder="'. esc_attr( $placeholder ) .'" name="s" id="nws">
        <button class="nav2_search_button" id="navsearchsubmit" type="submit"><span class="icon is-search"></span></button>
        </form>';
        return $form;
    }
    add_filter('get_search_form', 'naturally_nav_custom_search_form');
}

/*************************************************
## THEME SEARCH FORM
*************************************************/
if (! function_exists('naturally_megamenu_search_form')) {
    function naturally_megamenu_search_form()
    {
        $placeholder = esc_html__('Search...', 'naturally');
        $is_product = class_exists( 'WooCommerce' ) && 'product' == naturally_settings( 'header_search_type', 'default' ) ? '<input type="hidden" name="post_type" value="product" />' : '';
        $form = '<form class="nav3_search" role="search" method="get" id="nav-header-searchform" action="' . esc_url(home_url('/')) . '" >
        <input type="text" value="' . get_search_query() . '" placeholder="' . esc_attr( $placeholder ) . '" name="s" id="nhs">
        '.$is_product.'
        </form>';
        return $form;
    }

    if ( class_exists( 'WooCommerce' ) && 'product' == naturally_settings( 'header_search_type', 'default' ) ) {
        add_filter('get_product_search_form', 'naturally_megamenu_search_form');
    } else {
        add_filter('get_search_form', 'naturally_megamenu_search_form');
    }

}


/*************************************************
## THEME SIDEBARS SEARCH FORM
*************************************************/
if (! function_exists('naturally_sidebar_search_form')) {
    function naturally_sidebar_search_form()
    {
        $placeholder = esc_html__('Search for...', 'naturally');
        $form = '<form class="shop-sidebar_search" role="search" method="get" id="widget-searchform" action="' . esc_url(home_url('/')) . '" >
                    <input class="shop-sidebar_search_input" type="text" value="' . get_search_query() . '" placeholder="'. esc_attr( $placeholder ) .'" name="s" id="ws">
                    <input type="hidden" name="post_type" value="product" />
                    <button class="shop-sidebar_search_button" id="searchsubmit" type="submit"><span class="icon is-search"></span></button>
                </form>';
        return $form;
    }
    add_filter('get_product_search_form', 'naturally_sidebar_search_form');
    add_filter('get_search_form', 'naturally_sidebar_search_form');
}


/*************************************************
## THEME PASSWORD FORM
*************************************************/
if (! function_exists('naturally_custom_password_form')) {
    function naturally_custom_password_form()
    {
        global $post;
        $placeholder = esc_html__('Enter Password', 'naturally');
        $form = '<form class="form_password" role="password" method="get" id="widget-searchform" action="' . get_option('siteurl') . '/wp-login.php?action=postpass"><input class="form_password_input" type="password" placeholder="'. esc_attr( $placeholder ) .'" name="post_password" id="ws"><button class="form_password_button" id="submit" type="submit"><span class="icon is-next"></span></button></form>';

        return $form;
    }
    add_filter('the_password_form', 'naturally_custom_password_form');
}



/*************************************************
## EXCERPT FILTER
*************************************************/
if (! function_exists('naturally_custom_excerpt_more')) {
    function naturally_custom_excerpt_more($more)
    {
        return '...';
    }
    add_filter('excerpt_more', 'naturally_custom_excerpt_more');
}

/*************************************************
## EXCERPT LIMIT
*************************************************/
if (! function_exists('naturally_excerpt_limit')) {
    function naturally_excerpt_limit($limit)
    {
        $excerpt = explode(' ', get_the_excerpt(), $limit);
        if (count($excerpt) >= $limit) {
            array_pop($excerpt);
            $excerpt = implode(" ", $excerpt) . '...';
        } else {
            $excerpt = implode(" ", $excerpt);
        }
        $excerpt = preg_replace('`\[[^\]]*\]`', '', $excerpt);
        return $excerpt;
    }
}

/*************************************************
## DEFAULT CATEGORIES WIDGET
*************************************************/
if (! function_exists('naturally_add_span_cat_count')) {
    function naturally_add_span_cat_count($links)
    {

        $links = str_replace('</a> (', '</a> <span class="widget-list-span">', $links);
		$links = str_replace('</a> <span class="count">(', '</a> <span class="widget-list-span">', $links);
        $links = str_replace(')', '</span>', $links);

        return $links;

    }
    add_filter('wp_list_categories', 'naturally_add_span_cat_count');
}

/*************************************************
## woocommerce_layered_nav_term_html WIDGET
*************************************************/
if (! function_exists('naturally_add_span_woocommerce_layered_nav_term_html')) {
    function naturally_add_span_woocommerce_layered_nav_term_html($links)
    {

        $links = str_replace('</a> (', '</a> <span class="widget-list-span">', $links);
		$links = str_replace('</a> <span class="count">(', '</a> <span class="widget-list-span">', $links);
        $links = str_replace(')', '</span>', $links);

        return $links;

    }
    add_filter('woocommerce_layered_nav_term_html', 'naturally_add_span_woocommerce_layered_nav_term_html');
}



/*************************************************
## DEFAULT ARCHIVES WIDGET
*************************************************/
if (! function_exists('naturally_add_span_arc_count')) {
    function naturally_add_span_arc_count($links)
    {
        $links = str_replace('</a>&nbsp;(', '</a> <span class="widget-list-span">', $links);

        $links = str_replace(')', '</span>', $links);

        // dropdown selectbox
        $links = str_replace('&nbsp;(', ' - ', $links);

        return $links;

    }
    add_filter('get_archives_link', 'naturally_add_span_arc_count');
}

/*************************************************
## PAGINATION CUSTOMIZATION
*************************************************/
if (! function_exists('naturally_sanitize_pagination')) {
    function naturally_sanitize_pagination($content)
    {
        // remove role attribute
        $content = str_replace('role="navigation"', '', $content);

        // remove h2 tag
        $content = preg_replace('#<h2.*?>(.*?)<\/h2>#si', '', $content);

        return $content;

    }
    add_action('navigation_markup_template', 'naturally_sanitize_pagination');
}

/*************************************************
## CUSTOM ARCHIVE TITLES
*************************************************/
if (! function_exists('naturally_archive_title')) {
    function naturally_archive_title()
    {
        $title = '';
        if (is_category()) {
            $title = single_cat_title('', false);
        } elseif (is_tag()) {
            $title = single_tag_title('', false);
        } elseif (is_author()) {
            $title = get_the_author();
        } elseif (is_year()) {
            $title = get_the_date(_x('Y', 'yearly archives date format', 'naturally'));
        } elseif (is_month()) {
            $title = get_the_date(_x('F Y', 'monthly archives date format', 'naturally'));
        } elseif (is_day()) {
            $title = get_the_date(_x('F j, Y', 'daily archives date format', 'naturally'));
        } elseif (is_post_type_archive()) {
            $title = post_type_archive_title('', false);
        } elseif (is_tax()) {
            $title = single_term_title('', false);
        } else {
            $title = get_the_archive_title();
        }

        return $title;
    }
    add_filter('get_the_archive_title', 'naturally_archive_title');
}



/*************************************************
## CHECKS TO SEE IF CPT EXISTS.
*************************************************/
/*
* By setting '_builtin' to false,
* we exclude the WordPress built-in public post types
* (post, page, attachment, revision, and nav_menu_item)
* and retrieve only registered custom public post types.
* return boolean
*/
if (! function_exists('naturally_cpt_exists')) {
    function naturally_cpt_exists()
    {

        $args = array(
           'public'   => true,
           '_builtin' => false
        );

        $output = 'names'; // 'names' or 'objects' (default: 'names')
        $operator = 'and'; // 'and' or 'or' (default: 'and')

        $post_types = get_post_types( $args, $output, $operator ); // get simple cpt if exists
        $classes = get_body_class();
        $cpt_exsits = array();

        if ( $post_types ) {
            foreach ($post_types as $cpt ) {
                if ( is_single() ) {
                    array_push($cpt_exsits, 'single-'.$cpt);
                }
                if ( is_archive() ) {
                    array_push($cpt_exsits, 'post-type-archive-'.$cpt);
                }
            }
        }

        $sameclass = array_intersect( $cpt_exsits, $classes );

        if ( $sameclass ) {
            return true;
        }
        return false;
    }
}


/*************************************************
## CONVERT HEX TO RGB
*************************************************/

 if (! function_exists('naturally_hex2rgb')) {
     function naturally_hex2rgb($hex)
     {
         $hex = str_replace("#", "", $hex);

         if (strlen($hex) == 3) {
             $r = hexdec(substr($hex, 0, 1).substr($hex, 0, 1));
             $g = hexdec(substr($hex, 1, 1).substr($hex, 1, 1));
             $b = hexdec(substr($hex, 2, 1).substr($hex, 2, 1));
         } else {
             $r = hexdec(substr($hex, 0, 2));
             $g = hexdec(substr($hex, 2, 2));
             $b = hexdec(substr($hex, 4, 2));
         }
         $rgb = array($r, $g, $b);

         return $rgb; // returns an array with the rgb values
     }
 }

/**********************************
## THEME ALLOWED HTML TAG
/**********************************/

if (! function_exists('naturally_allowed_html')) {
    function naturally_allowed_html()
    {
        $allowed_tags = array(
            'a' => array(
                'class' => array(),
                'href'  => array(),
                'rel'   => array(),
                'title' => array(),
                'target' => array()
            ),
            'abbr' => array(
                'title' => array()
            ),
            'address' => array(),
            'iframe' => array(
                'src' => array(),
                'frameborder' => array(),
                'allowfullscreen' => array(),
                'allow' => array(),
                'width' => array(),
                'height' => array(),
            ),
            'b' => array(),
            'br' => array(),
            'blockquote' => array(
                'cite'  => array()
            ),
            'cite' => array(
                'title' => array()
            ),
            'code' => array(),
            'del' => array(
                'datetime' => array(),
                'title' => array()
            ),
            'dd' => array(),
            'div' => array(
                'class' => array(),
                'id'    => array(),
                'title' => array(),
                'style' => array()
            ),
            'dl' => array(),
            'dt' => array(),
            'em' => array(),
            'h1' => array(
                'class' => array()
            ),
            'h2' => array(
                'class' => array()
            ),
            'h3' => array(
                'class' => array()
            ),
            'h4' => array(
                'class' => array()
            ),
            'h5' => array(
                'class' => array()
            ),
            'h6' => array(
                'class' => array()
            ),
            'i' => array(
                'class'  => array()
            ),
            'img' => array(
                'alt'    => array(),
                'class'  => array(),
                'width'  => array(),
                'height' => array(),
                'src'    => array(),
                'srcset' => array(),
                'sizes' => array()
            ),
            'li' => array(
                'class' => array()
            ),
            'ol' => array(
                'class' => array()
            ),
            'p' => array(
                'class' => array()
            ),
            'q' => array(
                'cite' => array(),
                'title' => array()
            ),
            'span' => array(
                'class' => array(),
                'title' => array(),
                'style' => array()
            ),
            'strike' => array(),
            'strong' => array(),
            'ul' => array(
                'class' => array()
            )
        );
        return $allowed_tags;
    }
}

if ( ! function_exists('naturally_navmenu_choices') ) {
    function naturally_navmenu_choices()
    {
        $menus = wp_get_nav_menus();
        $options = array();
        if ( ! empty( $menus ) && ! is_wp_error( $menus ) ) {
            foreach ( $menus as $menu ) {
                $options[ $menu->slug ] = $menu->name;
            }
        }
        return $options;
    }
}

/*************************************************
## CHECK IS ELEMENTOR
*************************************************/
if ( !function_exists( 'naturally_check_is_elementor' ) ) {
    function naturally_check_is_elementor()
    {
        global $post;
        if ( class_exists( '\Elementor\Plugin' ) ) {
            return \Elementor\Plugin::$instance->db->is_built_with_elementor( $post->ID );
        }
    }
}

/*************************************************
## CHECK IS POST
*************************************************/
if ( !function_exists( 'naturally_check_is_post' ) ) {
    function naturally_check_is_post()
    {
        if ( class_exists( '\Elementor\Plugin' ) ) {
            $selected_post = get_option( 'elementor_cpt_support' );
            if ( is_array( $selected_post ) ) {
                if ( in_array( 'post', $selected_post ) ) {
                    return true;
                }
            }
            return false;
        }
    }
}
