<?php


/*************************************************
## Post Comment Customization
*************************************************/


// Theme custom comment list
function naturally_custom_commentlist($comment, $args, $depth) {
      $GLOBALS['comment'] = $comment; ?>

    	<li <?php comment_class('nt-comment-item'); ?> id="li-comment-<?php comment_ID() ?>">

    		<div id="comment-<?php comment_ID(); ?>">

    			<div class="nt-comment-left">

                    <div class="nt-comment-avatar">
    					<?php echo get_avatar($comment,$size='80' ); ?>
    				</div>

                    <?php if ($comment->comment_approved == '0') : ?>
    					<em><?php esc_html_e('Your comment is awaiting moderation.', 'naturally') ?></em>
    					<br />
    				<?php endif; ?>

    			</div>

    			<div class="nt-comment-right">

    				<div class="nt-comment-author comment__author-name">
                        <?php echo get_comment_author_link(); ?>
                    </div>
                    <div class="nt-comment-date">
                        <span class="post-meta__item __date-post">
                            <a href="<?php echo htmlspecialchars( get_comment_link( $comment->comment_ID ) ) ?>">
                                <?php printf(esc_html__('%1$s at %2$s', 'naturally'), get_comment_date(),  get_comment_time()) ?>
                            </a>
                            <?php edit_comment_link(esc_html__('(Edit)', 'naturally'),'  ','') ?>
                        </span>
                    </div>

    				<div class="nt-comment-content nt-theme-content nt-clearfix"><?php comment_text() ?></div>


                    <div class="nt-comment-date post-meta">

                        <div class="nt-comment-reply-content post-meta__item"><?php comment_reply_link(array_merge( $args, array('depth' => $depth, 'max_depth' => $args['max_depth']))) ?></div>

    				</div>

    			</div>

    		</div>
    <?php
    }



// Unset URL from comment form
function naturally_move_comment_form_below( $fields ) {

    $comment_field = $fields['comment'];
    unset( $fields['comment'] );
    $fields['comment'] = $comment_field;

    return $fields;

}
add_filter( 'comment_form_fields', 'naturally_move_comment_form_below' );



// Add placeholder for Name and Email
function naturally_move_modify_comment_form_fields($fields){

	$commenter     = wp_get_current_commenter();
	$user          = wp_get_current_user();
	$user_identity = $user->exists() ? $user->display_name : '';
	$req           = get_option( 'require_name_email' );
	$aria_req      = ( $req ? " aria-required='true'" : '' );
	$html_req      = ( $req ? " required='required'" : '' );
	$html5         = current_theme_supports( 'html5', 'comment-form' ) ? 'html5' : false;
    $consent       = empty( $commenter['comment_author_email'] ) ? '' : ' checked="checked"';

    $fields['author'] = '<div class="grid"><div class="grid_row is-30 mb-0"><div class="grid_col is-12 is-sm-6"><input class="form_control_input" id="author" name="author" type="text" value="' . esc_attr( $commenter['comment_author'] ) . '" size="30" placeholder="' . esc_attr__( 'Enter your name ...', 'naturally' ) . '"' . $aria_req . ' required /></div>';

    $fields['email'] = '<div class="grid_col is-12 is-sm-6"><input class="form_control_input" id="email" name="email" type="text" value="' . esc_attr(  $commenter['comment_author_email'] ) . '" size="30" placeholder="' . esc_attr__( 'Enter your name ...', 'naturally' ) . '"' . $aria_req . ' required/></div></div></div>';

    $fields['url'] = '<div class="grid"><div class="grid_row is-30 mb-0"><div class="grid_col is-12"><input class="nt-form-input form-control" id="url" name="url" type="text" value="' . esc_attr( $commenter['comment_author_url'] ) . '" size="30" placeholder="'.esc_attr__( 'Enter your website ...', 'naturally'  ).'" required/></div></div></div>';

    $fields['cookies'] = '<div class="grid"><div class="grid_row is-30 mb-0"><div class="grid_col is-12"><input id="wp-comment-cookies-consent" class="form_control_checkbox" name="wp-comment-cookies-consent" type="checkbox" value="yes"' . $consent . ' />' . '<span>' . esc_attr__( 'Save my name, email, and website in this browser for the next time I comment.', 'naturally' ) . '</span></div></div></div>';

    return $fields;
}
add_filter('comment_form_default_fields','naturally_move_modify_comment_form_fields');

function naturally_modify_comment_form_text_area($arg) {
    $arg['comment_field'] = '<div class="grid"><div class="grid_row is-30"><div class="grid_col is-12"><textarea id="comment" class="form_control_textarea" name="comment" cols="45" rows="6" aria-required="true" placeholder="' . esc_attr__( 'Enter your comment ...', 'naturally' ) . '"></textarea></div></div></div>';
    return $arg;
}

add_filter('comment_form_defaults', 'naturally_modify_comment_form_text_area');



// add class comment form button
function naturally_addclass_form_button( $arg ) {

  // $arg contains all the comment form defaults
  // simply redefine one of the existing array keys to change the comment form
  // see http://codex.wordpress.org/Function_Reference/comment_form for a list
  // of array keys
  // add Foundation classes to the button class
  $arg['class_submit'] = 'button is-grey';
  // return the modified array


  return $arg;

}
// run the comment form defaults through the newly defined filter
add_filter( 'comment_form_defaults', 'naturally_addclass_form_button' );
