<?php

/**
* Custom template parts for this theme.
*
* Eventually, some of the functionality here could be replaced by core features.
*
* @package naturally
*/

if ( ! function_exists( 'naturally_footer' ) ) {
    add_action( 'naturally_footer_action', 'naturally_footer', 10 );
    function naturally_footer()
    {
        $sidebar = !is_active_sidebar( 'footer-widget-area' ) ? ' footer-copyright' : '';

        $footer_visibility = naturally_settings( 'footer_visibility', '1' );
        $footer_page_visibility = naturally_page_settings( 'hide_page_footer', '1' );
        $footer_visibility = is_page() && '1' == $footer_visibility ? $footer_page_visibility : $footer_visibility;

        $fw_visibility = naturally_settings( 'footer_widgetize_visibility', '0' );
        $fw_page_visibility = naturally_page_settings( 'hide_page_footer_widget_area', '0' );
        $fw_visibility =  is_page() && '1' == $fw_visibility ? $fw_page_visibility : $fw_visibility;

        $copy_visibility = naturally_settings( 'footer_copyright_visibility', '1' );
        $copy_page_visibility = naturally_page_settings( 'hide_page_footer_copyright', '1' );
        $copy_visibility = is_page() && '1' == $fw_visibility ? $copy_page_visibility : $copy_visibility;

        $type = naturally_settings( 'footer_type', 'default' );

        if ( '0' != $footer_visibility ) {

            if ( 'custom' == $type ) {

                // custom footer allowed html
                echo naturally_settings( 'custom_footer' );

            } elseif ( 'elementor' == $type ) {

                if (class_exists('\Elementor\Frontend')) {

                    $page_footer_template = naturally_page_settings( 'page_footer_template' );
                    $page_footer_template = is_page() ? $page_footer_template : '';

                    if (!empty(naturally_settings('footer_elementor_templates'))) {

                        wp_enqueue_style('naturally-elementor');
                        $template_id = naturally_settings('footer_elementor_templates');
                        $frontend = new \Elementor\Frontend;
                        if ( defined( 'ICL_LANGUAGE_CODE' ) ) {
                            $wpml_options = get_option( 'icl_sitepress_settings' );
                            $default_lang = $wpml_options['default_language'];

                            if ( is_array( $template_id ) ) {
                                foreach ( $template_id as $id ) {
                                    $translated_id = apply_filters( 'wpml_object_id', $id );
                                    if ( $translated_id && null !== $translated_id ) {
                                       printf( '%1$s', $frontend->get_builder_content( $id, true ) );
                                    } else {
                                        preg_match('/'.ICL_LANGUAGE_CODE.'/i', strtolower(get_the_title( $id )), $matches );
                                        if ( $matches[0] == ICL_LANGUAGE_CODE ) {
                                            printf( '%1$s', $frontend->get_builder_content( $id, true ) );
                                            break;
                                        }
                                    }
                                }
                            }
                        } else {
                            printf( '%1$s', $frontend->get_builder_content( $template_id, true ) );
                        }
                    } else {

                        echo sprintf('<p class="copyright text-center ptb-40">'.esc_html__('No template exist for footer.', 'naturally').' <a class="main-color" href="%s">'.esc_html__('Add new section template.', 'naturally').'</a></p>', admin_url( 'edit.php?post_type=elementor_library&tabs_group=library&elementor_library_type=section' ));
                    }
                }

            } else {

                if ( '0' != $fw_visibility || '0' != $copy_visibility ) {
                    ?>
                    <footer id="nt-footer" class="footer<?php echo esc_attr($sidebar); ?>">
                        <div class="container">

                            <?php
                            if ( '0' != $fw_visibility && is_active_sidebar('footer-widget-area') ) {
                                naturally_footer_widgetize();
                            }

                            if ( '0' != $copy_visibility ) {
                                naturally_copyright();
                            }
                            ?>
                        </div>
                    </footer>
                    <?php
                }
            }
        }
    }
}


/*************************************************
##  WIDGETIZE FOOTER
*************************************************/

if ( ! function_exists( 'naturally_footer_widgetize' ) ) {
    function naturally_footer_widgetize()
    {
        ?>
        <div class="footer_top nt-footer-sidebar">
            <div class="grid">
                <div class="grid_row is-40 is-lg-60 justify-center">
                    <?php dynamic_sidebar('footer-widget-area'); ?>
                </div>
            </div>
        </div>
        <?php
    }
}


/*************************************************
##  FOOTER COPYRIGHT
*************************************************/

if ( ! function_exists( 'naturally_copyright' ) ) {
    function naturally_copyright()
    {
        ?>
        <div class="footer_bottom">
            <div class="grid">
                <div class="grid_row is-40 is-lg-60">

                    <?php if ( '' != naturally_settings( 'footer_copyright' ) ) { ?>

                        <div class="grid_col is-12 is-lg-col">
                            <div class="footer_copyright">
                                <?php echo wp_kses( naturally_settings( 'footer_copyright' ), naturally_allowed_html() ); ?>
                            </div>
                        </div>

                    <?php } else { ?>

                        <div class="grid_col is-12 is-lg-col">
                            <div class="footer_copyright">&copy; <?php echo date_i18n( _x( 'Y', 'copyright date format', 'naturally' ));?> <a href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php bloginfo( 'name' ); ?></a> <?php esc_html_e('All rights reserved by', 'naturally'); ?> <a class="dev" href="https://ninetheme.com/contact/" target="_blank"><?php esc_html_e('Ninetheme.', 'naturally'); ?></a>
                            </div>
                        </div>

                    <?php } ?>

                    <?php if ( has_nav_menu( 'footer_menu' ) ) { ?>

                        <div class="grid_col is-12 is-lg-auto">
                            <nav class="footer_menu">
                                <ul class="footer_menu_items">
                                    <?php
                                    wp_nav_menu(
                                        array(
                                            'menu' => '',
                                            'theme_location' => 'footer_menu',
                                            'container' => '', // menu wrapper element
                                            'container_class' => '',
                                            'container_id' => '', // default: none
                                            'menu_class' => '', // ul class
                                            'menu_id' => '', // ul id
                                            'items_wrap' => '%3$s',
                                            'before' => '', // before <a>
                                            'after' => '', // after <a>
                                            'link_before' => '', // inside <a>, before text
                                            'link_after' => '', // inside <a>, after text
                                            'depth' => 1, // '0' to display all depths
                                            'echo' => true,
                                        )
                                    );
                                    ?>
                                </ul>
                            </nav>
                        </div>

                    <?php } ?>

                </div>
            </div>
        </div>
        <?php
    }
}
