<?php

/**
 * Custom template parts for this theme.
 *
 * Eventually, some of the functionality here could be replaced by core features.
 *
 * @package naturally
*/


/*************************************************
##  LOGO
*************************************************/

if (! function_exists('naturally_logo')) {
    function naturally_logo()
    {
        $logo = naturally_settings('logo_type', 'sitename');
        $slogo = naturally_settings('slogo_type', 'sitename');

        if ('0' != naturally_settings('logo_visibility', '1')) { ?>

            <a href="<?php echo esc_url(home_url('/')); ?>" id="nt-logo" class="static-logo header_logo logo-type-<?php echo esc_attr($logo); ?>">

            <?php if ('img' == $logo && '' != naturally_settings('img_logo')) { ?>

                <img src="<?php echo esc_url(naturally_settings('img_logo')['url']); ?>" alt="<?php echo esc_attr(get_bloginfo('name')); ?>" />

            <?php } elseif ('sitename' == $logo ) {?>

                <span class="headline_title"><?php bloginfo( 'name' ); ?></span>

            <?php } elseif ('customtext' == $logo) { ?>

                <span class="headline_title"><?php echo naturally_settings('text_logo'); ?></span>

            <?php } else { ?>

                <span class="headline_title"> <?php bloginfo( 'name' );?> </span>

            <?php } ?>
            </a>
            <?php
        }
        //sticky logo
        if ('0' != naturally_settings('slogo_visibility', '0')) { ?>

            <a href="<?php echo esc_url(home_url('/')); ?>" id="nt-logo" class="sticky-logo header_logo logo-type-<?php echo esc_attr($slogo); ?>">

            <?php if ('img' == $slogo && '' != naturally_settings('simg_logo')) { ?>

                <img src="<?php echo esc_url(naturally_settings('simg_logo')['url']); ?>" alt="<?php echo esc_attr(get_bloginfo('name')); ?>" />

            <?php } elseif ('sitename' == $slogo ) {?>

                <span class="headline_title"><?php bloginfo( 'name' ); ?></span>

            <?php } elseif ('customtext' == $slogo) { ?>

                <span class="headline_title"><?php echo naturally_settings('stext_logo'); ?></span>

            <?php } else { ?>

                <span class="headline_title"> <?php bloginfo( 'name' );?> </span>

            <?php } ?>
            </a>
            <?php
        }
    }
}


/*************************************************
##  HEADER NAVIGATION
*************************************************/

if (! function_exists('naturally_main_header')) {
    add_action('naturally_header_action', 'naturally_main_header', 10);
    function naturally_main_header()
    {
        $header_template = naturally_settings( 'site_header_template', 'default' );

        $nav_visibility = naturally_settings( 'nav_visibility', '1' );
        $nav_page_visibility = naturally_page_settings( 'hide_page_header', '1' );
        $nav_visibility = is_page() && '0' != $nav_visibility ? $nav_page_visibility : $nav_visibility;

        $page_header_menu = naturally_page_settings( 'page_header_menu' );
        $page_header_menu = is_page() ? $page_header_menu : '';

        $header_type = naturally_settings( 'nav_type', 'default' );
        $page_header_type = naturally_page_settings( 'page_header_type', 'default' );
        $header_type = is_page() ? $page_header_type : $header_type;

        $header_topbar = naturally_settings( 'header_topbar_visibility', '0' );
        $page_header_topbar = naturally_page_settings( 'hide_page_header_topbar', '1' );
        $header_topbar = is_page() && '0' != $header_topbar ? $page_header_topbar : $header_topbar;

        $header_margin = '0' == $header_topbar ? ' mt-0' : '';
        $header_defbg = get_template_directory_uri().'/images/bg-nav.jpg';
        $header_mobbgimg = naturally_settings('header_mob_bg_img');
        $header_mobbgimg = !empty($header_mobbgimg['url']) ? $header_mobbgimg['url'] : $header_defbg;
        $header_string = $header_type;
        $header_class  = [
            '1' == naturally_settings('nav_sticky_visibility', '0') ? 'is-sticky' : '',
            apply_filters( 'naturally_header_string', $header_string )
        ];

        if ( '0' != $nav_visibility ) {

            if ( class_exists('\Elementor\Frontend') && 'elementor' == $header_template ) {

                $header_template_id = naturally_settings( 'header_elementor_templates' );

                if ( !empty( $header_template_id ) ) {

                    wp_enqueue_style( 'naturally-elementor' );
                    $header_frontend = new \Elementor\Frontend;
                    printf( '%1$s', $header_frontend->get_builder_content( $header_template_id, false ) );

                } else {

                    echo sprintf('<p class="copyright text-center ptb-40">'.esc_html__('No template exist for Header.', 'naturally').' <a class="main-color" href="%s">'.esc_html__('Add new section template.', 'naturally').'</a></p>', admin_url( 'edit.php?post_type=elementor_library&tabs_group=library&elementor_library_type=section' ));
                }

            } else {

                ?>
                <div class="naturally-main-header header <?php echo esc_attr( implode(' ', $header_class) ); ?>" data-ntr-header>
                    <div class="header_holder"></div>
                    <div class="header_container">
                        <?php if ( '0' != naturally_settings('header_search_visibility', '1') && '0' != $header_topbar ) { ?>
                            <?php if ( defined( 'YITH_WCAS' ) && 'product' == naturally_settings( 'header_search_type', 'default' ) ) {?>
                                <div class="header_search yith-ajaxsearchform-container">
                                    <div class="container">
                                        <?php echo do_shortcode('[yith_woocommerce_ajax_search]'); ?>
                                    </div>
                                </div>
                            <?php } else { ?>
                                <?php echo naturally_header_search_form(); ?>
                            <?php } ?>
                        <?php } ?>
                        <div class="container">

                            <?php if ( '0' != $header_topbar ) { ?>
                                <div class="naturally_header_topbar header_top">

                                    <?php if ( '' != naturally_settings('header_topbar_phone') ) { ?>
                                        <div class="header_phone">
                                            <span class="header_phone_icon icon is-support"></span>
                                            <span class="header_phone_text"><?php echo naturally_settings('header_topbar_phone'); ?></span>
                                        </div>
                                    <?php } ?>

                                    <div class="header_menu">

                                        <?php if ( '0' != naturally_settings('header_search_visibility', '0')) { ?>
                                            <div class="header_menu_item">
                                                <a class="header_menu_link header_search_open" href="#">
                                                    <span class="header_menu_link_icon icon is-search"></span>
                                                    <span class="header_menu_link_text"><?php echo esc_html_e('Search', 'naturally'); ?></span>
                                                </a>
                                            </div>
                                        <?php } ?>

                                        <?php do_action( 'naturally_header_woo_myaccount_action' ); ?>

                                    </div>
                                    <?php naturally_header_lang(); ?>
                                </div>
                            <?php } ?>

                            <div class="header_bottom<?php echo esc_attr($header_margin); ?>">

                                <?php naturally_logo(); ?>

                                    <nav class="header_nav lg-bg-none" data-ntr-background="<?php echo esc_url($header_mobbgimg); ?>">
                                        <a class="header_nav_close" href="#">
                                            <span class="header_nav_close_text"><?php echo esc_html_e('Close', 'naturally'); ?></span>
                                            <span class="header_nav_close_icon icon is-close"></span>
                                        </a>
                                    <ul>
                                        <?php
                                            wp_nav_menu(
                                                array(
                                                    'menu' => $page_header_menu,
                                                    'theme_location' => 'header_menu',
                                                    'container' => '', // menu wrapper element
                                                    'container_class' => '',
                                                    'container_id' => '', // default: none
                                                    'menu_class' => '', // ul class
                                                    'menu_id' => '', // ul id
                                                    'items_wrap' => '%3$s',
                                                    'before' => '', // before <a>
                                                    'after' => '', // after <a>
                                                    'link_before' => '', // inside <a>, before text
                                                    'link_after' => '', // inside <a>, after text
                                                    'depth' => 4, // '0' to display all depths
                                                    'echo' => true,
                                                    'fallback_cb' => 'Naturally_Wp_Bootstrap_Navwalker::fallback',
                                                    'walker' => new Naturally_Wp_Bootstrap_Navwalker()
                                                )
                                            );
                                        ?>
                                    </ul>
                                </nav>

                                <div class="header_nav_toggle"><span class="icon is-menu"></span></div>

                                <?php
                                if ( '0' != naturally_settings('header_minicart_visibility', '1') && class_exists( 'WooCommerce' ) ) {
                                    do_action( 'naturally_header_mini_cart_action');
                                }
                                if ( '0' != naturally_settings( 'wishlist_btn_visibility', '1' ) && defined( 'YITH_WCWL' ) ) {
                                    echo'<a class="wishlist--count header--icon" href="#0">
                                        <span class="naturally-wishlist--icon icon is-heart"></span>
                                        <span class="wishlist_label_count"></span>
                                    </a>';
                                }
                                ?>

                            </div>
                        </div>
                    </div>
                </div>
            <?php
            }
        }
    }
}

/*************************************************
##  HEADER LANGUAGE
*************************************************/

if (! function_exists('naturally_header_lang')) {
    function naturally_header_lang()
    {
        if ('0' != naturally_settings('nav_lang_visibility', '0')) { ?>
            <div class="header_lang">
                <div class="header_lang_label">
                    <span class="header_lang_label_icon icon is-internet"></span>
                    <?php if (function_exists('pll_the_languages')) : ?>
                        <span class="header_lang_label_text"><?php echo pll_current_language('name') ?></span>
                        <div class="header_lang_list polylang">
                            <ul class="header_lang_items">
                                <?php
                                pll_the_languages(
                                    array(
                                        'show_flags'=>1,
                                        'show_names'=>1,
                                        'dropdown'=>0,
                                        'raw'=>0,
                                        'hide_current'=>1,
                                        'display_names_as'=>'name'
                                    )
                                );
                                ?>
                            </ul>
                        </div>
                    <?php else : ?>
                        <span class="header_lang_label_text"><?php echo naturally_settings('header_first_lang_item', 'English');; ?></span>
                        <?php
                        $langs = naturally_settings('header_lang');
                        if(is_array($langs) && !empty($langs)) : ?>
                            <div class="header_lang_list">
                                <ul class="header_lang_items">
                                    <?php for ($i=0; $i < (count($langs)); $i++) {

                                        $name = $langs[$i] ? $langs[$i] : '';
                                        $flag = $langs[$i+1] ? $langs[$i+1] : '#';
                                        $url = $langs[$i+2] ? $langs[$i+2] : '#';
                                        if($name){ ?>
                                            <li class="header_lang_item">
                                                <a class="header_lang_link" href="<?php echo esc_url($url); ?>">
                                                    <img class="header_lang_link_flag" src="<?php echo esc_url($flag); ?>" alt="<?php echo esc_attr($name); ?>">
                                                    <span class="header_lang_link_text"><?php echo esc_html($name); ?></span>
                                                </a>
                                            </li>
                                        <?php
                                        }
                                        $i = $i+2;
                                    } ?>
                                </ul>
                            </div>
                        <?php endif; ?>
                    <?php endif; ?>
                </div>
            </div>
            <?php
        }
    }
}



if ( !function_exists( 'naturally_bottom_mobile_menu' ) ) {
    add_action( 'naturally_after_main_footer', 'naturally_bottom_mobile_menu' );
    function naturally_bottom_mobile_menu() {
        if ( '0' == naturally_settings( 'bottom_mobile_nav_visibility', '0' ) ) {
            return;
        }
        $menu_type = naturally_settings( 'bottom_mobile_menu_type' );
        $display_type = naturally_settings( 'bottom_mobile_menu_display_type' );
        $header_template_id = naturally_settings( 'header_elementor_templates' );
        ?>
        <nav class="bottom-mobile-nav <?php echo esc_attr( $display_type ); ?>">
            <?php
            if ( 'elementor' == $menu_type && class_exists('\Elementor\Frontend') && !empty( $header_template_id ) ) {

                $header_frontend = new \Elementor\Frontend;
                printf( '%1$s', $header_frontend->get_builder_content( $header_template_id, false ) );

            } elseif ( 'wp-menu' == $menu_type ) {

                if ( has_nav_menu( 'mobile_bottom_menu' ) ) {

                    echo '<div class="mobile-nav-wrapper">';
                        echo '<ul>';
                            echo wp_nav_menu(
                                array(
                                    'menu' => '',
                                    'theme_location' => 'mobile_bottom_menu',
                                    'container' => '',
                                    'container_class' => '',
                                    'container_id' => '',
                                    'menu_class' => '',
                                    'menu_id' => '',
                                    'items_wrap' => '%3$s',
                                    'before' => '',
                                    'after' => '',
                                    'link_before' => '',
                                    'link_after' => '',
                                    'depth' => 1,
                                    'echo' => true,
                                    'fallback_cb' => 'Naturally_Wp_Bootstrap_Navwalker::fallback',
                                    'walker' => new Naturally_Wp_Bootstrap_Navwalker()
                                )
                            );
                        echo '</ul>';
                    echo '</div>';
                }

            } else {

                $layouts = naturally_settings( 'mobile_bottom_menu_layouts' );
                $layouts = apply_filters( 'naturally_mobile_bottom_menu_layouts', $layouts );
                if ( !empty( $layouts ) && isset( $layouts['show'] ) ) {
                    unset( $layouts['show']['placebo'] );
                }
                if ( !empty( $layouts['show'] ) ) {
                    echo '<div class="mobile-nav-wrapper">';
                        echo '<ul>';
                        foreach ( $layouts['show'] as $key => $value ) {

                            switch ( $key ) {
                                case 'home':
                                    if ( '1' == naturally_settings( 'bottom_mobile_nav_item_customize' ) && '' != naturally_settings( 'mobile_bottom_menu_custom_home_html' ) ) {
                                        echo naturally_settings( 'mobile_bottom_menu_custom_home_html' );
                                    } else {
                                        echo '<li class="menu-item">';
                                            echo '<a href="'.esc_url( home_url( '/' ) ).'" class="home-page-link"><svg class="svgLeft styler-svg-icon" width="512" height="512" fill="currentColor" viewBox="0 0 128 128" enable-background="new 0 0 128 128" xmlns="http://www.w3.org/2000/svg"><path d="m64 0c-35.289 0-64 28.711-64 64s28.711 64 64 64 64-28.711 64-64-28.711-64-64-64zm0 120c-30.879 0-56-25.121-56-56s25.121-56 56-56 56 25.121 56 56-25.121 56-56 56zm28-56c0 2.211-1.791 4-4 4h-38.344l13.172 13.172c1.563 1.563 1.563 4.094 0 5.656-.781.781-1.805 1.172-2.828 1.172s-2.047-.391-2.828-1.172l-20-20c-1.563-1.563-1.563-4.094 0-5.656l20-20c1.563-1.563 4.094-1.563 5.656 0s1.563 4.094 0 5.656l-13.172 13.172h38.344c2.209 0 4 1.789 4 4z"></path></svg><span>'.esc_html__( 'Home', 'naturally' ).'</span></a>';
                                        echo '</li>';
                                    }
                                break;

                                case 'shop':
                                    if ( '1' == naturally_settings( 'bottom_mobile_nav_item_customize' ) && '' != naturally_settings( 'mobile_bottom_menu_custom_shop_html' ) ) {
                                        echo naturally_settings( 'mobile_bottom_menu_custom_shop_html' );
                                    } else {
                                        echo '<li class="menu-item">';
                                            echo '<a href="'.esc_url( wc_get_page_permalink( 'shop' ) ).'" class="shop-page-link">';
                                                echo '<svg class="svgStore styler-svg-icon" width="512" height="512" fill="currentColor" viewBox="0 0 512 512" xmlns="http://www.w3.org/2000/svg"><path d="M511.989,148.555c0-.107.007-.214.008-.322,0-.042,0-.083,0-.125h-.007a15.921,15.921,0,0,0-1.805-7.4L441.3,8.6A16,16,0,0,0,427.115,0H84.885A16,16,0,0,0,70.7,8.6L1.813,140.711a15.91,15.91,0,0,0-1.806,7.4H0c0,.042,0,.083,0,.125,0,.108.005.215.008.322a75.953,75.953,0,0,0,32.6,61.9V466a46.053,46.053,0,0,0,46,46H433.386a46.058,46.058,0,0,0,46-46V210.455A75.953,75.953,0,0,0,511.989,148.555Zm-32.15,3.167A43.994,43.994,0,0,1,392,148.108h-.016a16,16,0,0,0-.512-4.077L361.946,32h55.468ZM183.146,32H240V148.108A44,44,0,0,1,152.048,150ZM272,32h56.854l31.1,118A44,44,0,0,1,272,148.108ZM94.586,32h55.468L120.528,144.031a16,16,0,0,0-.512,4.077H120a43.994,43.994,0,0,1-87.839,3.614ZM380.331,480H298.96V306.347h81.371Zm67.054-14a14.058,14.058,0,0,1-14,14H412.331V290.347a16,16,0,0,0-16-16H282.96a16,16,0,0,0-16,16V480H78.615a14.016,14.016,0,0,1-14-14V223.253A75.917,75.917,0,0,0,136,194.673a75.869,75.869,0,0,0,120,0,75.869,75.869,0,0,0,120,0,75.917,75.917,0,0,0,71.385,28.58ZM215.215,274.347H115.67a16,16,0,0,0-16,16v99.545a16,16,0,0,0,16,16h99.545a16,16,0,0,0,16-16V290.347A16,16,0,0,0,215.215,274.347Zm-16,99.545H131.67V306.347h67.545Z"></path></svg>';
                                                echo '<span>'.esc_html__( 'Store', 'naturally' ).'</span>';
                                            echo '</a>';
                                        echo '</li>';
                                    }
                                break;

                                case 'cart':
                                    if ( '1' == naturally_settings( 'bottom_mobile_nav_item_customize' ) && '' != naturally_settings( 'mobile_bottom_menu_custom_cart_html' ) ) {
                                        echo naturally_settings( 'mobile_bottom_menu_custom_cart_html' );
                                    } else {
                                        echo '<li class="menu-item">';
                                            echo '<a href="'.esc_url( wc_get_page_permalink( 'cart' ) ).'" class="cart-page-link">';
                                                echo '<svg class="shopBag styler-svg-icon" width="512" height="512" fill="currentColor" viewBox="0 0 32 32" xmlns="http://www.w3.org/2000/svg"><path d="m26 8.9a1 1 0 0 0 -1-.9h-3a6 6 0 0 0 -12 0h-3a1 1 0 0 0 -1 .9l-1.78 17.8a3 3 0 0 0 .78 2.3 3 3 0 0 0 2.22 1h17.57a3 3 0 0 0 2.21-1 3 3 0 0 0 .77-2.31zm-10-4.9a4 4 0 0 1 4 4h-8a4 4 0 0 1 4-4zm9.53 23.67a1 1 0 0 1 -.74.33h-17.58a1 1 0 0 1 -.74-.33 1 1 0 0 1 -.26-.77l1.7-16.9h2.09v3a1 1 0 0 0 2 0v-3h8v3a1 1 0 0 0 2 0v-3h2.09l1.7 16.9a1 1 0 0 1 -.26.77z"></path></svg>';
                                                echo '<span class="naturally-cart-count wc-count"></span>';
                                                echo '<span>'.esc_html__( 'Cart', 'naturally' ).'</span>';
                                            echo '</a>';
                                        echo '</li>';
                                    }
                                break;

                                case 'account':
                                    if ( '1' == naturally_settings( 'bottom_mobile_nav_item_customize' ) && '' != naturally_settings( 'mobile_bottom_menu_custom_account_html' ) ) {
                                        echo naturally_settings( 'mobile_bottom_menu_custom_account_html' );
                                    } else {
                                        echo '<li class="menu-item">';
                                            echo '<a href="'.esc_url( wc_get_page_permalink( 'myaccount' ) ).'" class="myaccount-link">';
                                                echo '<svg class="svgUser2 styler-svg-icon" enable-background="new 0 0 512 512" height="512" viewBox="0 0 512 512" width="512" xmlns="http://www.w3.org/2000/svg"><g><g><path d="m256 253.7c-62 0-112.4-50.4-112.4-112.4s50.4-112.4 112.4-112.4 112.4 50.4 112.4 112.4-50.4 112.4-112.4 112.4zm0-195.8c-46 0-83.4 37.4-83.4 83.4s37.4 83.4 83.4 83.4 83.4-37.4 83.4-83.4-37.4-83.4-83.4-83.4z"></path></g><g><path d="m452.1 483.2h-392.2c-8 0-14.5-6.5-14.5-14.5 0-106.9 94.5-193.9 210.6-193.9s210.6 87 210.6 193.9c0 8-6.5 14.5-14.5 14.5zm-377-29.1h361.7c-8.1-84.1-86.1-150.3-180.8-150.3s-172.7 66.2-180.9 150.3z"></path></g></g></svg>';
                                                echo '<span>'.esc_html__( 'Account', 'naturally' ).'</span>';
                                            echo '</a>';
                                        echo '</li>';
                                    }
                                break;

                                case 'search':
                                    if ( '1' == naturally_settings( 'bottom_mobile_nav_item_customize' ) && '' != naturally_settings( 'mobile_bottom_menu_custom_search_html' ) ) {
                                        echo naturally_settings( 'mobile_bottom_menu_custom_search_html' );
                                    } else {
                                        echo '<li class="menu-item">';
                                            echo '<a href="#0" class="search-open">';
                                                echo '<svg class="svgSearch styler-svg-icon" width="512" height="512" fill="currentColor" viewBox="0 0 48 48" enable-background="new 0 0 48 48" xmlns="http://www.w3.org/2000/svg"><g><path d="m40.2850342 37.4604492-6.4862061-6.4862061c1.9657593-2.5733643 3.0438843-5.6947021 3.0443115-8.9884033 0-3.9692383-1.5458984-7.7011719-4.3530273-10.5078125-2.8066406-2.8066406-6.5380859-4.3525391-10.5078125-4.3525391-3.9692383 0-7.7011719 1.5458984-10.5078125 4.3525391-5.7939453 5.7944336-5.7939453 15.222168 0 21.015625 2.8066406 2.8071289 6.5385742 4.3530273 10.5078125 4.3530273 3.2937012-.0004272 6.4150391-1.0785522 8.9884033-3.0443115l6.4862061 6.4862061c.3901367.390625.9023438.5859375 1.4140625.5859375s1.0239258-.1953125 1.4140625-.5859375c.78125-.7807617.78125-2.0473633 0-2.828125zm-25.9824219-7.7949219c-4.234375-4.234375-4.2338867-11.1245117 0-15.359375 2.0512695-2.0507813 4.7788086-3.1806641 7.6796875-3.1806641 2.9013672 0 5.628418 1.1298828 7.6796875 3.1806641 2.0512695 2.0512695 3.1811523 4.7788086 3.1811523 7.6796875 0 2.9013672-1.1298828 5.628418-3.1811523 7.6796875s-4.7783203 3.1811523-7.6796875 3.1811523c-2.9008789.0000001-5.628418-1.1298827-7.6796875-3.1811523z"></path></g></svg>';
                                                echo '<span>'.esc_html__( 'Search', 'naturally' ).'</span>';
                                            echo '</a>';
                                        echo '</li>';
                                    }
                                break;
                            }
                        }
                        echo '</ul>';
                    echo '</div>';
                }
            }
            ?>
        </nav>
        <?php
    }
}
