<?php

/*************************************************
## HERO FUNCTION
*************************************************/

if (! function_exists('naturally_hero_section')) {
    function naturally_hero_section()
    {
        $h_s = get_bloginfo( 'name' );
        $h_t = esc_html__( 'Blog', 'naturally' );
        $page_id = '';

        if ( is_404() ) { // error page

            $name = 'error';
            $h_t = esc_html__( '404 - Not Found', 'naturally' );

        } elseif ( is_archive() ) { // blog and cpt archive page

            $name = 'archive';
            $h_t = get_the_archive_title();

        } elseif ( is_search() ) { // search page

            $name = 'search';
            $h_t = esc_html__( 'Search results for :', 'naturally' );

        } elseif ( is_home() || is_front_page() ) { // blog post loop page index.php or your choise on settings

            $name = 'blog';
            $h_t = esc_html( naturally_settings( 'blog_title', $h_t ) );

        } elseif ( is_single() && ! is_singular( 'portfolio' ) ) { // blog post single/singular page

            $name = 'single';
            $h_t = esc_html( naturally_settings( 'blog_title', $h_t ) );

        } elseif ( is_singular( 'portfolio' ) ) { // it is cpt and if you want use another clone this condition and add your cpt name as portfolio

            $name = 'single_portfolio';
            $h_t = get_the_title();

        } elseif ( is_page() ) {	// default or custom page

            $name = 'page';
            $h_t = get_the_title();
            $page_id = ' page-'.get_the_ID();

        }

        if( is_page() && class_exists('ACF') ){
            $h_b =  $h_bg = '';
            $h_v = true === get_field('naturally_hide_page_hero') ? '0' : '1';
            $h_all = get_field('naturally_page_hero_customize');
            if ( !empty( $h_all ) ) {
                // site title
                $h_s = $h_all["naturally_page_hero_text_customize"]["naturally_page_subtitle"];
                // page title
                $h_pt = $h_all["naturally_page_hero_text_customize"]["naturally_page_title"];
                $h_t = $h_pt ? $h_pt : $h_t;
                // page breadcrumbs
                $h_b = $h_all["naturally_page_hero_text_customize"]["naturally_page_bread_visibility"];
                // hero background image
                $h_bg = $h_all["naturally_page_hero_background_customize"]["naturally_hero_bg_img"];
                $h_bg = $h_bg ? esc_url($h_bg) : '';
            }

        } else {

            $h_v = naturally_settings( $name.'_hero_visibility', '1' );
            // site title
            $h_s = naturally_settings( $name.'_site_title', $h_s );
            // page title
            $h_t = naturally_settings( $name.'_title', $h_t ) ? naturally_settings( $name.'_title', $h_t ) : $h_t;
            // page breadcrumbs
            $h_b = naturally_settings( 'breadcrumbs_visibility', '1' );
            // hero background image
            $h_bg = naturally_settings( $name.'_hero_bg' );
            $h_bg = $h_bg ? esc_url( $h_bg['background-image'] ) : '';

        }

        do_action( 'naturally_before_hero_action' );

        if ('0' != $h_v) { ?>
            <div class="section text-center<?php echo esc_attr( $page_id ); ?>" data-ntr-background="<?php echo esc_url( $h_bg ); ?>">
                <div class="container">
                    <div class="headline">
                        <?php
                        if ($h_t) { ?>
                            <h1 class="nt-hero-title headline_title"><?php echo wp_kses( $h_t, naturally_allowed_html()), strlen( get_search_query() ) > 16 ? substr( get_search_query(), 0, 16 ).'...' : get_search_query(); ?></h1>
                        <?php
                        } else {
                            the_title('<h1 class="nt-hero-title headline_title">', '</h1>');
                        }
                        do_action( 'naturally_after_title_action' );
                        ?>
                        <?php if ( $h_s ) { ?>
                            <p class="headline_summary"><?php echo wp_kses( $h_s, naturally_allowed_html() ); ?></p>
                        <?php } ?>
                    </div>

                    <?php

                    if ( '1' == $h_b ) {
                        naturally_breadcrumbs();
                    }
                    ?>

        		</div>
        	</div>
        <?php
        } // hide hero area
        do_action( 'naturally_after_hero_action' );
    }
}
