<?php

add_action( 'naturally_blog_post_action', 'naturally_blog_post_thumbnail', 10 );
add_action( 'naturally_blog_post_action', 'naturally_blog_post_title', 20 );
add_action( 'naturally_blog_post_action', 'naturally_blog_post_meta', 30 );
add_action( 'naturally_blog_post_action', 'naturally_blog_post_content', 40 );
add_action( 'naturally_blog_post_action', 'naturally_blog_post_button', 50 );


if ( ! function_exists('naturally_post_style_one')) {

    function naturally_post_style_one()
    {
        ?>
        <div id="post-<?php echo get_the_ID(); ?>" <?php echo post_class( 'blog-post' ); ?> data-aos="ntr-fade-up" data-aos-once="true">

            <?php if ( is_sticky() ) { ?>
                <div class="nt-sticky-label"><span class="label is-green-light"><?php echo esc_html__( 'Sticky', 'naturally' ); ?></span></div>
            <?php } ?>

            <?php do_action( 'naturally_blog_post_action' ); ?>

        </div>

        <?php
    }
}

if ( ! function_exists('naturally_post_style_two')) {

    function naturally_post_style_two()
    {
        ?>
        <div id="post-<?php echo get_the_ID(); ?>" <?php echo post_class( 'grid_col is-12 style-1' ); ?> data-aos="ntr-fade-up" data-aos-once="true">
            <!-- Post -->
            <div class="blog-post2">

                <?php if ( is_sticky() ) { ?>
                    <div class="nt-sticky-label"><span class="label is-green-light"><?php echo esc_html__( 'Sticky', 'naturally' ); ?></span></div>
                <?php } ?>

                <?php if ( has_post_thumbnail() ) { ?>
                    <a class="blog-post2_photo" href="<?php echo esc_url( get_permalink() ); ?>">
                       <?php if ( function_exists('naturally_aq_resize') ) {

                            $blankimg = get_template_directory_uri().'/images/blank.gif';
                            $srcset1 = naturally_aq_resize( wp_get_attachment_url( get_post_thumbnail_id(), 'full' ), 400, 400, true, true, true );
                            $srcset1 = $srcset1 == false ? wp_get_attachment_url( get_post_thumbnail_id(), [400, 400] ) : $srcset1;
                            $srcset2 = naturally_aq_resize( wp_get_attachment_url( get_post_thumbnail_id(), 'full' ), 800, 800, true, true, true );
                            $srcset2 = $srcset2 == false ? wp_get_attachment_url( get_post_thumbnail_id(), [800, 800] ) : $srcset2;

                            $imagealt = esc_attr(get_post_meta(get_post_thumbnail_id(), '_wp_attachment_image_alt', true)); ?>
                            <span class="aspect-ratio is-1x1">
                                <img class="aspect-ratio_object lazyload"
                                src="<?php echo esc_url( $blankimg );?>"
                                data-srcset="<?php echo esc_url( $srcset1 ); ?> 1x, <?php echo esc_url( $srcset2 ); ?> 2x"
                                alt="<?php echo esc_attr( $imagealt ); ?>">
                            </span>
                        <?php } else {

                            the_post_thumbnail( 'naturally-post', array( 'class' => 'img-responsive' ) );
                        }
                        ?>
                    </a>
                <?php } ?>

                <div class="blog-post2_info">

                    <?php
                    if ('0' != naturally_settings( 'post_title_visibility', '1' ) ) {
                        the_title( sprintf( '<h3 class="blog-post2_title"><a href="%s" rel="bookmark">',esc_url(get_permalink() ) ), '</a></h3>' );
                        edit_post_link( esc_html__( 'Edit Post', 'naturally' ), '<div class="edit_post"><span class="label is-green-light">', '</span></div>' );
                    }
                    ?>

                    <?php
                    if ( '0' != naturally_settings('post_meta_visibility', '1' ) ) {
                        if ( get_the_author_meta( 'url' ) ) {
                            echo sprintf( '<p class="blog-post2_meta">%1$s %2$s %3$s</p>',
                                '0' != naturally_settings('post_date_visibility', '1' ) ? apply_filters( 'naturally_post_date', get_the_date(), true ) : '',
                                '0' != naturally_settings('post_author_visibility', '1' ) ? esc_html__( 'By','naturally' ) : '',
                                '0' != naturally_settings('post_author_visibility', '1' ) ? get_the_author_link() : ''
                            );
                        } else {
                            echo sprintf( '<p class="blog-post2_meta">%1$s %2$s <a href="%3$s" title="%4$s">%4$s</a></p>',
                                '0' != naturally_settings('post_date_visibility', '1' ) ? apply_filters( 'naturally_post2_date', get_the_date(), true ) : '',
                                '0' != naturally_settings('post_author_visibility', '1' ) ? esc_html__( 'By', 'naturally' ) : '',
                                '0' != naturally_settings('post_author_visibility', '1' ) ? esc_url( get_permalink() ) : '',
                                '0' != naturally_settings('post_author_visibility', '1' ) ? get_the_author() : ''
                            );
                        }
                    }
                    if ( '0' != naturally_settings( 'post_excerpt_visibility', '1' ) ) {
                        if ( has_excerpt() ) { ?>

                            <div class="blog-post2_summary">
                                <?php echo wp_trim_words( strip_tags( get_the_excerpt() ), naturally_settings( 'excerptsz', '30' ) ); ?>
                            </div>

                        <?php } elseif  ( get_the_content() ) { ?>

                            <div class="blog-post2_summary">
                                <?php echo wp_trim_words( strip_tags( get_the_content() ), naturally_settings( 'excerptsz', '30' ) ); ?>
                            </div>

                            <?php
                        }
                    }

                    if ( ! get_the_title() ) {
                        echo '<div class="mt-20">';
                        naturally_blog_post_button();
                        echo '</div>';
                    }

                    naturally_wp_link_pages();
                    ?>

                </div>
            </div>
            <!-- Post End -->
        </div>

        <?php
    }
}


if ( ! function_exists('naturally_blog_post_thumbnail')) {

    function naturally_blog_post_thumbnail()
    {
        if ( has_post_thumbnail() ) { ?>

            <a class="blog-post_photo" href="<?php echo esc_url( get_permalink() ); ?>">
               <?php
               if ( !function_exists('icl_object_id') ) {
                   if ( function_exists('naturally_aq_resize') ) {
                        $blankimg = get_template_directory_uri().'/images/blank.gif';
                        $srcset1 = naturally_aq_resize( wp_get_attachment_url( get_post_thumbnail_id(), 'full' ), 400, 300, true, true, true );
                        $srcset1 = $srcset1 == false ? wp_get_attachment_url( get_post_thumbnail_id(), [400, 300] ) : $srcset1;
                        $srcset2 = naturally_aq_resize( wp_get_attachment_url( get_post_thumbnail_id(), 'full' ), 800, 600, true, true, true );
                        $srcset2 = $srcset2 == false ? wp_get_attachment_url( get_post_thumbnail_id(), [800, 600] ) : $srcset2;
                        $imagealt = esc_attr(get_post_meta(get_post_thumbnail_id(), '_wp_attachment_image_alt', true)); ?>
                        <span class="aspect-ratio is-4x3">
                        <img class="aspect-ratio_object lazyload"
                        src="<?php echo esc_url( $blankimg );?>"
                        data-srcset="<?php echo esc_url( $srcset1 ); ?> 1x, <?php echo esc_url( $srcset2 ); ?> 2x"
                        alt="<?php echo esc_attr( $imagealt ); ?>">
                        </span>
                        <?php
                    } else {
                        the_post_thumbnail( 'naturally-post' );
                    }
                } else {
                    the_post_thumbnail( 'naturally-post' );
                }
                ?>
            </a>

        <?php
        }
    }
}


if ( ! function_exists( 'naturally_blog_post_title' ) ) {

    function naturally_blog_post_title()
    {
        if ( '0' != naturally_settings( 'post_title_visibility', '1' ) ) {

            the_title( sprintf( '<h3 class="blog-post_title"><a href="%s" rel="bookmark">', esc_url(get_permalink() ) ), '</a></h3>' );
            edit_post_link( esc_html__( 'Edit Post', 'naturally' ), '<div class="edit_post"><span class="label is-green-light">', '</span></div>' );

        }
    }
}


if ( ! function_exists( 'naturally_blog_post_meta' ) ) {

    function naturally_blog_post_meta()
    {
        if ( '0' != naturally_settings('post_meta_visibility', '1' ) ) {

            if( get_the_author_meta( 'url' ) ) {

                echo sprintf( '<p class="blog-post_meta">%1$s %2$s %3$s</p>',
                    apply_filters( 'naturally_post_date', get_the_date(), true ),
                    esc_html__( 'By', 'naturally' ),
                    get_the_author_link()
                );

            } else {

                echo sprintf( '<p class="blog-post_meta">%1$s %2$s <a href="%3$s" title="%4$s">%4$s</a></p>',
                    apply_filters( 'naturally_post_date', get_the_date(), true ),
                    esc_html__( 'By', 'naturally' ),
                    esc_url( get_permalink() ),
                    get_the_author()
                );

            }
        }
    }
}


if ( ! function_exists( 'naturally_blog_post_category' ) ) {

    function naturally_blog_post_category()
    {
        if ( '0' != naturally_settings( 'post_category_visibility', '1' ) ) {

            if ( has_category() ) { ?>

                <div class="blog-post_category"><?php the_category( ', ' ); ?></div>

            <?php
            }
        }
    }
}


if ( ! function_exists( 'naturally_blog_post_content' ) ) {

    function naturally_blog_post_content()
    {
        if ( '0' != naturally_settings( 'post_excerpt_visibility', '1' ) ) {

            if ( has_excerpt() ) { ?>

                <div class="blog-post_summary">
                    <?php echo wp_trim_words( strip_tags( get_the_excerpt() ), naturally_settings( 'excerptsz', '30' ) ); ?>
                </div>

            <?php } else { ?>

                <div class="blog-post_summary">
                    <?php echo wp_trim_words( strip_tags( get_the_content() ), naturally_settings( 'excerptsz', '30' ) ); ?>
                </div>

                <?php
            }

            naturally_wp_link_pages();
        }
    }
}

if ( ! function_exists( 'naturally_blog_post_button' ) ) {

    function naturally_blog_post_button()
    {
        if ( '0' != naturally_settings( 'post_button_visibility', '1') ) { ?>

            <p class="blog-post_readmore">
                <a class="link is-color-secondary" href="<?php echo esc_url( get_permalink() ); ?>">
                    <span class="link_text"><?php echo esc_html_e( 'Read more', 'naturally' ); ?></span>
                    <span class="link_icon icon is-next"></span>
                </a>
            </p>

            <?php
        }
    }
}
