<?php

/* naturally_single_post_header_action*/
add_action( 'naturally_single_post_header_content_action', 'naturally_single_post_header_content', 10 );
/* Single Post Header*/
add_action( 'naturally_single_post_header_action', 'naturally_single_post_header_title', 10 );
add_action( 'naturally_single_post_header_action', 'naturally_single_post_header_meta', 20 );


/* naturally_single_post_header_meta*/
add_action( 'naturally_single_post_meta_action', 'naturally_post_meta_date', 5 );
add_action( 'naturally_single_post_meta_action', 'naturally_post_meta_author', 10 );
add_action( 'naturally_single_post_meta_action', 'naturally_post_meta_categories', 20 );
add_action( 'naturally_single_post_meta_action', 'naturally_post_meta_comment_number', 30 );


/* naturally_single_post_content_action*/
add_action( 'naturally_single_post_action', 'naturally_single_post_formats_content', 10 );
add_action( 'naturally_single_post_action', 'naturally_single_post_content', 20 );
add_action( 'naturally_single_post_action', 'naturally_single_post_footer_content', 30 );
add_action( 'naturally_single_post_action', 'naturally_single_post_comment_template', 50 );


if ( ! function_exists( 'naturally_single_post_header_content' ) ) {

    function naturally_single_post_header_content()
    {
        ?>
        <!-- Single Header -->
        <div class="blog-single_header" data-ntr-animation='{"name":"fadein-up"}'>
            <?php
            /**
            * Hook: naturally_single_post_header_action.
            *
            * @hooked naturally_single_post_header_title - 10
            * @hooked naturally_single_post_header_meta - 20
            */
            do_action( 'naturally_single_post_header_action' );
            ?>
        </div>
        <!-- Single Header End -->
        <?php
    }
}

if ( ! function_exists( 'naturally_single_post_header_title' ) ) {

    function naturally_single_post_header_title()
    {
        edit_post_link( esc_html__( 'Edit Post', 'naturally' ), '<div class="single_edit_post"><span class="label is-green-light">', '</span></div>' );
        the_title( '<h1 class="blog-single_title">', '</h1>' );
    }
}

if ( ! function_exists( 'naturally_single_post_header_meta ') ) {

    function naturally_single_post_header_meta()
    {
        if ( '0' != naturally_settings('single_postmeta_all_visibility', '1') ) {
            ?>
            <!-- Single Header -->
            <ul class="blog-single_meta"><?php
            /**
            * Hook: naturally_single_post_header_meta.
            *
            * @hooked naturally_post_meta_date - 5
            * @hooked naturally_post_meta_author - 10
            * @hooked naturally_post_meta_categories - 20
            * @hooked naturally_post_meta_comment_number - 30
            */
            do_action( 'naturally_single_post_meta_action' );
            ?></ul>
            <?php
        }
    }
}

if ( ! function_exists('naturally_single_post_formats_content')) {

    function naturally_single_post_formats_content()
    {
        if ( has_post_thumbnail() ) {
            ?>

            <!-- Single Media -->
            <div class="blog-single_media" data-aos="ntr-fade-up" data-aos-once="true" data-aos-delay="200">

                <?php naturally_post_format(); ?>

            </div>
            <!-- Single Media End -->
            <?php
        }
    }
}

if (! function_exists( 'naturally_single_post_content' )) {

    function naturally_single_post_content()
    {
        $content = get_the_content();
        if ( $content ) {
            ?>
            <!-- Single Body -->
            <div <?php post_class('blog-single_body nt-theme-content'); ?> data-aos="ntr-fade-up" data-aos-once="true">
                <div class="grid">
                    <div class="grid_row is-60">
                        <div class="grid_col is-12">
                            <?php
                            the_content();
                            naturally_wp_link_pages();
                            ?>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Single Body End -->
            <?php
        }
    }
}

if (! function_exists('naturally_single_post_footer_content')) {

    function naturally_single_post_footer_content()
    {
        if ( '0' != naturally_settings('single_postmeta_tags_visibility', '1') || '0' != naturally_settings('single_postmeta_share_visibility', '1') ) {
        ?>
            <!-- Single Footer -->
            <div class="blog-single_footer" data-aos="ntr-fade-up" data-aos-once="true">
                <div class="grid">
                    <div class="grid_row is-60">
                        <?php if ( '0' != naturally_settings('single_postmeta_tags_visibility', '1') && has_tag() ) { ?>
                            <div class="grid_col is-12 is-lg-col">
                                <div class="blog-single_tags">
                                    <h3 class="blog-single_tags_title"><?php esc_html_e('Tags','naturally'); ?></h3>
                                    <div class="blog-single_tags_items">
                                        <?php
                                        $tags = get_the_tags(get_the_ID());
                                        foreach ($tags as $tag) {
                                            echo '<a class="blog-single_tags_item" href="'.esc_url(get_tag_link($tag->term_id)).'">'.esc_html( $tag->name ).'</a>';
                                        }
                                        ?>
                                    </div>
                                </div>
                            </div>
                        <?php } ?>

                        <?php
                        if ('0' != naturally_settings('single_postmeta_share_visibility', '1') ) {
                            do_action( 'single_post_after_tags_action' );
                        }
                        ?>
                    </div>
                </div>
            </div>
            <!-- End Single Footer -->
            <?php
        }
    }
}

if (! function_exists('naturally_single_post_comment_template')) {

    function naturally_single_post_comment_template()
    {
        $naturally_layout = naturally_settings( 'single_layout', 'right-sidebar' );
        $naturally_column = 'full-width' == $naturally_layout ? ' is-lg-8': '';
        if ( comments_open() || '0' != get_comments_number() ) {
        ?>
            <!-- End Single Commnets -->
            <div class="blog-single_comments" id="comments-area" data-aos="ntr-fade-up" data-aos-once="true">
                <div class="grid">
                    <div class="grid_row is-30">
                        <div class="grid_col is-12<?php echo esc_attr($naturally_column); ?>">

                            <?php comments_template(); ?>

                        </div>
                    </div>
                </div>
            </div>
            <!-- End Single Commnets -->
            <?php
        }
    }
}


/*************************************************
##  SINLGE POST/CPT TAGS
*************************************************/

if (! function_exists('naturally_post_meta_categories')) {

    function naturally_post_meta_categories()
    {
        $cats_display = is_single() ? naturally_settings('single_postmeta_cats_visibility', '1') : naturally_settings('post_category_visibility', '1');
        if ( '0' != $cats_display && has_category() ) {
            ?>
            <li class="blog-single_meta_item nt-post-cat">
                <span class="blog-single_meta_item_icon icon is-document"></span>
                <span><?php the_category(', '); ?></span>
            </li>
            <?php
        }
    }
}


if (! function_exists('naturally_post_meta_date')) {

    function naturally_post_meta_date()
    {
        $archive_year = get_the_time('Y');
        $archive_month = get_the_time('m');
        $archive_day = get_the_time('d');
        if ( '0' != naturally_settings('single_postmeta_date_visibility', '1') ) {
        ?>
        <li class="blog-single_meta_item nt-post-date">
            <span class="blog-single_meta_item_icon icon is-calendar"></span>
            <span><a href="<?php echo esc_url(get_day_link($archive_year, $archive_month, $archive_day)); ?>"><?php the_time(get_option('date_format')); ?></a></span>
        </li>
        <?php
        }
    }
}

/*************************************************
##  POST/CPT AUTHOR
*************************************************/

if (! function_exists('naturally_post_meta_author')) {

    function naturally_post_meta_author()
    {
        global $post;
        $author_id = $post->post_author;
        $author_link = get_author_posts_url( $author_id );
        if ( '0' != naturally_settings('single_postmeta_author_visibility', '1') ) {
            ?>
            <li class="blog-single_meta_item nt-post-author">
                <span class="blog-single_meta_item_icon icon is-user"></span>
                <span><?php esc_html_e( 'By', 'naturally' ); ?> <a href="<?php echo esc_url($author_link); ?>"><?php the_author_meta('display_name', $post->post_author ); ?></a></span>
            </li>
            <?php
        }
    }
}


/*************************************************
##  POST/CPT COMMENT
*************************************************/

if (! function_exists('naturally_post_meta_comment_number')) {

    function naturally_post_meta_comment_number()
    {
        if ( '0' != naturally_settings('single_postmeta_comments_visibility', '1') && have_comments() ) {
            ?>
            <li class="blog-single_meta_item nt-post-comment">
                <span class="blog-single_meta_item_icon icon is-comment"></span>
                <span><a href="<?php echo get_comments_link( get_the_ID() ); ?>"><?php printf( _nx( 'One Comment', '%1$s Comments', get_comments_number(), 'comments title', 'naturally' ), number_format_i18n( get_comments_number() ) ); ?></a></span>
            </li>
            <?php
        }
    }
}


/*************************************************
##  POST FORMAT
*************************************************/

if (! function_exists( 'naturally_post_format' ) ) {

    function naturally_post_format()
    {
        // post format
        $format = get_post_format();
        $format = $format ? $format : 'standard';

        // post format: video or audio embed
        if ( 'video' == $format || 'audio' == $format ) {

            naturally_single_post_format_embed();

        // post format: gallery
        } elseif ( 'gallery' == $format ) {

            naturally_single_post_format_gallery();

        // post format: quote
        } elseif ( 'quote' == $format ) {

            naturally_single_post_format_quote();

        // post format: link
        } elseif ( 'link' == $format ) {

            naturally_single_post_format_link();

        // post format: standart
        } else {

            if ( has_post_thumbnail() ) { ?>

                <div class="blog-single_media_photo">
                    <span class="aspect-ratio is-2x1">

                        <?php
                        if ( !function_exists('icl_object_id') ) {
                            if ( function_exists('naturally_aq_resize') ) {
                                $blankimg = get_template_directory_uri().'/images/blank.gif';
                                $srcset1 = naturally_aq_resize( wp_get_attachment_url( get_post_thumbnail_id(), 'full' ), 1200, 600, true, true, true );
                                $srcset1 = $srcset1 == false ? wp_get_attachment_url( get_post_thumbnail_id(), [1200, 600] ) : $srcset1;
                                $srcset2 = naturally_aq_resize( wp_get_attachment_url( get_post_thumbnail_id(), 'full' ), 800, 600, true, true, true );
                                $srcset2 = $srcset2 == false ? wp_get_attachment_url( get_post_thumbnail_id(), [2400, 1200] ) : $srcset2;
                                $imagealt = esc_attr(get_post_meta(get_post_thumbnail_id(), '_wp_attachment_image_alt', true));
                            ?>
                                <img class="aspect-ratio_object lazyload"
                                src="<?php echo esc_url( $blankimg );?>"
                                data-srcset="<?php echo esc_url( $srcset1 ); ?> 1x, <?php echo esc_url( $srcset2 ); ?> 2x"
                                alt="<?php echo esc_attr( $imagealt ); ?>">

                            <?php } else { ?>

                                <?php the_post_thumbnail( 'naturally-single', array( 'class' => 'aspect-ratio_object lazyload' ) ); ?>

                            <?php } ?>

                        <?php } else { ?>

                        <?php the_post_thumbnail( 'naturally-single', array( 'class' => 'aspect-ratio_object lazyload' ) ); ?>

                        <?php } ?>
                    </span>
                </div>
                <?php
            }

        } // end post format
    }
}


/*************************************************
## POST FORMAT : VIDEO OR AUDIO EMBED
*************************************************/
if (! function_exists( 'naturally_single_post_format_embed' ) ) {

    function naturally_single_post_format_embed()
    {
        $post = get_post(get_the_ID());
        $content = apply_filters('the_content', $post->post_content);
        $embed = get_media_embedded_in_content($content, array( 'video', 'object', 'embed', 'iframe', 'audio'  ));
        $iframe = class_exists('ACF') && function_exists('get_field') ? get_field('naturally_media_embed') : '';


        if ($iframe ) {
            $format = get_post_format();
            $iframe_format = 'audio' == $format ? 'audio' : 'video';

            // Use preg_match to find iframe src.
            preg_match('/src="(.+?)"/', $iframe, $matches);
            $src = $matches[1];

            // Add extra parameters to src and replcae HTML.
            $params = array(
                'controls'  => 0,
                'hd'        => 1,
                'autohide'  => 1
            );
            $new_src = add_query_arg($params, $src);
            $iframe = str_replace($src, $new_src, $iframe);

            // Add extra attributes to iframe HTML.
            $attributes = 'audio' == $format ? 'allow="autoplay"' : 'frameborder="0" allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture" allowfullscreen';
            $iframe = str_replace('></iframe>', ' ' . $attributes . '></iframe>', $iframe);
        ?>

            <div class="blog-single_media_<?php echo esc_attr( $iframe_format ); ?>"><?php echo wp_kses( $iframe, naturally_allowed_html() ); ?></div>

        <?php } else {

            if (false === strpos($content, 'wp-playlist-script') ) {
                // If not a single post, highlight the video file.
                if (! empty($embed)) {
                    foreach ($embed as $embed_html) { ?>
                        <div class="blog-single_media_video"><?php echo wp_kses( $embed_html, naturally_allowed_html() ); ?></div>
                        <?php
                    }
                }
            }
        }
    }
}


/*************************************************
## POST FORMAT : GALLERY
*************************************************/
if (! function_exists( 'naturally_single_post_format_gallery' ) ) {

    function naturally_single_post_format_gallery()
    {
        $images = get_post_meta( get_the_ID(), 'naturally_post_gallery' );

        $images = is_array( $images ) ? explode( ',', $images[0]) : $images;

        if ($images) { ?>

            <div class="blog-single_media_gallery">
                <div class="slick-slider text-center">

                    <?php foreach ($images as $image) { ?>

                        <div class="slick-slide">
                            <span class="aspect-ratio is-2x1">

                                <?php if ( function_exists('naturally_aq_resize') ) {

                                    $blankimg = get_template_directory_uri().'/images/blank.gif';
                                    $srcset1 = naturally_aq_resize( wp_get_attachment_url( $image, 'full' ), 1200, 600, true, true, true );
                                    $srcset1 = $srcset1 == false ? wp_get_attachment_url( $image, [1200, 600] ) : $srcset1;
                                    $srcset2 = naturally_aq_resize( wp_get_attachment_url( $image, 'full' ), 800, 600, true, true, true );
                                    $srcset2 = $srcset2 == false ? wp_get_attachment_url( $image, [2400, 1200] ) : $srcset2;
                                    $imagealt = esc_attr(get_post_meta(get_post_thumbnail_id(), '_wp_attachment_image_alt', true));

                                ?>

                                <img class="aspect-ratio_object lazyload"
                                    src="<?php echo esc_url( $blankimg );?>"
                                    data-srcset="<?php echo esc_url( $srcset1 ); ?> 1x, <?php echo esc_url( $srcset2 ); ?> 2x"
                                    alt="<?php echo esc_attr( $imagealt ); ?>">

                                    <?php
                            } else {

                                    the_post_thumbnail( 'naturally-single', array( 'class' => 'aspect-ratio_object lazyload' ) );

                                }
                                ?>

                            </span>
                        </div>

                    <?php } ?>

                </div>
            </div>
        <?php
        }
    }
}


/*************************************************
## POST FORMAT : QUOTE
*************************************************/
if (! function_exists( 'naturally_single_post_format_quote' ) ) {

    function naturally_single_post_format_quote()
    {

        $quote_text = $quote_author = '';
        if ( class_exists( 'ACF' ) && function_exists( 'get_field' ) ) {
            $quote_text = get_field('naturally_format_quote_text');
            $quote_author = get_field('naturally_format_quote_author');
        }

        if ( $quote_text ) { ?>

            <div class="blog-single_media_quote">
                <blockquote>

                    <p><?php echo esc_html( $quote_text ); ?></p>

                    <?php if ( $quote_author ) { ?>
                        <footer><cite title="<?php echo esc_attr( $quote_author ); ?>">- <?php echo esc_html( $quote_author ); ?></cite></footer>
                    <?php } ?>

                </blockquote>
            </div>

        <?php
        }
    }
}


/*************************************************
## POST FORMAT : LINK
*************************************************/
if (! function_exists( 'naturally_single_post_format_link' ) ) {

    function naturally_single_post_format_link()
    {
        $thumb_url = get_the_post_thumbnail_url();
        $thumb_url = function_exists('naturally_aq_resize') ? naturally_aq_resize( wp_get_attachment_url( get_post_thumbnail_id(), 'full' ), 1200, 600, true, true, true ) : $thumb_url;
        $thumb_url = $thumb_url == false ? wp_get_attachment_url( get_post_thumbnail_id(), [2400, 600] ) : $thumb_url;

        $link_title = $link_url = '';
        if ( class_exists('ACF') && function_exists('get_field') ) {
            $link_title = get_field('naturally_format_link_title');
            $link_url = get_field('naturally_format_link_url');
        }

        if ( $link_title || $link_url ) { ?>

            <div class="blog-single_media_link" data-ntr-background="<?php echo esc_url( $thumb_url ); ?>">
                <div class="blog-single_media_link_inner">

                    <?php if ( $link_title ) { ?>
                        <a href="<?php echo esc_url( $link_url ); ?>" class="blog-single_media_link_title"><?php echo esc_html( $link_title ); ?></a>
                    <?php } ?>

                    <?php if ( $link_url ) { ?>
                        <a href="<?php echo esc_url( $link_url ); ?>" class="blog-single_media_link_url"><?php echo esc_html( $link_url ); ?></a>
                    <?php } ?>

                </div>
            </div>
            <?php
        }
    }
}


/*************************************************
## SINGLE POST AUTHOR BOX FUNCTION
*************************************************/

if (! function_exists('naturally_single_post_author_box')) {

    function naturally_single_post_author_box()
    {
        global $post;
        if ('0' != naturally_settings('single_post_author_box_visibility', '1')) {
            // Get author's display name
            $display_name = get_the_author_meta('display_name', $post->post_author);
            // If display name is not available then use nickname as display name
            $display_name = empty($display_name) ? get_the_author_meta('nickname', $post->post_author) : $display_name ;
            // Get author's biographical information or description
            $user_description = get_the_author_meta('user_description', $post->post_author);
            // Get author's website URL
            $user_website = get_the_author_meta('url', $post->post_author);
            // Get link to the author archive page
            $user_posts = get_author_posts_url(get_the_author_meta('ID', $post->post_author));
            // Get the rest of the author links. These are stored in the
            // wp_usermeta table by the key assigned in wpse_user_contactmethods()
            $author_facebook = get_the_author_meta('facebook', $post->post_author);
            $author_twitter  = get_the_author_meta('twitter', $post->post_author);
            $author_instagram  = get_the_author_meta('instagram', $post->post_author);
            $author_linkedin = get_the_author_meta('linkedin', $post->post_author);
            $author_youtube  = get_the_author_meta('youtube', $post->post_author);

            if ('' != $user_description) {
                ?>
                <div class="blog-single_author" data-aos="ntr-fade-up" data-aos-once="true">
                    <div class="grid">
                        <div class="grid_row is-60">
                            <div class="grid_col is-12 is-md-6 is-lg-6">
                                <div class="author_desc">
                                    <div class="author_avatar">
                                        <?php if (function_exists('get_avatar')) {
                                            echo get_avatar(get_the_author_meta('email'), '80');
                                        } ?>
                                    </div>
                                    <div class="author_info">
                                        <span class="author_name"><?php echo esc_html($display_name); ?></span>
                                        <span class="author_comment">
                                            <span class="icon is-comment"></span>
                                            <span><?php comments_number(); ?></span>
                                        </span>

                                    </div>
                                </div>
                                <div class="social-icons">
                                    <?php if ('' != $author_facebook) { ?>
                                        <a class="social-icons_link" href="<?php echo esc_url($author_facebook); ?>" target="_blank"><span class="icon is-facebook"></span></a>
                                    <?php } ?>
                                    <?php if ('' != $author_twitter) { ?>
                                        <a class="social-icons_link" href="<?php echo esc_url($author_twitter); ?>" target="_blank"><span class="icon is-twitter"></span></a>
                                    <?php } ?>
                                    <?php if ('' != $author_instagram) { ?>
                                        <a class="social-icons_link" href="<?php echo esc_url($author_instagram); ?>" target="_blank"><span class="icon is-instagram"></span></a>
                                    <?php } ?>
                                    <?php if ('' != $author_linkedin) { ?>
                                        <a class="social-icons_link" href="<?php echo esc_url($author_linkedin); ?>" target="_blank"><span class="icon is-linkedin"></span></a>
                                    <?php } ?>
                                    <?php if ('' != $author_youtube) { ?>
                                        <a class="social-icons_link" href="<?php echo esc_url($author_youtube); ?>" target="_blank"><span class="icon is-youtube"></span></a>
                                    <?php } ?>
                                </div>
                            </div>

                            <div class="grid_col is-12 is-md-6 is-lg-6">
                                <!-- socials start-->
                                <p><?php echo esc_html($user_description); ?></p>
                            </div>

                            <!-- socials end -->
                        </div>
                    </div>
                </div>
                <?php
            }
        }
    }
}


/*************************************************
## SINGLE POST RELATED POSTS
*************************************************/

if (! function_exists('naturally_single_post_related')) {

    function naturally_single_post_related()
    {
        if ('0' != naturally_settings('single_related_visibility', '0')) {

            global $post;
            $cats = get_the_category($post->ID);
            $args = array(
                'post__not_in' => array($post->ID),
                'posts_per_page' => 6,
            );

            $related_query = new WP_Query( $args );
            if($related_query->have_posts()) {
                remove_action( 'naturally_blog_post_action','naturally_blog_post_content', 40 );
                ?>
                <div class="section blog-single_related" data-aos="ntr-fade-up" data-aos-once="true">
                    <div class="container">

                        <!-- Heading -->
                        <div class="heading" data-ntr-animation='{"name":"fadein-up"}'>
                            <h2 class="blog-single_title"><?php echo esc_html_e('Related Posts', 'naturally'); ?></h2>
                        </div>
                        <!-- Heading End -->

                        <!-- Slider Blog -->
                        <div class="slider-blog" data-ntr-slider-related>
                            <div class="slick-slider">
                                <?php
                                while($related_query->have_posts()) {

                                    $related_query->the_post();
                                    if (has_post_thumbnail()){ ?>

                                        <div class="slick-slide">

                                            <?php echo naturally_post_style_one(); ?>

                                        </div>
                                        <?php
                                    }
                                }
                                ?>
                            </div>
                        </div>
                    </div>
                </div>
            <?php
            wp_reset_postdata();
            }
        }
    }
}
