<?php


/**
 * Custom template parts for this theme.
 *
 * preloader, backtotop, conten-none
 *
 * Eventually, some of the functionality here could be replaced by core features.
 *
 * @package naturally
*/



/*************************************************
## START PRELOADER
*************************************************/

if ( ! function_exists( 'naturally_preloader' ) ) {
	function naturally_preloader()
	{
        $loader = naturally_settings('pre_type', '1');
		if ( '0' != naturally_settings('preloader_visibility', '1') ) {
			if ( 'custom' == $loader ) { ?>
				<div id="nt-preloader" class="justify-content-center align-items-center d-flex">
					<img src="<?php esc_url(naturally_settings('pre_custom_img')['url']); ?>" class="nt-custom-preloader">
				</div>
			<?php } elseif ( '1' == $loader ) { ?>
                <div class="loading is-active" data-ntr-loading>
                    <span class="loading_loader"></span>
                </div>
			<?php } else { ?>
                <div id="nt-preloader" class="preloader">
					<div class="loader<?php echo naturally_settings('pre_type');?>"></div>
				</div>
				<?php
			}
		}
	}
}
add_action( 'naturally_preloader_action', 'naturally_preloader', 10 );
/*************************************************
##  BACKTOP
*************************************************/

if ( ! function_exists( 'naturally_backtop' ) ) {
	function naturally_backtop() {

		if ( '1' == naturally_settings('backtotop_visibility', '1') ) { ?>

			<div class="back-top is-active" data-ntr-backtop>
				<span class="back-top_icon icon is-arrow-up"></span>
			</div>

		<?php
		}
	}
}


/*************************************************
##  CONTENT NONE
*************************************************/


if ( ! function_exists( 'naturally_content_none' ) ) {
function naturally_content_none() {
	$naturally_centered = is_search() && 'full-width' == naturally_settings( 'search_layout') ? ' text-center' : '';
?>

	<div class="content-none-container text-center">

		<h2 class="__title<?php echo esc_attr($naturally_centered); ?>"><?php esc_html_e( 'Nothing', 'naturally' ); ?> <span><?php esc_html_e( 'Found', 'naturally' ); ?></span></h2>

		<?php if ( is_home() && current_user_can( 'publish_posts' ) ) : ?>

			<p><?php printf( esc_html__( 'Ready to publish your first post? <a href="%1$s">Get started here</a>.', 'naturally' ), esc_url( admin_url( 'post-new.php' ) ) ); ?></p>

			<?php elseif ( is_search() ) : ?>

				<p class="__nothing<?php echo esc_attr($naturally_centered); ?>"><?php esc_html_e( 'Sorry, but nothing matched your search terms. Please try again with some different keywords.', 'naturally' ); ?></p>
				<div class="spacer py-4"></div>
				<?php echo naturally_content_custom_search_form(); ?>

			<?php else : ?>
				<p><?php esc_html_e( 'It seems we can&rsquo;t find what you&rsquo;re looking for. Perhaps searching can help.', 'naturally' ); ?></p>
			<?php naturally_content_custom_search_form(); ?>

		<?php endif; ?>

	</div> <!-- End article -->

<?php
}
}
