<?php
/**
* The main template file
*
* This is the most generic template file in a WordPress theme
* and one of the two required files for a theme (the other being style.css).
* It is used to display a page when nothing more specific matches a query.
* E.g., it puts together the home page when no home.php file exists.
*
* @link https://developer.wordpress.org/themes/basics/template-hierarchy/
*
* @package WordPress
* @subpackage Naturally
* @since 1.0.0
*/

get_header();

// Elementor `archive` location
if ( ! function_exists( 'elementor_theme_do_location' ) || ! elementor_theme_do_location( 'archive' ) ) {

    do_action( 'naturally_before_index' );

	$index_type = naturally_settings( 'index_type', 'grid' );
	$naturally_layout = naturally_settings( 'index_layout', 'right-sidebar' );
	$naturally_column = !is_active_sidebar('sidebar-1') ? 'is-xl-10' : 'is-xl-8';

    ?>
    <!-- container -->
    <div id="nt-index" class="nt-index">

        <!-- Hero section - this function using on all inner pages -->
        <?php naturally_hero_section(); ?>

        <div class="nt-theme-inner-container section">
            <div class="container">
                <div class="grid">
                    <div class="grid_row is-40 justify-center">

                        <!-- left sidebar -->
                        <?php
                        if( is_active_sidebar('sidebar-1') && 'left-sidebar' == $naturally_layout ) {
                            get_sidebar();
                        }
                        ?>
                        <!-- End left sidebar -->

                        <!-- Sidebar column control -->
                        <div class="grid_col is-12 <?php echo esc_attr($naturally_column); ?>">
                            <div class="grid">
                                <div class="grid_row is-40">
                                    <?php
                                    $delay = 0;
                                    if ( have_posts() ) {

                                        while ( have_posts() ) : the_post();

                                            // if there are posts, run naturally_post_style_one function
                                            // contain supported post formats from theme
                                            naturally_post_style_two();

                                        endwhile;

                                        // this function working with wp reading settins + posts
                                        naturally_index_loop_pagination();

                                    } else {

                                        // if there are no posts, read content none function
                                        naturally_content_none();

                                    }
                                    ?>
                                </div>
                            </div>
                        </div>
                        <!-- End content column -->

                        <!-- right sidebar -->
                        <?php
                        if( is_active_sidebar('sidebar-1') && 'right-sidebar' == $naturally_layout ) {
                            get_sidebar();
                        }
                        ?>
                        <!-- End right sidebar -->

                    </div>
                </div>
                <!--End row -->
            </div>
            <!--End container -->
        </div>
        <!--End #blog -->
    </div>
    <!--End index general div -->
    <?php

	// you can use this action to add any content after index page
	do_action( 'naturally_after_index' );

}
	get_footer();

?>
